# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory
from authenticationsdk.util.MLEUtility import MLEUtility
from authenticationsdk.util.GlobalLabelParameters import GlobalLabelParameters
from authenticationsdk.util.Utility import process_body

from ..utilities.tracking.sdk_tracker import SdkTracker
class CustomerShippingAddressApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def delete_customer_shipping_address(self, customer_id, shipping_address_id, **kwargs):
        """
        Delete a Customer Shipping Address
        |  |  |  | | --- | --- | --- | |**Customer Shipping Address**<br>A Customer Shipping Address represents tokenized customer shipping information.<br>A [Customer](#token-management_customer_create-a-customer) can have [one or more Shipping Addresses](#token-management_customer-shipping-address_list-shipping-addresses-for-a-customer), with one allocated as the Customers default for use in payments.|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Deleting a Customers Shipping Address**<br>Your system can use this API to delete an existing Shipping Address for a Customer.<br>If a customer has more than one Shipping Address then the default Shipping Address cannot be deleted without first selecting a [new default Shipping Address](#token-management_customer-shipping-address_update-a-customer-shipping-address_samplerequests-dropdown_make-customer-shipping-address-the-default_liveconsole-tab-request-body). 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_customer_shipping_address(customer_id, shipping_address_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_id: The Id of a Customer. (required)
        :param str shipping_address_id: The Id of a shipping address. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `delete_customer_shipping_address` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_customer_shipping_address_with_http_info(customer_id, shipping_address_id, **kwargs)
        else:
            (data) = self.delete_customer_shipping_address_with_http_info(customer_id, shipping_address_id, **kwargs)
            return data

    def delete_customer_shipping_address_with_http_info(self, customer_id, shipping_address_id, **kwargs):
        """
        Delete a Customer Shipping Address
        |  |  |  | | --- | --- | --- | |**Customer Shipping Address**<br>A Customer Shipping Address represents tokenized customer shipping information.<br>A [Customer](#token-management_customer_create-a-customer) can have [one or more Shipping Addresses](#token-management_customer-shipping-address_list-shipping-addresses-for-a-customer), with one allocated as the Customers default for use in payments.|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Deleting a Customers Shipping Address**<br>Your system can use this API to delete an existing Shipping Address for a Customer.<br>If a customer has more than one Shipping Address then the default Shipping Address cannot be deleted without first selecting a [new default Shipping Address](#token-management_customer-shipping-address_update-a-customer-shipping-address_samplerequests-dropdown_make-customer-shipping-address-the-default_liveconsole-tab-request-body). 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_customer_shipping_address_with_http_info(customer_id, shipping_address_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_id: The Id of a Customer. (required)
        :param str shipping_address_id: The Id of a shipping address. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'shipping_address_id', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_customer_shipping_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params) or (params['customer_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `customer_id` when calling `delete_customer_shipping_address`")
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_customer_shipping_address`")
        # verify the required parameter 'shipping_address_id' is set
        if ('shipping_address_id' not in params) or (params['shipping_address_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `shipping_address_id` when calling `delete_customer_shipping_address`")
            raise ValueError("Missing the required parameter `shipping_address_id` when calling `delete_customer_shipping_address`")


        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']
            customerId=customer_id
        if 'shipping_address_id' in params:
            path_params['shippingAddressId'] = params['shipping_address_id']
            shippingAddressId=shipping_address_id

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'DELETE' in ('POST'):
            body_params = '{}'

        if 'DELETE' == GlobalLabelParameters.POST or 'DELETE' == GlobalLabelParameters.PUT or 'DELETE' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "delete_customer_shipping_address,delete_customer_shipping_address_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v2/customers/{customerId}/shipping-addresses/{shippingAddressId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_customer_shipping_address(self, customer_id, shipping_address_id, **kwargs):
        """
        Retrieve a Customer Shipping Address
        |  |  |  | | --- | --- | --- | |**Customer Shipping Address**<br>A Customer Shipping Address represents tokenized customer shipping information.<br>A [Customer](#token-management_customer_create-a-customer) can have [one or more Shipping Addresses](#token-management_customer-shipping-address_list-shipping-addresses-for-a-customer), with one allocated as the Customers default for use in payments.|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Retrieving a Customer Shipping Address**<br>Your system can use this API to retrieve an existing Shipping Address for a Customer.<br>To perform a payment with a particular Shipping Address simply specify the [Shipping Address Id in the payments request](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-using-tokens_authorization-with-customer-payment-instrument-and-shipping-address-token-id_liveconsole-tab-request-body). 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_customer_shipping_address(customer_id, shipping_address_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_id: The Id of a Customer. (required)
        :param str shipping_address_id: The Id of a shipping address. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: PostCustomerShippingAddressRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `get_customer_shipping_address` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_customer_shipping_address_with_http_info(customer_id, shipping_address_id, **kwargs)
        else:
            (data) = self.get_customer_shipping_address_with_http_info(customer_id, shipping_address_id, **kwargs)
            return data

    def get_customer_shipping_address_with_http_info(self, customer_id, shipping_address_id, **kwargs):
        """
        Retrieve a Customer Shipping Address
        |  |  |  | | --- | --- | --- | |**Customer Shipping Address**<br>A Customer Shipping Address represents tokenized customer shipping information.<br>A [Customer](#token-management_customer_create-a-customer) can have [one or more Shipping Addresses](#token-management_customer-shipping-address_list-shipping-addresses-for-a-customer), with one allocated as the Customers default for use in payments.|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Retrieving a Customer Shipping Address**<br>Your system can use this API to retrieve an existing Shipping Address for a Customer.<br>To perform a payment with a particular Shipping Address simply specify the [Shipping Address Id in the payments request](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-using-tokens_authorization-with-customer-payment-instrument-and-shipping-address-token-id_liveconsole-tab-request-body). 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_customer_shipping_address_with_http_info(customer_id, shipping_address_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_id: The Id of a Customer. (required)
        :param str shipping_address_id: The Id of a shipping address. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: PostCustomerShippingAddressRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'shipping_address_id', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_shipping_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params) or (params['customer_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `customer_id` when calling `get_customer_shipping_address`")
            raise ValueError("Missing the required parameter `customer_id` when calling `get_customer_shipping_address`")
        # verify the required parameter 'shipping_address_id' is set
        if ('shipping_address_id' not in params) or (params['shipping_address_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `shipping_address_id` when calling `get_customer_shipping_address`")
            raise ValueError("Missing the required parameter `shipping_address_id` when calling `get_customer_shipping_address`")


        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']
            customerId=customer_id
        if 'shipping_address_id' in params:
            path_params['shippingAddressId'] = params['shipping_address_id']
            shippingAddressId=shipping_address_id

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'GET' in ('POST'):
            body_params = '{}'

        if 'GET' == GlobalLabelParameters.POST or 'GET' == GlobalLabelParameters.PUT or 'GET' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "get_customer_shipping_address,get_customer_shipping_address_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v2/customers/{customerId}/shipping-addresses/{shippingAddressId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PostCustomerShippingAddressRequest',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_customer_shipping_addresses_list(self, customer_id, **kwargs):
        """
        List Shipping Addresses for a Customer
        |  |  |  | | --- | --- | --- | |**Customer Shipping Address**<br>A Customer Shipping Address represents tokenized customer shipping information.<br>A [Customer](#token-management_customer_create-a-customer) can have [one or more Shipping Addresses](#token-management_customer-shipping-address_list-shipping-addresses-for-a-customer), with one allocated as the Customers default for use in payments.|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Retrieving all Customer Shipping Addresses**<br>Your system can use this API to retrieve all existing Shipping Addresses for a Customer. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_customer_shipping_addresses_list(customer_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_id: The Id of a Customer. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :param int offset: Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0.
        :param int limit: The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100.
        :return: ShippingAddressListForCustomer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `get_customer_shipping_addresses_list` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_customer_shipping_addresses_list_with_http_info(customer_id, **kwargs)
        else:
            (data) = self.get_customer_shipping_addresses_list_with_http_info(customer_id, **kwargs)
            return data

    def get_customer_shipping_addresses_list_with_http_info(self, customer_id, **kwargs):
        """
        List Shipping Addresses for a Customer
        |  |  |  | | --- | --- | --- | |**Customer Shipping Address**<br>A Customer Shipping Address represents tokenized customer shipping information.<br>A [Customer](#token-management_customer_create-a-customer) can have [one or more Shipping Addresses](#token-management_customer-shipping-address_list-shipping-addresses-for-a-customer), with one allocated as the Customers default for use in payments.|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Retrieving all Customer Shipping Addresses**<br>Your system can use this API to retrieve all existing Shipping Addresses for a Customer. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_customer_shipping_addresses_list_with_http_info(customer_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_id: The Id of a Customer. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :param int offset: Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0.
        :param int limit: The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100.
        :return: ShippingAddressListForCustomer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'profile_id', 'offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_shipping_addresses_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params) or (params['customer_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `customer_id` when calling `get_customer_shipping_addresses_list`")
            raise ValueError("Missing the required parameter `customer_id` when calling `get_customer_shipping_addresses_list`")


        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']
            customerId=customer_id

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'GET' in ('POST'):
            body_params = '{}'

        if 'GET' == GlobalLabelParameters.POST or 'GET' == GlobalLabelParameters.PUT or 'GET' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "get_customer_shipping_addresses_list,get_customer_shipping_addresses_list_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v2/customers/{customerId}/shipping-addresses', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ShippingAddressListForCustomer',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_customers_shipping_address(self, customer_id, shipping_address_id, patch_customer_shipping_address_request, **kwargs):
        """
        Update a Customer Shipping Address
        |  |  |  | | --- | --- | --- | |**Customer Shipping Address**<br>A Customer Shipping Address represents tokenized customer shipping information.<br>A [Customer](#token-management_customer_create-a-customer) can have [one or more Shipping Addresses](#token-management_customer-shipping-address_list-shipping-addresses-for-a-customer), with one allocated as the Customers default for use in payments.|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Updating a Customers Shipping Address**<br>Your system can use this API to update an existing Shipping Addresses for a Customer, including selecting a [default Shipping Address](#token-management_customer-shipping-address_update-a-customer-shipping-address_samplerequests-dropdown_make-customer-shipping-address-the-default_liveconsole-tab-request-body) for use in payments. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_customers_shipping_address(customer_id, shipping_address_id, patch_customer_shipping_address_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_id: The Id of a Customer. (required)
        :param str shipping_address_id: The Id of a shipping address. (required)
        :param PatchCustomerShippingAddressRequest patch_customer_shipping_address_request: (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :param str if_match: Contains an ETag value from a GET request to make the request conditional.
        :return: PatchCustomerShippingAddressRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `patch_customers_shipping_address` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_customers_shipping_address_with_http_info(customer_id, shipping_address_id, patch_customer_shipping_address_request, **kwargs)
        else:
            (data) = self.patch_customers_shipping_address_with_http_info(customer_id, shipping_address_id, patch_customer_shipping_address_request, **kwargs)
            return data

    def patch_customers_shipping_address_with_http_info(self, customer_id, shipping_address_id, patch_customer_shipping_address_request, **kwargs):
        """
        Update a Customer Shipping Address
        |  |  |  | | --- | --- | --- | |**Customer Shipping Address**<br>A Customer Shipping Address represents tokenized customer shipping information.<br>A [Customer](#token-management_customer_create-a-customer) can have [one or more Shipping Addresses](#token-management_customer-shipping-address_list-shipping-addresses-for-a-customer), with one allocated as the Customers default for use in payments.|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Updating a Customers Shipping Address**<br>Your system can use this API to update an existing Shipping Addresses for a Customer, including selecting a [default Shipping Address](#token-management_customer-shipping-address_update-a-customer-shipping-address_samplerequests-dropdown_make-customer-shipping-address-the-default_liveconsole-tab-request-body) for use in payments. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_customers_shipping_address_with_http_info(customer_id, shipping_address_id, patch_customer_shipping_address_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_id: The Id of a Customer. (required)
        :param str shipping_address_id: The Id of a shipping address. (required)
        :param PatchCustomerShippingAddressRequest patch_customer_shipping_address_request: (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :param str if_match: Contains an ETag value from a GET request to make the request conditional.
        :return: PatchCustomerShippingAddressRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'shipping_address_id', 'patch_customer_shipping_address_request', 'profile_id', 'if_match']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_customers_shipping_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params) or (params['customer_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `customer_id` when calling `patch_customers_shipping_address`")
            raise ValueError("Missing the required parameter `customer_id` when calling `patch_customers_shipping_address`")
        # verify the required parameter 'shipping_address_id' is set
        if ('shipping_address_id' not in params) or (params['shipping_address_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `shipping_address_id` when calling `patch_customers_shipping_address`")
            raise ValueError("Missing the required parameter `shipping_address_id` when calling `patch_customers_shipping_address`")
        # verify the required parameter 'patch_customer_shipping_address_request' is set
        if ('patch_customer_shipping_address_request' not in params) or (params['patch_customer_shipping_address_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `patch_customer_shipping_address_request` when calling `patch_customers_shipping_address`")
            raise ValueError("Missing the required parameter `patch_customer_shipping_address_request` when calling `patch_customers_shipping_address`")


        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']
            customerId=customer_id
        if 'shipping_address_id' in params:
            path_params['shippingAddressId'] = params['shipping_address_id']
            shippingAddressId=shipping_address_id

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']
        if 'if_match' in params:
            header_params['if-match'] = params['if_match']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_customer_shipping_address_request' in params:
            body_params = params['patch_customer_shipping_address_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'patch_customer_shipping_address_request', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)

        if 'PATCH' == GlobalLabelParameters.POST or 'PATCH' == GlobalLabelParameters.PUT or 'PATCH' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "patch_customers_shipping_address,patch_customers_shipping_address_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v2/customers/{customerId}/shipping-addresses/{shippingAddressId}', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PatchCustomerShippingAddressRequest',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_customer_shipping_address(self, customer_id, post_customer_shipping_address_request, **kwargs):
        """
        Create a Customer Shipping Address
        |  |  |  | | --- | --- | --- | |**Customer Shipping Address**<br>A Customer Shipping Address represents tokenized customer shipping information.<br>A [Customer](#token-management_customer_create-a-customer) can have [one or more Shipping Addresses](#token-management_customer-shipping-address_list-shipping-addresses-for-a-customer), with one allocated as the Customers default for use in payments.|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Creating a Customer Shipping Address**<br>Your system can use this API to create an existing Customers default or non default Shipping Address.<br>You can also create additional Customer Shipping Addresses via the [Payments API](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-with-token-create_authorization-create-default-payment-instrument-shipping-address-for-existing-customer_liveconsole-tab-request-body). 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_customer_shipping_address(customer_id, post_customer_shipping_address_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_id: The Id of a Customer. (required)
        :param PostCustomerShippingAddressRequest post_customer_shipping_address_request: (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: PostCustomerShippingAddressRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `post_customer_shipping_address` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_customer_shipping_address_with_http_info(customer_id, post_customer_shipping_address_request, **kwargs)
        else:
            (data) = self.post_customer_shipping_address_with_http_info(customer_id, post_customer_shipping_address_request, **kwargs)
            return data

    def post_customer_shipping_address_with_http_info(self, customer_id, post_customer_shipping_address_request, **kwargs):
        """
        Create a Customer Shipping Address
        |  |  |  | | --- | --- | --- | |**Customer Shipping Address**<br>A Customer Shipping Address represents tokenized customer shipping information.<br>A [Customer](#token-management_customer_create-a-customer) can have [one or more Shipping Addresses](#token-management_customer-shipping-address_list-shipping-addresses-for-a-customer), with one allocated as the Customers default for use in payments.|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|**Creating a Customer Shipping Address**<br>Your system can use this API to create an existing Customers default or non default Shipping Address.<br>You can also create additional Customer Shipping Addresses via the [Payments API](#payments_payments_process-a-payment_samplerequests-dropdown_authorization-with-token-create_authorization-create-default-payment-instrument-shipping-address-for-existing-customer_liveconsole-tab-request-body). 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_customer_shipping_address_with_http_info(customer_id, post_customer_shipping_address_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_id: The Id of a Customer. (required)
        :param PostCustomerShippingAddressRequest post_customer_shipping_address_request: (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: PostCustomerShippingAddressRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'post_customer_shipping_address_request', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_customer_shipping_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params) or (params['customer_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `customer_id` when calling `post_customer_shipping_address`")
            raise ValueError("Missing the required parameter `customer_id` when calling `post_customer_shipping_address`")
        # verify the required parameter 'post_customer_shipping_address_request' is set
        if ('post_customer_shipping_address_request' not in params) or (params['post_customer_shipping_address_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `post_customer_shipping_address_request` when calling `post_customer_shipping_address`")
            raise ValueError("Missing the required parameter `post_customer_shipping_address_request` when calling `post_customer_shipping_address`")


        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']
            customerId=customer_id

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'post_customer_shipping_address_request' in params:
            body_params = params['post_customer_shipping_address_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'post_customer_shipping_address_request', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)

        if 'POST' == GlobalLabelParameters.POST or 'POST' == GlobalLabelParameters.PUT or 'POST' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "post_customer_shipping_address,post_customer_shipping_address_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v2/customers/{customerId}/shipping-addresses', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PostCustomerShippingAddressRequest',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
