# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory
from authenticationsdk.util.MLEUtility import MLEUtility
from authenticationsdk.util.GlobalLabelParameters import GlobalLabelParameters
from authenticationsdk.util.Utility import process_body

from ..utilities.tracking.sdk_tracker import SdkTracker
class PushFundsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def create_push_funds_transfer(self, push_funds_request, content_type, x_requestid, v_c_merchant_id, v_c_permissions, v_c_correlation_id, v_c_organization_id, **kwargs):
        """
        Process a Push Funds Transfer
        Receive funds using an Original Credit Transaction (OCT). 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_push_funds_transfer(push_funds_request, content_type, x_requestid, v_c_merchant_id, v_c_permissions, v_c_correlation_id, v_c_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PushFundsRequest push_funds_request: (required)
        :param str content_type: (required)
        :param str x_requestid: (required)
        :param str v_c_merchant_id: (required)
        :param str v_c_permissions: (required)
        :param str v_c_correlation_id: (required)
        :param str v_c_organization_id: (required)
        :return: PushFunds201Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `create_push_funds_transfer` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_push_funds_transfer_with_http_info(push_funds_request, content_type, x_requestid, v_c_merchant_id, v_c_permissions, v_c_correlation_id, v_c_organization_id, **kwargs)
        else:
            (data) = self.create_push_funds_transfer_with_http_info(push_funds_request, content_type, x_requestid, v_c_merchant_id, v_c_permissions, v_c_correlation_id, v_c_organization_id, **kwargs)
            return data

    def create_push_funds_transfer_with_http_info(self, push_funds_request, content_type, x_requestid, v_c_merchant_id, v_c_permissions, v_c_correlation_id, v_c_organization_id, **kwargs):
        """
        Process a Push Funds Transfer
        Receive funds using an Original Credit Transaction (OCT). 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_push_funds_transfer_with_http_info(push_funds_request, content_type, x_requestid, v_c_merchant_id, v_c_permissions, v_c_correlation_id, v_c_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PushFundsRequest push_funds_request: (required)
        :param str content_type: (required)
        :param str x_requestid: (required)
        :param str v_c_merchant_id: (required)
        :param str v_c_permissions: (required)
        :param str v_c_correlation_id: (required)
        :param str v_c_organization_id: (required)
        :return: PushFunds201Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['push_funds_request', 'content_type', 'x_requestid', 'v_c_merchant_id', 'v_c_permissions', 'v_c_correlation_id', 'v_c_organization_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_push_funds_transfer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'push_funds_request' is set
        if ('push_funds_request' not in params) or (params['push_funds_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `push_funds_request` when calling `create_push_funds_transfer`")
            raise ValueError("Missing the required parameter `push_funds_request` when calling `create_push_funds_transfer`")
        # verify the required parameter 'content_type' is set
        if ('content_type' not in params) or (params['content_type'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `content_type` when calling `create_push_funds_transfer`")
            raise ValueError("Missing the required parameter `content_type` when calling `create_push_funds_transfer`")
        # verify the required parameter 'x_requestid' is set
        if ('x_requestid' not in params) or (params['x_requestid'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `x_requestid` when calling `create_push_funds_transfer`")
            raise ValueError("Missing the required parameter `x_requestid` when calling `create_push_funds_transfer`")
        # verify the required parameter 'v_c_merchant_id' is set
        if ('v_c_merchant_id' not in params) or (params['v_c_merchant_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `v_c_merchant_id` when calling `create_push_funds_transfer`")
            raise ValueError("Missing the required parameter `v_c_merchant_id` when calling `create_push_funds_transfer`")
        # verify the required parameter 'v_c_permissions' is set
        if ('v_c_permissions' not in params) or (params['v_c_permissions'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `v_c_permissions` when calling `create_push_funds_transfer`")
            raise ValueError("Missing the required parameter `v_c_permissions` when calling `create_push_funds_transfer`")
        # verify the required parameter 'v_c_correlation_id' is set
        if ('v_c_correlation_id' not in params) or (params['v_c_correlation_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `v_c_correlation_id` when calling `create_push_funds_transfer`")
            raise ValueError("Missing the required parameter `v_c_correlation_id` when calling `create_push_funds_transfer`")
        # verify the required parameter 'v_c_organization_id' is set
        if ('v_c_organization_id' not in params) or (params['v_c_organization_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `v_c_organization_id` when calling `create_push_funds_transfer`")
            raise ValueError("Missing the required parameter `v_c_organization_id` when calling `create_push_funds_transfer`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']
        if 'x_requestid' in params:
            header_params['x-requestid'] = params['x_requestid']
        if 'v_c_merchant_id' in params:
            header_params['v-c-merchant-id'] = params['v_c_merchant_id']
        if 'v_c_permissions' in params:
            header_params['v-c-permissions'] = params['v_c_permissions']
        if 'v_c_correlation_id' in params:
            header_params['v-c-correlation-id'] = params['v_c_correlation_id']
        if 'v_c_organization_id' in params:
            header_params['v-c-organization-id'] = params['v_c_organization_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'push_funds_request' in params:
            body_params = params['push_funds_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'push_funds_request', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)

        if 'POST' == GlobalLabelParameters.POST or 'POST' == GlobalLabelParameters.PUT or 'POST' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = True
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "create_push_funds_transfer,create_push_funds_transfer_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/pts/v1/push-funds-transfer', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PushFunds201Response',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
