# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory
from authenticationsdk.util.MLEUtility import MLEUtility
from authenticationsdk.util.GlobalLabelParameters import GlobalLabelParameters
from authenticationsdk.util.Utility import process_body

from ..utilities.tracking.sdk_tracker import SdkTracker
class TokenizedCardApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def delete_tokenized_card(self, tokenized_card_id, **kwargs):
        """
        Delete a Tokenized Card
        |  |  |  | | --- | --- | --- | | The Network Token will attempt to be deleted from the card association and if successful the corresponding TMS Network Token will be deleted. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tokenized_card(tokenized_card_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str tokenized_card_id: The Id of a tokenized card. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `delete_tokenized_card` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_tokenized_card_with_http_info(tokenized_card_id, **kwargs)
        else:
            (data) = self.delete_tokenized_card_with_http_info(tokenized_card_id, **kwargs)
            return data

    def delete_tokenized_card_with_http_info(self, tokenized_card_id, **kwargs):
        """
        Delete a Tokenized Card
        |  |  |  | | --- | --- | --- | | The Network Token will attempt to be deleted from the card association and if successful the corresponding TMS Network Token will be deleted. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tokenized_card_with_http_info(tokenized_card_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str tokenized_card_id: The Id of a tokenized card. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tokenized_card_id', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tokenized_card" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tokenized_card_id' is set
        if ('tokenized_card_id' not in params) or (params['tokenized_card_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `tokenized_card_id` when calling `delete_tokenized_card`")
            raise ValueError("Missing the required parameter `tokenized_card_id` when calling `delete_tokenized_card`")


        collection_formats = {}

        path_params = {}
        if 'tokenized_card_id' in params:
            path_params['tokenizedCardId'] = params['tokenized_card_id']
            tokenizedCardId=tokenized_card_id

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'DELETE' in ('POST'):
            body_params = '{}'

        if 'DELETE' == GlobalLabelParameters.POST or 'DELETE' == GlobalLabelParameters.PUT or 'DELETE' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "delete_tokenized_card,delete_tokenized_card_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v2/tokenized-cards/{tokenizedCardId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_tokenized_card(self, tokenized_card_id, **kwargs):
        """
        Retrieve a Tokenized Card
        |  |  |  | | --- | --- | --- | |**Tokenized Cards**<br>A Tokenized Card represents a network token. Network tokens perform better than regular card numbers and they are not necessarily invalidated when a cardholder loses their card, or it expires.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tokenized_card(tokenized_card_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str tokenized_card_id: The Id of a tokenized card. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: TokenizedcardRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `get_tokenized_card` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_tokenized_card_with_http_info(tokenized_card_id, **kwargs)
        else:
            (data) = self.get_tokenized_card_with_http_info(tokenized_card_id, **kwargs)
            return data

    def get_tokenized_card_with_http_info(self, tokenized_card_id, **kwargs):
        """
        Retrieve a Tokenized Card
        |  |  |  | | --- | --- | --- | |**Tokenized Cards**<br>A Tokenized Card represents a network token. Network tokens perform better than regular card numbers and they are not necessarily invalidated when a cardholder loses their card, or it expires.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tokenized_card_with_http_info(tokenized_card_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str tokenized_card_id: The Id of a tokenized card. (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: TokenizedcardRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tokenized_card_id', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tokenized_card" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tokenized_card_id' is set
        if ('tokenized_card_id' not in params) or (params['tokenized_card_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `tokenized_card_id` when calling `get_tokenized_card`")
            raise ValueError("Missing the required parameter `tokenized_card_id` when calling `get_tokenized_card`")


        collection_formats = {}

        path_params = {}
        if 'tokenized_card_id' in params:
            path_params['tokenizedCardId'] = params['tokenized_card_id']
            tokenizedCardId=tokenized_card_id

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'GET' in ('POST'):
            body_params = '{}'

        if 'GET' == GlobalLabelParameters.POST or 'GET' == GlobalLabelParameters.PUT or 'GET' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "get_tokenized_card,get_tokenized_card_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v2/tokenized-cards/{tokenizedCardId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TokenizedcardRequest',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_tokenized_card(self, tokenizedcard_request, **kwargs):
        """
        Create a Tokenized Card
        |  |  |  | | --- | --- | --- | |**Tokenized cards**<br>A Tokenized card represents a network token. Network tokens perform better than regular card numbers and they are not necessarily invalidated when a cardholder loses their card, or it expires. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_tokenized_card(tokenizedcard_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TokenizedcardRequest tokenizedcard_request: (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: TokenizedcardRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `post_tokenized_card` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_tokenized_card_with_http_info(tokenizedcard_request, **kwargs)
        else:
            (data) = self.post_tokenized_card_with_http_info(tokenizedcard_request, **kwargs)
            return data

    def post_tokenized_card_with_http_info(self, tokenizedcard_request, **kwargs):
        """
        Create a Tokenized Card
        |  |  |  | | --- | --- | --- | |**Tokenized cards**<br>A Tokenized card represents a network token. Network tokens perform better than regular card numbers and they are not necessarily invalidated when a cardholder loses their card, or it expires. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_tokenized_card_with_http_info(tokenizedcard_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TokenizedcardRequest tokenizedcard_request: (required)
        :param str profile_id: The Id of a profile containing user specific TMS configuration.
        :return: TokenizedcardRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tokenizedcard_request', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_tokenized_card" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tokenizedcard_request' is set
        if ('tokenizedcard_request' not in params) or (params['tokenizedcard_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `tokenizedcard_request` when calling `post_tokenized_card`")
            raise ValueError("Missing the required parameter `tokenizedcard_request` when calling `post_tokenized_card`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tokenizedcard_request' in params:
            body_params = params['tokenizedcard_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'tokenizedcard_request', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)

        if 'POST' == GlobalLabelParameters.POST or 'POST' == GlobalLabelParameters.PUT or 'POST' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "post_tokenized_card,post_tokenized_card_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v2/tokenized-cards', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TokenizedcardRequest',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
