# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory
from authenticationsdk.util.MLEUtility import MLEUtility
from authenticationsdk.util.GlobalLabelParameters import GlobalLabelParameters
from authenticationsdk.util.Utility import process_body

from ..utilities.tracking.sdk_tracker import SdkTracker
class VerificationApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def validate_export_compliance(self, validate_export_compliance_request, **kwargs):
        """
        Validate export compliance
        This call checks customer data against specified watch lists to ensure export compliance. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.validate_export_compliance(validate_export_compliance_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ValidateExportComplianceRequest validate_export_compliance_request: (required)
        :return: RiskV1ExportComplianceInquiriesPost201Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `validate_export_compliance` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.validate_export_compliance_with_http_info(validate_export_compliance_request, **kwargs)
        else:
            (data) = self.validate_export_compliance_with_http_info(validate_export_compliance_request, **kwargs)
            return data

    def validate_export_compliance_with_http_info(self, validate_export_compliance_request, **kwargs):
        """
        Validate export compliance
        This call checks customer data against specified watch lists to ensure export compliance. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.validate_export_compliance_with_http_info(validate_export_compliance_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ValidateExportComplianceRequest validate_export_compliance_request: (required)
        :return: RiskV1ExportComplianceInquiriesPost201Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['validate_export_compliance_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_export_compliance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'validate_export_compliance_request' is set
        if ('validate_export_compliance_request' not in params) or (params['validate_export_compliance_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `validate_export_compliance_request` when calling `validate_export_compliance`")
            raise ValueError("Missing the required parameter `validate_export_compliance_request` when calling `validate_export_compliance`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'validate_export_compliance_request' in params:
            body_params = params['validate_export_compliance_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'validate_export_compliance_request', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)

        if 'POST' == GlobalLabelParameters.POST or 'POST' == GlobalLabelParameters.PUT or 'POST' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "validate_export_compliance,validate_export_compliance_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/risk/v1/export-compliance-inquiries', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RiskV1ExportComplianceInquiriesPost201Response',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def verify_customer_address(self, verify_customer_address_request, **kwargs):
        """
        Verify customer address
        This call verifies that the customer address submitted is valid.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.verify_customer_address(verify_customer_address_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param VerifyCustomerAddressRequest verify_customer_address_request: (required)
        :return: RiskV1AddressVerificationsPost201Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `verify_customer_address` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.verify_customer_address_with_http_info(verify_customer_address_request, **kwargs)
        else:
            (data) = self.verify_customer_address_with_http_info(verify_customer_address_request, **kwargs)
            return data

    def verify_customer_address_with_http_info(self, verify_customer_address_request, **kwargs):
        """
        Verify customer address
        This call verifies that the customer address submitted is valid.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.verify_customer_address_with_http_info(verify_customer_address_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param VerifyCustomerAddressRequest verify_customer_address_request: (required)
        :return: RiskV1AddressVerificationsPost201Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['verify_customer_address_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_customer_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'verify_customer_address_request' is set
        if ('verify_customer_address_request' not in params) or (params['verify_customer_address_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `verify_customer_address_request` when calling `verify_customer_address`")
            raise ValueError("Missing the required parameter `verify_customer_address_request` when calling `verify_customer_address`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'verify_customer_address_request' in params:
            body_params = params['verify_customer_address_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'verify_customer_address_request', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)

        if 'POST' == GlobalLabelParameters.POST or 'POST' == GlobalLabelParameters.PUT or 'POST' == GlobalLabelParameters.PATCH:
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "verify_customer_address,verify_customer_address_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/risk/v1/address-verifications', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RiskV1AddressVerificationsPost201Response',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
