# coding: utf-8

"""
    OAuth2 API

    OAuth2 Token Service (OAuth2)

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class CreateAccessTokenRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'client_id': 'str',
        'client_secret': 'str',
        'grant_type': 'str',
        'code': 'str',
        'refresh_token': 'str'
    }

    attribute_map = {
        'client_id': 'client_id',
        'client_secret': 'client_secret',
        'grant_type': 'grant_type',
        'code': 'code',
        'refresh_token': 'refresh_token'
    }

    def __init__(self, client_id=None, client_secret=None, grant_type=None, code=None, refresh_token=None):
        """
        CreateAccessTokenRequest - a model defined in Swagger
        """

        self._client_id = None
        self._client_secret = None
        self._grant_type = None
        self._code = None
        self._refresh_token = None

        self.client_id = client_id
        self.client_secret = client_secret
        if grant_type is not None:
          self.grant_type = grant_type
        if code is not None:
          self.code = code
        if refresh_token is not None:
          self.refresh_token = refresh_token

    @property
    def client_id(self):
        """
        Gets the client_id of this CreateAccessTokenRequest.
        The client ID that you received when you registered your application in the CyberSource Business Center. This identifies your client application.

        :return: The client_id of this CreateAccessTokenRequest.
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """
        Sets the client_id of this CreateAccessTokenRequest.
        The client ID that you received when you registered your application in the CyberSource Business Center. This identifies your client application.

        :param client_id: The client_id of this CreateAccessTokenRequest.
        :type: str
        """
        if client_id is None:
            raise ValueError("Invalid value for `client_id`, must not be `None`")

        self._client_id = client_id

    @property
    def client_secret(self):
        """
        Gets the client_secret of this CreateAccessTokenRequest.
        The client secret that you received when you registered your application in the CyberSource Business Center.

        :return: The client_secret of this CreateAccessTokenRequest.
        :rtype: str
        """
        return self._client_secret

    @client_secret.setter
    def client_secret(self, client_secret):
        """
        Sets the client_secret of this CreateAccessTokenRequest.
        The client secret that you received when you registered your application in the CyberSource Business Center.

        :param client_secret: The client_secret of this CreateAccessTokenRequest.
        :type: str
        """
        if client_secret is None:
            raise ValueError("Invalid value for `client_secret`, must not be `None`")

        self._client_secret = client_secret

    @property
    def grant_type(self):
        """
        Gets the grant_type of this CreateAccessTokenRequest.
        The grant type value determines which type of flow is used to obtain the access token. The first time your application requests a token, use the value `authorization_code`. When you use this value, you must also include the `code` field in the request. For subsequent request, use `refresh_token`. When you use this value, you must also include the `refresh_token` field in the request. Valid values: - authorization_code - refresh_token 

        :return: The grant_type of this CreateAccessTokenRequest.
        :rtype: str
        """
        return self._grant_type

    @grant_type.setter
    def grant_type(self, grant_type):
        """
        Sets the grant_type of this CreateAccessTokenRequest.
        The grant type value determines which type of flow is used to obtain the access token. The first time your application requests a token, use the value `authorization_code`. When you use this value, you must also include the `code` field in the request. For subsequent request, use `refresh_token`. When you use this value, you must also include the `refresh_token` field in the request. Valid values: - authorization_code - refresh_token 

        :param grant_type: The grant_type of this CreateAccessTokenRequest.
        :type: str
        """

        self._grant_type = grant_type

    @property
    def code(self):
        """
        Gets the code of this CreateAccessTokenRequest.
        This value is sent by CyberSource in the redirect URL. For security reasons, the code expires in 10 minutes. If it expires, you must repeat the redirect to request another. Conditional. This value is equired if grant_type is `authorization_code`.

        :return: The code of this CreateAccessTokenRequest.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this CreateAccessTokenRequest.
        This value is sent by CyberSource in the redirect URL. For security reasons, the code expires in 10 minutes. If it expires, you must repeat the redirect to request another. Conditional. This value is equired if grant_type is `authorization_code`.

        :param code: The code of this CreateAccessTokenRequest.
        :type: str
        """

        self._code = code

    @property
    def refresh_token(self):
        """
        Gets the refresh_token of this CreateAccessTokenRequest.
        Conditional. Required if grant_type is `refresh_token`.

        :return: The refresh_token of this CreateAccessTokenRequest.
        :rtype: str
        """
        return self._refresh_token

    @refresh_token.setter
    def refresh_token(self, refresh_token):
        """
        Sets the refresh_token of this CreateAccessTokenRequest.
        Conditional. Required if grant_type is `refresh_token`.

        :param refresh_token: The refresh_token of this CreateAccessTokenRequest.
        :type: str
        """

        self._refresh_token = refresh_token

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CreateAccessTokenRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
