# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory
from CyberSource.utilities.MultipartHelpers import MultipartHelpers
from authenticationsdk.util.MLEUtility import MLEUtility
from authenticationsdk.util.GlobalLabelParameters import GlobalLabelParameters
from authenticationsdk.util.Utility import process_body

from ..utilities.tracking.sdk_tracker import SdkTracker
class CreateNewWebhooksApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def find_products_to_subscribe(self, organization_id, **kwargs):
        """
        Find Products You Can Subscribe To
        Retrieve a list of products and event types that your account is eligible for. These products and events are the ones that you may subscribe to in the next step of creating webhooks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.find_products_to_subscribe(organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str organization_id: The Organization Identifier. (required)
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `find_products_to_subscribe` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.find_products_to_subscribe_with_http_info(organization_id, **kwargs)
        else:
            (data) = self.find_products_to_subscribe_with_http_info(organization_id, **kwargs)
            return data

    def find_products_to_subscribe_with_http_info(self, organization_id, **kwargs):
        """
        Find Products You Can Subscribe To
        Retrieve a list of products and event types that your account is eligible for. These products and events are the ones that you may subscribe to in the next step of creating webhooks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.find_products_to_subscribe_with_http_info(organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str organization_id: The Organization Identifier. (required)
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_products_to_subscribe" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params) or (params['organization_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `organization_id` when calling `find_products_to_subscribe`")
            raise ValueError("Missing the required parameter `organization_id` when calling `find_products_to_subscribe`")


        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']
            organizationId=organization_id

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'GET' in ('POST'):
            body_params = '{}'
        
        file_post_body_and_delimiter = MultipartHelpers.build_post_body_for_files(local_var_files)
        if file_post_body_and_delimiter is not None:
            body_params = file_post_body_and_delimiter[0]
            header_params['Content-Type'] = f"multipart/form-data; boundary={file_post_body_and_delimiter[1]}" 

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "find_products_to_subscribe,find_products_to_subscribe_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/notification-subscriptions/v2/products/{organizationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[InlineResponse2003]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def notification_subscriptions_v2_webhooks_post(self, **kwargs):
        """
        Create a New Webhook Subscription
        Create a new webhook subscription. Before creating a webhook, ensure that a signature key has been created.  For the example \"Create Webhook using oAuth with Client Credentials\" - for clients who have more than one oAuth Provider and have different client secrets that they would like to config for a given webhook, they may do so by overriding the keyId inside security config of webhook subscription. See the Developer Center examples section titled \"Webhook Security - Create or Store Egress Symmetric Key - Store oAuth Credentials For Symmetric Key\" to store these oAuth credentials that CYBS will need for oAuth.  For JWT authentication, attach your oAuth details to the webhook subscription. See the example \"Create Webhook using oAuth with JWT\" 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.notification_subscriptions_v2_webhooks_post(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateWebhook create_webhook: The webhook payload
        :return: InlineResponse2014
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `notification_subscriptions_v2_webhooks_post` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.notification_subscriptions_v2_webhooks_post_with_http_info(**kwargs)
        else:
            (data) = self.notification_subscriptions_v2_webhooks_post_with_http_info(**kwargs)
            return data

    def notification_subscriptions_v2_webhooks_post_with_http_info(self, **kwargs):
        """
        Create a New Webhook Subscription
        Create a new webhook subscription. Before creating a webhook, ensure that a signature key has been created.  For the example \"Create Webhook using oAuth with Client Credentials\" - for clients who have more than one oAuth Provider and have different client secrets that they would like to config for a given webhook, they may do so by overriding the keyId inside security config of webhook subscription. See the Developer Center examples section titled \"Webhook Security - Create or Store Egress Symmetric Key - Store oAuth Credentials For Symmetric Key\" to store these oAuth credentials that CYBS will need for oAuth.  For JWT authentication, attach your oAuth details to the webhook subscription. See the example \"Create Webhook using oAuth with JWT\" 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.notification_subscriptions_v2_webhooks_post_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateWebhook create_webhook: The webhook payload
        :return: InlineResponse2014
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['create_webhook']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_subscriptions_v2_webhooks_post" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'create_webhook' in params:
            body_params = params['create_webhook']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'create_webhook', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "notification_subscriptions_v2_webhooks_post,notification_subscriptions_v2_webhooks_post_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/notification-subscriptions/v2/webhooks', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InlineResponse2014',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def save_sym_egress_key(self, v_c_sender_organization_id, v_c_permissions, **kwargs):
        """
        Create Webhook Security Keys
        Create security keys that CyberSource will use internally to connect to your servers and validate messages using a digital signature.  Select the CREATE example for CyberSource to generate the key on our server and maintain it for you as well. Remember to save the key in the API response, so that you can use it to validate messages later. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.save_sym_egress_key(v_c_sender_organization_id, v_c_permissions, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str v_c_sender_organization_id: Sender organization id (required)
        :param str v_c_permissions: Encoded user permissions returned by the CGK, for the entity user who initiated the boarding (required)
        :param str v_c_correlation_id: A globally unique id associated with your request
        :param SaveSymEgressKey save_sym_egress_key: Provide egress Symmetric key information to save (create or store or refresh)
        :return: InlineResponse2013
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `save_sym_egress_key` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.save_sym_egress_key_with_http_info(v_c_sender_organization_id, v_c_permissions, **kwargs)
        else:
            (data) = self.save_sym_egress_key_with_http_info(v_c_sender_organization_id, v_c_permissions, **kwargs)
            return data

    def save_sym_egress_key_with_http_info(self, v_c_sender_organization_id, v_c_permissions, **kwargs):
        """
        Create Webhook Security Keys
        Create security keys that CyberSource will use internally to connect to your servers and validate messages using a digital signature.  Select the CREATE example for CyberSource to generate the key on our server and maintain it for you as well. Remember to save the key in the API response, so that you can use it to validate messages later. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.save_sym_egress_key_with_http_info(v_c_sender_organization_id, v_c_permissions, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str v_c_sender_organization_id: Sender organization id (required)
        :param str v_c_permissions: Encoded user permissions returned by the CGK, for the entity user who initiated the boarding (required)
        :param str v_c_correlation_id: A globally unique id associated with your request
        :param SaveSymEgressKey save_sym_egress_key: Provide egress Symmetric key information to save (create or store or refresh)
        :return: InlineResponse2013
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['v_c_sender_organization_id', 'v_c_permissions', 'v_c_correlation_id', 'save_sym_egress_key']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_sym_egress_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'v_c_sender_organization_id' is set
        if ('v_c_sender_organization_id' not in params) or (params['v_c_sender_organization_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `v_c_sender_organization_id` when calling `save_sym_egress_key`")
            raise ValueError("Missing the required parameter `v_c_sender_organization_id` when calling `save_sym_egress_key`")
        # verify the required parameter 'v_c_permissions' is set
        if ('v_c_permissions' not in params) or (params['v_c_permissions'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `v_c_permissions` when calling `save_sym_egress_key`")
            raise ValueError("Missing the required parameter `v_c_permissions` when calling `save_sym_egress_key`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'v_c_correlation_id' in params:
            header_params['v-c-correlation-id'] = params['v_c_correlation_id']
        if 'v_c_sender_organization_id' in params:
            header_params['v-c-sender-organization-id'] = params['v_c_sender_organization_id']
        if 'v_c_permissions' in params:
            header_params['v-c-permissions'] = params['v_c_permissions']

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'save_sym_egress_key' in params:
            body_params = params['save_sym_egress_key']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'save_sym_egress_key', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "save_sym_egress_key,save_sym_egress_key_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/kms/egress/v2/keys-sym', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InlineResponse2013',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
