# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory
from CyberSource.utilities.MultipartHelpers import MultipartHelpers
from authenticationsdk.util.MLEUtility import MLEUtility
from authenticationsdk.util.GlobalLabelParameters import GlobalLabelParameters
from authenticationsdk.util.Utility import process_body

from ..utilities.tracking.sdk_tracker import SdkTracker
class DeviceDeAssociationV3Api(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def post_de_associate_v3_terminal(self, device_de_associate_v3_request, **kwargs):
        """
        De-associate a device from merchant to account or reseller and from account to reseller V3
        A device will be de-associated from its current organization and moved up in the hierarchy. The device's new position will be determined by a specified destination, either an account or a portfolio. If no destination is provided, the device will default to the currently logged-in user. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_de_associate_v3_terminal(device_de_associate_v3_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[DeviceDeAssociateV3Request] device_de_associate_v3_request: deviceId that has to be de-associated to the destination organizationId. (required)
        :return: list[InlineResponse2005]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `post_de_associate_v3_terminal` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_de_associate_v3_terminal_with_http_info(device_de_associate_v3_request, **kwargs)
        else:
            (data) = self.post_de_associate_v3_terminal_with_http_info(device_de_associate_v3_request, **kwargs)
            return data

    def post_de_associate_v3_terminal_with_http_info(self, device_de_associate_v3_request, **kwargs):
        """
        De-associate a device from merchant to account or reseller and from account to reseller V3
        A device will be de-associated from its current organization and moved up in the hierarchy. The device's new position will be determined by a specified destination, either an account or a portfolio. If no destination is provided, the device will default to the currently logged-in user. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_de_associate_v3_terminal_with_http_info(device_de_associate_v3_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[DeviceDeAssociateV3Request] device_de_associate_v3_request: deviceId that has to be de-associated to the destination organizationId. (required)
        :return: list[InlineResponse2005]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_de_associate_v3_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_de_associate_v3_terminal" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_de_associate_v3_request' is set
        if ('device_de_associate_v3_request' not in params) or (params['device_de_associate_v3_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `device_de_associate_v3_request` when calling `post_de_associate_v3_terminal`")
            raise ValueError("Missing the required parameter `device_de_associate_v3_request` when calling `post_de_associate_v3_terminal`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json;charset=UTF-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=UTF-8'])

        body_params = None
        if 'device_de_associate_v3_request' in params:
            body_params = params['device_de_associate_v3_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'device_de_associate_v3_request', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "post_de_associate_v3_terminal,post_de_associate_v3_terminal_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/dms/v3/devices/deassociate', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[InlineResponse2005]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
