# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory
from CyberSource.utilities.MultipartHelpers import MultipartHelpers
from authenticationsdk.util.MLEUtility import MLEUtility
from authenticationsdk.util.GlobalLabelParameters import GlobalLabelParameters
from authenticationsdk.util.Utility import process_body

from ..utilities.tracking.sdk_tracker import SdkTracker
class SubscriptionsFollowOnsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def create_follow_on_subscription(self, request_id, create_subscription_request, **kwargs):
        """
        Create a Follow-On Subscription
        Create a new Subscription based on the Request Id of an existing successful Transaction.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_follow_on_subscription(request_id, create_subscription_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str request_id: Request Id of an existing successful Transaction (required)
        :param CreateSubscriptionRequest1 create_subscription_request: (required)
        :return: CreateSubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `create_follow_on_subscription` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_follow_on_subscription_with_http_info(request_id, create_subscription_request, **kwargs)
        else:
            (data) = self.create_follow_on_subscription_with_http_info(request_id, create_subscription_request, **kwargs)
            return data

    def create_follow_on_subscription_with_http_info(self, request_id, create_subscription_request, **kwargs):
        """
        Create a Follow-On Subscription
        Create a new Subscription based on the Request Id of an existing successful Transaction.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_follow_on_subscription_with_http_info(request_id, create_subscription_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str request_id: Request Id of an existing successful Transaction (required)
        :param CreateSubscriptionRequest1 create_subscription_request: (required)
        :return: CreateSubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request_id', 'create_subscription_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_follow_on_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request_id' is set
        if ('request_id' not in params) or (params['request_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `request_id` when calling `create_follow_on_subscription`")
            raise ValueError("Missing the required parameter `request_id` when calling `create_follow_on_subscription`")
        # verify the required parameter 'create_subscription_request' is set
        if ('create_subscription_request' not in params) or (params['create_subscription_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `create_subscription_request` when calling `create_follow_on_subscription`")
            raise ValueError("Missing the required parameter `create_subscription_request` when calling `create_follow_on_subscription`")


        collection_formats = {}

        path_params = {}
        if 'request_id' in params:
            path_params['requestId'] = params['request_id']
            requestId=request_id

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json', 'application/hal+json', 'application/json;charset=utf-8', 'application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'create_subscription_request' in params:
            body_params = params['create_subscription_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'create_subscription_request', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "create_follow_on_subscription,create_follow_on_subscription_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/rbs/v1/subscriptions/follow-ons/{requestId}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CreateSubscriptionResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_follow_on_subscription(self, request_id, **kwargs):
        """
        Get a Follow-On Subscription
        Get details of the Subscription being created based on the Request Id of an existing successful Transaction. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_follow_on_subscription(request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str request_id: Request Id of an existing successful Transaction (required)
        :return: GetSubscriptionResponse1
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `get_follow_on_subscription` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_follow_on_subscription_with_http_info(request_id, **kwargs)
        else:
            (data) = self.get_follow_on_subscription_with_http_info(request_id, **kwargs)
            return data

    def get_follow_on_subscription_with_http_info(self, request_id, **kwargs):
        """
        Get a Follow-On Subscription
        Get details of the Subscription being created based on the Request Id of an existing successful Transaction. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_follow_on_subscription_with_http_info(request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str request_id: Request Id of an existing successful Transaction (required)
        :return: GetSubscriptionResponse1
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_follow_on_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request_id' is set
        if ('request_id' not in params) or (params['request_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `request_id` when calling `get_follow_on_subscription`")
            raise ValueError("Missing the required parameter `request_id` when calling `get_follow_on_subscription`")


        collection_formats = {}

        path_params = {}
        if 'request_id' in params:
            path_params['requestId'] = params['request_id']
            requestId=request_id

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json', 'application/hal+json', 'application/json;charset=utf-8', 'application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'GET' in ('POST'):
            body_params = '{}'
        
        file_post_body_and_delimiter = MultipartHelpers.build_post_body_for_files(local_var_files)
        if file_post_body_and_delimiter is not None:
            body_params = file_post_body_and_delimiter[0]
            header_params['Content-Type'] = f"multipart/form-data; boundary={file_post_body_and_delimiter[1]}" 

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "get_follow_on_subscription,get_follow_on_subscription_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/rbs/v1/subscriptions/follow-ons/{requestId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='GetSubscriptionResponse1',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
