# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class TmsBusinessInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'doing_business_as': 'str',
        'address': 'TmsBusinessInformationAddress',
        'website_url': 'str',
        'business_identification_type': 'str',
        'business_identification_value': 'str',
        'acquirer': 'TmsBusinessInformationAcquirer'
    }

    attribute_map = {
        'name': 'name',
        'doing_business_as': 'doingBusinessAs',
        'address': 'address',
        'website_url': 'websiteUrl',
        'business_identification_type': 'businessIdentificationType',
        'business_identification_value': 'businessIdentificationValue',
        'acquirer': 'acquirer'
    }

    def __init__(self, name=None, doing_business_as=None, address=None, website_url=None, business_identification_type=None, business_identification_value=None, acquirer=None):
        """
        TmsBusinessInformation - a model defined in Swagger
        """

        self._name = None
        self._doing_business_as = None
        self._address = None
        self._website_url = None
        self._business_identification_type = None
        self._business_identification_value = None
        self._acquirer = None

        if name is not None:
          self.name = name
        if doing_business_as is not None:
          self.doing_business_as = doing_business_as
        if address is not None:
          self.address = address
        if website_url is not None:
          self.website_url = website_url
        if business_identification_type is not None:
          self.business_identification_type = business_identification_type
        if business_identification_value is not None:
          self.business_identification_value = business_identification_value
        if acquirer is not None:
          self.acquirer = acquirer

    @property
    def name(self):
        """
        Gets the name of this TmsBusinessInformation.
        Name of the network token merchant.

        :return: The name of this TmsBusinessInformation.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this TmsBusinessInformation.
        Name of the network token merchant.

        :param name: The name of this TmsBusinessInformation.
        :type: str
        """

        self._name = name

    @property
    def doing_business_as(self):
        """
        Gets the doing_business_as of this TmsBusinessInformation.
        Name the network token merchant does business as

        :return: The doing_business_as of this TmsBusinessInformation.
        :rtype: str
        """
        return self._doing_business_as

    @doing_business_as.setter
    def doing_business_as(self, doing_business_as):
        """
        Sets the doing_business_as of this TmsBusinessInformation.
        Name the network token merchant does business as

        :param doing_business_as: The doing_business_as of this TmsBusinessInformation.
        :type: str
        """

        self._doing_business_as = doing_business_as

    @property
    def address(self):
        """
        Gets the address of this TmsBusinessInformation.

        :return: The address of this TmsBusinessInformation.
        :rtype: TmsBusinessInformationAddress
        """
        return self._address

    @address.setter
    def address(self, address):
        """
        Sets the address of this TmsBusinessInformation.

        :param address: The address of this TmsBusinessInformation.
        :type: TmsBusinessInformationAddress
        """

        self._address = address

    @property
    def website_url(self):
        """
        Gets the website_url of this TmsBusinessInformation.
        Website of network token merchant.

        :return: The website_url of this TmsBusinessInformation.
        :rtype: str
        """
        return self._website_url

    @website_url.setter
    def website_url(self, website_url):
        """
        Sets the website_url of this TmsBusinessInformation.
        Website of network token merchant.

        :param website_url: The website_url of this TmsBusinessInformation.
        :type: str
        """

        self._website_url = website_url

    @property
    def business_identification_type(self):
        """
        Gets the business_identification_type of this TmsBusinessInformation.
        The Identifier associated with the business type; required unless both acquirerId and acquirerMerchantId are provided. 

        :return: The business_identification_type of this TmsBusinessInformation.
        :rtype: str
        """
        return self._business_identification_type

    @business_identification_type.setter
    def business_identification_type(self, business_identification_type):
        """
        Sets the business_identification_type of this TmsBusinessInformation.
        The Identifier associated with the business type; required unless both acquirerId and acquirerMerchantId are provided. 

        :param business_identification_type: The business_identification_type of this TmsBusinessInformation.
        :type: str
        """

        self._business_identification_type = business_identification_type

    @property
    def business_identification_value(self):
        """
        Gets the business_identification_value of this TmsBusinessInformation.
        The value associated with the business identifier type; required unless both acquirerId and acquirerMerchantId are provided. 

        :return: The business_identification_value of this TmsBusinessInformation.
        :rtype: str
        """
        return self._business_identification_value

    @business_identification_value.setter
    def business_identification_value(self, business_identification_value):
        """
        Sets the business_identification_value of this TmsBusinessInformation.
        The value associated with the business identifier type; required unless both acquirerId and acquirerMerchantId are provided. 

        :param business_identification_value: The business_identification_value of this TmsBusinessInformation.
        :type: str
        """

        self._business_identification_value = business_identification_value

    @property
    def acquirer(self):
        """
        Gets the acquirer of this TmsBusinessInformation.

        :return: The acquirer of this TmsBusinessInformation.
        :rtype: TmsBusinessInformationAcquirer
        """
        return self._acquirer

    @acquirer.setter
    def acquirer(self, acquirer):
        """
        Sets the acquirer of this TmsBusinessInformation.

        :param acquirer: The acquirer of this TmsBusinessInformation.
        :type: TmsBusinessInformationAcquirer
        """

        self._acquirer = acquirer

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TmsBusinessInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
