# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class PostDeviceSearchRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'query': 'str',
        'sort': 'str',
        'offset': 'int',
        'limit': 'int'
    }

    attribute_map = {
        'query': 'query',
        'sort': 'sort',
        'offset': 'offset',
        'limit': 'limit'
    }

    def __init__(self, query=None, sort=None, offset=None, limit=None):
        """
        PostDeviceSearchRequest - a model defined in Swagger
        """

        self._query = None
        self._sort = None
        self._offset = None
        self._limit = None

        if query is not None:
          self.query = query
        if sort is not None:
          self.sort = sort
        if offset is not None:
          self.offset = offset
        if limit is not None:
          self.limit = limit

    @property
    def query(self):
        """
        Gets the query of this PostDeviceSearchRequest.
        The Search Query to retrieve the Terminals(Example :- terminalSerialNumber:12345678 AND readerId:66c395ca-4f20-4b40-acac-5ff4c772d5f9 AND terminalId:T9KN88RTPE). Empty Query returns everything for the given organization.

        :return: The query of this PostDeviceSearchRequest.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this PostDeviceSearchRequest.
        The Search Query to retrieve the Terminals(Example :- terminalSerialNumber:12345678 AND readerId:66c395ca-4f20-4b40-acac-5ff4c772d5f9 AND terminalId:T9KN88RTPE). Empty Query returns everything for the given organization.

        :param query: The query of this PostDeviceSearchRequest.
        :type: str
        """

        self._query = query

    @property
    def sort(self):
        """
        Gets the sort of this PostDeviceSearchRequest.
        The Sort Query to order the Terminals by. By Default, It is in ascending order of last update of a device.

        :return: The sort of this PostDeviceSearchRequest.
        :rtype: str
        """
        return self._sort

    @sort.setter
    def sort(self, sort):
        """
        Sets the sort of this PostDeviceSearchRequest.
        The Sort Query to order the Terminals by. By Default, It is in ascending order of last update of a device.

        :param sort: The sort of this PostDeviceSearchRequest.
        :type: str
        """

        self._sort = sort

    @property
    def offset(self):
        """
        Gets the offset of this PostDeviceSearchRequest.
        The offset or page number.

        :return: The offset of this PostDeviceSearchRequest.
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """
        Sets the offset of this PostDeviceSearchRequest.
        The offset or page number.

        :param offset: The offset of this PostDeviceSearchRequest.
        :type: int
        """

        self._offset = offset

    @property
    def limit(self):
        """
        Gets the limit of this PostDeviceSearchRequest.
        Number of devices to retrieve in one request.

        :return: The limit of this PostDeviceSearchRequest.
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """
        Sets the limit of this PostDeviceSearchRequest.
        Number of devices to retrieve in one request.

        :param limit: The limit of this PostDeviceSearchRequest.
        :type: int
        """

        self._limit = limit

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PostDeviceSearchRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
