# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory
from CyberSource.utilities.MultipartHelpers import MultipartHelpers
from authenticationsdk.util.MLEUtility import MLEUtility
from authenticationsdk.util.GlobalLabelParameters import GlobalLabelParameters
from authenticationsdk.util.Utility import process_body

from ..utilities.tracking.sdk_tracker import SdkTracker
class ManageWebhooksApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def delete_webhook_subscription(self, webhook_id, **kwargs):
        """
        Delete a Webhook Subscription
        Delete the webhook. Please note that deleting a particular webhook does not delete the history of the webhook notifications.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_webhook_subscription(webhook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str webhook_id: The webhook identifier. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `delete_webhook_subscription` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_webhook_subscription_with_http_info(webhook_id, **kwargs)
        else:
            (data) = self.delete_webhook_subscription_with_http_info(webhook_id, **kwargs)
            return data

    def delete_webhook_subscription_with_http_info(self, webhook_id, **kwargs):
        """
        Delete a Webhook Subscription
        Delete the webhook. Please note that deleting a particular webhook does not delete the history of the webhook notifications.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_webhook_subscription_with_http_info(webhook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str webhook_id: The webhook identifier. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_webhook_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_id' is set
        if ('webhook_id' not in params) or (params['webhook_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `webhook_id` when calling `delete_webhook_subscription`")
            raise ValueError("Missing the required parameter `webhook_id` when calling `delete_webhook_subscription`")


        collection_formats = {}

        path_params = {}
        if 'webhook_id' in params:
            path_params['webhookId'] = params['webhook_id']
            webhookId=webhook_id

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'DELETE' in ('POST'):
            body_params = '{}'
        
        file_post_body_and_delimiter = MultipartHelpers.build_post_body_for_files(local_var_files)
        if file_post_body_and_delimiter is not None:
            body_params = file_post_body_and_delimiter[0]
            header_params['Content-Type'] = f"multipart/form-data; boundary={file_post_body_and_delimiter[1]}" 

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "delete_webhook_subscription,delete_webhook_subscription_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/notification-subscriptions/v2/webhooks/{webhookId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_webhook_subscription_by_id(self, webhook_id, **kwargs):
        """
        Get Details On a Single Webhook
        Retrieve the details of a specific webhook by supplying the webhook ID in the path.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_webhook_subscription_by_id(webhook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str webhook_id: The webhook Identifier (required)
        :return: InlineResponse2015
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `get_webhook_subscription_by_id` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_webhook_subscription_by_id_with_http_info(webhook_id, **kwargs)
        else:
            (data) = self.get_webhook_subscription_by_id_with_http_info(webhook_id, **kwargs)
            return data

    def get_webhook_subscription_by_id_with_http_info(self, webhook_id, **kwargs):
        """
        Get Details On a Single Webhook
        Retrieve the details of a specific webhook by supplying the webhook ID in the path.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_webhook_subscription_by_id_with_http_info(webhook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str webhook_id: The webhook Identifier (required)
        :return: InlineResponse2015
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhook_subscription_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_id' is set
        if ('webhook_id' not in params) or (params['webhook_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `webhook_id` when calling `get_webhook_subscription_by_id`")
            raise ValueError("Missing the required parameter `webhook_id` when calling `get_webhook_subscription_by_id`")


        collection_formats = {}

        path_params = {}
        if 'webhook_id' in params:
            path_params['webhookId'] = params['webhook_id']
            webhookId=webhook_id

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'GET' in ('POST'):
            body_params = '{}'
        
        file_post_body_and_delimiter = MultipartHelpers.build_post_body_for_files(local_var_files)
        if file_post_body_and_delimiter is not None:
            body_params = file_post_body_and_delimiter[0]
            header_params['Content-Type'] = f"multipart/form-data; boundary={file_post_body_and_delimiter[1]}" 

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "get_webhook_subscription_by_id,get_webhook_subscription_by_id_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/notification-subscriptions/v2/webhooks/{webhookId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InlineResponse2015',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_webhook_subscriptions_by_org(self, organization_id, **kwargs):
        """
        Get Details On All Created Webhooks
        Retrieve a list of all previously created webhooks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_webhook_subscriptions_by_org(organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str organization_id: The Organization Identifier. (required)
        :param str product_id: The Product Identifier.
        :param str event_type: The Event Type.
        :return: list[InlineResponse2004]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `get_webhook_subscriptions_by_org` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_webhook_subscriptions_by_org_with_http_info(organization_id, **kwargs)
        else:
            (data) = self.get_webhook_subscriptions_by_org_with_http_info(organization_id, **kwargs)
            return data

    def get_webhook_subscriptions_by_org_with_http_info(self, organization_id, **kwargs):
        """
        Get Details On All Created Webhooks
        Retrieve a list of all previously created webhooks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_webhook_subscriptions_by_org_with_http_info(organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str organization_id: The Organization Identifier. (required)
        :param str product_id: The Product Identifier.
        :param str event_type: The Event Type.
        :return: list[InlineResponse2004]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'product_id', 'event_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhook_subscriptions_by_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params) or (params['organization_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `organization_id` when calling `get_webhook_subscriptions_by_org`")
            raise ValueError("Missing the required parameter `organization_id` when calling `get_webhook_subscriptions_by_org`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'organization_id' in params:
            query_params.append(('organizationId', params['organization_id']))
        if 'product_id' in params:
            query_params.append(('productId', params['product_id']))
        if 'event_type' in params:
            query_params.append(('eventType', params['event_type']))

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'GET' in ('POST'):
            body_params = '{}'
        
        file_post_body_and_delimiter = MultipartHelpers.build_post_body_for_files(local_var_files)
        if file_post_body_and_delimiter is not None:
            body_params = file_post_body_and_delimiter[0]
            header_params['Content-Type'] = f"multipart/form-data; boundary={file_post_body_and_delimiter[1]}" 

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "get_webhook_subscriptions_by_org,get_webhook_subscriptions_by_org_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/notification-subscriptions/v2/webhooks', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[InlineResponse2004]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def notification_subscriptions_v1_webhooks_webhook_id_post(self, webhook_id, **kwargs):
        """
        Test a Webhook Configuration
        Test the webhook configuration by sending a sample webhook. Calling this endpoint sends a sample webhook to the endpoint identified in the user's subscription.   It will contain sample values for the product & eventType based on values present in your subscription along with a sample message in the payload.   Based on the webhook response users can make any necessary modifications or rest assured knowing their setup is configured correctly. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.notification_subscriptions_v1_webhooks_webhook_id_post(webhook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str webhook_id: The Webhook Identifier. (required)
        :return: InlineResponse2016
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `notification_subscriptions_v1_webhooks_webhook_id_post` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.notification_subscriptions_v1_webhooks_webhook_id_post_with_http_info(webhook_id, **kwargs)
        else:
            (data) = self.notification_subscriptions_v1_webhooks_webhook_id_post_with_http_info(webhook_id, **kwargs)
            return data

    def notification_subscriptions_v1_webhooks_webhook_id_post_with_http_info(self, webhook_id, **kwargs):
        """
        Test a Webhook Configuration
        Test the webhook configuration by sending a sample webhook. Calling this endpoint sends a sample webhook to the endpoint identified in the user's subscription.   It will contain sample values for the product & eventType based on values present in your subscription along with a sample message in the payload.   Based on the webhook response users can make any necessary modifications or rest assured knowing their setup is configured correctly. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.notification_subscriptions_v1_webhooks_webhook_id_post_with_http_info(webhook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str webhook_id: The Webhook Identifier. (required)
        :return: InlineResponse2016
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_subscriptions_v1_webhooks_webhook_id_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_id' is set
        if ('webhook_id' not in params) or (params['webhook_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `webhook_id` when calling `notification_subscriptions_v1_webhooks_webhook_id_post`")
            raise ValueError("Missing the required parameter `webhook_id` when calling `notification_subscriptions_v1_webhooks_webhook_id_post`")


        collection_formats = {}

        path_params = {}
        if 'webhook_id' in params:
            path_params['webhookId'] = params['webhook_id']
            webhookId=webhook_id

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'POST' in ('POST'):
            body_params = '{}'
        
        file_post_body_and_delimiter = MultipartHelpers.build_post_body_for_files(local_var_files)
        if file_post_body_and_delimiter is not None:
            body_params = file_post_body_and_delimiter[0]
            header_params['Content-Type'] = f"multipart/form-data; boundary={file_post_body_and_delimiter[1]}" 

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "notification_subscriptions_v1_webhooks_webhook_id_post,notification_subscriptions_v1_webhooks_webhook_id_post_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/notification-subscriptions/v1/webhooks/{webhookId}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InlineResponse2016',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def notification_subscriptions_v2_webhooks_webhook_id_patch(self, webhook_id, **kwargs):
        """
        Update a Webhook Subscription
        Update a Webhook Subscription.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.notification_subscriptions_v2_webhooks_webhook_id_patch(webhook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str webhook_id: The Webhook Identifier. (required)
        :param UpdateWebhook update_webhook: The webhook payload or changes to apply.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `notification_subscriptions_v2_webhooks_webhook_id_patch` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.notification_subscriptions_v2_webhooks_webhook_id_patch_with_http_info(webhook_id, **kwargs)
        else:
            (data) = self.notification_subscriptions_v2_webhooks_webhook_id_patch_with_http_info(webhook_id, **kwargs)
            return data

    def notification_subscriptions_v2_webhooks_webhook_id_patch_with_http_info(self, webhook_id, **kwargs):
        """
        Update a Webhook Subscription
        Update a Webhook Subscription.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.notification_subscriptions_v2_webhooks_webhook_id_patch_with_http_info(webhook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str webhook_id: The Webhook Identifier. (required)
        :param UpdateWebhook update_webhook: The webhook payload or changes to apply.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_id', 'update_webhook']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_subscriptions_v2_webhooks_webhook_id_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_id' is set
        if ('webhook_id' not in params) or (params['webhook_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `webhook_id` when calling `notification_subscriptions_v2_webhooks_webhook_id_patch`")
            raise ValueError("Missing the required parameter `webhook_id` when calling `notification_subscriptions_v2_webhooks_webhook_id_patch`")


        collection_formats = {}

        path_params = {}
        if 'webhook_id' in params:
            path_params['webhookId'] = params['webhook_id']
            webhookId=webhook_id

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'update_webhook' in params:
            body_params = params['update_webhook']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'update_webhook', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "notification_subscriptions_v2_webhooks_webhook_id_patch,notification_subscriptions_v2_webhooks_webhook_id_patch_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/notification-subscriptions/v2/webhooks/{webhookId}', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def notification_subscriptions_v2_webhooks_webhook_id_status_put(self, webhook_id, **kwargs):
        """
        Update a Webhook Status
        Users can update the status of a webhook subscription by calling this endpoint.   The webhookId parameter in the URL path identifies the specific webhook subscription to be updated. The request body accepts the values ACTIVE or INACTIVE. If the subscription is set to INACTIVE, webhooks will not be delivered until the subscription is activated again. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.notification_subscriptions_v2_webhooks_webhook_id_status_put(webhook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str webhook_id: The Webhook Identifier. (required)
        :param UpdateStatus update_status: The status that the subscription should be updated to.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `notification_subscriptions_v2_webhooks_webhook_id_status_put` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.notification_subscriptions_v2_webhooks_webhook_id_status_put_with_http_info(webhook_id, **kwargs)
        else:
            (data) = self.notification_subscriptions_v2_webhooks_webhook_id_status_put_with_http_info(webhook_id, **kwargs)
            return data

    def notification_subscriptions_v2_webhooks_webhook_id_status_put_with_http_info(self, webhook_id, **kwargs):
        """
        Update a Webhook Status
        Users can update the status of a webhook subscription by calling this endpoint.   The webhookId parameter in the URL path identifies the specific webhook subscription to be updated. The request body accepts the values ACTIVE or INACTIVE. If the subscription is set to INACTIVE, webhooks will not be delivered until the subscription is activated again. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.notification_subscriptions_v2_webhooks_webhook_id_status_put_with_http_info(webhook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str webhook_id: The Webhook Identifier. (required)
        :param UpdateStatus update_status: The status that the subscription should be updated to.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_id', 'update_status']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_subscriptions_v2_webhooks_webhook_id_status_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_id' is set
        if ('webhook_id' not in params) or (params['webhook_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `webhook_id` when calling `notification_subscriptions_v2_webhooks_webhook_id_status_put`")
            raise ValueError("Missing the required parameter `webhook_id` when calling `notification_subscriptions_v2_webhooks_webhook_id_status_put`")


        collection_formats = {}

        path_params = {}
        if 'webhook_id' in params:
            path_params['webhookId'] = params['webhook_id']
            webhookId=webhook_id

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'update_status' in params:
            body_params = params['update_status']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'update_status', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "notification_subscriptions_v2_webhooks_webhook_id_status_put,notification_subscriptions_v2_webhooks_webhook_id_status_put_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/notification-subscriptions/v2/webhooks/{webhookId}/status', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def save_asym_egress_key(self, v_c_sender_organization_id, v_c_permissions, save_asym_egress_key, **kwargs):
        """
        Message Level Encryption
        Store and manage certificates that will be used to preform Message Level Encryption (MLE). Each new webhook will need its own unique asymmetric certificate. You can either use a digital certificate issued/signed by a CA or self-sign your own using the documentation available on the Developer Guide. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.save_asym_egress_key(v_c_sender_organization_id, v_c_permissions, save_asym_egress_key, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str v_c_sender_organization_id: Sender organization id (required)
        :param str v_c_permissions: Encoded user permissions returned by the CGK, for the entity user who initiated the boarding (required)
        :param SaveAsymEgressKey save_asym_egress_key: Provide egress Asymmetric key information to save (create or store) (required)
        :param str v_c_correlation_id: A globally unique id associated with your request
        :return: InlineResponse2017
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `save_asym_egress_key` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.save_asym_egress_key_with_http_info(v_c_sender_organization_id, v_c_permissions, save_asym_egress_key, **kwargs)
        else:
            (data) = self.save_asym_egress_key_with_http_info(v_c_sender_organization_id, v_c_permissions, save_asym_egress_key, **kwargs)
            return data

    def save_asym_egress_key_with_http_info(self, v_c_sender_organization_id, v_c_permissions, save_asym_egress_key, **kwargs):
        """
        Message Level Encryption
        Store and manage certificates that will be used to preform Message Level Encryption (MLE). Each new webhook will need its own unique asymmetric certificate. You can either use a digital certificate issued/signed by a CA or self-sign your own using the documentation available on the Developer Guide. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.save_asym_egress_key_with_http_info(v_c_sender_organization_id, v_c_permissions, save_asym_egress_key, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str v_c_sender_organization_id: Sender organization id (required)
        :param str v_c_permissions: Encoded user permissions returned by the CGK, for the entity user who initiated the boarding (required)
        :param SaveAsymEgressKey save_asym_egress_key: Provide egress Asymmetric key information to save (create or store) (required)
        :param str v_c_correlation_id: A globally unique id associated with your request
        :return: InlineResponse2017
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['v_c_sender_organization_id', 'v_c_permissions', 'save_asym_egress_key', 'v_c_correlation_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_asym_egress_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'v_c_sender_organization_id' is set
        if ('v_c_sender_organization_id' not in params) or (params['v_c_sender_organization_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `v_c_sender_organization_id` when calling `save_asym_egress_key`")
            raise ValueError("Missing the required parameter `v_c_sender_organization_id` when calling `save_asym_egress_key`")
        # verify the required parameter 'v_c_permissions' is set
        if ('v_c_permissions' not in params) or (params['v_c_permissions'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `v_c_permissions` when calling `save_asym_egress_key`")
            raise ValueError("Missing the required parameter `v_c_permissions` when calling `save_asym_egress_key`")
        # verify the required parameter 'save_asym_egress_key' is set
        if ('save_asym_egress_key' not in params) or (params['save_asym_egress_key'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `save_asym_egress_key` when calling `save_asym_egress_key`")
            raise ValueError("Missing the required parameter `save_asym_egress_key` when calling `save_asym_egress_key`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'v_c_correlation_id' in params:
            header_params['v-c-correlation-id'] = params['v_c_correlation_id']
        if 'v_c_sender_organization_id' in params:
            header_params['v-c-sender-organization-id'] = params['v_c_sender_organization_id']
        if 'v_c_permissions' in params:
            header_params['v-c-permissions'] = params['v_c_permissions']

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'save_asym_egress_key' in params:
            body_params = params['save_asym_egress_key']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'save_asym_egress_key', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)
            body_params = process_body(body_params)

        is_mle_supported_by_cybs_for_api = False
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, is_mle_supported_by_cybs_for_api, "save_asym_egress_key,save_asym_egress_key_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/kms/egress/v2/keys-asym', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InlineResponse2017',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
