# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class InlineResponse2015(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'webhook_id': 'str',
        'organization_id': 'str',
        'products': 'list[Notificationsubscriptionsv2webhooksProducts]',
        'webhook_url': 'str',
        'health_check_url': 'str',
        'status': 'str',
        'name': 'str',
        'description': 'str',
        'retry_policy': 'Notificationsubscriptionsv2webhooksRetryPolicy',
        'security_policy': 'Notificationsubscriptionsv2webhooksSecurityPolicy',
        'created_on': 'str',
        'updated_on': 'str'
    }

    attribute_map = {
        'webhook_id': 'webhookId',
        'organization_id': 'organizationId',
        'products': 'products',
        'webhook_url': 'webhookUrl',
        'health_check_url': 'healthCheckUrl',
        'status': 'status',
        'name': 'name',
        'description': 'description',
        'retry_policy': 'retryPolicy',
        'security_policy': 'securityPolicy',
        'created_on': 'createdOn',
        'updated_on': 'updatedOn'
    }

    def __init__(self, webhook_id=None, organization_id=None, products=None, webhook_url=None, health_check_url=None, status='INACTIVE', name=None, description=None, retry_policy=None, security_policy=None, created_on=None, updated_on=None):
        """
        InlineResponse2015 - a model defined in Swagger
        """

        self._webhook_id = None
        self._organization_id = None
        self._products = None
        self._webhook_url = None
        self._health_check_url = None
        self._status = None
        self._name = None
        self._description = None
        self._retry_policy = None
        self._security_policy = None
        self._created_on = None
        self._updated_on = None

        if webhook_id is not None:
          self.webhook_id = webhook_id
        if organization_id is not None:
          self.organization_id = organization_id
        if products is not None:
          self.products = products
        if webhook_url is not None:
          self.webhook_url = webhook_url
        if health_check_url is not None:
          self.health_check_url = health_check_url
        if status is not None:
          self.status = status
        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if retry_policy is not None:
          self.retry_policy = retry_policy
        if security_policy is not None:
          self.security_policy = security_policy
        if created_on is not None:
          self.created_on = created_on
        if updated_on is not None:
          self.updated_on = updated_on

    @property
    def webhook_id(self):
        """
        Gets the webhook_id of this InlineResponse2015.
        Webhook Id. This is generated by the server.

        :return: The webhook_id of this InlineResponse2015.
        :rtype: str
        """
        return self._webhook_id

    @webhook_id.setter
    def webhook_id(self, webhook_id):
        """
        Sets the webhook_id of this InlineResponse2015.
        Webhook Id. This is generated by the server.

        :param webhook_id: The webhook_id of this InlineResponse2015.
        :type: str
        """

        self._webhook_id = webhook_id

    @property
    def organization_id(self):
        """
        Gets the organization_id of this InlineResponse2015.
        Organization ID.

        :return: The organization_id of this InlineResponse2015.
        :rtype: str
        """
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id):
        """
        Sets the organization_id of this InlineResponse2015.
        Organization ID.

        :param organization_id: The organization_id of this InlineResponse2015.
        :type: str
        """

        self._organization_id = organization_id

    @property
    def products(self):
        """
        Gets the products of this InlineResponse2015.

        :return: The products of this InlineResponse2015.
        :rtype: list[Notificationsubscriptionsv2webhooksProducts]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this InlineResponse2015.

        :param products: The products of this InlineResponse2015.
        :type: list[Notificationsubscriptionsv2webhooksProducts]
        """

        self._products = products

    @property
    def webhook_url(self):
        """
        Gets the webhook_url of this InlineResponse2015.
        The client's endpoint (URL) to receive webhooks.

        :return: The webhook_url of this InlineResponse2015.
        :rtype: str
        """
        return self._webhook_url

    @webhook_url.setter
    def webhook_url(self, webhook_url):
        """
        Sets the webhook_url of this InlineResponse2015.
        The client's endpoint (URL) to receive webhooks.

        :param webhook_url: The webhook_url of this InlineResponse2015.
        :type: str
        """

        self._webhook_url = webhook_url

    @property
    def health_check_url(self):
        """
        Gets the health_check_url of this InlineResponse2015.
        The client's health check endpoint (URL). This should be as close as possible to the actual webhookUrl.

        :return: The health_check_url of this InlineResponse2015.
        :rtype: str
        """
        return self._health_check_url

    @health_check_url.setter
    def health_check_url(self, health_check_url):
        """
        Sets the health_check_url of this InlineResponse2015.
        The client's health check endpoint (URL). This should be as close as possible to the actual webhookUrl.

        :param health_check_url: The health_check_url of this InlineResponse2015.
        :type: str
        """

        self._health_check_url = health_check_url

    @property
    def status(self):
        """
        Gets the status of this InlineResponse2015.
        Webhook status.

        :return: The status of this InlineResponse2015.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this InlineResponse2015.
        Webhook status.

        :param status: The status of this InlineResponse2015.
        :type: str
        """

        self._status = status

    @property
    def name(self):
        """
        Gets the name of this InlineResponse2015.
        Client friendly webhook name.

        :return: The name of this InlineResponse2015.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this InlineResponse2015.
        Client friendly webhook name.

        :param name: The name of this InlineResponse2015.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this InlineResponse2015.
        Client friendly webhook description.

        :return: The description of this InlineResponse2015.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this InlineResponse2015.
        Client friendly webhook description.

        :param description: The description of this InlineResponse2015.
        :type: str
        """

        self._description = description

    @property
    def retry_policy(self):
        """
        Gets the retry_policy of this InlineResponse2015.

        :return: The retry_policy of this InlineResponse2015.
        :rtype: Notificationsubscriptionsv2webhooksRetryPolicy
        """
        return self._retry_policy

    @retry_policy.setter
    def retry_policy(self, retry_policy):
        """
        Sets the retry_policy of this InlineResponse2015.

        :param retry_policy: The retry_policy of this InlineResponse2015.
        :type: Notificationsubscriptionsv2webhooksRetryPolicy
        """

        self._retry_policy = retry_policy

    @property
    def security_policy(self):
        """
        Gets the security_policy of this InlineResponse2015.

        :return: The security_policy of this InlineResponse2015.
        :rtype: Notificationsubscriptionsv2webhooksSecurityPolicy
        """
        return self._security_policy

    @security_policy.setter
    def security_policy(self, security_policy):
        """
        Sets the security_policy of this InlineResponse2015.

        :param security_policy: The security_policy of this InlineResponse2015.
        :type: Notificationsubscriptionsv2webhooksSecurityPolicy
        """

        self._security_policy = security_policy

    @property
    def created_on(self):
        """
        Gets the created_on of this InlineResponse2015.
        Date on which webhook was created/registered.

        :return: The created_on of this InlineResponse2015.
        :rtype: str
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """
        Sets the created_on of this InlineResponse2015.
        Date on which webhook was created/registered.

        :param created_on: The created_on of this InlineResponse2015.
        :type: str
        """

        self._created_on = created_on

    @property
    def updated_on(self):
        """
        Gets the updated_on of this InlineResponse2015.
        Date on which webhook was most recently updated.

        :return: The updated_on of this InlineResponse2015.
        :rtype: str
        """
        return self._updated_on

    @updated_on.setter
    def updated_on(self, updated_on):
        """
        Sets the updated_on of this InlineResponse2015.
        Date on which webhook was most recently updated.

        :param updated_on: The updated_on of this InlineResponse2015.
        :type: str
        """

        self._updated_on = updated_on

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, InlineResponse2015):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
