# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class Ptsv2paymentsInstallmentInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amount': 'str',
        'frequency': 'str',
        'plan_type': 'str',
        'sequence': 'int',
        'total_amount': 'str',
        'total_count': 'int',
        'first_installment_date': 'str',
        'invoice_data': 'str',
        'payment_type': 'str',
        'eligibility_inquiry': 'str',
        'grace_period_duration': 'str',
        'grace_period_duration_type': 'str',
        'first_installment_amount': 'str',
        'validation_indicator': 'str',
        'identifier': 'str',
        'annual_interest_rate': 'str'
    }

    attribute_map = {
        'amount': 'amount',
        'frequency': 'frequency',
        'plan_type': 'planType',
        'sequence': 'sequence',
        'total_amount': 'totalAmount',
        'total_count': 'totalCount',
        'first_installment_date': 'firstInstallmentDate',
        'invoice_data': 'invoiceData',
        'payment_type': 'paymentType',
        'eligibility_inquiry': 'eligibilityInquiry',
        'grace_period_duration': 'gracePeriodDuration',
        'grace_period_duration_type': 'gracePeriodDurationType',
        'first_installment_amount': 'firstInstallmentAmount',
        'validation_indicator': 'validationIndicator',
        'identifier': 'identifier',
        'annual_interest_rate': 'annualInterestRate'
    }

    def __init__(self, amount=None, frequency=None, plan_type=None, sequence=None, total_amount=None, total_count=None, first_installment_date=None, invoice_data=None, payment_type=None, eligibility_inquiry=None, grace_period_duration=None, grace_period_duration_type=None, first_installment_amount=None, validation_indicator=None, identifier=None, annual_interest_rate=None):
        """
        Ptsv2paymentsInstallmentInformation - a model defined in Swagger
        """

        self._amount = None
        self._frequency = None
        self._plan_type = None
        self._sequence = None
        self._total_amount = None
        self._total_count = None
        self._first_installment_date = None
        self._invoice_data = None
        self._payment_type = None
        self._eligibility_inquiry = None
        self._grace_period_duration = None
        self._grace_period_duration_type = None
        self._first_installment_amount = None
        self._validation_indicator = None
        self._identifier = None
        self._annual_interest_rate = None

        if amount is not None:
          self.amount = amount
        if frequency is not None:
          self.frequency = frequency
        if plan_type is not None:
          self.plan_type = plan_type
        if sequence is not None:
          self.sequence = sequence
        if total_amount is not None:
          self.total_amount = total_amount
        if total_count is not None:
          self.total_count = total_count
        if first_installment_date is not None:
          self.first_installment_date = first_installment_date
        if invoice_data is not None:
          self.invoice_data = invoice_data
        if payment_type is not None:
          self.payment_type = payment_type
        if eligibility_inquiry is not None:
          self.eligibility_inquiry = eligibility_inquiry
        if grace_period_duration is not None:
          self.grace_period_duration = grace_period_duration
        if grace_period_duration_type is not None:
          self.grace_period_duration_type = grace_period_duration_type
        if first_installment_amount is not None:
          self.first_installment_amount = first_installment_amount
        if validation_indicator is not None:
          self.validation_indicator = validation_indicator
        if identifier is not None:
          self.identifier = identifier
        if annual_interest_rate is not None:
          self.annual_interest_rate = annual_interest_rate

    @property
    def amount(self):
        """
        Gets the amount of this Ptsv2paymentsInstallmentInformation.
        Amount for the current installment payment.  This field is supported only for CyberSource through VisaNet. 

        :return: The amount of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """
        Sets the amount of this Ptsv2paymentsInstallmentInformation.
        Amount for the current installment payment.  This field is supported only for CyberSource through VisaNet. 

        :param amount: The amount of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._amount = amount

    @property
    def frequency(self):
        """
        Gets the frequency of this Ptsv2paymentsInstallmentInformation.
        Frequency of the installment payments. When you do not include this field in a request for a Crediario installment payment, CyberSource sends a space character to the processor.  This field is supported only for CyberSource through VisaNet. Possible values: - `B`: Biweekly - `M`: Monthly - `W`: Weekly  For Crediario installment payments, the value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP01 TCR9 - Position: 41 - Field: Installment Frequency 

        :return: The frequency of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._frequency

    @frequency.setter
    def frequency(self, frequency):
        """
        Sets the frequency of this Ptsv2paymentsInstallmentInformation.
        Frequency of the installment payments. When you do not include this field in a request for a Crediario installment payment, CyberSource sends a space character to the processor.  This field is supported only for CyberSource through VisaNet. Possible values: - `B`: Biweekly - `M`: Monthly - `W`: Weekly  For Crediario installment payments, the value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP01 TCR9 - Position: 41 - Field: Installment Frequency 

        :param frequency: The frequency of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._frequency = frequency

    @property
    def plan_type(self):
        """
        Gets the plan_type of this Ptsv2paymentsInstallmentInformation.
        #### American Express Direct, Cielo, and CyberSource Latin American Processing Flag that indicates the type of funding for the installment plan associated with the payment.  Possible values: - `1`: Merchant-funded installment plan - `2`: Issuer-funded installment plan If you do not include this field in the request, CyberSource uses the value in your CyberSource account.  To change the value in your CyberSource account, contact CyberSource Customer Service.  #### CyberSource through VisaNet and American Express Defined code that indicates the type of installment plan for this transaction.  Contact American Express for: - Information about the kinds of installment plans that American Express provides - Values for this field  For installment payments with American Express in Brazil, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP07 TCR3 - Position: 5-6 - Field: Plan Type  * The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment card companies.  #### CyberSource through VisaNet with Visa or Mastercard Flag indicating the type of funding for the installment plan associated with the payment. Possible values: - 1 or 01: Merchant-funded installment plan - 2 or 02: Issuer-funded installment plan - 43: Crediario installment plan—only with Visa in Brazil  For installment payments with Visa in Brazil, the value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP07 TCR1 - Position: 5-6 - Field: Installment Type  For all other kinds of installment payments, the value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP01 TCR5 - Position: 39-40 - Field: Installment Plan Type (Issuer or Merchant) 

        :return: The plan_type of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._plan_type

    @plan_type.setter
    def plan_type(self, plan_type):
        """
        Sets the plan_type of this Ptsv2paymentsInstallmentInformation.
        #### American Express Direct, Cielo, and CyberSource Latin American Processing Flag that indicates the type of funding for the installment plan associated with the payment.  Possible values: - `1`: Merchant-funded installment plan - `2`: Issuer-funded installment plan If you do not include this field in the request, CyberSource uses the value in your CyberSource account.  To change the value in your CyberSource account, contact CyberSource Customer Service.  #### CyberSource through VisaNet and American Express Defined code that indicates the type of installment plan for this transaction.  Contact American Express for: - Information about the kinds of installment plans that American Express provides - Values for this field  For installment payments with American Express in Brazil, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP07 TCR3 - Position: 5-6 - Field: Plan Type  * The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment card companies.  #### CyberSource through VisaNet with Visa or Mastercard Flag indicating the type of funding for the installment plan associated with the payment. Possible values: - 1 or 01: Merchant-funded installment plan - 2 or 02: Issuer-funded installment plan - 43: Crediario installment plan—only with Visa in Brazil  For installment payments with Visa in Brazil, the value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP07 TCR1 - Position: 5-6 - Field: Installment Type  For all other kinds of installment payments, the value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP01 TCR5 - Position: 39-40 - Field: Installment Plan Type (Issuer or Merchant) 

        :param plan_type: The plan_type of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._plan_type = plan_type

    @property
    def sequence(self):
        """
        Gets the sequence of this Ptsv2paymentsInstallmentInformation.
        Installment number when making payments in installments. Used along with `totalCount` to track which payment is being processed.  For example, the second of 5 payments would be passed to CyberSource as `sequence` = 2 and `totalCount` = 5.  #### Chase Paymentech Solutions and FDC Compass This field is optional because this value is required in the merchant descriptors.  #### CyberSource through VisaNet When you do not include this field in a request for a Crediario installment payment, CyberSource sends a value of 0 to the processor.  For Crediario installment payments, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP01 TCR9 - Position: 38-40 - Field: Installment Payment Number  * The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment card companies. 

        :return: The sequence of this Ptsv2paymentsInstallmentInformation.
        :rtype: int
        """
        return self._sequence

    @sequence.setter
    def sequence(self, sequence):
        """
        Sets the sequence of this Ptsv2paymentsInstallmentInformation.
        Installment number when making payments in installments. Used along with `totalCount` to track which payment is being processed.  For example, the second of 5 payments would be passed to CyberSource as `sequence` = 2 and `totalCount` = 5.  #### Chase Paymentech Solutions and FDC Compass This field is optional because this value is required in the merchant descriptors.  #### CyberSource through VisaNet When you do not include this field in a request for a Crediario installment payment, CyberSource sends a value of 0 to the processor.  For Crediario installment payments, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP01 TCR9 - Position: 38-40 - Field: Installment Payment Number  * The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment card companies. 

        :param sequence: The sequence of this Ptsv2paymentsInstallmentInformation.
        :type: int
        """

        self._sequence = sequence

    @property
    def total_amount(self):
        """
        Gets the total_amount of this Ptsv2paymentsInstallmentInformation.
        Total amount of the loan that is being paid in installments. This field is supported only for CyberSource through VisaNet. 

        :return: The total_amount of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._total_amount

    @total_amount.setter
    def total_amount(self, total_amount):
        """
        Sets the total_amount of this Ptsv2paymentsInstallmentInformation.
        Total amount of the loan that is being paid in installments. This field is supported only for CyberSource through VisaNet. 

        :param total_amount: The total_amount of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._total_amount = total_amount

    @property
    def total_count(self):
        """
        Gets the total_count of this Ptsv2paymentsInstallmentInformation.
        Total number of installments when making payments in installments.  #### Chase Paymentech Solutions and FDC Compass This field is optional because this value is required in the merchant descriptors.  #### American Express Direct, Cielo, and Comercio Latino This value is the total number of installments you approved.  #### CyberSource Latin American Processing in Brazil This value is the total number of installments that you approved. The default is 1.  #### All Other Processors This value is used along with _sequence_ to track which payment is being processed.  For example, the second of 5 payments would be passed to CyberSource as _sequence_ = 2 and _totalCount_ = 5.  #### CyberSource through VisaNet For Crediario installment payments, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP01 TCR9 - Position: 23-25 - Field: Number of Installments  For installment payments with American Express in Brazil, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP07 TCR3 - Position: 7-8 - Field: Number of Installments  For installment payments with Visa in Brazil, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP07 TCR1 - Position: 7-8 - Field: Number of Installments  For all other kinds of installment payments, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP01 TCR5 - Position: 20-22 - Field: Installment Total Count  **Note** The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment card companies. 

        :return: The total_count of this Ptsv2paymentsInstallmentInformation.
        :rtype: int
        """
        return self._total_count

    @total_count.setter
    def total_count(self, total_count):
        """
        Sets the total_count of this Ptsv2paymentsInstallmentInformation.
        Total number of installments when making payments in installments.  #### Chase Paymentech Solutions and FDC Compass This field is optional because this value is required in the merchant descriptors.  #### American Express Direct, Cielo, and Comercio Latino This value is the total number of installments you approved.  #### CyberSource Latin American Processing in Brazil This value is the total number of installments that you approved. The default is 1.  #### All Other Processors This value is used along with _sequence_ to track which payment is being processed.  For example, the second of 5 payments would be passed to CyberSource as _sequence_ = 2 and _totalCount_ = 5.  #### CyberSource through VisaNet For Crediario installment payments, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP01 TCR9 - Position: 23-25 - Field: Number of Installments  For installment payments with American Express in Brazil, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP07 TCR3 - Position: 7-8 - Field: Number of Installments  For installment payments with Visa in Brazil, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP07 TCR1 - Position: 7-8 - Field: Number of Installments  For all other kinds of installment payments, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP01 TCR5 - Position: 20-22 - Field: Installment Total Count  **Note** The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment card companies. 

        :param total_count: The total_count of this Ptsv2paymentsInstallmentInformation.
        :type: int
        """

        self._total_count = total_count

    @property
    def first_installment_date(self):
        """
        Gets the first_installment_date of this Ptsv2paymentsInstallmentInformation.
        Date of the first installment payment. Format: YYMMDD. When you do not include this field, CyberSource sends a string of six zeros (000000) to the processor.  This field is supported only for Crediario installment payments in Brazil on CyberSource through VisaNet.  The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR9 - Position: 42-47 - Field: Date of First Installment 

        :return: The first_installment_date of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._first_installment_date

    @first_installment_date.setter
    def first_installment_date(self, first_installment_date):
        """
        Sets the first_installment_date of this Ptsv2paymentsInstallmentInformation.
        Date of the first installment payment. Format: YYMMDD. When you do not include this field, CyberSource sends a string of six zeros (000000) to the processor.  This field is supported only for Crediario installment payments in Brazil on CyberSource through VisaNet.  The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR9 - Position: 42-47 - Field: Date of First Installment 

        :param first_installment_date: The first_installment_date of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._first_installment_date = first_installment_date

    @property
    def invoice_data(self):
        """
        Gets the invoice_data of this Ptsv2paymentsInstallmentInformation.
        Invoice information that you want to provide to the issuer. This value is similar to a tracking number and is the same for all installment payments for one purchase.  This field is supported only for installment payments with Mastercard on CyberSource through VisaNet in Brazil.  The value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP07 TCR4 - Position: 51-70 - Field: Purchase Identification 

        :return: The invoice_data of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._invoice_data

    @invoice_data.setter
    def invoice_data(self, invoice_data):
        """
        Sets the invoice_data of this Ptsv2paymentsInstallmentInformation.
        Invoice information that you want to provide to the issuer. This value is similar to a tracking number and is the same for all installment payments for one purchase.  This field is supported only for installment payments with Mastercard on CyberSource through VisaNet in Brazil.  The value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP07 TCR4 - Position: 51-70 - Field: Purchase Identification 

        :param invoice_data: The invoice_data of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._invoice_data = invoice_data

    @property
    def payment_type(self):
        """
        Gets the payment_type of this Ptsv2paymentsInstallmentInformation.
        Payment plan for the installments. This field is supported only for installment payments on Visa Platform Connect, RuPay and SPG-KSA seamless flow.  Possible values for a standing-instruction (SI) merchant-initiated transaction (MIT) with Diners Club or Mastercard in India or with an India-issued card: - 1: SI with a fixed amount. - 2: SI with a maximum amount. - 3: Other kind of SI.  Possible values for a type of Installment transaction for on-soil transaction in Kingdom of Saudi Arabia - 1: Registration or first transaction. - 2: Subsequent transaction.  Possible values for other kinds of installment payments: - 0 (default): Regular installment. This value is not allowed for airline transactions. - 1: Installment payment with down payment. - 2: Installment payment without down payment. This value is supported only for airline transactions. - 3: Installment payment; down payment and boarding fee will follow. This value is supported only for airline transactions. - 4: Down payment only; regular installment payment will follow. - 5: Boarding fee only. This value is supported only for airline transactions. - 6: SI de-registration on RuPay for the payer authentication seamless flow. 

        :return: The payment_type of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._payment_type

    @payment_type.setter
    def payment_type(self, payment_type):
        """
        Sets the payment_type of this Ptsv2paymentsInstallmentInformation.
        Payment plan for the installments. This field is supported only for installment payments on Visa Platform Connect, RuPay and SPG-KSA seamless flow.  Possible values for a standing-instruction (SI) merchant-initiated transaction (MIT) with Diners Club or Mastercard in India or with an India-issued card: - 1: SI with a fixed amount. - 2: SI with a maximum amount. - 3: Other kind of SI.  Possible values for a type of Installment transaction for on-soil transaction in Kingdom of Saudi Arabia - 1: Registration or first transaction. - 2: Subsequent transaction.  Possible values for other kinds of installment payments: - 0 (default): Regular installment. This value is not allowed for airline transactions. - 1: Installment payment with down payment. - 2: Installment payment without down payment. This value is supported only for airline transactions. - 3: Installment payment; down payment and boarding fee will follow. This value is supported only for airline transactions. - 4: Down payment only; regular installment payment will follow. - 5: Boarding fee only. This value is supported only for airline transactions. - 6: SI de-registration on RuPay for the payer authentication seamless flow. 

        :param payment_type: The payment_type of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._payment_type = payment_type

    @property
    def eligibility_inquiry(self):
        """
        Gets the eligibility_inquiry of this Ptsv2paymentsInstallmentInformation.
        Indicates whether the authorization request is a Crediario eligibility inquiry.  Set the value for this field to `Crediario`.  This field is supported only for Crediario installment payments in Brazil on CyberSource through VisaNet. 

        :return: The eligibility_inquiry of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._eligibility_inquiry

    @eligibility_inquiry.setter
    def eligibility_inquiry(self, eligibility_inquiry):
        """
        Sets the eligibility_inquiry of this Ptsv2paymentsInstallmentInformation.
        Indicates whether the authorization request is a Crediario eligibility inquiry.  Set the value for this field to `Crediario`.  This field is supported only for Crediario installment payments in Brazil on CyberSource through VisaNet. 

        :param eligibility_inquiry: The eligibility_inquiry of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._eligibility_inquiry = eligibility_inquiry

    @property
    def grace_period_duration(self):
        """
        Gets the grace_period_duration of this Ptsv2paymentsInstallmentInformation.
        Grace period requested by the customer before the first installment payment is due.  When you include this field in a request, you must also include the grace period duration type field.  The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR5, Position: 100-101, Field: Mastercard Grace Period Details.  This field is supported only for Mastercard installment payments in Brazil and Greece. 

        :return: The grace_period_duration of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._grace_period_duration

    @grace_period_duration.setter
    def grace_period_duration(self, grace_period_duration):
        """
        Sets the grace_period_duration of this Ptsv2paymentsInstallmentInformation.
        Grace period requested by the customer before the first installment payment is due.  When you include this field in a request, you must also include the grace period duration type field.  The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR5, Position: 100-101, Field: Mastercard Grace Period Details.  This field is supported only for Mastercard installment payments in Brazil and Greece. 

        :param grace_period_duration: The grace_period_duration of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._grace_period_duration = grace_period_duration

    @property
    def grace_period_duration_type(self):
        """
        Gets the grace_period_duration_type of this Ptsv2paymentsInstallmentInformation.
        Unit for the requested grace period duration.  Possible values: - `D`: Days - `W`: Weeks - `M`: Months  The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR5, Position: 99, Field: Mastercard Grace Period Details  This field is supported only for Mastercard installment payments in Brazil and Greece on CyberSource through VisaNet. 

        :return: The grace_period_duration_type of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._grace_period_duration_type

    @grace_period_duration_type.setter
    def grace_period_duration_type(self, grace_period_duration_type):
        """
        Sets the grace_period_duration_type of this Ptsv2paymentsInstallmentInformation.
        Unit for the requested grace period duration.  Possible values: - `D`: Days - `W`: Weeks - `M`: Months  The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR5, Position: 99, Field: Mastercard Grace Period Details  This field is supported only for Mastercard installment payments in Brazil and Greece on CyberSource through VisaNet. 

        :param grace_period_duration_type: The grace_period_duration_type of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._grace_period_duration_type = grace_period_duration_type

    @property
    def first_installment_amount(self):
        """
        Gets the first_installment_amount of this Ptsv2paymentsInstallmentInformation.
        Amount of the first installment payment. The issuer provides this value when the first installment payment is successful. This field is supported for Mastercard installment payments on CyberSource through VisaNet in all countries except Brazil,Croatia, Georgia, and Greece. The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR5 - Position: 23-34 - Field: Amount of Each Installment 

        :return: The first_installment_amount of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._first_installment_amount

    @first_installment_amount.setter
    def first_installment_amount(self, first_installment_amount):
        """
        Sets the first_installment_amount of this Ptsv2paymentsInstallmentInformation.
        Amount of the first installment payment. The issuer provides this value when the first installment payment is successful. This field is supported for Mastercard installment payments on CyberSource through VisaNet in all countries except Brazil,Croatia, Georgia, and Greece. The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR5 - Position: 23-34 - Field: Amount of Each Installment 

        :param first_installment_amount: The first_installment_amount of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._first_installment_amount = first_installment_amount

    @property
    def validation_indicator(self):
        """
        Gets the validation_indicator of this Ptsv2paymentsInstallmentInformation.
        Standing Instruction/Installment validation indicator. - '1': Prevalidated - '2': Not Validated 

        :return: The validation_indicator of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._validation_indicator

    @validation_indicator.setter
    def validation_indicator(self, validation_indicator):
        """
        Sets the validation_indicator of this Ptsv2paymentsInstallmentInformation.
        Standing Instruction/Installment validation indicator. - '1': Prevalidated - '2': Not Validated 

        :param validation_indicator: The validation_indicator of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._validation_indicator = validation_indicator

    @property
    def identifier(self):
        """
        Gets the identifier of this Ptsv2paymentsInstallmentInformation.
        Standing Instruction/Installment identifier. 

        :return: The identifier of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """
        Sets the identifier of this Ptsv2paymentsInstallmentInformation.
        Standing Instruction/Installment identifier. 

        :param identifier: The identifier of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._identifier = identifier

    @property
    def annual_interest_rate(self):
        """
        Gets the annual_interest_rate of this Ptsv2paymentsInstallmentInformation.
        Annual interest rate.  This field is returned only for two kinds of installment payments on Visa Platform Connect: - Crediario with Visa in Brazil: this field is included in the authorization response for the Crediario eligibility request when the issuer approves the customer's request for Crediario installment payments. - Mastercard in all countries except Brazil, Croatia, Georgia, and Greece.   Example: A value of 1.0 specifies 1%.  Example: A value of 4.0 specifies 4%.  #### Brazil The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR9 - Position: 151-157 - Field: Annual Interest Rate   #### Other Countries The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR5 - Position: 58-62 SCMP API Fields| 216 - Field: Mastercard Annual Percentage Rate 

        :return: The annual_interest_rate of this Ptsv2paymentsInstallmentInformation.
        :rtype: str
        """
        return self._annual_interest_rate

    @annual_interest_rate.setter
    def annual_interest_rate(self, annual_interest_rate):
        """
        Sets the annual_interest_rate of this Ptsv2paymentsInstallmentInformation.
        Annual interest rate.  This field is returned only for two kinds of installment payments on Visa Platform Connect: - Crediario with Visa in Brazil: this field is included in the authorization response for the Crediario eligibility request when the issuer approves the customer's request for Crediario installment payments. - Mastercard in all countries except Brazil, Croatia, Georgia, and Greece.   Example: A value of 1.0 specifies 1%.  Example: A value of 4.0 specifies 4%.  #### Brazil The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR9 - Position: 151-157 - Field: Annual Interest Rate   #### Other Countries The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR5 - Position: 58-62 SCMP API Fields| 216 - Field: Mastercard Annual Percentage Rate 

        :param annual_interest_rate: The annual_interest_rate of this Ptsv2paymentsInstallmentInformation.
        :type: str
        """

        self._annual_interest_rate = annual_interest_rate

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Ptsv2paymentsInstallmentInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
