# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class UpdateWebhook(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'organization_id': 'str',
        'description': 'str',
        'products': 'list[Notificationsubscriptionsv2webhooksProducts]',
        'webhook_url': 'str',
        'notification_scope': 'str',
        'health_check_url': 'str',
        'security_policy': 'Notificationsubscriptionsv2webhooksSecurityPolicy'
    }

    attribute_map = {
        'name': 'name',
        'organization_id': 'organizationId',
        'description': 'description',
        'products': 'products',
        'webhook_url': 'webhookUrl',
        'notification_scope': 'notificationScope',
        'health_check_url': 'healthCheckUrl',
        'security_policy': 'securityPolicy'
    }

    def __init__(self, name=None, organization_id=None, description=None, products=None, webhook_url=None, notification_scope='DESCENDANTS', health_check_url=None, security_policy=None):
        """
        UpdateWebhook - a model defined in Swagger
        """

        self._name = None
        self._organization_id = None
        self._description = None
        self._products = None
        self._webhook_url = None
        self._notification_scope = None
        self._health_check_url = None
        self._security_policy = None

        if name is not None:
          self.name = name
        if organization_id is not None:
          self.organization_id = organization_id
        if description is not None:
          self.description = description
        if products is not None:
          self.products = products
        if webhook_url is not None:
          self.webhook_url = webhook_url
        if notification_scope is not None:
          self.notification_scope = notification_scope
        if health_check_url is not None:
          self.health_check_url = health_check_url
        if security_policy is not None:
          self.security_policy = security_policy

    @property
    def name(self):
        """
        Gets the name of this UpdateWebhook.
        Client friendly webhook name.

        :return: The name of this UpdateWebhook.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UpdateWebhook.
        Client friendly webhook name.

        :param name: The name of this UpdateWebhook.
        :type: str
        """

        self._name = name

    @property
    def organization_id(self):
        """
        Gets the organization_id of this UpdateWebhook.
        Organization Id.

        :return: The organization_id of this UpdateWebhook.
        :rtype: str
        """
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id):
        """
        Sets the organization_id of this UpdateWebhook.
        Organization Id.

        :param organization_id: The organization_id of this UpdateWebhook.
        :type: str
        """

        self._organization_id = organization_id

    @property
    def description(self):
        """
        Gets the description of this UpdateWebhook.
        Client friendly webhook description.

        :return: The description of this UpdateWebhook.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateWebhook.
        Client friendly webhook description.

        :param description: The description of this UpdateWebhook.
        :type: str
        """

        self._description = description

    @property
    def products(self):
        """
        Gets the products of this UpdateWebhook.

        :return: The products of this UpdateWebhook.
        :rtype: list[Notificationsubscriptionsv2webhooksProducts]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this UpdateWebhook.

        :param products: The products of this UpdateWebhook.
        :type: list[Notificationsubscriptionsv2webhooksProducts]
        """

        self._products = products

    @property
    def webhook_url(self):
        """
        Gets the webhook_url of this UpdateWebhook.
        The client's endpoint (URL) to receive webhooks.

        :return: The webhook_url of this UpdateWebhook.
        :rtype: str
        """
        return self._webhook_url

    @webhook_url.setter
    def webhook_url(self, webhook_url):
        """
        Sets the webhook_url of this UpdateWebhook.
        The client's endpoint (URL) to receive webhooks.

        :param webhook_url: The webhook_url of this UpdateWebhook.
        :type: str
        """

        self._webhook_url = webhook_url

    @property
    def notification_scope(self):
        """
        Gets the notification_scope of this UpdateWebhook.
        The webhook scope. 1. SELF The Webhook is used to deliver webhooks for only this Organization (or Merchant). 2. DESCENDANTS The Webhook is used to deliver webhooks for this Organization and its children. This field is optional.    Possible values: - SELF - DESCENDANTS

        :return: The notification_scope of this UpdateWebhook.
        :rtype: str
        """
        return self._notification_scope

    @notification_scope.setter
    def notification_scope(self, notification_scope):
        """
        Sets the notification_scope of this UpdateWebhook.
        The webhook scope. 1. SELF The Webhook is used to deliver webhooks for only this Organization (or Merchant). 2. DESCENDANTS The Webhook is used to deliver webhooks for this Organization and its children. This field is optional.    Possible values: - SELF - DESCENDANTS

        :param notification_scope: The notification_scope of this UpdateWebhook.
        :type: str
        """

        self._notification_scope = notification_scope

    @property
    def health_check_url(self):
        """
        Gets the health_check_url of this UpdateWebhook.
        The client's health check endpoint (URL).

        :return: The health_check_url of this UpdateWebhook.
        :rtype: str
        """
        return self._health_check_url

    @health_check_url.setter
    def health_check_url(self, health_check_url):
        """
        Sets the health_check_url of this UpdateWebhook.
        The client's health check endpoint (URL).

        :param health_check_url: The health_check_url of this UpdateWebhook.
        :type: str
        """

        self._health_check_url = health_check_url

    @property
    def security_policy(self):
        """
        Gets the security_policy of this UpdateWebhook.

        :return: The security_policy of this UpdateWebhook.
        :rtype: Notificationsubscriptionsv2webhooksSecurityPolicy
        """
        return self._security_policy

    @security_policy.setter
    def security_policy(self, security_policy):
        """
        Sets the security_policy of this UpdateWebhook.

        :param security_policy: The security_policy of this UpdateWebhook.
        :type: Notificationsubscriptionsv2webhooksSecurityPolicy
        """

        self._security_policy = security_policy

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, UpdateWebhook):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
