# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class CardProcessingConfigCommonProcessors(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'batch_group': 'str',
        'business_application_id': 'str',
        'merchant_verification_value': 'str',
        'aba_number': 'str',
        'acquirer': 'CardProcessingConfigCommonAcquirer',
        'acquirers': 'dict(str, CardProcessingConfigCommonAcquirers)',
        'merchant_id': 'str',
        'terminal_id': 'str',
        'payment_types': 'dict(str, CardProcessingConfigCommonPaymentTypes)',
        'currencies': 'dict(str, CardProcessingConfigCommonCurrencies1)',
        'visa_aggregator_id': 'str',
        'amex_aggregator_id': 'str',
        'master_card_aggregator_id': 'str',
        'sic_code': 'str',
        'allow_multiple_bills': 'bool',
        'allow_merchant_descriptor_override': 'bool',
        'enhanced_data': 'str',
        'fire_safety_indicator': 'bool',
        'quasi_cash': 'bool',
        'acquirer_merchant_id': 'str',
        'avs_format': 'str',
        'enable_long_trans_ref_no': 'bool',
        'enable_level2': 'bool',
        'enable_multiple_transaction_advice_addendum': 'bool',
        'amex_transaction_advice_addendum1': 'str',
        'enable_multi_line_items': 'bool',
        'enable_transaction_reference_number': 'bool',
        'enable_auto_auth_reversal_after_void': 'bool',
        'enable_expresspay_pan_translation': 'bool',
        'enable_credit_auth': 'bool',
        'industry_code': 'str',
        'send_amex_level2_data': 'bool',
        'soft_descriptor_type': 'str',
        'vital_number': 'str',
        'bank_number': 'str',
        'chain_number': 'str',
        'merchant_bin_number': 'str',
        'merchant_location_number': 'str',
        'store_id': 'str',
        'travel_agency_code': 'str',
        'travel_agency_name': 'str',
        'settlement_currency': 'str',
        'enable_least_cost_routing': 'bool',
        'enable_cvv_response_indicator': 'bool',
        'enable_multi_currency_processing': 'str',
        'enable_pos_network_switching': 'bool',
        'enable_dynamic_currency_conversion': 'bool',
        'merchant_tier': 'str'
    }

    attribute_map = {
        'batch_group': 'batchGroup',
        'business_application_id': 'businessApplicationId',
        'merchant_verification_value': 'merchantVerificationValue',
        'aba_number': 'abaNumber',
        'acquirer': 'acquirer',
        'acquirers': 'acquirers',
        'merchant_id': 'merchantId',
        'terminal_id': 'terminalId',
        'payment_types': 'paymentTypes',
        'currencies': 'currencies',
        'visa_aggregator_id': 'visaAggregatorId',
        'amex_aggregator_id': 'amexAggregatorId',
        'master_card_aggregator_id': 'masterCardAggregatorId',
        'sic_code': 'sicCode',
        'allow_multiple_bills': 'allowMultipleBills',
        'allow_merchant_descriptor_override': 'allowMerchantDescriptorOverride',
        'enhanced_data': 'enhancedData',
        'fire_safety_indicator': 'fireSafetyIndicator',
        'quasi_cash': 'quasiCash',
        'acquirer_merchant_id': 'acquirerMerchantId',
        'avs_format': 'avsFormat',
        'enable_long_trans_ref_no': 'enableLongTransRefNo',
        'enable_level2': 'enableLevel2',
        'enable_multiple_transaction_advice_addendum': 'enableMultipleTransactionAdviceAddendum',
        'amex_transaction_advice_addendum1': 'amexTransactionAdviceAddendum1',
        'enable_multi_line_items': 'enableMultiLineItems',
        'enable_transaction_reference_number': 'enableTransactionReferenceNumber',
        'enable_auto_auth_reversal_after_void': 'enableAutoAuthReversalAfterVoid',
        'enable_expresspay_pan_translation': 'enableExpresspayPanTranslation',
        'enable_credit_auth': 'enableCreditAuth',
        'industry_code': 'industryCode',
        'send_amex_level2_data': 'sendAmexLevel2Data',
        'soft_descriptor_type': 'softDescriptorType',
        'vital_number': 'vitalNumber',
        'bank_number': 'bankNumber',
        'chain_number': 'chainNumber',
        'merchant_bin_number': 'merchantBinNumber',
        'merchant_location_number': 'merchantLocationNumber',
        'store_id': 'storeID',
        'travel_agency_code': 'travelAgencyCode',
        'travel_agency_name': 'travelAgencyName',
        'settlement_currency': 'settlementCurrency',
        'enable_least_cost_routing': 'enableLeastCostRouting',
        'enable_cvv_response_indicator': 'enableCVVResponseIndicator',
        'enable_multi_currency_processing': 'enableMultiCurrencyProcessing',
        'enable_pos_network_switching': 'enablePosNetworkSwitching',
        'enable_dynamic_currency_conversion': 'enableDynamicCurrencyConversion',
        'merchant_tier': 'merchantTier'
    }

    def __init__(self, batch_group=None, business_application_id=None, merchant_verification_value=None, aba_number=None, acquirer=None, acquirers=None, merchant_id=None, terminal_id=None, payment_types=None, currencies=None, visa_aggregator_id=None, amex_aggregator_id=None, master_card_aggregator_id=None, sic_code=None, allow_multiple_bills=None, allow_merchant_descriptor_override=None, enhanced_data=None, fire_safety_indicator=None, quasi_cash=None, acquirer_merchant_id=None, avs_format=None, enable_long_trans_ref_no=None, enable_level2=None, enable_multiple_transaction_advice_addendum=None, amex_transaction_advice_addendum1=None, enable_multi_line_items=None, enable_transaction_reference_number=None, enable_auto_auth_reversal_after_void=None, enable_expresspay_pan_translation=None, enable_credit_auth=None, industry_code=None, send_amex_level2_data=None, soft_descriptor_type=None, vital_number=None, bank_number=None, chain_number=None, merchant_bin_number=None, merchant_location_number=None, store_id=None, travel_agency_code=None, travel_agency_name=None, settlement_currency=None, enable_least_cost_routing=None, enable_cvv_response_indicator=None, enable_multi_currency_processing=None, enable_pos_network_switching=None, enable_dynamic_currency_conversion=None, merchant_tier=None):
        """
        CardProcessingConfigCommonProcessors - a model defined in Swagger
        """

        self._batch_group = None
        self._business_application_id = None
        self._merchant_verification_value = None
        self._aba_number = None
        self._acquirer = None
        self._acquirers = None
        self._merchant_id = None
        self._terminal_id = None
        self._payment_types = None
        self._currencies = None
        self._visa_aggregator_id = None
        self._amex_aggregator_id = None
        self._master_card_aggregator_id = None
        self._sic_code = None
        self._allow_multiple_bills = None
        self._allow_merchant_descriptor_override = None
        self._enhanced_data = None
        self._fire_safety_indicator = None
        self._quasi_cash = None
        self._acquirer_merchant_id = None
        self._avs_format = None
        self._enable_long_trans_ref_no = None
        self._enable_level2 = None
        self._enable_multiple_transaction_advice_addendum = None
        self._amex_transaction_advice_addendum1 = None
        self._enable_multi_line_items = None
        self._enable_transaction_reference_number = None
        self._enable_auto_auth_reversal_after_void = None
        self._enable_expresspay_pan_translation = None
        self._enable_credit_auth = None
        self._industry_code = None
        self._send_amex_level2_data = None
        self._soft_descriptor_type = None
        self._vital_number = None
        self._bank_number = None
        self._chain_number = None
        self._merchant_bin_number = None
        self._merchant_location_number = None
        self._store_id = None
        self._travel_agency_code = None
        self._travel_agency_name = None
        self._settlement_currency = None
        self._enable_least_cost_routing = None
        self._enable_cvv_response_indicator = None
        self._enable_multi_currency_processing = None
        self._enable_pos_network_switching = None
        self._enable_dynamic_currency_conversion = None
        self._merchant_tier = None

        if batch_group is not None:
          self.batch_group = batch_group
        if business_application_id is not None:
          self.business_application_id = business_application_id
        if merchant_verification_value is not None:
          self.merchant_verification_value = merchant_verification_value
        if aba_number is not None:
          self.aba_number = aba_number
        if acquirer is not None:
          self.acquirer = acquirer
        if acquirers is not None:
          self.acquirers = acquirers
        self.merchant_id = merchant_id
        if terminal_id is not None:
          self.terminal_id = terminal_id
        if payment_types is not None:
          self.payment_types = payment_types
        if currencies is not None:
          self.currencies = currencies
        if visa_aggregator_id is not None:
          self.visa_aggregator_id = visa_aggregator_id
        if amex_aggregator_id is not None:
          self.amex_aggregator_id = amex_aggregator_id
        if master_card_aggregator_id is not None:
          self.master_card_aggregator_id = master_card_aggregator_id
        if sic_code is not None:
          self.sic_code = sic_code
        if allow_multiple_bills is not None:
          self.allow_multiple_bills = allow_multiple_bills
        if allow_merchant_descriptor_override is not None:
          self.allow_merchant_descriptor_override = allow_merchant_descriptor_override
        if enhanced_data is not None:
          self.enhanced_data = enhanced_data
        if fire_safety_indicator is not None:
          self.fire_safety_indicator = fire_safety_indicator
        if quasi_cash is not None:
          self.quasi_cash = quasi_cash
        if acquirer_merchant_id is not None:
          self.acquirer_merchant_id = acquirer_merchant_id
        if avs_format is not None:
          self.avs_format = avs_format
        if enable_long_trans_ref_no is not None:
          self.enable_long_trans_ref_no = enable_long_trans_ref_no
        if enable_level2 is not None:
          self.enable_level2 = enable_level2
        if enable_multiple_transaction_advice_addendum is not None:
          self.enable_multiple_transaction_advice_addendum = enable_multiple_transaction_advice_addendum
        if amex_transaction_advice_addendum1 is not None:
          self.amex_transaction_advice_addendum1 = amex_transaction_advice_addendum1
        if enable_multi_line_items is not None:
          self.enable_multi_line_items = enable_multi_line_items
        if enable_transaction_reference_number is not None:
          self.enable_transaction_reference_number = enable_transaction_reference_number
        if enable_auto_auth_reversal_after_void is not None:
          self.enable_auto_auth_reversal_after_void = enable_auto_auth_reversal_after_void
        if enable_expresspay_pan_translation is not None:
          self.enable_expresspay_pan_translation = enable_expresspay_pan_translation
        if enable_credit_auth is not None:
          self.enable_credit_auth = enable_credit_auth
        if industry_code is not None:
          self.industry_code = industry_code
        if send_amex_level2_data is not None:
          self.send_amex_level2_data = send_amex_level2_data
        if soft_descriptor_type is not None:
          self.soft_descriptor_type = soft_descriptor_type
        if vital_number is not None:
          self.vital_number = vital_number
        if bank_number is not None:
          self.bank_number = bank_number
        if chain_number is not None:
          self.chain_number = chain_number
        if merchant_bin_number is not None:
          self.merchant_bin_number = merchant_bin_number
        if merchant_location_number is not None:
          self.merchant_location_number = merchant_location_number
        if store_id is not None:
          self.store_id = store_id
        if travel_agency_code is not None:
          self.travel_agency_code = travel_agency_code
        if travel_agency_name is not None:
          self.travel_agency_name = travel_agency_name
        if settlement_currency is not None:
          self.settlement_currency = settlement_currency
        if enable_least_cost_routing is not None:
          self.enable_least_cost_routing = enable_least_cost_routing
        if enable_cvv_response_indicator is not None:
          self.enable_cvv_response_indicator = enable_cvv_response_indicator
        if enable_multi_currency_processing is not None:
          self.enable_multi_currency_processing = enable_multi_currency_processing
        if enable_pos_network_switching is not None:
          self.enable_pos_network_switching = enable_pos_network_switching
        if enable_dynamic_currency_conversion is not None:
          self.enable_dynamic_currency_conversion = enable_dynamic_currency_conversion
        if merchant_tier is not None:
          self.merchant_tier = merchant_tier

    @property
    def batch_group(self):
        """
        Gets the batch_group of this CardProcessingConfigCommonProcessors.
        Determines the batching group that separates merchants for special batching times. Batching groups can separate merchant batches by the following criteria:  * Timezone * Merchant deadlines * Large merchants (top 10) * Merchants with Service-Level Agreements  Applicable for Chase Paymentech Salem (chasepaymentechsalem), Streamline (streamline2), Six (six), Barclays (barclays2), Paymentech Tampa (paymentechtampa), CMCIC (cmcic), FDC Nashville (smartfdc), RUPAY, American Express Direct (amexdirect), GPN (gpn), VPC, GPX (gpx), CB2A, Barclays HISO (barclayshiso), TSYS (tsys) and FDI Global (fdiglobal) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>Yes</td></tr> <tr><td>Barclays HISO</td><td>cnp, cp, hybrid</td><td>Yes</td></tr> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td></tr> </table> 

        :return: The batch_group of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._batch_group

    @batch_group.setter
    def batch_group(self, batch_group):
        """
        Sets the batch_group of this CardProcessingConfigCommonProcessors.
        Determines the batching group that separates merchants for special batching times. Batching groups can separate merchant batches by the following criteria:  * Timezone * Merchant deadlines * Large merchants (top 10) * Merchants with Service-Level Agreements  Applicable for Chase Paymentech Salem (chasepaymentechsalem), Streamline (streamline2), Six (six), Barclays (barclays2), Paymentech Tampa (paymentechtampa), CMCIC (cmcic), FDC Nashville (smartfdc), RUPAY, American Express Direct (amexdirect), GPN (gpn), VPC, GPX (gpx), CB2A, Barclays HISO (barclayshiso), TSYS (tsys) and FDI Global (fdiglobal) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>Yes</td></tr> <tr><td>Barclays HISO</td><td>cnp, cp, hybrid</td><td>Yes</td></tr> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td></tr> </table> 

        :param batch_group: The batch_group of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._batch_group = batch_group

    @property
    def business_application_id(self):
        """
        Gets the business_application_id of this CardProcessingConfigCommonProcessors.
        Indicates the type of money transfer used in the transaction. Applicable for VPC and GPX (gpx) processors.

        :return: The business_application_id of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._business_application_id

    @business_application_id.setter
    def business_application_id(self, business_application_id):
        """
        Sets the business_application_id of this CardProcessingConfigCommonProcessors.
        Indicates the type of money transfer used in the transaction. Applicable for VPC and GPX (gpx) processors.

        :param business_application_id: The business_application_id of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._business_application_id = business_application_id

    @property
    def merchant_verification_value(self):
        """
        Gets the merchant_verification_value of this CardProcessingConfigCommonProcessors.
        Identify merchants that participate in Select Merchant Fee (SMF) programs. Unique to the merchant. Applicable for GPX (gpx) and VPC processors.

        :return: The merchant_verification_value of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._merchant_verification_value

    @merchant_verification_value.setter
    def merchant_verification_value(self, merchant_verification_value):
        """
        Sets the merchant_verification_value of this CardProcessingConfigCommonProcessors.
        Identify merchants that participate in Select Merchant Fee (SMF) programs. Unique to the merchant. Applicable for GPX (gpx) and VPC processors.

        :param merchant_verification_value: The merchant_verification_value of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._merchant_verification_value = merchant_verification_value

    @property
    def aba_number(self):
        """
        Gets the aba_number of this CardProcessingConfigCommonProcessors.
        Routing Number to identify banks within the United States. Applicable for GPX (gpx) processors.

        :return: The aba_number of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._aba_number

    @aba_number.setter
    def aba_number(self, aba_number):
        """
        Sets the aba_number of this CardProcessingConfigCommonProcessors.
        Routing Number to identify banks within the United States. Applicable for GPX (gpx) processors.

        :param aba_number: The aba_number of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._aba_number = aba_number

    @property
    def acquirer(self):
        """
        Gets the acquirer of this CardProcessingConfigCommonProcessors.

        :return: The acquirer of this CardProcessingConfigCommonProcessors.
        :rtype: CardProcessingConfigCommonAcquirer
        """
        return self._acquirer

    @acquirer.setter
    def acquirer(self, acquirer):
        """
        Sets the acquirer of this CardProcessingConfigCommonProcessors.

        :param acquirer: The acquirer of this CardProcessingConfigCommonProcessors.
        :type: CardProcessingConfigCommonAcquirer
        """

        self._acquirer = acquirer

    @property
    def acquirers(self):
        """
        Gets the acquirers of this CardProcessingConfigCommonProcessors.
        Identifies the financial institution acting as the acquirer of this customer transaction. The acquirer is the member or system user that signed the merchant.

        :return: The acquirers of this CardProcessingConfigCommonProcessors.
        :rtype: dict(str, CardProcessingConfigCommonAcquirers)
        """
        return self._acquirers

    @acquirers.setter
    def acquirers(self, acquirers):
        """
        Sets the acquirers of this CardProcessingConfigCommonProcessors.
        Identifies the financial institution acting as the acquirer of this customer transaction. The acquirer is the member or system user that signed the merchant.

        :param acquirers: The acquirers of this CardProcessingConfigCommonProcessors.
        :type: dict(str, CardProcessingConfigCommonAcquirers)
        """

        self._acquirers = acquirers

    @property
    def merchant_id(self):
        """
        Gets the merchant_id of this CardProcessingConfigCommonProcessors.
        Merchant ID assigned by an acquirer or a processor. Should not be overriden by any other party.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays HISO</td><td>cp, cnp, hybrid</td><td>Yes</td><td>1</td><td>15</td><td>^[0-9a-zA-Z]+$</td></tr> <tr><td>Barclays</td><td>cp, cnp, hybrid</td><td>Yes</td><td>1</td><td>11</td><td>^[0-9a-zA-Z]+$</td></tr> </table> 

        :return: The merchant_id of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._merchant_id

    @merchant_id.setter
    def merchant_id(self, merchant_id):
        """
        Sets the merchant_id of this CardProcessingConfigCommonProcessors.
        Merchant ID assigned by an acquirer or a processor. Should not be overriden by any other party.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays HISO</td><td>cp, cnp, hybrid</td><td>Yes</td><td>1</td><td>15</td><td>^[0-9a-zA-Z]+$</td></tr> <tr><td>Barclays</td><td>cp, cnp, hybrid</td><td>Yes</td><td>1</td><td>11</td><td>^[0-9a-zA-Z]+$</td></tr> </table> 

        :param merchant_id: The merchant_id of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._merchant_id = merchant_id

    @property
    def terminal_id(self):
        """
        Gets the terminal_id of this CardProcessingConfigCommonProcessors.
        The 'Terminal Id' aka TID, is an identifier used for with your payments processor. Depending on the processor and payment acceptance type this may also be the default Terminal ID used for Card Present and Virtual Terminal transactions.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays HISO</td><td>cnp, hybrid</td><td>Yes</td><td>1</td><td>16</td><td>^[0-9a-zA-Z]+$</td></tr> <tr><td>Barclays HISO</td><td>cp</td><td>No</td><td>1</td><td>16</td><td>^[0-9a-zA-Z]+$</td></tr> </table> 

        :return: The terminal_id of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._terminal_id

    @terminal_id.setter
    def terminal_id(self, terminal_id):
        """
        Sets the terminal_id of this CardProcessingConfigCommonProcessors.
        The 'Terminal Id' aka TID, is an identifier used for with your payments processor. Depending on the processor and payment acceptance type this may also be the default Terminal ID used for Card Present and Virtual Terminal transactions.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays HISO</td><td>cnp, hybrid</td><td>Yes</td><td>1</td><td>16</td><td>^[0-9a-zA-Z]+$</td></tr> <tr><td>Barclays HISO</td><td>cp</td><td>No</td><td>1</td><td>16</td><td>^[0-9a-zA-Z]+$</td></tr> </table> 

        :param terminal_id: The terminal_id of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._terminal_id = terminal_id

    @property
    def payment_types(self):
        """
        Gets the payment_types of this CardProcessingConfigCommonProcessors.
        Valid values are: * VISA * MASTERCARD * AMERICAN_EXPRESS * CUP * EFTPOS * DINERS_CLUB * DISCOVER * JCB 

        :return: The payment_types of this CardProcessingConfigCommonProcessors.
        :rtype: dict(str, CardProcessingConfigCommonPaymentTypes)
        """
        return self._payment_types

    @payment_types.setter
    def payment_types(self, payment_types):
        """
        Sets the payment_types of this CardProcessingConfigCommonProcessors.
        Valid values are: * VISA * MASTERCARD * AMERICAN_EXPRESS * CUP * EFTPOS * DINERS_CLUB * DISCOVER * JCB 

        :param payment_types: The payment_types of this CardProcessingConfigCommonProcessors.
        :type: dict(str, CardProcessingConfigCommonPaymentTypes)
        """

        self._payment_types = payment_types

    @property
    def currencies(self):
        """
        Gets the currencies of this CardProcessingConfigCommonProcessors.
        Three-character [ISO 4217 ALPHA-3 Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf)

        :return: The currencies of this CardProcessingConfigCommonProcessors.
        :rtype: dict(str, CardProcessingConfigCommonCurrencies1)
        """
        return self._currencies

    @currencies.setter
    def currencies(self, currencies):
        """
        Sets the currencies of this CardProcessingConfigCommonProcessors.
        Three-character [ISO 4217 ALPHA-3 Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf)

        :param currencies: The currencies of this CardProcessingConfigCommonProcessors.
        :type: dict(str, CardProcessingConfigCommonCurrencies1)
        """

        self._currencies = currencies

    @property
    def visa_aggregator_id(self):
        """
        Gets the visa_aggregator_id of this CardProcessingConfigCommonProcessors.
        This field is used as aggregator Id when Visa payment type is selected

        :return: The visa_aggregator_id of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._visa_aggregator_id

    @visa_aggregator_id.setter
    def visa_aggregator_id(self, visa_aggregator_id):
        """
        Sets the visa_aggregator_id of this CardProcessingConfigCommonProcessors.
        This field is used as aggregator Id when Visa payment type is selected

        :param visa_aggregator_id: The visa_aggregator_id of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._visa_aggregator_id = visa_aggregator_id

    @property
    def amex_aggregator_id(self):
        """
        Gets the amex_aggregator_id of this CardProcessingConfigCommonProcessors.
        This field is used as aggregator Id when Amex payment type is selected

        :return: The amex_aggregator_id of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._amex_aggregator_id

    @amex_aggregator_id.setter
    def amex_aggregator_id(self, amex_aggregator_id):
        """
        Sets the amex_aggregator_id of this CardProcessingConfigCommonProcessors.
        This field is used as aggregator Id when Amex payment type is selected

        :param amex_aggregator_id: The amex_aggregator_id of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._amex_aggregator_id = amex_aggregator_id

    @property
    def master_card_aggregator_id(self):
        """
        Gets the master_card_aggregator_id of this CardProcessingConfigCommonProcessors.
        This field is used as aggregator Id when Master Card payment type is selected

        :return: The master_card_aggregator_id of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._master_card_aggregator_id

    @master_card_aggregator_id.setter
    def master_card_aggregator_id(self, master_card_aggregator_id):
        """
        Sets the master_card_aggregator_id of this CardProcessingConfigCommonProcessors.
        This field is used as aggregator Id when Master Card payment type is selected

        :param master_card_aggregator_id: The master_card_aggregator_id of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._master_card_aggregator_id = master_card_aggregator_id

    @property
    def sic_code(self):
        """
        Gets the sic_code of this CardProcessingConfigCommonProcessors.
        The Standard Industrial Classification (SIC) are four-digit codes that categorize the industries that companies belong to based on their business activities. Standard Industrial Classification codes were mostly replaced by the six-digit North American Industry Classification System (NAICS). Applicable for VPC and GPX (gpx) processors.

        :return: The sic_code of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._sic_code

    @sic_code.setter
    def sic_code(self, sic_code):
        """
        Sets the sic_code of this CardProcessingConfigCommonProcessors.
        The Standard Industrial Classification (SIC) are four-digit codes that categorize the industries that companies belong to based on their business activities. Standard Industrial Classification codes were mostly replaced by the six-digit North American Industry Classification System (NAICS). Applicable for VPC and GPX (gpx) processors.

        :param sic_code: The sic_code of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._sic_code = sic_code

    @property
    def allow_multiple_bills(self):
        """
        Gets the allow_multiple_bills of this CardProcessingConfigCommonProcessors.
        Allows multiple captures for a single authorization transaction. Applicable for Paymentech Tampa (paymentechtampa), VPC, American Express Direct (amexdirect) and GPX (gpx) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, hybrid</td><td>Yes</td><td>No</td></tr> <tr><td>American Express Direct</td><td>cnp</td><td>No</td><td>No</td></tr> </table> 

        :return: The allow_multiple_bills of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._allow_multiple_bills

    @allow_multiple_bills.setter
    def allow_multiple_bills(self, allow_multiple_bills):
        """
        Sets the allow_multiple_bills of this CardProcessingConfigCommonProcessors.
        Allows multiple captures for a single authorization transaction. Applicable for Paymentech Tampa (paymentechtampa), VPC, American Express Direct (amexdirect) and GPX (gpx) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, hybrid</td><td>Yes</td><td>No</td></tr> <tr><td>American Express Direct</td><td>cnp</td><td>No</td><td>No</td></tr> </table> 

        :param allow_multiple_bills: The allow_multiple_bills of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._allow_multiple_bills = allow_multiple_bills

    @property
    def allow_merchant_descriptor_override(self):
        """
        Gets the allow_merchant_descriptor_override of this CardProcessingConfigCommonProcessors.
        Enables partner to enable/disable merchant descriptors values. Applicable for VPC, EFTPOS and CUP processors.

        :return: The allow_merchant_descriptor_override of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._allow_merchant_descriptor_override

    @allow_merchant_descriptor_override.setter
    def allow_merchant_descriptor_override(self, allow_merchant_descriptor_override):
        """
        Sets the allow_merchant_descriptor_override of this CardProcessingConfigCommonProcessors.
        Enables partner to enable/disable merchant descriptors values. Applicable for VPC, EFTPOS and CUP processors.

        :param allow_merchant_descriptor_override: The allow_merchant_descriptor_override of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._allow_merchant_descriptor_override = allow_merchant_descriptor_override

    @property
    def enhanced_data(self):
        """
        Gets the enhanced_data of this CardProcessingConfigCommonProcessors.
        To enable airline transactions. Applicable for TSYS (tsys), VPC, Elavon Americas (elavonamericas), FDI Global (fdiglobal), GPX (gpx), Barclays (barclays2) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td></tr> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td></tr> </table> 

        :return: The enhanced_data of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._enhanced_data

    @enhanced_data.setter
    def enhanced_data(self, enhanced_data):
        """
        Sets the enhanced_data of this CardProcessingConfigCommonProcessors.
        To enable airline transactions. Applicable for TSYS (tsys), VPC, Elavon Americas (elavonamericas), FDI Global (fdiglobal), GPX (gpx), Barclays (barclays2) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td></tr> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td></tr> </table> 

        :param enhanced_data: The enhanced_data of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._enhanced_data = enhanced_data

    @property
    def fire_safety_indicator(self):
        """
        Gets the fire_safety_indicator of this CardProcessingConfigCommonProcessors.
        Indicates whether the merchant is compliant with Hotel and Motel Fire Safety Act of 1990. Applicable for GPX (gpx) and VPC processors.

        :return: The fire_safety_indicator of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._fire_safety_indicator

    @fire_safety_indicator.setter
    def fire_safety_indicator(self, fire_safety_indicator):
        """
        Sets the fire_safety_indicator of this CardProcessingConfigCommonProcessors.
        Indicates whether the merchant is compliant with Hotel and Motel Fire Safety Act of 1990. Applicable for GPX (gpx) and VPC processors.

        :param fire_safety_indicator: The fire_safety_indicator of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._fire_safety_indicator = fire_safety_indicator

    @property
    def quasi_cash(self):
        """
        Gets the quasi_cash of this CardProcessingConfigCommonProcessors.
        To enable quasi-cash transactions. A quasi-cash transaction is a cash-like transaction for the sale of items that are directly convertible to cash, such as:- Casino gaming chips, Money orders, Wire transfers.  Applicable for GPX (gpx), TSYS (tsys), Barclays (barclays2) and VPC processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :return: The quasi_cash of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._quasi_cash

    @quasi_cash.setter
    def quasi_cash(self, quasi_cash):
        """
        Sets the quasi_cash of this CardProcessingConfigCommonProcessors.
        To enable quasi-cash transactions. A quasi-cash transaction is a cash-like transaction for the sale of items that are directly convertible to cash, such as:- Casino gaming chips, Money orders, Wire transfers.  Applicable for GPX (gpx), TSYS (tsys), Barclays (barclays2) and VPC processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :param quasi_cash: The quasi_cash of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._quasi_cash = quasi_cash

    @property
    def acquirer_merchant_id(self):
        """
        Gets the acquirer_merchant_id of this CardProcessingConfigCommonProcessors.
        Identifier assigned by the acquirer. Applicable for RUPAY, VPC and Six (six) processors.

        :return: The acquirer_merchant_id of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._acquirer_merchant_id

    @acquirer_merchant_id.setter
    def acquirer_merchant_id(self, acquirer_merchant_id):
        """
        Sets the acquirer_merchant_id of this CardProcessingConfigCommonProcessors.
        Identifier assigned by the acquirer. Applicable for RUPAY, VPC and Six (six) processors.

        :param acquirer_merchant_id: The acquirer_merchant_id of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._acquirer_merchant_id = acquirer_merchant_id

    @property
    def avs_format(self):
        """
        Gets the avs_format of this CardProcessingConfigCommonProcessors.
        Enables Enhanced AVS/Automated Address Verification Plus (AAV+).  Valid values: \"basic\" - Standard address verification system.   When a processor supports AVS for a transaction's card type, the issuing bank uses AVS to confirm that the customer has provided the correct billing address.   When a customer provides incorrect information, the transaction might be fraudulent. \"basic + name\" - Enhanced address verification system.   Consists of the standard AVS functionality plus verification of some additional fields.   The additional fields that are verified for Enhanced AVS are:   - customer_firstname   - customer_lastname \"basic + name + shipto\" - Automated address verification plus.   Consists of the Enhanced AVS functionality plus verification of some additional fields.   AAV+ intended for merchants who deliver physical goods to a different address than the billing address.   AAV+ verifies the additional fields only when the standard and Enhanced AVS tests pass first.   For information about Enhanced AVS - The additional fields that are verified for AAV+ are:   - ship_to_firstname   - ship_to_lastname   - ship_to_address1   - ship_to_country   - ship_to_zip   - ship_to_phone   - customer_phone(American Express Direct only)  Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>basic</td></tr> </table> 

        :return: The avs_format of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._avs_format

    @avs_format.setter
    def avs_format(self, avs_format):
        """
        Sets the avs_format of this CardProcessingConfigCommonProcessors.
        Enables Enhanced AVS/Automated Address Verification Plus (AAV+).  Valid values: \"basic\" - Standard address verification system.   When a processor supports AVS for a transaction's card type, the issuing bank uses AVS to confirm that the customer has provided the correct billing address.   When a customer provides incorrect information, the transaction might be fraudulent. \"basic + name\" - Enhanced address verification system.   Consists of the standard AVS functionality plus verification of some additional fields.   The additional fields that are verified for Enhanced AVS are:   - customer_firstname   - customer_lastname \"basic + name + shipto\" - Automated address verification plus.   Consists of the Enhanced AVS functionality plus verification of some additional fields.   AAV+ intended for merchants who deliver physical goods to a different address than the billing address.   AAV+ verifies the additional fields only when the standard and Enhanced AVS tests pass first.   For information about Enhanced AVS - The additional fields that are verified for AAV+ are:   - ship_to_firstname   - ship_to_lastname   - ship_to_address1   - ship_to_country   - ship_to_zip   - ship_to_phone   - customer_phone(American Express Direct only)  Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>basic</td></tr> </table> 

        :param avs_format: The avs_format of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._avs_format = avs_format

    @property
    def enable_long_trans_ref_no(self):
        """
        Gets the enable_long_trans_ref_no of this CardProcessingConfigCommonProcessors.
        Amex Direct specific merchant config value which determines what length (either 9 or Unique 12-char reference number) of reference number will be CYBS generated if the merchant does not pass in a trans_ref_no. Can be any combination of alpha, numeric and special characters, and/or binary data in hexadecimal.  Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :return: The enable_long_trans_ref_no of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._enable_long_trans_ref_no

    @enable_long_trans_ref_no.setter
    def enable_long_trans_ref_no(self, enable_long_trans_ref_no):
        """
        Sets the enable_long_trans_ref_no of this CardProcessingConfigCommonProcessors.
        Amex Direct specific merchant config value which determines what length (either 9 or Unique 12-char reference number) of reference number will be CYBS generated if the merchant does not pass in a trans_ref_no. Can be any combination of alpha, numeric and special characters, and/or binary data in hexadecimal.  Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :param enable_long_trans_ref_no: The enable_long_trans_ref_no of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._enable_long_trans_ref_no = enable_long_trans_ref_no

    @property
    def enable_level2(self):
        """
        Gets the enable_level2 of this CardProcessingConfigCommonProcessors.
        Field that indicates whether merchant will send level 2 data for Amex cards. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :return: The enable_level2 of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._enable_level2

    @enable_level2.setter
    def enable_level2(self, enable_level2):
        """
        Sets the enable_level2 of this CardProcessingConfigCommonProcessors.
        Field that indicates whether merchant will send level 2 data for Amex cards. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :param enable_level2: The enable_level2 of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._enable_level2 = enable_level2

    @property
    def enable_multiple_transaction_advice_addendum(self):
        """
        Gets the enable_multiple_transaction_advice_addendum of this CardProcessingConfigCommonProcessors.
        This flag related to multiple transaction advice addendum field. It is used to display descriptive information about a transaction on customer's American Express card statement. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :return: The enable_multiple_transaction_advice_addendum of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._enable_multiple_transaction_advice_addendum

    @enable_multiple_transaction_advice_addendum.setter
    def enable_multiple_transaction_advice_addendum(self, enable_multiple_transaction_advice_addendum):
        """
        Sets the enable_multiple_transaction_advice_addendum of this CardProcessingConfigCommonProcessors.
        This flag related to multiple transaction advice addendum field. It is used to display descriptive information about a transaction on customer's American Express card statement. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :param enable_multiple_transaction_advice_addendum: The enable_multiple_transaction_advice_addendum of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._enable_multiple_transaction_advice_addendum = enable_multiple_transaction_advice_addendum

    @property
    def amex_transaction_advice_addendum1(self):
        """
        Gets the amex_transaction_advice_addendum1 of this CardProcessingConfigCommonProcessors.
        Advice addendum field. It is used to display descriptive information about a transaction on customer's American Express card statement. Applicable for TSYS (tsys), FDI Global (fdiglobal) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>40</td><td>^[0-9a-zA-Z&#92;-\\s.]+$</td></tr> </table> 

        :return: The amex_transaction_advice_addendum1 of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._amex_transaction_advice_addendum1

    @amex_transaction_advice_addendum1.setter
    def amex_transaction_advice_addendum1(self, amex_transaction_advice_addendum1):
        """
        Sets the amex_transaction_advice_addendum1 of this CardProcessingConfigCommonProcessors.
        Advice addendum field. It is used to display descriptive information about a transaction on customer's American Express card statement. Applicable for TSYS (tsys), FDI Global (fdiglobal) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>40</td><td>^[0-9a-zA-Z&#92;-\\s.]+$</td></tr> </table> 

        :param amex_transaction_advice_addendum1: The amex_transaction_advice_addendum1 of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._amex_transaction_advice_addendum1 = amex_transaction_advice_addendum1

    @property
    def enable_multi_line_items(self):
        """
        Gets the enable_multi_line_items of this CardProcessingConfigCommonProcessors.
        This flag is related to offer/line item details to be included instead of sending one line item, and a grand total. Example, offer0, offer 1...offer n. Applicable for American Express Direct (amexdirect) and Elavon Americas (elavonamericas) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :return: The enable_multi_line_items of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._enable_multi_line_items

    @enable_multi_line_items.setter
    def enable_multi_line_items(self, enable_multi_line_items):
        """
        Sets the enable_multi_line_items of this CardProcessingConfigCommonProcessors.
        This flag is related to offer/line item details to be included instead of sending one line item, and a grand total. Example, offer0, offer 1...offer n. Applicable for American Express Direct (amexdirect) and Elavon Americas (elavonamericas) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :param enable_multi_line_items: The enable_multi_line_items of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._enable_multi_line_items = enable_multi_line_items

    @property
    def enable_transaction_reference_number(self):
        """
        Gets the enable_transaction_reference_number of this CardProcessingConfigCommonProcessors.
        To enable merchant to send in transaction reference number (unique reconciliation ID). Applicable for VPC, Vero (vero), FDI Global (fdiglobal), Six (six), CB2A, CUP, VPC, Chase Paymentech Salem (chasepaymentechsalem), Fiserv (fiserv), Elavon Americas (elavonamericas) and EFTPOS processors.

        :return: The enable_transaction_reference_number of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._enable_transaction_reference_number

    @enable_transaction_reference_number.setter
    def enable_transaction_reference_number(self, enable_transaction_reference_number):
        """
        Sets the enable_transaction_reference_number of this CardProcessingConfigCommonProcessors.
        To enable merchant to send in transaction reference number (unique reconciliation ID). Applicable for VPC, Vero (vero), FDI Global (fdiglobal), Six (six), CB2A, CUP, VPC, Chase Paymentech Salem (chasepaymentechsalem), Fiserv (fiserv), Elavon Americas (elavonamericas) and EFTPOS processors.

        :param enable_transaction_reference_number: The enable_transaction_reference_number of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._enable_transaction_reference_number = enable_transaction_reference_number

    @property
    def enable_auto_auth_reversal_after_void(self):
        """
        Gets the enable_auto_auth_reversal_after_void of this CardProcessingConfigCommonProcessors.
        Enables to meet the Visa mandate requirements to reverse unused authorizations, benefitting the customer by releasing the hold on unused credit card funds. Applicable for CB2A, Elavon Americas (elavonamericas), Six (six), VPC and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :return: The enable_auto_auth_reversal_after_void of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._enable_auto_auth_reversal_after_void

    @enable_auto_auth_reversal_after_void.setter
    def enable_auto_auth_reversal_after_void(self, enable_auto_auth_reversal_after_void):
        """
        Sets the enable_auto_auth_reversal_after_void of this CardProcessingConfigCommonProcessors.
        Enables to meet the Visa mandate requirements to reverse unused authorizations, benefitting the customer by releasing the hold on unused credit card funds. Applicable for CB2A, Elavon Americas (elavonamericas), Six (six), VPC and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table> 

        :param enable_auto_auth_reversal_after_void: The enable_auto_auth_reversal_after_void of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._enable_auto_auth_reversal_after_void = enable_auto_auth_reversal_after_void

    @property
    def enable_expresspay_pan_translation(self):
        """
        Gets the enable_expresspay_pan_translation of this CardProcessingConfigCommonProcessors.
        When this is enabled, authorization responses from American Express expresspay transactions include the Primary Account Number (PAN) and expiration date of the card. Applicable for American Express Direct (amexdirect) processor.

        :return: The enable_expresspay_pan_translation of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._enable_expresspay_pan_translation

    @enable_expresspay_pan_translation.setter
    def enable_expresspay_pan_translation(self, enable_expresspay_pan_translation):
        """
        Sets the enable_expresspay_pan_translation of this CardProcessingConfigCommonProcessors.
        When this is enabled, authorization responses from American Express expresspay transactions include the Primary Account Number (PAN) and expiration date of the card. Applicable for American Express Direct (amexdirect) processor.

        :param enable_expresspay_pan_translation: The enable_expresspay_pan_translation of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._enable_expresspay_pan_translation = enable_expresspay_pan_translation

    @property
    def enable_credit_auth(self):
        """
        Gets the enable_credit_auth of this CardProcessingConfigCommonProcessors.
        Authorizes a credit. Reduces refund chargebacks and prevents customers from seeing the online update for credits which are otherwise offline settlements.

        :return: The enable_credit_auth of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._enable_credit_auth

    @enable_credit_auth.setter
    def enable_credit_auth(self, enable_credit_auth):
        """
        Sets the enable_credit_auth of this CardProcessingConfigCommonProcessors.
        Authorizes a credit. Reduces refund chargebacks and prevents customers from seeing the online update for credits which are otherwise offline settlements.

        :param enable_credit_auth: The enable_credit_auth of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._enable_credit_auth = enable_credit_auth

    @property
    def industry_code(self):
        """
        Gets the industry_code of this CardProcessingConfigCommonProcessors.
        Field used to identify the industry type of the merchant submitting the authorization request.  Valid values: `0` – unknown or unsure `A` – auto rental (EMV supported) `B` – bank/financial institution (EMV supported) `D` – direct marketing `F` – food/restaurant (EMV supported) `G` – grocery store/super market (EMV supported) `H` – hotel (EMV supported) `L` – limited amount terminal (EMV supported) `O` – oil company/automated fueling system (EMV supported) `P` – passenger transport (EMV supported) `R` – retail (EMV supported) Applicable for TSYS (tsys), RUPAY and Elavon Americas (elavonamericas) processors.   Possible values: - 0 - A - B - D - F - G - H - L - O - P - R

        :return: The industry_code of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._industry_code

    @industry_code.setter
    def industry_code(self, industry_code):
        """
        Sets the industry_code of this CardProcessingConfigCommonProcessors.
        Field used to identify the industry type of the merchant submitting the authorization request.  Valid values: `0` – unknown or unsure `A` – auto rental (EMV supported) `B` – bank/financial institution (EMV supported) `D` – direct marketing `F` – food/restaurant (EMV supported) `G` – grocery store/super market (EMV supported) `H` – hotel (EMV supported) `L` – limited amount terminal (EMV supported) `O` – oil company/automated fueling system (EMV supported) `P` – passenger transport (EMV supported) `R` – retail (EMV supported) Applicable for TSYS (tsys), RUPAY and Elavon Americas (elavonamericas) processors.   Possible values: - 0 - A - B - D - F - G - H - L - O - P - R

        :param industry_code: The industry_code of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._industry_code = industry_code

    @property
    def send_amex_level2_data(self):
        """
        Gets the send_amex_level2_data of this CardProcessingConfigCommonProcessors.
        Field that indicates whether merchant will send level 2 data for Amex cards. Applicable for TSYS (tsys) processor.

        :return: The send_amex_level2_data of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._send_amex_level2_data

    @send_amex_level2_data.setter
    def send_amex_level2_data(self, send_amex_level2_data):
        """
        Sets the send_amex_level2_data of this CardProcessingConfigCommonProcessors.
        Field that indicates whether merchant will send level 2 data for Amex cards. Applicable for TSYS (tsys) processor.

        :param send_amex_level2_data: The send_amex_level2_data of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._send_amex_level2_data = send_amex_level2_data

    @property
    def soft_descriptor_type(self):
        """
        Gets the soft_descriptor_type of this CardProcessingConfigCommonProcessors.
        A soft descriptor is a text, rendered on a cardholder's statement, describing a particular product or service, purchased by the cardholder. Descriptors are intended to help the cardholder identify the products or services purchased. Valid values: `1` - trans_ref_no `2` - merchant_descriptor `3` - trans_ref_no and merchant_descriptor Applicable for TSYS (tsys) processor. 

        :return: The soft_descriptor_type of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._soft_descriptor_type

    @soft_descriptor_type.setter
    def soft_descriptor_type(self, soft_descriptor_type):
        """
        Sets the soft_descriptor_type of this CardProcessingConfigCommonProcessors.
        A soft descriptor is a text, rendered on a cardholder's statement, describing a particular product or service, purchased by the cardholder. Descriptors are intended to help the cardholder identify the products or services purchased. Valid values: `1` - trans_ref_no `2` - merchant_descriptor `3` - trans_ref_no and merchant_descriptor Applicable for TSYS (tsys) processor. 

        :param soft_descriptor_type: The soft_descriptor_type of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._soft_descriptor_type = soft_descriptor_type

    @property
    def vital_number(self):
        """
        Gets the vital_number of this CardProcessingConfigCommonProcessors.
        V-number provided by TSYS info. The leading `V` must be replaced by a `7`. For example, replace `V1234567` with `71234567`. Applicable for TSYS (tsys) processor.

        :return: The vital_number of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._vital_number

    @vital_number.setter
    def vital_number(self, vital_number):
        """
        Sets the vital_number of this CardProcessingConfigCommonProcessors.
        V-number provided by TSYS info. The leading `V` must be replaced by a `7`. For example, replace `V1234567` with `71234567`. Applicable for TSYS (tsys) processor.

        :param vital_number: The vital_number of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._vital_number = vital_number

    @property
    def bank_number(self):
        """
        Gets the bank_number of this CardProcessingConfigCommonProcessors.
        6 digit agent bank number provided by acquirer. Applicable for TSYS (tsys) processor.

        :return: The bank_number of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._bank_number

    @bank_number.setter
    def bank_number(self, bank_number):
        """
        Sets the bank_number of this CardProcessingConfigCommonProcessors.
        6 digit agent bank number provided by acquirer. Applicable for TSYS (tsys) processor.

        :param bank_number: The bank_number of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._bank_number = bank_number

    @property
    def chain_number(self):
        """
        Gets the chain_number of this CardProcessingConfigCommonProcessors.
        6 digit chain number provided by acquirer. Applicable for TSYS (tsys) processor.

        :return: The chain_number of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._chain_number

    @chain_number.setter
    def chain_number(self, chain_number):
        """
        Sets the chain_number of this CardProcessingConfigCommonProcessors.
        6 digit chain number provided by acquirer. Applicable for TSYS (tsys) processor.

        :param chain_number: The chain_number of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._chain_number = chain_number

    @property
    def merchant_bin_number(self):
        """
        Gets the merchant_bin_number of this CardProcessingConfigCommonProcessors.
        6 digits acquirer bank identification number. Applicable for TSYS (tsys) processor.

        :return: The merchant_bin_number of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._merchant_bin_number

    @merchant_bin_number.setter
    def merchant_bin_number(self, merchant_bin_number):
        """
        Sets the merchant_bin_number of this CardProcessingConfigCommonProcessors.
        6 digits acquirer bank identification number. Applicable for TSYS (tsys) processor.

        :param merchant_bin_number: The merchant_bin_number of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._merchant_bin_number = merchant_bin_number

    @property
    def merchant_location_number(self):
        """
        Gets the merchant_location_number of this CardProcessingConfigCommonProcessors.
        5 digit merchant location number. Unless otherwise specified by merchant's bank or processor, this field should default to 00001. Applicable for TSYS (tsys) processor.

        :return: The merchant_location_number of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._merchant_location_number

    @merchant_location_number.setter
    def merchant_location_number(self, merchant_location_number):
        """
        Sets the merchant_location_number of this CardProcessingConfigCommonProcessors.
        5 digit merchant location number. Unless otherwise specified by merchant's bank or processor, this field should default to 00001. Applicable for TSYS (tsys) processor.

        :param merchant_location_number: The merchant_location_number of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._merchant_location_number = merchant_location_number

    @property
    def store_id(self):
        """
        Gets the store_id of this CardProcessingConfigCommonProcessors.
        4 digits number used to identify a specific merchant store location within the member systems. Applicable for TSYS (tsys) processor.

        :return: The store_id of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._store_id

    @store_id.setter
    def store_id(self, store_id):
        """
        Sets the store_id of this CardProcessingConfigCommonProcessors.
        4 digits number used to identify a specific merchant store location within the member systems. Applicable for TSYS (tsys) processor.

        :param store_id: The store_id of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._store_id = store_id

    @property
    def travel_agency_code(self):
        """
        Gets the travel_agency_code of this CardProcessingConfigCommonProcessors.
        Contains travel agency code if airline ticket was issued by a travel agency. Applicable for TSYS (tsys) processor.

        :return: The travel_agency_code of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._travel_agency_code

    @travel_agency_code.setter
    def travel_agency_code(self, travel_agency_code):
        """
        Sets the travel_agency_code of this CardProcessingConfigCommonProcessors.
        Contains travel agency code if airline ticket was issued by a travel agency. Applicable for TSYS (tsys) processor.

        :param travel_agency_code: The travel_agency_code of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._travel_agency_code = travel_agency_code

    @property
    def travel_agency_name(self):
        """
        Gets the travel_agency_name of this CardProcessingConfigCommonProcessors.
        Contains travel agency name if airline ticket was issued by travel agency. Applicable for TSYS (tsys) processor.

        :return: The travel_agency_name of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._travel_agency_name

    @travel_agency_name.setter
    def travel_agency_name(self, travel_agency_name):
        """
        Sets the travel_agency_name of this CardProcessingConfigCommonProcessors.
        Contains travel agency name if airline ticket was issued by travel agency. Applicable for TSYS (tsys) processor.

        :param travel_agency_name: The travel_agency_name of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._travel_agency_name = travel_agency_name

    @property
    def settlement_currency(self):
        """
        Gets the settlement_currency of this CardProcessingConfigCommonProcessors.
        This field is used to indicate Merchant's settlement currency. [ISO 4217 ALPHA-3 Standard Currency Codes] Applicable for TSYS (tsys) and Streamline (streamline2) processors.

        :return: The settlement_currency of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._settlement_currency

    @settlement_currency.setter
    def settlement_currency(self, settlement_currency):
        """
        Sets the settlement_currency of this CardProcessingConfigCommonProcessors.
        This field is used to indicate Merchant's settlement currency. [ISO 4217 ALPHA-3 Standard Currency Codes] Applicable for TSYS (tsys) and Streamline (streamline2) processors.

        :param settlement_currency: The settlement_currency of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._settlement_currency = settlement_currency

    @property
    def enable_least_cost_routing(self):
        """
        Gets the enable_least_cost_routing of this CardProcessingConfigCommonProcessors.
        Indicates whether Least Cost Routing is enabled. Applicable for EFTPOS and CUP processors.

        :return: The enable_least_cost_routing of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._enable_least_cost_routing

    @enable_least_cost_routing.setter
    def enable_least_cost_routing(self, enable_least_cost_routing):
        """
        Sets the enable_least_cost_routing of this CardProcessingConfigCommonProcessors.
        Indicates whether Least Cost Routing is enabled. Applicable for EFTPOS and CUP processors.

        :param enable_least_cost_routing: The enable_least_cost_routing of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._enable_least_cost_routing = enable_least_cost_routing

    @property
    def enable_cvv_response_indicator(self):
        """
        Gets the enable_cvv_response_indicator of this CardProcessingConfigCommonProcessors.
        This field denotes EFTPOS Merchant's choice of receiving CVV Processing Response in return. Applicable for EFTPOS processors.

        :return: The enable_cvv_response_indicator of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._enable_cvv_response_indicator

    @enable_cvv_response_indicator.setter
    def enable_cvv_response_indicator(self, enable_cvv_response_indicator):
        """
        Sets the enable_cvv_response_indicator of this CardProcessingConfigCommonProcessors.
        This field denotes EFTPOS Merchant's choice of receiving CVV Processing Response in return. Applicable for EFTPOS processors.

        :param enable_cvv_response_indicator: The enable_cvv_response_indicator of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._enable_cvv_response_indicator = enable_cvv_response_indicator

    @property
    def enable_multi_currency_processing(self):
        """
        Gets the enable_multi_currency_processing of this CardProcessingConfigCommonProcessors.
        Applicable for Barclays (barclays2) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>Yes</td></tr> </table> 

        :return: The enable_multi_currency_processing of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._enable_multi_currency_processing

    @enable_multi_currency_processing.setter
    def enable_multi_currency_processing(self, enable_multi_currency_processing):
        """
        Sets the enable_multi_currency_processing of this CardProcessingConfigCommonProcessors.
        Applicable for Barclays (barclays2) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>Yes</td></tr> </table> 

        :param enable_multi_currency_processing: The enable_multi_currency_processing of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._enable_multi_currency_processing = enable_multi_currency_processing

    @property
    def enable_pos_network_switching(self):
        """
        Gets the enable_pos_network_switching of this CardProcessingConfigCommonProcessors.
        'POS Network Switching' or 'Alternate Routing' means merchant can process PIN Debit transactions without a PIN. Set the value to 'Yes' if it is supported. Applicable for FDI Global (fdiglobal) processor.

        :return: The enable_pos_network_switching of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._enable_pos_network_switching

    @enable_pos_network_switching.setter
    def enable_pos_network_switching(self, enable_pos_network_switching):
        """
        Sets the enable_pos_network_switching of this CardProcessingConfigCommonProcessors.
        'POS Network Switching' or 'Alternate Routing' means merchant can process PIN Debit transactions without a PIN. Set the value to 'Yes' if it is supported. Applicable for FDI Global (fdiglobal) processor.

        :param enable_pos_network_switching: The enable_pos_network_switching of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._enable_pos_network_switching = enable_pos_network_switching

    @property
    def enable_dynamic_currency_conversion(self):
        """
        Gets the enable_dynamic_currency_conversion of this CardProcessingConfigCommonProcessors.
        Enable dynamic currency conversion for a merchant.

        :return: The enable_dynamic_currency_conversion of this CardProcessingConfigCommonProcessors.
        :rtype: bool
        """
        return self._enable_dynamic_currency_conversion

    @enable_dynamic_currency_conversion.setter
    def enable_dynamic_currency_conversion(self, enable_dynamic_currency_conversion):
        """
        Sets the enable_dynamic_currency_conversion of this CardProcessingConfigCommonProcessors.
        Enable dynamic currency conversion for a merchant.

        :param enable_dynamic_currency_conversion: The enable_dynamic_currency_conversion of this CardProcessingConfigCommonProcessors.
        :type: bool
        """

        self._enable_dynamic_currency_conversion = enable_dynamic_currency_conversion

    @property
    def merchant_tier(self):
        """
        Gets the merchant_tier of this CardProcessingConfigCommonProcessors.
        Merchant Tier defines the type of merchant, the numeric Merchant Tier value is allocated by EFTPOS. Applicable for EFTPOS processors.

        :return: The merchant_tier of this CardProcessingConfigCommonProcessors.
        :rtype: str
        """
        return self._merchant_tier

    @merchant_tier.setter
    def merchant_tier(self, merchant_tier):
        """
        Sets the merchant_tier of this CardProcessingConfigCommonProcessors.
        Merchant Tier defines the type of merchant, the numeric Merchant Tier value is allocated by EFTPOS. Applicable for EFTPOS processors.

        :param merchant_tier: The merchant_tier of this CardProcessingConfigCommonProcessors.
        :type: str
        """

        self._merchant_tier = merchant_tier

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CardProcessingConfigCommonProcessors):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
