# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class TmsBinLookupPaymentAccountInformationCard(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'str',
        'brand_name': 'str',
        'currency': 'str',
        'max_length': 'str',
        'credential_type': 'str',
        'brands': 'list[TmsBinLookupPaymentAccountInformationCardBrands]'
    }

    attribute_map = {
        'type': 'type',
        'brand_name': 'brandName',
        'currency': 'currency',
        'max_length': 'maxLength',
        'credential_type': 'credentialType',
        'brands': 'brands'
    }

    def __init__(self, type=None, brand_name=None, currency=None, max_length=None, credential_type=None, brands=None):
        """
        TmsBinLookupPaymentAccountInformationCard - a model defined in Swagger
        """

        self._type = None
        self._brand_name = None
        self._currency = None
        self._max_length = None
        self._credential_type = None
        self._brands = None

        if type is not None:
          self.type = type
        if brand_name is not None:
          self.brand_name = brand_name
        if currency is not None:
          self.currency = currency
        if max_length is not None:
          self.max_length = max_length
        if credential_type is not None:
          self.credential_type = credential_type
        if brands is not None:
          self.brands = brands

    @property
    def type(self):
        """
        Gets the type of this TmsBinLookupPaymentAccountInformationCard.
        This field contains a 3-digit numeric value that indicates the card type within Cybersource eco-system. Possible values from BIN Lookup Service (based on availability and enablement): - `000`: Unsupported Card Type - `001`: Visa - `002`: Mastercard - `003`: American Express - `004`: Discover - `005`: Diners Club - `007`: JCB - `036`: Cartes Bancaire - `042`: Maestro - `054`: Elo - `058`: Carnet - `060`: MADA - `061`: RuPay - `062`: China UnionPay - `064`: Prompt Card - `067`: Meeza - `068`: PayPak - `070`: EFTPOS - `081`: Jaywan - `082`: TPN  Glossary of possible values in the payments ecosystem: - `001`: Visa - `002`: Mastercard - `003`: American Express - `004`: Discover - `005`: Diners Club - `006`: Carte Blanche - `007`: JCB - `008`: Optima - `009`: GE Private Label - `010`: Beneficial Private Label - `011`: Twinpay Credit Card - `012`: Twinpay Debit Card - `013`: Walmart - `014`: EnRoute - `015`: Lowe's Consumer - `016`: Home Depot Consumer - `017`: MBNA - `018`: Dick's Sportwear - `019`: Casual Corner - `020`: Sears - `021`: JAL - `023`: Disney Card - `024`: Switch/Solo - `025`: Sam's Club Consumer - `026`: Sam's Club Business - `027`: Nico's - `028`: Paymentech Bill Me Later - `029`: Bebe - `030`: Restoration Hardware - `031`: Delta Online - `032`: Solo - `033`: Visa Electron - `034`: Dankort - `035`: Laser - `036`: Cartes Bancaire - `037`: Carta Si - `040`: UATP - `041`: HOUSEHOLD - `042`: Maestro - `043`: GE MONEY - `044`: Korean Cards - `045`: Style Cards - `046`: J.Crew - `047`: Payeasecn eWallet - `048`: Payeasecn Bank Transfer - `049`: Meijer - `050`: Hipercard - `051`: Aura - `052`: Redecard - `053`: Orico Card - `054`: Elo - `055`: Capital One Private Label - `057`: Costco Private Label - `058`: Carnet - `059`: ValueLink - `060`: MADA - `061`: RuPay - `062`: China UnionPay - `063`: Falabella Private Label - `064`: Prompt Card - `065`: Korean Domestic - `066`: Banricompras - `067`: Meeza - `068`: PayPak - `070`: EFTPOS - `071`: Codensa - `072`: Olimpica - `073`: Colsubsidio - `074`: Tuya - `075`: Sodexo - `076`: Naranja - `077`: Cabal - `078`: DINELCO - `079`: PANAL - `080`: EPM - `081`: Jaywan - `082`: TPN 

        :return: The type of this TmsBinLookupPaymentAccountInformationCard.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this TmsBinLookupPaymentAccountInformationCard.
        This field contains a 3-digit numeric value that indicates the card type within Cybersource eco-system. Possible values from BIN Lookup Service (based on availability and enablement): - `000`: Unsupported Card Type - `001`: Visa - `002`: Mastercard - `003`: American Express - `004`: Discover - `005`: Diners Club - `007`: JCB - `036`: Cartes Bancaire - `042`: Maestro - `054`: Elo - `058`: Carnet - `060`: MADA - `061`: RuPay - `062`: China UnionPay - `064`: Prompt Card - `067`: Meeza - `068`: PayPak - `070`: EFTPOS - `081`: Jaywan - `082`: TPN  Glossary of possible values in the payments ecosystem: - `001`: Visa - `002`: Mastercard - `003`: American Express - `004`: Discover - `005`: Diners Club - `006`: Carte Blanche - `007`: JCB - `008`: Optima - `009`: GE Private Label - `010`: Beneficial Private Label - `011`: Twinpay Credit Card - `012`: Twinpay Debit Card - `013`: Walmart - `014`: EnRoute - `015`: Lowe's Consumer - `016`: Home Depot Consumer - `017`: MBNA - `018`: Dick's Sportwear - `019`: Casual Corner - `020`: Sears - `021`: JAL - `023`: Disney Card - `024`: Switch/Solo - `025`: Sam's Club Consumer - `026`: Sam's Club Business - `027`: Nico's - `028`: Paymentech Bill Me Later - `029`: Bebe - `030`: Restoration Hardware - `031`: Delta Online - `032`: Solo - `033`: Visa Electron - `034`: Dankort - `035`: Laser - `036`: Cartes Bancaire - `037`: Carta Si - `040`: UATP - `041`: HOUSEHOLD - `042`: Maestro - `043`: GE MONEY - `044`: Korean Cards - `045`: Style Cards - `046`: J.Crew - `047`: Payeasecn eWallet - `048`: Payeasecn Bank Transfer - `049`: Meijer - `050`: Hipercard - `051`: Aura - `052`: Redecard - `053`: Orico Card - `054`: Elo - `055`: Capital One Private Label - `057`: Costco Private Label - `058`: Carnet - `059`: ValueLink - `060`: MADA - `061`: RuPay - `062`: China UnionPay - `063`: Falabella Private Label - `064`: Prompt Card - `065`: Korean Domestic - `066`: Banricompras - `067`: Meeza - `068`: PayPak - `070`: EFTPOS - `071`: Codensa - `072`: Olimpica - `073`: Colsubsidio - `074`: Tuya - `075`: Sodexo - `076`: Naranja - `077`: Cabal - `078`: DINELCO - `079`: PANAL - `080`: EPM - `081`: Jaywan - `082`: TPN 

        :param type: The type of this TmsBinLookupPaymentAccountInformationCard.
        :type: str
        """

        self._type = type

    @property
    def brand_name(self):
        """
        Gets the brand_name of this TmsBinLookupPaymentAccountInformationCard.
        This field contains the card brand name.   Some of the possible values (not an exhaustive list) are -    - VISA   - MASTERCARD   - AMERICAN EXPRESS   - DISCOVER   - DINERS CLUB   - CARTE BLANCHE   - JCB   - OPTIMA   - TWINPAY CREDIT CARD   - TWINPAY DEBIT CARD   - WALMART   - ENROUTE   - LOWES CONSUMER   - HOME DEPOT CONSUMER   - MBNA   - DICKS SPORTWEAR   - CASUAL CORNER   - SEARS   - JAL   - DISNEY CARD   - SWITCH/SOLO   - SAMS CLUB CONSUMER   - SAMS CLUB BUSINESS   - NICOS HOUSE CARD   - BEBE   - RESTORATION HARDWARE   - DELTA ONLINE   - SOLO   - VISA ELECTRON   - DANKORT   - LASER   - CARTE BANCAIRE   - CARTA SI   - ENCODED ACCOUNT   - UATP   - HOUSEHOLD   - MAESTRO   - GE CAPITAL   - KOREAN CARDS   - STYLE CARDS   - JCREW   - MEIJER   - HIPERCARD   - AURA   - REDECARD   - ORICO HOUSE CARD   - MADA   - ELO   - CAPITAL ONE PRIVATE LABEL   - CARNET   - RUPAY   - CHINA UNION PAY   - FALABELLA PRIVATE LABEL   - PROMPTCARD   - KOREAN DOMESTIC   - BANRICOMPRAS   - MEEZA   - PAYPAK   - JAYWAN   - TPN 

        :return: The brand_name of this TmsBinLookupPaymentAccountInformationCard.
        :rtype: str
        """
        return self._brand_name

    @brand_name.setter
    def brand_name(self, brand_name):
        """
        Sets the brand_name of this TmsBinLookupPaymentAccountInformationCard.
        This field contains the card brand name.   Some of the possible values (not an exhaustive list) are -    - VISA   - MASTERCARD   - AMERICAN EXPRESS   - DISCOVER   - DINERS CLUB   - CARTE BLANCHE   - JCB   - OPTIMA   - TWINPAY CREDIT CARD   - TWINPAY DEBIT CARD   - WALMART   - ENROUTE   - LOWES CONSUMER   - HOME DEPOT CONSUMER   - MBNA   - DICKS SPORTWEAR   - CASUAL CORNER   - SEARS   - JAL   - DISNEY CARD   - SWITCH/SOLO   - SAMS CLUB CONSUMER   - SAMS CLUB BUSINESS   - NICOS HOUSE CARD   - BEBE   - RESTORATION HARDWARE   - DELTA ONLINE   - SOLO   - VISA ELECTRON   - DANKORT   - LASER   - CARTE BANCAIRE   - CARTA SI   - ENCODED ACCOUNT   - UATP   - HOUSEHOLD   - MAESTRO   - GE CAPITAL   - KOREAN CARDS   - STYLE CARDS   - JCREW   - MEIJER   - HIPERCARD   - AURA   - REDECARD   - ORICO HOUSE CARD   - MADA   - ELO   - CAPITAL ONE PRIVATE LABEL   - CARNET   - RUPAY   - CHINA UNION PAY   - FALABELLA PRIVATE LABEL   - PROMPTCARD   - KOREAN DOMESTIC   - BANRICOMPRAS   - MEEZA   - PAYPAK   - JAYWAN   - TPN 

        :param brand_name: The brand_name of this TmsBinLookupPaymentAccountInformationCard.
        :type: str
        """

        self._brand_name = brand_name

    @property
    def currency(self):
        """
        Gets the currency of this TmsBinLookupPaymentAccountInformationCard.
        This field indicates the 3-letter [ISO Standard Currency Codes](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf) for the card currency. 

        :return: The currency of this TmsBinLookupPaymentAccountInformationCard.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this TmsBinLookupPaymentAccountInformationCard.
        This field indicates the 3-letter [ISO Standard Currency Codes](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf) for the card currency. 

        :param currency: The currency of this TmsBinLookupPaymentAccountInformationCard.
        :type: str
        """

        self._currency = currency

    @property
    def max_length(self):
        """
        Gets the max_length of this TmsBinLookupPaymentAccountInformationCard.
        This field contains the max length of the card. 

        :return: The max_length of this TmsBinLookupPaymentAccountInformationCard.
        :rtype: str
        """
        return self._max_length

    @max_length.setter
    def max_length(self, max_length):
        """
        Sets the max_length of this TmsBinLookupPaymentAccountInformationCard.
        This field contains the max length of the card. 

        :param max_length: The max_length of this TmsBinLookupPaymentAccountInformationCard.
        :type: str
        """

        self._max_length = max_length

    @property
    def credential_type(self):
        """
        Gets the credential_type of this TmsBinLookupPaymentAccountInformationCard.
        This field contains the type of the payment credential. Possible values:   - PAN   - TOKEN  

        :return: The credential_type of this TmsBinLookupPaymentAccountInformationCard.
        :rtype: str
        """
        return self._credential_type

    @credential_type.setter
    def credential_type(self, credential_type):
        """
        Sets the credential_type of this TmsBinLookupPaymentAccountInformationCard.
        This field contains the type of the payment credential. Possible values:   - PAN   - TOKEN  

        :param credential_type: The credential_type of this TmsBinLookupPaymentAccountInformationCard.
        :type: str
        """

        self._credential_type = credential_type

    @property
    def brands(self):
        """
        Gets the brands of this TmsBinLookupPaymentAccountInformationCard.
        Array of brands

        :return: The brands of this TmsBinLookupPaymentAccountInformationCard.
        :rtype: list[TmsBinLookupPaymentAccountInformationCardBrands]
        """
        return self._brands

    @brands.setter
    def brands(self, brands):
        """
        Sets the brands of this TmsBinLookupPaymentAccountInformationCard.
        Array of brands

        :param brands: The brands of this TmsBinLookupPaymentAccountInformationCard.
        :type: list[TmsBinLookupPaymentAccountInformationCardBrands]
        """

        self._brands = brands

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TmsBinLookupPaymentAccountInformationCard):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
