# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class Tmsv2TokenizedCardCard(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'number': 'str',
        'expiration_month': 'str',
        'expiration_year': 'str',
        'type': 'str',
        'suffix': 'str',
        'issue_date': 'date',
        'activation_date': 'date',
        'expiration_printed': 'bool',
        'security_code_printed': 'bool',
        'terms_and_conditions': 'Tmsv2TokenizedCardCardTermsAndConditions'
    }

    attribute_map = {
        'number': 'number',
        'expiration_month': 'expirationMonth',
        'expiration_year': 'expirationYear',
        'type': 'type',
        'suffix': 'suffix',
        'issue_date': 'issueDate',
        'activation_date': 'activationDate',
        'expiration_printed': 'expirationPrinted',
        'security_code_printed': 'securityCodePrinted',
        'terms_and_conditions': 'termsAndConditions'
    }

    def __init__(self, number=None, expiration_month=None, expiration_year=None, type=None, suffix=None, issue_date=None, activation_date=None, expiration_printed=None, security_code_printed=None, terms_and_conditions=None):
        """
        Tmsv2TokenizedCardCard - a model defined in Swagger
        """

        self._number = None
        self._expiration_month = None
        self._expiration_year = None
        self._type = None
        self._suffix = None
        self._issue_date = None
        self._activation_date = None
        self._expiration_printed = None
        self._security_code_printed = None
        self._terms_and_conditions = None

        if number is not None:
          self.number = number
        if expiration_month is not None:
          self.expiration_month = expiration_month
        if expiration_year is not None:
          self.expiration_year = expiration_year
        if type is not None:
          self.type = type
        if suffix is not None:
          self.suffix = suffix
        if issue_date is not None:
          self.issue_date = issue_date
        if activation_date is not None:
          self.activation_date = activation_date
        if expiration_printed is not None:
          self.expiration_printed = expiration_printed
        if security_code_printed is not None:
          self.security_code_printed = security_code_printed
        if terms_and_conditions is not None:
          self.terms_and_conditions = terms_and_conditions

    @property
    def number(self):
        """
        Gets the number of this Tmsv2TokenizedCardCard.
        The customer's payment card number, also known as the Primary Account Number (PAN). 

        :return: The number of this Tmsv2TokenizedCardCard.
        :rtype: str
        """
        return self._number

    @number.setter
    def number(self, number):
        """
        Sets the number of this Tmsv2TokenizedCardCard.
        The customer's payment card number, also known as the Primary Account Number (PAN). 

        :param number: The number of this Tmsv2TokenizedCardCard.
        :type: str
        """

        self._number = number

    @property
    def expiration_month(self):
        """
        Gets the expiration_month of this Tmsv2TokenizedCardCard.
        Two-digit month in which the payment card expires.  Format: `MM`.  Possible Values: `01` through `12`. 

        :return: The expiration_month of this Tmsv2TokenizedCardCard.
        :rtype: str
        """
        return self._expiration_month

    @expiration_month.setter
    def expiration_month(self, expiration_month):
        """
        Sets the expiration_month of this Tmsv2TokenizedCardCard.
        Two-digit month in which the payment card expires.  Format: `MM`.  Possible Values: `01` through `12`. 

        :param expiration_month: The expiration_month of this Tmsv2TokenizedCardCard.
        :type: str
        """

        self._expiration_month = expiration_month

    @property
    def expiration_year(self):
        """
        Gets the expiration_year of this Tmsv2TokenizedCardCard.
        Four-digit year in which the credit card expires.  Format: `YYYY`. 

        :return: The expiration_year of this Tmsv2TokenizedCardCard.
        :rtype: str
        """
        return self._expiration_year

    @expiration_year.setter
    def expiration_year(self, expiration_year):
        """
        Sets the expiration_year of this Tmsv2TokenizedCardCard.
        Four-digit year in which the credit card expires.  Format: `YYYY`. 

        :param expiration_year: The expiration_year of this Tmsv2TokenizedCardCard.
        :type: str
        """

        self._expiration_year = expiration_year

    @property
    def type(self):
        """
        Gets the type of this Tmsv2TokenizedCardCard.
        The type of card (Card Network). Possible Values: - 001: visa 

        :return: The type of this Tmsv2TokenizedCardCard.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Tmsv2TokenizedCardCard.
        The type of card (Card Network). Possible Values: - 001: visa 

        :param type: The type of this Tmsv2TokenizedCardCard.
        :type: str
        """

        self._type = type

    @property
    def suffix(self):
        """
        Gets the suffix of this Tmsv2TokenizedCardCard.
        The customer's latest payment card number suffix. 

        :return: The suffix of this Tmsv2TokenizedCardCard.
        :rtype: str
        """
        return self._suffix

    @suffix.setter
    def suffix(self, suffix):
        """
        Sets the suffix of this Tmsv2TokenizedCardCard.
        The customer's latest payment card number suffix. 

        :param suffix: The suffix of this Tmsv2TokenizedCardCard.
        :type: str
        """

        self._suffix = suffix

    @property
    def issue_date(self):
        """
        Gets the issue_date of this Tmsv2TokenizedCardCard.
        Card issuance date. XML date format: YYYY-MM-DD.

        :return: The issue_date of this Tmsv2TokenizedCardCard.
        :rtype: date
        """
        return self._issue_date

    @issue_date.setter
    def issue_date(self, issue_date):
        """
        Sets the issue_date of this Tmsv2TokenizedCardCard.
        Card issuance date. XML date format: YYYY-MM-DD.

        :param issue_date: The issue_date of this Tmsv2TokenizedCardCard.
        :type: date
        """

        self._issue_date = issue_date

    @property
    def activation_date(self):
        """
        Gets the activation_date of this Tmsv2TokenizedCardCard.
        Card activation date. XML date format: YYYY-MM-DD

        :return: The activation_date of this Tmsv2TokenizedCardCard.
        :rtype: date
        """
        return self._activation_date

    @activation_date.setter
    def activation_date(self, activation_date):
        """
        Sets the activation_date of this Tmsv2TokenizedCardCard.
        Card activation date. XML date format: YYYY-MM-DD

        :param activation_date: The activation_date of this Tmsv2TokenizedCardCard.
        :type: date
        """

        self._activation_date = activation_date

    @property
    def expiration_printed(self):
        """
        Gets the expiration_printed of this Tmsv2TokenizedCardCard.
        Indicates if the expiration date is printed on the card.

        :return: The expiration_printed of this Tmsv2TokenizedCardCard.
        :rtype: bool
        """
        return self._expiration_printed

    @expiration_printed.setter
    def expiration_printed(self, expiration_printed):
        """
        Sets the expiration_printed of this Tmsv2TokenizedCardCard.
        Indicates if the expiration date is printed on the card.

        :param expiration_printed: The expiration_printed of this Tmsv2TokenizedCardCard.
        :type: bool
        """

        self._expiration_printed = expiration_printed

    @property
    def security_code_printed(self):
        """
        Gets the security_code_printed of this Tmsv2TokenizedCardCard.
        Indicates if the Card Verification Number is printed on the card.

        :return: The security_code_printed of this Tmsv2TokenizedCardCard.
        :rtype: bool
        """
        return self._security_code_printed

    @security_code_printed.setter
    def security_code_printed(self, security_code_printed):
        """
        Sets the security_code_printed of this Tmsv2TokenizedCardCard.
        Indicates if the Card Verification Number is printed on the card.

        :param security_code_printed: The security_code_printed of this Tmsv2TokenizedCardCard.
        :type: bool
        """

        self._security_code_printed = security_code_printed

    @property
    def terms_and_conditions(self):
        """
        Gets the terms_and_conditions of this Tmsv2TokenizedCardCard.

        :return: The terms_and_conditions of this Tmsv2TokenizedCardCard.
        :rtype: Tmsv2TokenizedCardCardTermsAndConditions
        """
        return self._terms_and_conditions

    @terms_and_conditions.setter
    def terms_and_conditions(self, terms_and_conditions):
        """
        Sets the terms_and_conditions of this Tmsv2TokenizedCardCard.

        :param terms_and_conditions: The terms_and_conditions of this Tmsv2TokenizedCardCard.
        :type: Tmsv2TokenizedCardCardTermsAndConditions
        """

        self._terms_and_conditions = terms_and_conditions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Tmsv2TokenizedCardCard):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
