# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory
from CyberSource.utilities.MultipartHelpers import MultipartHelpers
from authenticationsdk.util.MLEUtility import MLEUtility
from authenticationsdk.util.GlobalLabelParameters import GlobalLabelParameters
from authenticationsdk.util.Utility import process_body

from ..utilities.tracking.sdk_tracker import SdkTracker
class FlexAPIApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        if api_client:
            self.api_client = api_client
        else:
            self.api_client = ApiClient()
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def generate_flex_api_capture_context(self, generate_flex_api_capture_context_request, **kwargs):
        """
        Establish a Payment Session with a Capture Context
        To establish a payment session, include the API fields you plan to use in that session in the body of the request.  The system then returns a JSON Web Token (JWT) that includes the capture context.   To determine which fields to include in your capture context, identify the personal information that you wish to isolate from the payment session.  **Capture Context Fields**<br> When making a session request, any fields that you request to be added to the capture context are required by default.  However, you can choose to make a field optional by setting the required parameter to false. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.generate_flex_api_capture_context(generate_flex_api_capture_context_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param GenerateFlexAPICaptureContextRequest generate_flex_api_capture_context_request: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        self.logger.info("CALL TO METHOD `generate_flex_api_capture_context` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.generate_flex_api_capture_context_with_http_info(generate_flex_api_capture_context_request, **kwargs)
        else:
            (data) = self.generate_flex_api_capture_context_with_http_info(generate_flex_api_capture_context_request, **kwargs)
            return data

    def generate_flex_api_capture_context_with_http_info(self, generate_flex_api_capture_context_request, **kwargs):
        """
        Establish a Payment Session with a Capture Context
        To establish a payment session, include the API fields you plan to use in that session in the body of the request.  The system then returns a JSON Web Token (JWT) that includes the capture context.   To determine which fields to include in your capture context, identify the personal information that you wish to isolate from the payment session.  **Capture Context Fields**<br> When making a session request, any fields that you request to be added to the capture context are required by default.  However, you can choose to make a field optional by setting the required parameter to false. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.generate_flex_api_capture_context_with_http_info(generate_flex_api_capture_context_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param GenerateFlexAPICaptureContextRequest generate_flex_api_capture_context_request: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['generate_flex_api_capture_context_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_flex_api_capture_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'generate_flex_api_capture_context_request' is set
        if ('generate_flex_api_capture_context_request' not in params) or (params['generate_flex_api_capture_context_request'] is None):
            self.logger.error("InvalidArgumentException : Missing the required parameter `generate_flex_api_capture_context_request` when calling `generate_flex_api_capture_context`")
            raise ValueError("Missing the required parameter `generate_flex_api_capture_context_request` when calling `generate_flex_api_capture_context`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/jwt'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'generate_flex_api_capture_context_request' in params:
            body_params = params['generate_flex_api_capture_context_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'generate_flex_api_capture_context_request', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)
            body_params = process_body(body_params)

        inbound_mle_status = "false"
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, inbound_mle_status, "generate_flex_api_capture_context,generate_flex_api_capture_context_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/flex/v2/sessions', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
