# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory
from CyberSource.utilities.MultipartHelpers import MultipartHelpers
from authenticationsdk.util.MLEUtility import MLEUtility
from authenticationsdk.util.GlobalLabelParameters import GlobalLabelParameters
from authenticationsdk.util.Utility import process_body

from ..utilities.tracking.sdk_tracker import SdkTracker
class InvoiceSettingsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        if api_client:
            self.api_client = api_client
        else:
            self.api_client = ApiClient()
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def get_invoice_settings(self, **kwargs):
        """
        Get Invoice Settings
        Allows you to retrieve the invoice settings for the payment page.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_invoice_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: InvoicingV2InvoiceSettingsGet200Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        self.logger.info("CALL TO METHOD `get_invoice_settings` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_invoice_settings_with_http_info(**kwargs)
        else:
            (data) = self.get_invoice_settings_with_http_info(**kwargs)
            return data

    def get_invoice_settings_with_http_info(self, **kwargs):
        """
        Get Invoice Settings
        Allows you to retrieve the invoice settings for the payment page.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_invoice_settings_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: InvoicingV2InvoiceSettingsGet200Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json', 'application/hal+json', 'application/json;charset=utf-8', 'application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'GET' in ('POST'):
            body_params = '{}'
        
        file_post_body_and_delimiter = MultipartHelpers.build_post_body_for_files(local_var_files)
        if file_post_body_and_delimiter is not None:
            body_params = file_post_body_and_delimiter[0]
            header_params['Content-Type'] = f"multipart/form-data; boundary={file_post_body_and_delimiter[1]}" 

        inbound_mle_status = "false"
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, inbound_mle_status, "get_invoice_settings,get_invoice_settings_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/invoicing/v2/invoiceSettings', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InvoicingV2InvoiceSettingsGet200Response',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_invoice_settings(self, invoice_settings_request, **kwargs):
        """
        Update Invoice Settings
        Allows you to customize the payment page, the checkout experience, email communication and payer authentication. You can customize the invoice to match your brand with your business name, logo and brand colors, and a VAT Tax number. You can choose to capture the payers shipping details, phone number and email during the checkout process. You can add a custom message to all invoice emails and enable or disable payer authentication for invoice payments.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_invoice_settings(invoice_settings_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param InvoiceSettingsRequest invoice_settings_request: (required)
        :return: InvoicingV2InvoiceSettingsGet200Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        self.logger.info("CALL TO METHOD `update_invoice_settings` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_invoice_settings_with_http_info(invoice_settings_request, **kwargs)
        else:
            (data) = self.update_invoice_settings_with_http_info(invoice_settings_request, **kwargs)
            return data

    def update_invoice_settings_with_http_info(self, invoice_settings_request, **kwargs):
        """
        Update Invoice Settings
        Allows you to customize the payment page, the checkout experience, email communication and payer authentication. You can customize the invoice to match your brand with your business name, logo and brand colors, and a VAT Tax number. You can choose to capture the payers shipping details, phone number and email during the checkout process. You can add a custom message to all invoice emails and enable or disable payer authentication for invoice payments.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_invoice_settings_with_http_info(invoice_settings_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param InvoiceSettingsRequest invoice_settings_request: (required)
        :return: InvoicingV2InvoiceSettingsGet200Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_settings_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_invoice_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_settings_request' is set
        if ('invoice_settings_request' not in params) or (params['invoice_settings_request'] is None):
            self.logger.error("InvalidArgumentException : Missing the required parameter `invoice_settings_request` when calling `update_invoice_settings`")
            raise ValueError("Missing the required parameter `invoice_settings_request` when calling `update_invoice_settings`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json', 'application/hal+json', 'application/json;charset=utf-8', 'application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'invoice_settings_request' in params:
            body_params = params['invoice_settings_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'invoice_settings_request', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)
            body_params = process_body(body_params)

        inbound_mle_status = "false"
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, inbound_mle_status, "update_invoice_settings,update_invoice_settings_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/invoicing/v2/invoiceSettings', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InvoicingV2InvoiceSettingsGet200Response',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
