# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory
from CyberSource.utilities.MultipartHelpers import MultipartHelpers
from authenticationsdk.util.MLEUtility import MLEUtility
from authenticationsdk.util.GlobalLabelParameters import GlobalLabelParameters
from authenticationsdk.util.Utility import process_body

from ..utilities.tracking.sdk_tracker import SdkTracker
class MerchantDefinedFieldsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        if api_client:
            self.api_client = api_client
        else:
            self.api_client = ApiClient()
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def create_merchant_defined_field_definition(self, reference_type, merchant_defined_field_definition_request, **kwargs):
        """
        Create merchant defined field for a given reference type
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_merchant_defined_field_definition(reference_type, merchant_defined_field_definition_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str reference_type: The reference type for which merchant defined fields are to be fetched. Available values are Invoice, Purchase, Donation (required)
        :param MerchantDefinedFieldDefinitionRequest merchant_defined_field_definition_request: (required)
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        self.logger.info("CALL TO METHOD `create_merchant_defined_field_definition` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_merchant_defined_field_definition_with_http_info(reference_type, merchant_defined_field_definition_request, **kwargs)
        else:
            (data) = self.create_merchant_defined_field_definition_with_http_info(reference_type, merchant_defined_field_definition_request, **kwargs)
            return data

    def create_merchant_defined_field_definition_with_http_info(self, reference_type, merchant_defined_field_definition_request, **kwargs):
        """
        Create merchant defined field for a given reference type
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_merchant_defined_field_definition_with_http_info(reference_type, merchant_defined_field_definition_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str reference_type: The reference type for which merchant defined fields are to be fetched. Available values are Invoice, Purchase, Donation (required)
        :param MerchantDefinedFieldDefinitionRequest merchant_defined_field_definition_request: (required)
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reference_type', 'merchant_defined_field_definition_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_merchant_defined_field_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reference_type' is set
        if ('reference_type' not in params) or (params['reference_type'] is None):
            self.logger.error("InvalidArgumentException : Missing the required parameter `reference_type` when calling `create_merchant_defined_field_definition`")
            raise ValueError("Missing the required parameter `reference_type` when calling `create_merchant_defined_field_definition`")
        # verify the required parameter 'merchant_defined_field_definition_request' is set
        if ('merchant_defined_field_definition_request' not in params) or (params['merchant_defined_field_definition_request'] is None):
            self.logger.error("InvalidArgumentException : Missing the required parameter `merchant_defined_field_definition_request` when calling `create_merchant_defined_field_definition`")
            raise ValueError("Missing the required parameter `merchant_defined_field_definition_request` when calling `create_merchant_defined_field_definition`")


        collection_formats = {}

        path_params = {}
        if 'reference_type' in params:
            path_params['referenceType'] = params['reference_type']
            referenceType=reference_type

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])

        body_params = None
        if 'merchant_defined_field_definition_request' in params:
            body_params = params['merchant_defined_field_definition_request']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'merchant_defined_field_definition_request', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)
            body_params = process_body(body_params)

        inbound_mle_status = "false"
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, inbound_mle_status, "create_merchant_defined_field_definition,create_merchant_defined_field_definition_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/invoicing/v2/{referenceType}/merchantDefinedFields', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[InlineResponse2003]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_merchant_defined_fields_definitions(self, reference_type, id, **kwargs):
        """
        Delete a MerchantDefinedField by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_merchant_defined_fields_definitions(reference_type, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str reference_type: (required)
        :param int id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        self.logger.info("CALL TO METHOD `delete_merchant_defined_fields_definitions` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_merchant_defined_fields_definitions_with_http_info(reference_type, id, **kwargs)
        else:
            (data) = self.delete_merchant_defined_fields_definitions_with_http_info(reference_type, id, **kwargs)
            return data

    def delete_merchant_defined_fields_definitions_with_http_info(self, reference_type, id, **kwargs):
        """
        Delete a MerchantDefinedField by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_merchant_defined_fields_definitions_with_http_info(reference_type, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str reference_type: (required)
        :param int id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reference_type', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_merchant_defined_fields_definitions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reference_type' is set
        if ('reference_type' not in params) or (params['reference_type'] is None):
            self.logger.error("InvalidArgumentException : Missing the required parameter `reference_type` when calling `delete_merchant_defined_fields_definitions`")
            raise ValueError("Missing the required parameter `reference_type` when calling `delete_merchant_defined_fields_definitions`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            self.logger.error("InvalidArgumentException : Missing the required parameter `id` when calling `delete_merchant_defined_fields_definitions`")
            raise ValueError("Missing the required parameter `id` when calling `delete_merchant_defined_fields_definitions`")


        collection_formats = {}

        path_params = {}
        if 'reference_type' in params:
            path_params['referenceType'] = params['reference_type']
            referenceType=reference_type
        if 'id' in params:
            path_params['id'] = params['id']
            id=id

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'DELETE' in ('POST'):
            body_params = '{}'
        
        file_post_body_and_delimiter = MultipartHelpers.build_post_body_for_files(local_var_files)
        if file_post_body_and_delimiter is not None:
            body_params = file_post_body_and_delimiter[0]
            header_params['Content-Type'] = f"multipart/form-data; boundary={file_post_body_and_delimiter[1]}" 

        inbound_mle_status = "false"
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, inbound_mle_status, "delete_merchant_defined_fields_definitions,delete_merchant_defined_fields_definitions_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/invoicing/v2/{referenceType}/merchantDefinedFields/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_merchant_defined_fields_definitions(self, reference_type, **kwargs):
        """
        Get all merchant defined fields for a given reference type
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_merchant_defined_fields_definitions(reference_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str reference_type: The reference type for which merchant defined fields are to be fetched. Available values are Invoice, Purchase, Donation (required)
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        self.logger.info("CALL TO METHOD `get_merchant_defined_fields_definitions` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_merchant_defined_fields_definitions_with_http_info(reference_type, **kwargs)
        else:
            (data) = self.get_merchant_defined_fields_definitions_with_http_info(reference_type, **kwargs)
            return data

    def get_merchant_defined_fields_definitions_with_http_info(self, reference_type, **kwargs):
        """
        Get all merchant defined fields for a given reference type
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_merchant_defined_fields_definitions_with_http_info(reference_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str reference_type: The reference type for which merchant defined fields are to be fetched. Available values are Invoice, Purchase, Donation (required)
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reference_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_merchant_defined_fields_definitions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reference_type' is set
        if ('reference_type' not in params) or (params['reference_type'] is None):
            self.logger.error("InvalidArgumentException : Missing the required parameter `reference_type` when calling `get_merchant_defined_fields_definitions`")
            raise ValueError("Missing the required parameter `reference_type` when calling `get_merchant_defined_fields_definitions`")


        collection_formats = {}

        path_params = {}
        if 'reference_type' in params:
            path_params['referenceType'] = params['reference_type']
            referenceType=reference_type

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])

        body_params = None
        if 'GET' in ('POST'):
            body_params = '{}'
        
        file_post_body_and_delimiter = MultipartHelpers.build_post_body_for_files(local_var_files)
        if file_post_body_and_delimiter is not None:
            body_params = file_post_body_and_delimiter[0]
            header_params['Content-Type'] = f"multipart/form-data; boundary={file_post_body_and_delimiter[1]}" 

        inbound_mle_status = "false"
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, inbound_mle_status, "get_merchant_defined_fields_definitions,get_merchant_defined_fields_definitions_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/invoicing/v2/{referenceType}/merchantDefinedFields', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[InlineResponse2003]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put_merchant_defined_fields_definitions(self, reference_type, id, merchant_defined_field_core, **kwargs):
        """
        Update a MerchantDefinedField by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_merchant_defined_fields_definitions(reference_type, id, merchant_defined_field_core, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str reference_type: (required)
        :param int id: (required)
        :param MerchantDefinedFieldCore merchant_defined_field_core: (required)
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        self.logger.info("CALL TO METHOD `put_merchant_defined_fields_definitions` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_merchant_defined_fields_definitions_with_http_info(reference_type, id, merchant_defined_field_core, **kwargs)
        else:
            (data) = self.put_merchant_defined_fields_definitions_with_http_info(reference_type, id, merchant_defined_field_core, **kwargs)
            return data

    def put_merchant_defined_fields_definitions_with_http_info(self, reference_type, id, merchant_defined_field_core, **kwargs):
        """
        Update a MerchantDefinedField by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_merchant_defined_fields_definitions_with_http_info(reference_type, id, merchant_defined_field_core, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str reference_type: (required)
        :param int id: (required)
        :param MerchantDefinedFieldCore merchant_defined_field_core: (required)
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reference_type', 'id', 'merchant_defined_field_core']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_merchant_defined_fields_definitions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reference_type' is set
        if ('reference_type' not in params) or (params['reference_type'] is None):
            self.logger.error("InvalidArgumentException : Missing the required parameter `reference_type` when calling `put_merchant_defined_fields_definitions`")
            raise ValueError("Missing the required parameter `reference_type` when calling `put_merchant_defined_fields_definitions`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            self.logger.error("InvalidArgumentException : Missing the required parameter `id` when calling `put_merchant_defined_fields_definitions`")
            raise ValueError("Missing the required parameter `id` when calling `put_merchant_defined_fields_definitions`")
        # verify the required parameter 'merchant_defined_field_core' is set
        if ('merchant_defined_field_core' not in params) or (params['merchant_defined_field_core'] is None):
            self.logger.error("InvalidArgumentException : Missing the required parameter `merchant_defined_field_core` when calling `put_merchant_defined_fields_definitions`")
            raise ValueError("Missing the required parameter `merchant_defined_field_core` when calling `put_merchant_defined_fields_definitions`")


        collection_formats = {}

        path_params = {}
        if 'reference_type' in params:
            path_params['referenceType'] = params['reference_type']
            referenceType=reference_type
        if 'id' in params:
            path_params['id'] = params['id']
            id=id

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/hal+json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json;charset=utf-8'])

        body_params = None
        if 'merchant_defined_field_core' in params:
            body_params = params['merchant_defined_field_core']
        
            sdkTracker = SdkTracker()
            body_params = sdkTracker.insert_developer_id_tracker(body_params, 'merchant_defined_field_core', self.api_client.mconfig.run_environment, self.api_client.mconfig.defaultDeveloperId)
            body_params = process_body(body_params)

        inbound_mle_status = "false"
        if MLEUtility.check_is_mle_for_api(self.api_client.mconfig, inbound_mle_status, "put_merchant_defined_fields_definitions,put_merchant_defined_fields_definitions_with_http_info"):
                body_params = MLEUtility.encrypt_request_payload(self.api_client.mconfig, body_params)
        
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/invoicing/v2/{referenceType}/merchantDefinedFields/{id}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[InlineResponse2003]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
