# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class CardProcessingConfigCommonAcquirers(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'institution_id': 'str',
        'interbank_card_association_id': 'str',
        'discover_institution_id': 'str',
        'country_code': 'str',
        'file_destination_bin': 'str',
        'merchant_verification_value': 'str',
        'merchant_id': 'str',
        'terminal_id': 'str',
        'allow_multiple_bills': 'bool',
        'enable_transaction_reference_number': 'bool',
        'payment_types': 'dict(str, CardProcessingConfigCommonPaymentTypes)',
        'currencies': 'dict(str, CardProcessingConfigCommonCurrencies)'
    }

    attribute_map = {
        'institution_id': 'institutionId',
        'interbank_card_association_id': 'interbankCardAssociationId',
        'discover_institution_id': 'discoverInstitutionId',
        'country_code': 'countryCode',
        'file_destination_bin': 'fileDestinationBin',
        'merchant_verification_value': 'merchantVerificationValue',
        'merchant_id': 'merchantId',
        'terminal_id': 'terminalId',
        'allow_multiple_bills': 'allowMultipleBills',
        'enable_transaction_reference_number': 'enableTransactionReferenceNumber',
        'payment_types': 'paymentTypes',
        'currencies': 'currencies'
    }

    def __init__(self, institution_id=None, interbank_card_association_id=None, discover_institution_id=None, country_code=None, file_destination_bin=None, merchant_verification_value=None, merchant_id=None, terminal_id=None, allow_multiple_bills=None, enable_transaction_reference_number=None, payment_types=None, currencies=None):
        """
        CardProcessingConfigCommonAcquirers - a model defined in Swagger
        """

        self._institution_id = None
        self._interbank_card_association_id = None
        self._discover_institution_id = None
        self._country_code = None
        self._file_destination_bin = None
        self._merchant_verification_value = None
        self._merchant_id = None
        self._terminal_id = None
        self._allow_multiple_bills = None
        self._enable_transaction_reference_number = None
        self._payment_types = None
        self._currencies = None

        if institution_id is not None:
          self.institution_id = institution_id
        if interbank_card_association_id is not None:
          self.interbank_card_association_id = interbank_card_association_id
        if discover_institution_id is not None:
          self.discover_institution_id = discover_institution_id
        if country_code is not None:
          self.country_code = country_code
        if file_destination_bin is not None:
          self.file_destination_bin = file_destination_bin
        if merchant_verification_value is not None:
          self.merchant_verification_value = merchant_verification_value
        if merchant_id is not None:
          self.merchant_id = merchant_id
        if terminal_id is not None:
          self.terminal_id = terminal_id
        if allow_multiple_bills is not None:
          self.allow_multiple_bills = allow_multiple_bills
        if enable_transaction_reference_number is not None:
          self.enable_transaction_reference_number = enable_transaction_reference_number
        if payment_types is not None:
          self.payment_types = payment_types
        if currencies is not None:
          self.currencies = currencies

    @property
    def institution_id(self):
        """
        Gets the institution_id of this CardProcessingConfigCommonAcquirers.
        Identifier of the acquirer. This number is usually assigned by Visa.

        :return: The institution_id of this CardProcessingConfigCommonAcquirers.
        :rtype: str
        """
        return self._institution_id

    @institution_id.setter
    def institution_id(self, institution_id):
        """
        Sets the institution_id of this CardProcessingConfigCommonAcquirers.
        Identifier of the acquirer. This number is usually assigned by Visa.

        :param institution_id: The institution_id of this CardProcessingConfigCommonAcquirers.
        :type: str
        """

        self._institution_id = institution_id

    @property
    def interbank_card_association_id(self):
        """
        Gets the interbank_card_association_id of this CardProcessingConfigCommonAcquirers.
        Number assigned by MasterCard to banks to identify the member in transactions.

        :return: The interbank_card_association_id of this CardProcessingConfigCommonAcquirers.
        :rtype: str
        """
        return self._interbank_card_association_id

    @interbank_card_association_id.setter
    def interbank_card_association_id(self, interbank_card_association_id):
        """
        Sets the interbank_card_association_id of this CardProcessingConfigCommonAcquirers.
        Number assigned by MasterCard to banks to identify the member in transactions.

        :param interbank_card_association_id: The interbank_card_association_id of this CardProcessingConfigCommonAcquirers.
        :type: str
        """

        self._interbank_card_association_id = interbank_card_association_id

    @property
    def discover_institution_id(self):
        """
        Gets the discover_institution_id of this CardProcessingConfigCommonAcquirers.
        Assigned by Discover to identify the acquirer.

        :return: The discover_institution_id of this CardProcessingConfigCommonAcquirers.
        :rtype: str
        """
        return self._discover_institution_id

    @discover_institution_id.setter
    def discover_institution_id(self, discover_institution_id):
        """
        Sets the discover_institution_id of this CardProcessingConfigCommonAcquirers.
        Assigned by Discover to identify the acquirer.

        :param discover_institution_id: The discover_institution_id of this CardProcessingConfigCommonAcquirers.
        :type: str
        """

        self._discover_institution_id = discover_institution_id

    @property
    def country_code(self):
        """
        Gets the country_code of this CardProcessingConfigCommonAcquirers.
        ISO 4217 format.

        :return: The country_code of this CardProcessingConfigCommonAcquirers.
        :rtype: str
        """
        return self._country_code

    @country_code.setter
    def country_code(self, country_code):
        """
        Sets the country_code of this CardProcessingConfigCommonAcquirers.
        ISO 4217 format.

        :param country_code: The country_code of this CardProcessingConfigCommonAcquirers.
        :type: str
        """

        self._country_code = country_code

    @property
    def file_destination_bin(self):
        """
        Gets the file_destination_bin of this CardProcessingConfigCommonAcquirers.
        The BIN to which this capturefile is sent. This field must contain a valid BIN.

        :return: The file_destination_bin of this CardProcessingConfigCommonAcquirers.
        :rtype: str
        """
        return self._file_destination_bin

    @file_destination_bin.setter
    def file_destination_bin(self, file_destination_bin):
        """
        Sets the file_destination_bin of this CardProcessingConfigCommonAcquirers.
        The BIN to which this capturefile is sent. This field must contain a valid BIN.

        :param file_destination_bin: The file_destination_bin of this CardProcessingConfigCommonAcquirers.
        :type: str
        """

        self._file_destination_bin = file_destination_bin

    @property
    def merchant_verification_value(self):
        """
        Gets the merchant_verification_value of this CardProcessingConfigCommonAcquirers.
        Identify merchants that participate in Select Merchant Fee (SMF) programs. Unique to the merchant.

        :return: The merchant_verification_value of this CardProcessingConfigCommonAcquirers.
        :rtype: str
        """
        return self._merchant_verification_value

    @merchant_verification_value.setter
    def merchant_verification_value(self, merchant_verification_value):
        """
        Sets the merchant_verification_value of this CardProcessingConfigCommonAcquirers.
        Identify merchants that participate in Select Merchant Fee (SMF) programs. Unique to the merchant.

        :param merchant_verification_value: The merchant_verification_value of this CardProcessingConfigCommonAcquirers.
        :type: str
        """

        self._merchant_verification_value = merchant_verification_value

    @property
    def merchant_id(self):
        """
        Gets the merchant_id of this CardProcessingConfigCommonAcquirers.
        Merchant ID assigned by an acquirer or a processor. Should not be overriden by any other party.

        :return: The merchant_id of this CardProcessingConfigCommonAcquirers.
        :rtype: str
        """
        return self._merchant_id

    @merchant_id.setter
    def merchant_id(self, merchant_id):
        """
        Sets the merchant_id of this CardProcessingConfigCommonAcquirers.
        Merchant ID assigned by an acquirer or a processor. Should not be overriden by any other party.

        :param merchant_id: The merchant_id of this CardProcessingConfigCommonAcquirers.
        :type: str
        """

        self._merchant_id = merchant_id

    @property
    def terminal_id(self):
        """
        Gets the terminal_id of this CardProcessingConfigCommonAcquirers.
        The 'Terminal Id' aka TID, is an identifier used for with your payments processor. Depending on the processor and payment acceptance type this may also be the default Terminal ID used for Card Present and Virtual Terminal transactions. 

        :return: The terminal_id of this CardProcessingConfigCommonAcquirers.
        :rtype: str
        """
        return self._terminal_id

    @terminal_id.setter
    def terminal_id(self, terminal_id):
        """
        Sets the terminal_id of this CardProcessingConfigCommonAcquirers.
        The 'Terminal Id' aka TID, is an identifier used for with your payments processor. Depending on the processor and payment acceptance type this may also be the default Terminal ID used for Card Present and Virtual Terminal transactions. 

        :param terminal_id: The terminal_id of this CardProcessingConfigCommonAcquirers.
        :type: str
        """

        self._terminal_id = terminal_id

    @property
    def allow_multiple_bills(self):
        """
        Gets the allow_multiple_bills of this CardProcessingConfigCommonAcquirers.
        Allows multiple captures for a single authorization transaction. 

        :return: The allow_multiple_bills of this CardProcessingConfigCommonAcquirers.
        :rtype: bool
        """
        return self._allow_multiple_bills

    @allow_multiple_bills.setter
    def allow_multiple_bills(self, allow_multiple_bills):
        """
        Sets the allow_multiple_bills of this CardProcessingConfigCommonAcquirers.
        Allows multiple captures for a single authorization transaction. 

        :param allow_multiple_bills: The allow_multiple_bills of this CardProcessingConfigCommonAcquirers.
        :type: bool
        """

        self._allow_multiple_bills = allow_multiple_bills

    @property
    def enable_transaction_reference_number(self):
        """
        Gets the enable_transaction_reference_number of this CardProcessingConfigCommonAcquirers.
        To enable merchant to send in transaction reference number (unique reconciliation ID).

        :return: The enable_transaction_reference_number of this CardProcessingConfigCommonAcquirers.
        :rtype: bool
        """
        return self._enable_transaction_reference_number

    @enable_transaction_reference_number.setter
    def enable_transaction_reference_number(self, enable_transaction_reference_number):
        """
        Sets the enable_transaction_reference_number of this CardProcessingConfigCommonAcquirers.
        To enable merchant to send in transaction reference number (unique reconciliation ID).

        :param enable_transaction_reference_number: The enable_transaction_reference_number of this CardProcessingConfigCommonAcquirers.
        :type: bool
        """

        self._enable_transaction_reference_number = enable_transaction_reference_number

    @property
    def payment_types(self):
        """
        Gets the payment_types of this CardProcessingConfigCommonAcquirers.
        Valid values are: * VISA * MASTERCARD * AMERICAN_EXPRESS * CUP * EFTPOS * DINERS_CLUB * DISCOVER * JCB 

        :return: The payment_types of this CardProcessingConfigCommonAcquirers.
        :rtype: dict(str, CardProcessingConfigCommonPaymentTypes)
        """
        return self._payment_types

    @payment_types.setter
    def payment_types(self, payment_types):
        """
        Sets the payment_types of this CardProcessingConfigCommonAcquirers.
        Valid values are: * VISA * MASTERCARD * AMERICAN_EXPRESS * CUP * EFTPOS * DINERS_CLUB * DISCOVER * JCB 

        :param payment_types: The payment_types of this CardProcessingConfigCommonAcquirers.
        :type: dict(str, CardProcessingConfigCommonPaymentTypes)
        """

        self._payment_types = payment_types

    @property
    def currencies(self):
        """
        Gets the currencies of this CardProcessingConfigCommonAcquirers.
        Three-character [ISO 4217 ALPHA-3 Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf)

        :return: The currencies of this CardProcessingConfigCommonAcquirers.
        :rtype: dict(str, CardProcessingConfigCommonCurrencies)
        """
        return self._currencies

    @currencies.setter
    def currencies(self, currencies):
        """
        Sets the currencies of this CardProcessingConfigCommonAcquirers.
        Three-character [ISO 4217 ALPHA-3 Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf)

        :param currencies: The currencies of this CardProcessingConfigCommonAcquirers.
        :type: dict(str, CardProcessingConfigCommonCurrencies)
        """

        self._currencies = currencies

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CardProcessingConfigCommonAcquirers):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
