# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class InlineResponse2018OrderInformationCurrencyConversionOffer(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'original_amount': 'str',
        'original_currency': 'str',
        'amount': 'str',
        'currency': 'str',
        'exchange_rate': 'str',
        'exchange_rate_inverted': 'bool',
        'margin_rate': 'str',
        'rate_source': 'str',
        'exchange_rate_time_utc': 'str',
        'exchange_rate_expiration_time_utc': 'str',
        'rate_id': 'str'
    }

    attribute_map = {
        'original_amount': 'originalAmount',
        'original_currency': 'originalCurrency',
        'amount': 'amount',
        'currency': 'currency',
        'exchange_rate': 'exchangeRate',
        'exchange_rate_inverted': 'exchangeRateInverted',
        'margin_rate': 'marginRate',
        'rate_source': 'rateSource',
        'exchange_rate_time_utc': 'exchangeRateTimeUtc',
        'exchange_rate_expiration_time_utc': 'exchangeRateExpirationTimeUtc',
        'rate_id': 'rateId'
    }

    def __init__(self, original_amount=None, original_currency=None, amount=None, currency=None, exchange_rate=None, exchange_rate_inverted=None, margin_rate=None, rate_source=None, exchange_rate_time_utc=None, exchange_rate_expiration_time_utc=None, rate_id=None):
        """
        InlineResponse2018OrderInformationCurrencyConversionOffer - a model defined in Swagger
        """

        self._original_amount = None
        self._original_currency = None
        self._amount = None
        self._currency = None
        self._exchange_rate = None
        self._exchange_rate_inverted = None
        self._margin_rate = None
        self._rate_source = None
        self._exchange_rate_time_utc = None
        self._exchange_rate_expiration_time_utc = None
        self._rate_id = None

        if original_amount is not None:
          self.original_amount = original_amount
        if original_currency is not None:
          self.original_currency = original_currency
        if amount is not None:
          self.amount = amount
        if currency is not None:
          self.currency = currency
        if exchange_rate is not None:
          self.exchange_rate = exchange_rate
        if exchange_rate_inverted is not None:
          self.exchange_rate_inverted = exchange_rate_inverted
        if margin_rate is not None:
          self.margin_rate = margin_rate
        if rate_source is not None:
          self.rate_source = rate_source
        if exchange_rate_time_utc is not None:
          self.exchange_rate_time_utc = exchange_rate_time_utc
        if exchange_rate_expiration_time_utc is not None:
          self.exchange_rate_expiration_time_utc = exchange_rate_expiration_time_utc
        if rate_id is not None:
          self.rate_id = rate_id

    @property
    def original_amount(self):
        """
        Gets the original_amount of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The amount of the sale in the merchant's currency.  For DCC this should be the same value as the request. For MCP will be 1 major unit of the merchant's base currency. 

        :return: The original_amount of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :rtype: str
        """
        return self._original_amount

    @original_amount.setter
    def original_amount(self, original_amount):
        """
        Sets the original_amount of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The amount of the sale in the merchant's currency.  For DCC this should be the same value as the request. For MCP will be 1 major unit of the merchant's base currency. 

        :param original_amount: The original_amount of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :type: str
        """

        self._original_amount = original_amount

    @property
    def original_currency(self):
        """
        Gets the original_currency of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        Currency of the transaction in the merchant's currency.  For DCC this should be the same value as the request.  For MCP will be the merchant's base currency as configured on the currency conversion provider's system. Use three-character alphabetic [ISO 4271 Currency Codes.](https://developer.cybersource.com/docs/cybs/en-us/currency-codes/reference/all/na/currency-codes/currency-codes.html) 

        :return: The original_currency of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :rtype: str
        """
        return self._original_currency

    @original_currency.setter
    def original_currency(self, original_currency):
        """
        Sets the original_currency of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        Currency of the transaction in the merchant's currency.  For DCC this should be the same value as the request.  For MCP will be the merchant's base currency as configured on the currency conversion provider's system. Use three-character alphabetic [ISO 4271 Currency Codes.](https://developer.cybersource.com/docs/cybs/en-us/currency-codes/reference/all/na/currency-codes/currency-codes.html) 

        :param original_currency: The original_currency of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :type: str
        """

        self._original_currency = original_currency

    @property
    def amount(self):
        """
        Gets the amount of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The offer amount, calculated using the originalAmount and the exchangeRate. For DCC this is the amount in the card issuer's currency. 

        :return: The amount of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """
        Sets the amount of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The offer amount, calculated using the originalAmount and the exchangeRate. For DCC this is the amount in the card issuer's currency. 

        :param amount: The amount of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :type: str
        """

        self._amount = amount

    @property
    def currency(self):
        """
        Gets the currency of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        Currency of the offer. For DCC this is the card's issuers currency. Use three-character alphabetic  [ISO 4271 Currency Codes.](https://developer.cybersource.com/docs/cybs/en-us/currency-codes/reference/all/na/currency-codes/currency-codes.html) 

        :return: The currency of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        Currency of the offer. For DCC this is the card's issuers currency. Use three-character alphabetic  [ISO 4271 Currency Codes.](https://developer.cybersource.com/docs/cybs/en-us/currency-codes/reference/all/na/currency-codes/currency-codes.html) 

        :param currency: The currency of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :type: str
        """

        self._currency = currency

    @property
    def exchange_rate(self):
        """
        Gets the exchange_rate of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The exchange rate of the offer from 1 major unit of the sale currency including margin. This will be printed on the receipt. For example, if a USD consumer is purchasing in EUR, this field should return the amount of 1 EUR in USD including mark-up. The receipt will contain the following: `EUR 1.00 = USD 1.09998900010999` - where 1.09998900010999 is the value returned in this field. 

        :return: The exchange_rate of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :rtype: str
        """
        return self._exchange_rate

    @exchange_rate.setter
    def exchange_rate(self, exchange_rate):
        """
        Sets the exchange_rate of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The exchange rate of the offer from 1 major unit of the sale currency including margin. This will be printed on the receipt. For example, if a USD consumer is purchasing in EUR, this field should return the amount of 1 EUR in USD including mark-up. The receipt will contain the following: `EUR 1.00 = USD 1.09998900010999` - where 1.09998900010999 is the value returned in this field. 

        :param exchange_rate: The exchange_rate of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :type: str
        """

        self._exchange_rate = exchange_rate

    @property
    def exchange_rate_inverted(self):
        """
        Gets the exchange_rate_inverted of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        An inverted exchange rate is the base currency amount divided by the converted currency amount. Ex. If a USD customer is purchasing in EUR, this field should return the value of USD divided by EUR. 

        :return: The exchange_rate_inverted of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :rtype: bool
        """
        return self._exchange_rate_inverted

    @exchange_rate_inverted.setter
    def exchange_rate_inverted(self, exchange_rate_inverted):
        """
        Sets the exchange_rate_inverted of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        An inverted exchange rate is the base currency amount divided by the converted currency amount. Ex. If a USD customer is purchasing in EUR, this field should return the value of USD divided by EUR. 

        :param exchange_rate_inverted: The exchange_rate_inverted of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :type: bool
        """

        self._exchange_rate_inverted = exchange_rate_inverted

    @property
    def margin_rate(self):
        """
        Gets the margin_rate of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The margin between the offer exchange rate and wholesale rates, i.e. the mark up. Expressed as a percentage of 100, e.g. 3.75 

        :return: The margin_rate of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :rtype: str
        """
        return self._margin_rate

    @margin_rate.setter
    def margin_rate(self, margin_rate):
        """
        Sets the margin_rate of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The margin between the offer exchange rate and wholesale rates, i.e. the mark up. Expressed as a percentage of 100, e.g. 3.75 

        :param margin_rate: The margin_rate of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :type: str
        """

        self._margin_rate = margin_rate

    @property
    def rate_source(self):
        """
        Gets the rate_source of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The source of the rate (excluding mark up). Optional field. 

        :return: The rate_source of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :rtype: str
        """
        return self._rate_source

    @rate_source.setter
    def rate_source(self, rate_source):
        """
        Sets the rate_source of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The source of the rate (excluding mark up). Optional field. 

        :param rate_source: The rate_source of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :type: str
        """

        self._rate_source = rate_source

    @property
    def exchange_rate_time_utc(self):
        """
        Gets the exchange_rate_time_utc of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The date and time of exchange rate in UTC. Format: `YYYY-MM-DDThh:mm:ssZ` **Example** `2023-05-17T23:47:57Z` equals May 17, 2023, at 23:47:57 (11:47:57 PM). The `T` separates the date and the time. The `Z` indicates UTC. 

        :return: The exchange_rate_time_utc of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :rtype: str
        """
        return self._exchange_rate_time_utc

    @exchange_rate_time_utc.setter
    def exchange_rate_time_utc(self, exchange_rate_time_utc):
        """
        Sets the exchange_rate_time_utc of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The date and time of exchange rate in UTC. Format: `YYYY-MM-DDThh:mm:ssZ` **Example** `2023-05-17T23:47:57Z` equals May 17, 2023, at 23:47:57 (11:47:57 PM). The `T` separates the date and the time. The `Z` indicates UTC. 

        :param exchange_rate_time_utc: The exchange_rate_time_utc of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :type: str
        """

        self._exchange_rate_time_utc = exchange_rate_time_utc

    @property
    def exchange_rate_expiration_time_utc(self):
        """
        Gets the exchange_rate_expiration_time_utc of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The expiration time of the exchange rate in UTC. Format: `YYYY-MM-DDThh:mm:ssZ` 

        :return: The exchange_rate_expiration_time_utc of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :rtype: str
        """
        return self._exchange_rate_expiration_time_utc

    @exchange_rate_expiration_time_utc.setter
    def exchange_rate_expiration_time_utc(self, exchange_rate_expiration_time_utc):
        """
        Sets the exchange_rate_expiration_time_utc of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        The expiration time of the exchange rate in UTC. Format: `YYYY-MM-DDThh:mm:ssZ` 

        :param exchange_rate_expiration_time_utc: The exchange_rate_expiration_time_utc of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :type: str
        """

        self._exchange_rate_expiration_time_utc = exchange_rate_expiration_time_utc

    @property
    def rate_id(self):
        """
        Gets the rate_id of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        A unique MCP rate identifier. 

        :return: The rate_id of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :rtype: str
        """
        return self._rate_id

    @rate_id.setter
    def rate_id(self, rate_id):
        """
        Sets the rate_id of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        A unique MCP rate identifier. 

        :param rate_id: The rate_id of this InlineResponse2018OrderInformationCurrencyConversionOffer.
        :type: str
        """

        self._rate_id = rate_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, InlineResponse2018OrderInformationCurrencyConversionOffer):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
