# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class PostPaymentCredentialsRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'payment_credential_type': 'str',
        'transaction_type': 'str',
        'client_correlation_id': 'str',
        'order_information': 'Tmsv2tokenstokenIdpaymentcredentialsOrderInformation',
        'merchant_information': 'Tmsv2tokenstokenIdpaymentcredentialsMerchantInformation',
        'device_information': 'Tmsv2tokenstokenIdpaymentcredentialsDeviceInformation',
        'authenticated_identities': 'list[Tmsv2tokenstokenIdpaymentcredentialsAuthenticatedIdentities]'
    }

    attribute_map = {
        'payment_credential_type': 'paymentCredentialType',
        'transaction_type': 'transactionType',
        'client_correlation_id': 'clientCorrelationId',
        'order_information': 'orderInformation',
        'merchant_information': 'merchantInformation',
        'device_information': 'deviceInformation',
        'authenticated_identities': 'authenticatedIdentities'
    }

    def __init__(self, payment_credential_type=None, transaction_type=None, client_correlation_id=None, order_information=None, merchant_information=None, device_information=None, authenticated_identities=None):
        """
        PostPaymentCredentialsRequest - a model defined in Swagger
        """

        self._payment_credential_type = None
        self._transaction_type = None
        self._client_correlation_id = None
        self._order_information = None
        self._merchant_information = None
        self._device_information = None
        self._authenticated_identities = None

        if payment_credential_type is not None:
          self.payment_credential_type = payment_credential_type
        if transaction_type is not None:
          self.transaction_type = transaction_type
        if client_correlation_id is not None:
          self.client_correlation_id = client_correlation_id
        if order_information is not None:
          self.order_information = order_information
        if merchant_information is not None:
          self.merchant_information = merchant_information
        if device_information is not None:
          self.device_information = device_information
        if authenticated_identities is not None:
          self.authenticated_identities = authenticated_identities

    @property
    def payment_credential_type(self):
        """
        Gets the payment_credential_type of this PostPaymentCredentialsRequest.
        The type of payment credentials to be returned. By default, payment credentials include network token and cryptogram or dynamic CVV. If \"NETWORK_TOKEN\" is supplied then only network token card number will be returned and no cryptogram or dynamic CVV will be requested. If \"SECURITY_CODE\" is supplied then dynamic CVV will be requested and returned with the network token card number. Dynamic CVV is only supported for Amex and SCOF. If \"CRYPTOGRAM\" is supplied then cryptogram will be requested and returned with the network token card number. Cryptogram is NOT supported for Amex.  Possible Values:   - NETWORK_TOKEN   - SECURITY_CODE   - CRYPTOGRAM 

        :return: The payment_credential_type of this PostPaymentCredentialsRequest.
        :rtype: str
        """
        return self._payment_credential_type

    @payment_credential_type.setter
    def payment_credential_type(self, payment_credential_type):
        """
        Sets the payment_credential_type of this PostPaymentCredentialsRequest.
        The type of payment credentials to be returned. By default, payment credentials include network token and cryptogram or dynamic CVV. If \"NETWORK_TOKEN\" is supplied then only network token card number will be returned and no cryptogram or dynamic CVV will be requested. If \"SECURITY_CODE\" is supplied then dynamic CVV will be requested and returned with the network token card number. Dynamic CVV is only supported for Amex and SCOF. If \"CRYPTOGRAM\" is supplied then cryptogram will be requested and returned with the network token card number. Cryptogram is NOT supported for Amex.  Possible Values:   - NETWORK_TOKEN   - SECURITY_CODE   - CRYPTOGRAM 

        :param payment_credential_type: The payment_credential_type of this PostPaymentCredentialsRequest.
        :type: str
        """

        self._payment_credential_type = payment_credential_type

    @property
    def transaction_type(self):
        """
        Gets the transaction_type of this PostPaymentCredentialsRequest.
        Specifies the type of transaction for which the network token credentials are required. Possible Values:   - ECOM: Ecommerce transaction. If transactionType is not provided, ECOM is set as the default.   - AFT: Account Funding Transaction. This is only supported for VISA and paymentCredentialType of CRYPTOGRAM. 

        :return: The transaction_type of this PostPaymentCredentialsRequest.
        :rtype: str
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """
        Sets the transaction_type of this PostPaymentCredentialsRequest.
        Specifies the type of transaction for which the network token credentials are required. Possible Values:   - ECOM: Ecommerce transaction. If transactionType is not provided, ECOM is set as the default.   - AFT: Account Funding Transaction. This is only supported for VISA and paymentCredentialType of CRYPTOGRAM. 

        :param transaction_type: The transaction_type of this PostPaymentCredentialsRequest.
        :type: str
        """

        self._transaction_type = transaction_type

    @property
    def client_correlation_id(self):
        """
        Gets the client_correlation_id of this PostPaymentCredentialsRequest.
        Used to correlate authentication and payment credential requests. 

        :return: The client_correlation_id of this PostPaymentCredentialsRequest.
        :rtype: str
        """
        return self._client_correlation_id

    @client_correlation_id.setter
    def client_correlation_id(self, client_correlation_id):
        """
        Sets the client_correlation_id of this PostPaymentCredentialsRequest.
        Used to correlate authentication and payment credential requests. 

        :param client_correlation_id: The client_correlation_id of this PostPaymentCredentialsRequest.
        :type: str
        """

        self._client_correlation_id = client_correlation_id

    @property
    def order_information(self):
        """
        Gets the order_information of this PostPaymentCredentialsRequest.

        :return: The order_information of this PostPaymentCredentialsRequest.
        :rtype: Tmsv2tokenstokenIdpaymentcredentialsOrderInformation
        """
        return self._order_information

    @order_information.setter
    def order_information(self, order_information):
        """
        Sets the order_information of this PostPaymentCredentialsRequest.

        :param order_information: The order_information of this PostPaymentCredentialsRequest.
        :type: Tmsv2tokenstokenIdpaymentcredentialsOrderInformation
        """

        self._order_information = order_information

    @property
    def merchant_information(self):
        """
        Gets the merchant_information of this PostPaymentCredentialsRequest.

        :return: The merchant_information of this PostPaymentCredentialsRequest.
        :rtype: Tmsv2tokenstokenIdpaymentcredentialsMerchantInformation
        """
        return self._merchant_information

    @merchant_information.setter
    def merchant_information(self, merchant_information):
        """
        Sets the merchant_information of this PostPaymentCredentialsRequest.

        :param merchant_information: The merchant_information of this PostPaymentCredentialsRequest.
        :type: Tmsv2tokenstokenIdpaymentcredentialsMerchantInformation
        """

        self._merchant_information = merchant_information

    @property
    def device_information(self):
        """
        Gets the device_information of this PostPaymentCredentialsRequest.

        :return: The device_information of this PostPaymentCredentialsRequest.
        :rtype: Tmsv2tokenstokenIdpaymentcredentialsDeviceInformation
        """
        return self._device_information

    @device_information.setter
    def device_information(self, device_information):
        """
        Sets the device_information of this PostPaymentCredentialsRequest.

        :param device_information: The device_information of this PostPaymentCredentialsRequest.
        :type: Tmsv2tokenstokenIdpaymentcredentialsDeviceInformation
        """

        self._device_information = device_information

    @property
    def authenticated_identities(self):
        """
        Gets the authenticated_identities of this PostPaymentCredentialsRequest.

        :return: The authenticated_identities of this PostPaymentCredentialsRequest.
        :rtype: list[Tmsv2tokenstokenIdpaymentcredentialsAuthenticatedIdentities]
        """
        return self._authenticated_identities

    @authenticated_identities.setter
    def authenticated_identities(self, authenticated_identities):
        """
        Sets the authenticated_identities of this PostPaymentCredentialsRequest.

        :param authenticated_identities: The authenticated_identities of this PostPaymentCredentialsRequest.
        :type: list[Tmsv2tokenstokenIdpaymentcredentialsAuthenticatedIdentities]
        """

        self._authenticated_identities = authenticated_identities

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PostPaymentCredentialsRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
