# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class Ptsv2intentsPaymentInformationTokenizedPaymentMethod(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'description': 'str',
        'usage_pattern': 'str',
        'usage_type': 'str',
        'allow_multiple_tokens': 'str'
    }

    attribute_map = {
        'description': 'description',
        'usage_pattern': 'usagePattern',
        'usage_type': 'usageType',
        'allow_multiple_tokens': 'allowMultipleTokens'
    }

    def __init__(self, description=None, usage_pattern=None, usage_type=None, allow_multiple_tokens=None):
        """
        Ptsv2intentsPaymentInformationTokenizedPaymentMethod - a model defined in Swagger
        """

        self._description = None
        self._usage_pattern = None
        self._usage_type = None
        self._allow_multiple_tokens = None

        if description is not None:
          self.description = description
        if usage_pattern is not None:
          self.usage_pattern = usage_pattern
        if usage_type is not None:
          self.usage_type = usage_type
        if allow_multiple_tokens is not None:
          self.allow_multiple_tokens = allow_multiple_tokens

    @property
    def description(self):
        """
        Gets the description of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        Description of the vaulted payment method shown to the buyer during checkout and in their PayPal account. 

        :return: The description of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        Description of the vaulted payment method shown to the buyer during checkout and in their PayPal account. 

        :param description: The description of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        :type: str
        """

        self._description = description

    @property
    def usage_pattern(self):
        """
        Gets the usage_pattern of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        Indicates how the merchant will primarily use the vaulted payment method. Valid values: - \"IMMEDIATE\": For on-demand, instant payments. These payments are variable in both amount and frequency and will be used to pay for goods or services before they are rendered to the buyer - \"DEFERRED\": For post-pay payments; that is, payments for goods or services that have already been rendered to the buyer - \"RECURRING_PREPAID\": For recurring payments before services are rendered. - \"RECURRING_POSTPAID\": For recurring payments after services are rendered. - \"THRESHOLD_PREPAID\": For payments when a pre-defined threshold is reached before services are rendered. - \"THRESHOLD_POSTPAID\": For payments when a pre-defined threshold is reached after services are rendered. 

        :return: The usage_pattern of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        :rtype: str
        """
        return self._usage_pattern

    @usage_pattern.setter
    def usage_pattern(self, usage_pattern):
        """
        Sets the usage_pattern of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        Indicates how the merchant will primarily use the vaulted payment method. Valid values: - \"IMMEDIATE\": For on-demand, instant payments. These payments are variable in both amount and frequency and will be used to pay for goods or services before they are rendered to the buyer - \"DEFERRED\": For post-pay payments; that is, payments for goods or services that have already been rendered to the buyer - \"RECURRING_PREPAID\": For recurring payments before services are rendered. - \"RECURRING_POSTPAID\": For recurring payments after services are rendered. - \"THRESHOLD_PREPAID\": For payments when a pre-defined threshold is reached before services are rendered. - \"THRESHOLD_POSTPAID\": For payments when a pre-defined threshold is reached after services are rendered. 

        :param usage_pattern: The usage_pattern of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        :type: str
        """

        self._usage_pattern = usage_pattern

    @property
    def usage_type(self):
        """
        Gets the usage_type of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        Indicates the type of vaulting relationship. Valid values: - \"MERCHANT\": Single merchant relationship. - \"PLATFORM\": Platform hosting multiple merchants. 

        :return: The usage_type of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        :rtype: str
        """
        return self._usage_type

    @usage_type.setter
    def usage_type(self, usage_type):
        """
        Sets the usage_type of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        Indicates the type of vaulting relationship. Valid values: - \"MERCHANT\": Single merchant relationship. - \"PLATFORM\": Platform hosting multiple merchants. 

        :param usage_type: The usage_type of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        :type: str
        """

        self._usage_type = usage_type

    @property
    def allow_multiple_tokens(self):
        """
        Gets the allow_multiple_tokens of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        Create multiple payment tokens for the same payer, merchant/platform combination. This helps to identify customers distinctly even though they may share the same PayPal account. 

        :return: The allow_multiple_tokens of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        :rtype: str
        """
        return self._allow_multiple_tokens

    @allow_multiple_tokens.setter
    def allow_multiple_tokens(self, allow_multiple_tokens):
        """
        Sets the allow_multiple_tokens of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        Create multiple payment tokens for the same payer, merchant/platform combination. This helps to identify customers distinctly even though they may share the same PayPal account. 

        :param allow_multiple_tokens: The allow_multiple_tokens of this Ptsv2intentsPaymentInformationTokenizedPaymentMethod.
        :type: str
        """

        self._allow_multiple_tokens = allow_multiple_tokens

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Ptsv2intentsPaymentInformationTokenizedPaymentMethod):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
