# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from pprint import pformat
from six import iteritems
import re


class Tmsv2tokenizeTokenInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'jti': 'str',
        'transient_token_jwt': 'str',
        'customer': 'Tmsv2tokenizeTokenInformationCustomer',
        'shipping_address': 'Tmsv2tokenizeTokenInformationCustomerEmbeddedDefaultShippingAddress',
        'payment_instrument': 'Tmsv2tokenizeTokenInformationCustomerEmbeddedDefaultPaymentInstrument',
        'instrument_identifier': 'TmsEmbeddedInstrumentIdentifier'
    }

    attribute_map = {
        'jti': 'jti',
        'transient_token_jwt': 'transientTokenJwt',
        'customer': 'customer',
        'shipping_address': 'shippingAddress',
        'payment_instrument': 'paymentInstrument',
        'instrument_identifier': 'instrumentIdentifier'
    }

    def __init__(self, jti=None, transient_token_jwt=None, customer=None, shipping_address=None, payment_instrument=None, instrument_identifier=None):
        """
        Tmsv2tokenizeTokenInformation - a model defined in Swagger
        """

        self._jti = None
        self._transient_token_jwt = None
        self._customer = None
        self._shipping_address = None
        self._payment_instrument = None
        self._instrument_identifier = None

        if jti is not None:
          self.jti = jti
        if transient_token_jwt is not None:
          self.transient_token_jwt = transient_token_jwt
        if customer is not None:
          self.customer = customer
        if shipping_address is not None:
          self.shipping_address = shipping_address
        if payment_instrument is not None:
          self.payment_instrument = payment_instrument
        if instrument_identifier is not None:
          self.instrument_identifier = instrument_identifier

    @property
    def jti(self):
        """
        Gets the jti of this Tmsv2tokenizeTokenInformation.
        TMS Transient Token, 64 hexadecimal id value representing captured payment credentials (including Sensitive Authentication Data, e.g. CVV). 

        :return: The jti of this Tmsv2tokenizeTokenInformation.
        :rtype: str
        """
        return self._jti

    @jti.setter
    def jti(self, jti):
        """
        Sets the jti of this Tmsv2tokenizeTokenInformation.
        TMS Transient Token, 64 hexadecimal id value representing captured payment credentials (including Sensitive Authentication Data, e.g. CVV). 

        :param jti: The jti of this Tmsv2tokenizeTokenInformation.
        :type: str
        """

        self._jti = jti

    @property
    def transient_token_jwt(self):
        """
        Gets the transient_token_jwt of this Tmsv2tokenizeTokenInformation.
        Flex API Transient Token encoded as JWT (JSON Web Token), e.g. Flex microform or Unified Payment checkout result. 

        :return: The transient_token_jwt of this Tmsv2tokenizeTokenInformation.
        :rtype: str
        """
        return self._transient_token_jwt

    @transient_token_jwt.setter
    def transient_token_jwt(self, transient_token_jwt):
        """
        Sets the transient_token_jwt of this Tmsv2tokenizeTokenInformation.
        Flex API Transient Token encoded as JWT (JSON Web Token), e.g. Flex microform or Unified Payment checkout result. 

        :param transient_token_jwt: The transient_token_jwt of this Tmsv2tokenizeTokenInformation.
        :type: str
        """

        self._transient_token_jwt = transient_token_jwt

    @property
    def customer(self):
        """
        Gets the customer of this Tmsv2tokenizeTokenInformation.

        :return: The customer of this Tmsv2tokenizeTokenInformation.
        :rtype: Tmsv2tokenizeTokenInformationCustomer
        """
        return self._customer

    @customer.setter
    def customer(self, customer):
        """
        Sets the customer of this Tmsv2tokenizeTokenInformation.

        :param customer: The customer of this Tmsv2tokenizeTokenInformation.
        :type: Tmsv2tokenizeTokenInformationCustomer
        """

        self._customer = customer

    @property
    def shipping_address(self):
        """
        Gets the shipping_address of this Tmsv2tokenizeTokenInformation.

        :return: The shipping_address of this Tmsv2tokenizeTokenInformation.
        :rtype: Tmsv2tokenizeTokenInformationCustomerEmbeddedDefaultShippingAddress
        """
        return self._shipping_address

    @shipping_address.setter
    def shipping_address(self, shipping_address):
        """
        Sets the shipping_address of this Tmsv2tokenizeTokenInformation.

        :param shipping_address: The shipping_address of this Tmsv2tokenizeTokenInformation.
        :type: Tmsv2tokenizeTokenInformationCustomerEmbeddedDefaultShippingAddress
        """

        self._shipping_address = shipping_address

    @property
    def payment_instrument(self):
        """
        Gets the payment_instrument of this Tmsv2tokenizeTokenInformation.

        :return: The payment_instrument of this Tmsv2tokenizeTokenInformation.
        :rtype: Tmsv2tokenizeTokenInformationCustomerEmbeddedDefaultPaymentInstrument
        """
        return self._payment_instrument

    @payment_instrument.setter
    def payment_instrument(self, payment_instrument):
        """
        Sets the payment_instrument of this Tmsv2tokenizeTokenInformation.

        :param payment_instrument: The payment_instrument of this Tmsv2tokenizeTokenInformation.
        :type: Tmsv2tokenizeTokenInformationCustomerEmbeddedDefaultPaymentInstrument
        """

        self._payment_instrument = payment_instrument

    @property
    def instrument_identifier(self):
        """
        Gets the instrument_identifier of this Tmsv2tokenizeTokenInformation.

        :return: The instrument_identifier of this Tmsv2tokenizeTokenInformation.
        :rtype: TmsEmbeddedInstrumentIdentifier
        """
        return self._instrument_identifier

    @instrument_identifier.setter
    def instrument_identifier(self, instrument_identifier):
        """
        Sets the instrument_identifier of this Tmsv2tokenizeTokenInformation.

        :param instrument_identifier: The instrument_identifier of this Tmsv2tokenizeTokenInformation.
        :type: TmsEmbeddedInstrumentIdentifier
        """

        self._instrument_identifier = instrument_identifier

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Tmsv2tokenizeTokenInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
