# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import io
import json
import ssl
import certifi
import CyberSource.logging.log_factory as LogFactory
import re
import hashlib

# python 2 and python 3 compatibility library
from six import PY3
from six.moves.urllib.parse import urlencode

from .configuration import Configuration

try:
    import urllib3
    from urllib3 import ProxyManager, make_headers
except ImportError:
    raise ImportError('Swagger python client requires urllib3.')



class RESTResponse(io.IOBase):
    def __init__(self, resp):
        self.urllib3_response = resp
        self.status = resp.status
        self.reason = resp.reason
        self.data = resp.data

    def getheaders(self):
        """
        Returns a dictionary of the response headers.
        """
        return self.urllib3_response.getheaders()

    def getheader(self, name, default=None):
        """
        Returns a given response header.
        """
        return self.urllib3_response.getheader(name, default)


class RESTClientObject(object):
    _urllib3_poolmanagers = {}

    @classmethod
    def get_pool_manager(cls, hash_candidates_dict):
        sorted_items = sorted(hash_candidates_dict.items())
        json_string = json.dumps(sorted_items, separators=(',', ':')).encode('utf-8')
        hash_object = hashlib.sha256()
        hash_object.update(json_string)
        hashed_key = hash_object.hexdigest()

        if hashed_key not in cls._urllib3_poolmanagers:
            my_pool_manager = None
            if 'proxy' in hash_candidates_dict:
                my_pool_manager = urllib3.ProxyManager(
                    num_pools=hash_candidates_dict['pools_size'],
                    maxsize=hash_candidates_dict['maxsize'],
                    cert_reqs=hash_candidates_dict['cert_reqs'],
                    ca_certs=hash_candidates_dict['ca_certs'],
                    cert_file=hash_candidates_dict['cert_file'],
                    key_file=hash_candidates_dict['key_file'],
                    key_password=hash_candidates_dict['key_password'],
                    proxy_url=hash_candidates_dict['proxy'],
                    proxy_headers=hash_candidates_dict['proxy_auth_headers'],
                    keepalive_delay=hash_candidates_dict['keepalive_delay'],
                    keepalive_idle_window=hash_candidates_dict['keepalive_idle_window']
                )
            else:
                my_pool_manager = urllib3.PoolManager(
                    num_pools=hash_candidates_dict['pools_size'],
                    maxsize=hash_candidates_dict['maxsize'],
                    cert_reqs=hash_candidates_dict['cert_reqs'],
                    ca_certs=hash_candidates_dict['ca_certs'],
                    cert_file=hash_candidates_dict['cert_file'],
                    key_file=hash_candidates_dict['key_file'],
                    key_password=hash_candidates_dict['key_password'],
                    keepalive_delay=hash_candidates_dict['keepalive_delay'],
                    keepalive_idle_window=hash_candidates_dict['keepalive_idle_window']
                )

            cls._urllib3_poolmanagers[hashed_key] = my_pool_manager
        
        return cls._urllib3_poolmanagers[hashed_key]

    def __init__(self, mconfig = None):
        # urllib3.PoolManager will pass all kw parameters to connectionpool
        # https://github.com/shazow/urllib3/blob/f9409436f83aeb79fbaf090181cd81b784f1b8ce/urllib3/poolmanager.py#L75
        # https://github.com/shazow/urllib3/blob/f9409436f83aeb79fbaf090181cd81b784f1b8ce/urllib3/connectionpool.py#L680
        # maxsize is the number of requests to host that are allowed in parallel
        # ca_certs vs cert_file vs key_file
        # http://stackoverflow.com/a/23957365/2985775

        if mconfig is None:
            raise ValueError("Merchant Configuration cannot be None")
        
        log_config = mconfig.log_config

        self.logger = LogFactory.setup_logger(self.__class__.__name__, log_config)
        if log_config is not None:
            self.enable_log = log_config.enable_log
        else:
            self.enable_log = False

        # cert_reqs
        if mconfig.ssl_verify:
            cert_reqs = ssl.CERT_REQUIRED
        else:
            cert_reqs = ssl.CERT_NONE

        # ca_certs
        ca_certs = certifi.where()

        cert_file = None
        key_file = None
        key_password = None

        if mconfig.enable_client_cert:
            import os
            # cert_file
            cert_file = os.path.join(mconfig.client_cert_dir, mconfig.ssl_client_cert)

            # key file
            key_file = os.path.join(mconfig.client_cert_dir, mconfig.private_key)

            # key pass
            key_password = mconfig.ssl_key_password

        pools_size = mconfig.get_MaxPoolSize()
        maxsize = mconfig.get_MaxNumIdleConnections()
        keepalive_delay = mconfig.get_MaxKeepAliveDelay()
        keepalive_idle_window = mconfig.get_MaxKeepAliveIdleWindow()

        hash_candidates = {}
        hash_candidates['cert_reqs'] = cert_reqs
        hash_candidates['ca_certs'] = ca_certs
        hash_candidates['cert_file'] = cert_file
        hash_candidates['key_file'] = key_file
        hash_candidates['key_password'] = key_password
        hash_candidates['pools_size'] = pools_size
        hash_candidates['maxsize'] = maxsize
        hash_candidates['keepalive_delay'] = keepalive_delay
        hash_candidates['keepalive_idle_window'] = keepalive_idle_window

        # proxy
        proxy_host = mconfig.proxy_address

        # https pool manager
        if mconfig.use_proxy and not (proxy_host is None or proxy_host == ''):
            # proxy auth headers
            proxy_host = proxy_host.replace("https://", "").replace("http://", "")
            proxy_port = mconfig.proxy_port
            proxy_username = mconfig.proxy_username
            proxy_password = mconfig.proxy_password
            proxy_auth_headers = None

            proxy = 'http://' + proxy_host + ':' + proxy_port

            hash_candidates['proxy'] = proxy

            if (proxy_username and proxy_password):
                proxy_auth_headers = make_headers(proxy_basic_auth=proxy_username + ':' + proxy_password)
                hash_candidates['proxy_auth_headers'] = proxy_auth_headers

        self.pool_manager = self.__class__.get_pool_manager(hash_candidates)

    def request(self, method, url, query_params=None, headers=None,
                body=None, post_params=None, _preload_content=True, _request_timeout=None):
        """
        :param method: http request method
        :param url: http request url
        :param query_params: query parameters in the url
        :param headers: http request headers
        :param body: request json body, for `application/json`
        :param post_params: request post parameters,
                            `application/x-www-form-urlencoded`
                            and `multipart/form-data`
        :param _preload_content: if False, the urllib3.HTTPResponse object will be returned without
                                 reading/decoding response data. Default is True.
        :param _request_timeout: timeout setting for this request. If one number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of (connection, read) timeouts.
        """
        method = method.upper()
        assert method in ['GET', 'HEAD', 'DELETE', 'POST', 'PUT', 'PATCH', 'OPTIONS']

        if post_params and body and not headers['Content-Type'] == 'application/x-www-form-urlencoded':
            raise ValueError(
                "body parameter cannot be used with post_params parameter."
            )

        post_params = post_params or {}
        headers = headers or {}

        timeout = None
        if _request_timeout:
            if isinstance(_request_timeout, (int, ) if PY3 else (int, long)):
                timeout = urllib3.Timeout(total=_request_timeout)
            elif isinstance(_request_timeout, tuple) and len(_request_timeout) == 2:
                timeout = urllib3.Timeout(connect=_request_timeout[0], read=_request_timeout[1])

        if 'Content-Type' not in headers:
            headers['Content-Type'] = 'application/json'

        try:
            # For `POST`, `PUT`, `PATCH`, `OPTIONS`, `DELETE`
            if method in ['POST', 'PUT', 'PATCH', 'OPTIONS', 'DELETE']:
                if query_params:
                    url += '?' + urlencode(query_params)
                if re.search('json', headers['Content-Type'], re.IGNORECASE):
                    request_body = None
                    if body:
                        request_body = body
                    r = self.pool_manager.request(method, url,
                                                  body=request_body,
                                                  preload_content=_preload_content,
                                                  timeout=timeout,
                                                  headers=headers)
                elif headers['Content-Type'] == 'application/x-www-form-urlencoded':
                    r = self.pool_manager.request(method, url,
                                                  fields=post_params,
                                                  encode_multipart=False,
                                                  preload_content=_preload_content,
                                                  timeout=timeout,
                                                  headers=headers)
                elif headers['Content-Type'] == 'multipart/form-data':
                    # must del headers['Content-Type'], or the correct Content-Type
                    # which generated by urllib3 will be overwritten.
                    del headers['Content-Type']
                    r = self.pool_manager.request(method, url,
                                                  fields=post_params,
                                                  encode_multipart=True,
                                                  preload_content=_preload_content,
                                                  timeout=timeout,
                                                  headers=headers)
                # Pass a `string` parameter directly in the body to support
                # other content types than Json when `body` argument is provided
                # in serialized form
                elif isinstance(body, str):
                    request_body = body
                    r = self.pool_manager.request(method, url,
                                                  body=request_body,
                                                  preload_content=_preload_content,
                                                  timeout=timeout,
                                                  headers=headers)
                else:
                    # Cannot generate the request from given parameters
                    msg = """Cannot prepare a request message for provided arguments.
                             Please check that your arguments match declared content type."""
                    raise ApiException(status=0, reason=msg)
            # For `GET`, `HEAD`
            else:
                r = self.pool_manager.request(method, url,
                                              fields=query_params,
                                              preload_content=_preload_content,
                                              timeout=timeout,
                                              headers=headers)
        except urllib3.exceptions.SSLError as e:
            msg = "{0}\n{1}".format(type(e).__name__, str(e))
            raise ApiException(status=0, reason=msg)

        if _preload_content:
            r = RESTResponse(r)

            # In the python 3, the response.data is bytes.
            # we need to decode it to string.
            if PY3:
                r.data = r.data.decode('utf-8')

            # # log response body
            # if self.enable_log:
            #     self.logger.debug("response body: %s", r.data)

        if not 200 <= r.status <= 299:
            raise ApiException(http_resp=r)

        return r

    def GET(self, url, headers=None, query_params=None, _preload_content=True, _request_timeout=None):
        return self.request("GET", url,
                            headers=headers,
                            _preload_content=_preload_content,
                            _request_timeout=_request_timeout,
                            query_params=query_params)

    def HEAD(self, url, headers=None, query_params=None, _preload_content=True, _request_timeout=None):
        return self.request("HEAD", url,
                            headers=headers,
                            _preload_content=_preload_content,
                            _request_timeout=_request_timeout,
                            query_params=query_params)

    def OPTIONS(self, url, headers=None, query_params=None, post_params=None, body=None, _preload_content=True,
                _request_timeout=None):
        return self.request("OPTIONS", url,
                            headers=headers,
                            query_params=query_params,
                            post_params=post_params,
                            _preload_content=_preload_content,
                            _request_timeout=_request_timeout,
                            body=body)

    def DELETE(self, url, headers=None, query_params=None, body=None, _preload_content=True, _request_timeout=None):
        return self.request("DELETE", url,
                            headers=headers,
                            query_params=query_params,
                            _preload_content=_preload_content,
                            _request_timeout=_request_timeout,
                            body=body)

    def POST(self, url, headers=None, query_params=None, post_params=None, body=None, _preload_content=True,
             _request_timeout=None):
        return self.request("POST", url,
                            headers=headers,
                            query_params=query_params,
                            post_params=post_params,
                            _preload_content=_preload_content,
                            _request_timeout=_request_timeout,
                            body=body)

    def PUT(self, url, headers=None, query_params=None, post_params=None, body=None, _preload_content=True,
            _request_timeout=None):
        return self.request("PUT", url,
                            headers=headers,
                            query_params=query_params,
                            post_params=post_params,
                            _preload_content=_preload_content,
                            _request_timeout=_request_timeout,
                            body=body)

    def PATCH(self, url, headers=None, query_params=None, post_params=None, body=None, _preload_content=True,
              _request_timeout=None):
        return self.request("PATCH", url,
                            headers=headers,
                            query_params=query_params,
                            post_params=post_params,
                            _preload_content=_preload_content,
                            _request_timeout=_request_timeout,
                            body=body)


class ApiException(Exception):

    def __init__(self, status=None, reason=None, http_resp=None):
        if http_resp:
            self.status = http_resp.status
            self.reason = http_resp.reason
            self.body = http_resp.data
            self.headers = http_resp.getheaders()
        else:
            self.status = status
            self.reason = reason
            self.body = None
            self.headers = None

    def __str__(self):
        """
        Custom error messages for exception
        """
        error_message = "({0})\n"\
                        "Reason: {1}\n".format(self.status, self.reason)
        if self.headers:
            error_message += "HTTP response headers: {0}\n".format(self.headers)

        if self.body:
            error_message += "HTTP response body: {0}\n".format(self.body)

        return error_message
