# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ReportingV3ReportsIdGet200Response(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'organization_id': 'str',
        'report_id': 'str',
        'report_definition_id': 'str',
        'report_name': 'str',
        'report_mime_type': 'str',
        'report_frequency': 'str',
        'report_fields': 'list[str]',
        'report_status': 'str',
        'report_start_time': 'datetime',
        'report_end_time': 'datetime',
        'timezone': 'str',
        'report_filters': 'dict(str, list[str])',
        'report_preferences': 'Reportingv3reportsReportPreferences',
        'group_id': 'str'
    }

    attribute_map = {
        'organization_id': 'organizationId',
        'report_id': 'reportId',
        'report_definition_id': 'reportDefinitionId',
        'report_name': 'reportName',
        'report_mime_type': 'reportMimeType',
        'report_frequency': 'reportFrequency',
        'report_fields': 'reportFields',
        'report_status': 'reportStatus',
        'report_start_time': 'reportStartTime',
        'report_end_time': 'reportEndTime',
        'timezone': 'timezone',
        'report_filters': 'reportFilters',
        'report_preferences': 'reportPreferences',
        'group_id': 'groupId'
    }

    def __init__(self, organization_id=None, report_id=None, report_definition_id=None, report_name=None, report_mime_type=None, report_frequency=None, report_fields=None, report_status=None, report_start_time=None, report_end_time=None, timezone=None, report_filters=None, report_preferences=None, group_id=None):
        """
        ReportingV3ReportsIdGet200Response - a model defined in Swagger
        """

        self._organization_id = None
        self._report_id = None
        self._report_definition_id = None
        self._report_name = None
        self._report_mime_type = None
        self._report_frequency = None
        self._report_fields = None
        self._report_status = None
        self._report_start_time = None
        self._report_end_time = None
        self._timezone = None
        self._report_filters = None
        self._report_preferences = None
        self._group_id = None

        if organization_id is not None:
          self.organization_id = organization_id
        if report_id is not None:
          self.report_id = report_id
        if report_definition_id is not None:
          self.report_definition_id = report_definition_id
        if report_name is not None:
          self.report_name = report_name
        if report_mime_type is not None:
          self.report_mime_type = report_mime_type
        if report_frequency is not None:
          self.report_frequency = report_frequency
        if report_fields is not None:
          self.report_fields = report_fields
        if report_status is not None:
          self.report_status = report_status
        if report_start_time is not None:
          self.report_start_time = report_start_time
        if report_end_time is not None:
          self.report_end_time = report_end_time
        if timezone is not None:
          self.timezone = timezone
        if report_filters is not None:
          self.report_filters = report_filters
        if report_preferences is not None:
          self.report_preferences = report_preferences
        if group_id is not None:
          self.group_id = group_id

    @property
    def organization_id(self):
        """
        Gets the organization_id of this ReportingV3ReportsIdGet200Response.
        CyberSource merchant id

        :return: The organization_id of this ReportingV3ReportsIdGet200Response.
        :rtype: str
        """
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id):
        """
        Sets the organization_id of this ReportingV3ReportsIdGet200Response.
        CyberSource merchant id

        :param organization_id: The organization_id of this ReportingV3ReportsIdGet200Response.
        :type: str
        """

        self._organization_id = organization_id

    @property
    def report_id(self):
        """
        Gets the report_id of this ReportingV3ReportsIdGet200Response.
        Report ID Value

        :return: The report_id of this ReportingV3ReportsIdGet200Response.
        :rtype: str
        """
        return self._report_id

    @report_id.setter
    def report_id(self, report_id):
        """
        Sets the report_id of this ReportingV3ReportsIdGet200Response.
        Report ID Value

        :param report_id: The report_id of this ReportingV3ReportsIdGet200Response.
        :type: str
        """

        self._report_id = report_id

    @property
    def report_definition_id(self):
        """
        Gets the report_definition_id of this ReportingV3ReportsIdGet200Response.
        Report definition Id

        :return: The report_definition_id of this ReportingV3ReportsIdGet200Response.
        :rtype: str
        """
        return self._report_definition_id

    @report_definition_id.setter
    def report_definition_id(self, report_definition_id):
        """
        Sets the report_definition_id of this ReportingV3ReportsIdGet200Response.
        Report definition Id

        :param report_definition_id: The report_definition_id of this ReportingV3ReportsIdGet200Response.
        :type: str
        """

        self._report_definition_id = report_definition_id

    @property
    def report_name(self):
        """
        Gets the report_name of this ReportingV3ReportsIdGet200Response.
        Report Name

        :return: The report_name of this ReportingV3ReportsIdGet200Response.
        :rtype: str
        """
        return self._report_name

    @report_name.setter
    def report_name(self, report_name):
        """
        Sets the report_name of this ReportingV3ReportsIdGet200Response.
        Report Name

        :param report_name: The report_name of this ReportingV3ReportsIdGet200Response.
        :type: str
        """

        self._report_name = report_name

    @property
    def report_mime_type(self):
        """
        Gets the report_mime_type of this ReportingV3ReportsIdGet200Response.
        Report Format

        :return: The report_mime_type of this ReportingV3ReportsIdGet200Response.
        :rtype: str
        """
        return self._report_mime_type

    @report_mime_type.setter
    def report_mime_type(self, report_mime_type):
        """
        Sets the report_mime_type of this ReportingV3ReportsIdGet200Response.
        Report Format

        :param report_mime_type: The report_mime_type of this ReportingV3ReportsIdGet200Response.
        :type: str
        """
        allowed_values = ["application/xml", "text/csv"]
        if report_mime_type not in allowed_values:
            raise ValueError(
                "Invalid value for `report_mime_type` ({0}), must be one of {1}"
                .format(report_mime_type, allowed_values)
            )

        self._report_mime_type = report_mime_type

    @property
    def report_frequency(self):
        """
        Gets the report_frequency of this ReportingV3ReportsIdGet200Response.
        Report Frequency Value

        :return: The report_frequency of this ReportingV3ReportsIdGet200Response.
        :rtype: str
        """
        return self._report_frequency

    @report_frequency.setter
    def report_frequency(self, report_frequency):
        """
        Sets the report_frequency of this ReportingV3ReportsIdGet200Response.
        Report Frequency Value

        :param report_frequency: The report_frequency of this ReportingV3ReportsIdGet200Response.
        :type: str
        """
        allowed_values = ["DAILY", "WEEKLY", "MONTHLY", "ADHOC"]
        if report_frequency not in allowed_values:
            raise ValueError(
                "Invalid value for `report_frequency` ({0}), must be one of {1}"
                .format(report_frequency, allowed_values)
            )

        self._report_frequency = report_frequency

    @property
    def report_fields(self):
        """
        Gets the report_fields of this ReportingV3ReportsIdGet200Response.
        List of Integer Values

        :return: The report_fields of this ReportingV3ReportsIdGet200Response.
        :rtype: list[str]
        """
        return self._report_fields

    @report_fields.setter
    def report_fields(self, report_fields):
        """
        Sets the report_fields of this ReportingV3ReportsIdGet200Response.
        List of Integer Values

        :param report_fields: The report_fields of this ReportingV3ReportsIdGet200Response.
        :type: list[str]
        """

        self._report_fields = report_fields

    @property
    def report_status(self):
        """
        Gets the report_status of this ReportingV3ReportsIdGet200Response.
        Report Status Value

        :return: The report_status of this ReportingV3ReportsIdGet200Response.
        :rtype: str
        """
        return self._report_status

    @report_status.setter
    def report_status(self, report_status):
        """
        Sets the report_status of this ReportingV3ReportsIdGet200Response.
        Report Status Value

        :param report_status: The report_status of this ReportingV3ReportsIdGet200Response.
        :type: str
        """
        allowed_values = ["COMPLETED", "PENDING", "QUEUED", "RUNNING", "ERROR", "NO_DATA", "RERUN"]
        if report_status not in allowed_values:
            raise ValueError(
                "Invalid value for `report_status` ({0}), must be one of {1}"
                .format(report_status, allowed_values)
            )

        self._report_status = report_status

    @property
    def report_start_time(self):
        """
        Gets the report_start_time of this ReportingV3ReportsIdGet200Response.
        Report Start Time Value

        :return: The report_start_time of this ReportingV3ReportsIdGet200Response.
        :rtype: datetime
        """
        return self._report_start_time

    @report_start_time.setter
    def report_start_time(self, report_start_time):
        """
        Sets the report_start_time of this ReportingV3ReportsIdGet200Response.
        Report Start Time Value

        :param report_start_time: The report_start_time of this ReportingV3ReportsIdGet200Response.
        :type: datetime
        """

        self._report_start_time = report_start_time

    @property
    def report_end_time(self):
        """
        Gets the report_end_time of this ReportingV3ReportsIdGet200Response.
        Report End Time Value

        :return: The report_end_time of this ReportingV3ReportsIdGet200Response.
        :rtype: datetime
        """
        return self._report_end_time

    @report_end_time.setter
    def report_end_time(self, report_end_time):
        """
        Sets the report_end_time of this ReportingV3ReportsIdGet200Response.
        Report End Time Value

        :param report_end_time: The report_end_time of this ReportingV3ReportsIdGet200Response.
        :type: datetime
        """

        self._report_end_time = report_end_time

    @property
    def timezone(self):
        """
        Gets the timezone of this ReportingV3ReportsIdGet200Response.
        Time Zone Value

        :return: The timezone of this ReportingV3ReportsIdGet200Response.
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """
        Sets the timezone of this ReportingV3ReportsIdGet200Response.
        Time Zone Value

        :param timezone: The timezone of this ReportingV3ReportsIdGet200Response.
        :type: str
        """

        self._timezone = timezone

    @property
    def report_filters(self):
        """
        Gets the report_filters of this ReportingV3ReportsIdGet200Response.
        List of filters to apply

        :return: The report_filters of this ReportingV3ReportsIdGet200Response.
        :rtype: dict(str, list[str])
        """
        return self._report_filters

    @report_filters.setter
    def report_filters(self, report_filters):
        """
        Sets the report_filters of this ReportingV3ReportsIdGet200Response.
        List of filters to apply

        :param report_filters: The report_filters of this ReportingV3ReportsIdGet200Response.
        :type: dict(str, list[str])
        """

        self._report_filters = report_filters

    @property
    def report_preferences(self):
        """
        Gets the report_preferences of this ReportingV3ReportsIdGet200Response.

        :return: The report_preferences of this ReportingV3ReportsIdGet200Response.
        :rtype: Reportingv3reportsReportPreferences
        """
        return self._report_preferences

    @report_preferences.setter
    def report_preferences(self, report_preferences):
        """
        Sets the report_preferences of this ReportingV3ReportsIdGet200Response.

        :param report_preferences: The report_preferences of this ReportingV3ReportsIdGet200Response.
        :type: Reportingv3reportsReportPreferences
        """

        self._report_preferences = report_preferences

    @property
    def group_id(self):
        """
        Gets the group_id of this ReportingV3ReportsIdGet200Response.
        Id for selected group.

        :return: The group_id of this ReportingV3ReportsIdGet200Response.
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """
        Sets the group_id of this ReportingV3ReportsIdGet200Response.
        Id for selected group.

        :param group_id: The group_id of this ReportingV3ReportsIdGet200Response.
        :type: str
        """

        self._group_id = group_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ReportingV3ReportsIdGet200Response):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
