# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'acs_url': 'str',
        'authentication_path': 'str',
        'authentication_transaction_id': 'str',
        'cavv': 'str',
        'cavv_algorithm': 'str',
        'challenge_required': 'bool',
        'ecommerce_indicator': 'str',
        'eci': 'str',
        'eci_raw': 'str',
        'pareq': 'str',
        'pares_status': 'str',
        'proof_xml': 'str',
        'proxy_pan': 'str',
        'specification_version': 'str',
        'ucaf_authentication_data': 'str',
        'ucaf_collection_indicator': 'float',
        'veres_enrolled': 'str',
        'xid': 'str'
    }

    attribute_map = {
        'acs_url': 'acsUrl',
        'authentication_path': 'authenticationPath',
        'authentication_transaction_id': 'authenticationTransactionId',
        'cavv': 'cavv',
        'cavv_algorithm': 'cavvAlgorithm',
        'challenge_required': 'challengeRequired',
        'ecommerce_indicator': 'ecommerceIndicator',
        'eci': 'eci',
        'eci_raw': 'eciRaw',
        'pareq': 'pareq',
        'pares_status': 'paresStatus',
        'proof_xml': 'proofXml',
        'proxy_pan': 'proxyPan',
        'specification_version': 'specificationVersion',
        'ucaf_authentication_data': 'ucafAuthenticationData',
        'ucaf_collection_indicator': 'ucafCollectionIndicator',
        'veres_enrolled': 'veresEnrolled',
        'xid': 'xid'
    }

    def __init__(self, acs_url=None, authentication_path=None, authentication_transaction_id=None, cavv=None, cavv_algorithm=None, challenge_required=None, ecommerce_indicator=None, eci=None, eci_raw=None, pareq=None, pares_status=None, proof_xml=None, proxy_pan=None, specification_version=None, ucaf_authentication_data=None, ucaf_collection_indicator=None, veres_enrolled=None, xid=None):
        """
        RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation - a model defined in Swagger
        """

        self._acs_url = None
        self._authentication_path = None
        self._authentication_transaction_id = None
        self._cavv = None
        self._cavv_algorithm = None
        self._challenge_required = None
        self._ecommerce_indicator = None
        self._eci = None
        self._eci_raw = None
        self._pareq = None
        self._pares_status = None
        self._proof_xml = None
        self._proxy_pan = None
        self._specification_version = None
        self._ucaf_authentication_data = None
        self._ucaf_collection_indicator = None
        self._veres_enrolled = None
        self._xid = None

        if acs_url is not None:
          self.acs_url = acs_url
        if authentication_path is not None:
          self.authentication_path = authentication_path
        if authentication_transaction_id is not None:
          self.authentication_transaction_id = authentication_transaction_id
        if cavv is not None:
          self.cavv = cavv
        if cavv_algorithm is not None:
          self.cavv_algorithm = cavv_algorithm
        if challenge_required is not None:
          self.challenge_required = challenge_required
        if ecommerce_indicator is not None:
          self.ecommerce_indicator = ecommerce_indicator
        if eci is not None:
          self.eci = eci
        if eci_raw is not None:
          self.eci_raw = eci_raw
        if pareq is not None:
          self.pareq = pareq
        if pares_status is not None:
          self.pares_status = pares_status
        if proof_xml is not None:
          self.proof_xml = proof_xml
        if proxy_pan is not None:
          self.proxy_pan = proxy_pan
        if specification_version is not None:
          self.specification_version = specification_version
        if ucaf_authentication_data is not None:
          self.ucaf_authentication_data = ucaf_authentication_data
        if ucaf_collection_indicator is not None:
          self.ucaf_collection_indicator = ucaf_collection_indicator
        if veres_enrolled is not None:
          self.veres_enrolled = veres_enrolled
        if xid is not None:
          self.xid = xid

    @property
    def acs_url(self):
        """
        Gets the acs_url of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        URL for the card-issuing bank’s authentication form that you receive when the card is enrolled. The value can be very large. 

        :return: The acs_url of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._acs_url

    @acs_url.setter
    def acs_url(self, acs_url):
        """
        Sets the acs_url of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        URL for the card-issuing bank’s authentication form that you receive when the card is enrolled. The value can be very large. 

        :param acs_url: The acs_url of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if acs_url is not None and len(acs_url) > 2048:
            raise ValueError("Invalid value for `acs_url`, length must be less than or equal to `2048`")

        self._acs_url = acs_url

    @property
    def authentication_path(self):
        """
        Gets the authentication_path of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Indicates what displays to the customer during the authentication process. This field can contain one of these values: - `ADS`: (Card not enrolled) customer prompted to activate the card during the checkout process. - `ATTEMPTS`: (Attempts processing) Processing briefly displays before the checkout process is completed. - `ENROLLED`: (Card enrolled) the card issuer’s authentication window displays. - `UNKNOWN`: Card enrollment status cannot be determined. - `NOREDIRECT`: (Card not enrolled, authentication unavailable, or error occurred) nothing displays to the customer.  The following values can be returned if you are using rules-based payer authentication. - `RIBA`: The card-issuing bank supports risk-based authentication, but whether the cardholder is likely to be challenged cannot be determined. - `RIBA_PASS`: The card-issuing bank supports risk-based authentication and it is likely that the cardholder will not be challenged to provide credentials, also known as _silent authentication_.  For details about possible values, see `pa_enroll_authentication_path` field description and \"Rules-Based Payer Authentication\" in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/wwhelp/wwhimpl/js/html/wwhelp.htm) 

        :return: The authentication_path of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_path

    @authentication_path.setter
    def authentication_path(self, authentication_path):
        """
        Sets the authentication_path of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Indicates what displays to the customer during the authentication process. This field can contain one of these values: - `ADS`: (Card not enrolled) customer prompted to activate the card during the checkout process. - `ATTEMPTS`: (Attempts processing) Processing briefly displays before the checkout process is completed. - `ENROLLED`: (Card enrolled) the card issuer’s authentication window displays. - `UNKNOWN`: Card enrollment status cannot be determined. - `NOREDIRECT`: (Card not enrolled, authentication unavailable, or error occurred) nothing displays to the customer.  The following values can be returned if you are using rules-based payer authentication. - `RIBA`: The card-issuing bank supports risk-based authentication, but whether the cardholder is likely to be challenged cannot be determined. - `RIBA_PASS`: The card-issuing bank supports risk-based authentication and it is likely that the cardholder will not be challenged to provide credentials, also known as _silent authentication_.  For details about possible values, see `pa_enroll_authentication_path` field description and \"Rules-Based Payer Authentication\" in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/wwhelp/wwhimpl/js/html/wwhelp.htm) 

        :param authentication_path: The authentication_path of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._authentication_path = authentication_path

    @property
    def authentication_transaction_id(self):
        """
        Gets the authentication_transaction_id of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages. 

        :return: The authentication_transaction_id of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_transaction_id

    @authentication_transaction_id.setter
    def authentication_transaction_id(self, authentication_transaction_id):
        """
        Sets the authentication_transaction_id of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages. 

        :param authentication_transaction_id: The authentication_transaction_id of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if authentication_transaction_id is not None and len(authentication_transaction_id) > 20:
            raise ValueError("Invalid value for `authentication_transaction_id`, length must be less than or equal to `20`")

        self._authentication_transaction_id = authentication_transaction_id

    @property
    def cavv(self):
        """
        Gets the cavv of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Unique identifier generated by the card-issuing bank for Visa, American Express, JCB, Diners Club, and Discover transactions after the customer is authenticated. The value is in base64. When you request the card authorization service, CyberSource automatically converts the value, not the field name, to the format required by your payment processor. 

        :return: The cavv of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._cavv

    @cavv.setter
    def cavv(self, cavv):
        """
        Sets the cavv of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Unique identifier generated by the card-issuing bank for Visa, American Express, JCB, Diners Club, and Discover transactions after the customer is authenticated. The value is in base64. When you request the card authorization service, CyberSource automatically converts the value, not the field name, to the format required by your payment processor. 

        :param cavv: The cavv of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if cavv is not None and len(cavv) > 255:
            raise ValueError("Invalid value for `cavv`, length must be less than or equal to `255`")

        self._cavv = cavv

    @property
    def cavv_algorithm(self):
        """
        Gets the cavv_algorithm of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Field that is returned only when the CAVV is generated, which occurs when paresStatus contains the values Y (successful authentication) or A (attempted authentication). If you use the ATOS processor, send the value of this field in the `cavv_algorithm` request field of the authorization service. This field contains one of these values: - `2`: Visa, American Express, JCB, Diners Club, and Discover - `3`: Mastercard 

        :return: The cavv_algorithm of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._cavv_algorithm

    @cavv_algorithm.setter
    def cavv_algorithm(self, cavv_algorithm):
        """
        Sets the cavv_algorithm of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Field that is returned only when the CAVV is generated, which occurs when paresStatus contains the values Y (successful authentication) or A (attempted authentication). If you use the ATOS processor, send the value of this field in the `cavv_algorithm` request field of the authorization service. This field contains one of these values: - `2`: Visa, American Express, JCB, Diners Club, and Discover - `3`: Mastercard 

        :param cavv_algorithm: The cavv_algorithm of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if cavv_algorithm is not None and len(cavv_algorithm) > 1:
            raise ValueError("Invalid value for `cavv_algorithm`, length must be less than or equal to `1`")

        self._cavv_algorithm = cavv_algorithm

    @property
    def challenge_required(self):
        """
        Gets the challenge_required of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Indicates whether a challenge is required to complete authentication (region mandates). 

        :return: The challenge_required of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: bool
        """
        return self._challenge_required

    @challenge_required.setter
    def challenge_required(self, challenge_required):
        """
        Sets the challenge_required of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Indicates whether a challenge is required to complete authentication (region mandates). 

        :param challenge_required: The challenge_required of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: bool
        """

        self._challenge_required = challenge_required

    @property
    def ecommerce_indicator(self):
        """
        Gets the ecommerce_indicator of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Commerce indicator for cards not enrolled. This field contains one of these values: - `internet`: Card not enrolled, or card type not supported by payer authentication. No liability shift. - `js_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `js_failure`: J/Secure directory service is not available. No liability shift. - `spa`: Mastercard card not enrolled in the SecureCode program. No liability shift. - `vbv_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `vbv_failure`: For payment processor Barclays, Streamline, AIBMS, or FDC Germany, you receive this result if Visa’s directory service is not available. No liability shift. 

        :return: The ecommerce_indicator of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._ecommerce_indicator

    @ecommerce_indicator.setter
    def ecommerce_indicator(self, ecommerce_indicator):
        """
        Sets the ecommerce_indicator of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Commerce indicator for cards not enrolled. This field contains one of these values: - `internet`: Card not enrolled, or card type not supported by payer authentication. No liability shift. - `js_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `js_failure`: J/Secure directory service is not available. No liability shift. - `spa`: Mastercard card not enrolled in the SecureCode program. No liability shift. - `vbv_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `vbv_failure`: For payment processor Barclays, Streamline, AIBMS, or FDC Germany, you receive this result if Visa’s directory service is not available. No liability shift. 

        :param ecommerce_indicator: The ecommerce_indicator of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """
        if ecommerce_indicator is not None and len(ecommerce_indicator) > 255:
            raise ValueError("Invalid value for `ecommerce_indicator`, length must be less than or equal to `255`")

        self._ecommerce_indicator = ecommerce_indicator

    @property
    def eci(self):
        """
        Gets the eci of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Note This field applies only to non-U.S-issued cards.  For enroll, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions when the card is not enrolled. For more information, see \"Interpreting the Reply,\" page 22.  If you are not using the CyberSource payment services, you must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `06`: The card can be enrolled. Liability shift. - `07`: The card cannot be enrolled. No liability shift.  For validate, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions. The field is absent when authentication fails. You must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `05`: Successful authentication - `06`: Authentication attempted - `07`: Failed authentication (No response from the merchant because of a problem.) 

        :return: The eci of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._eci

    @eci.setter
    def eci(self, eci):
        """
        Sets the eci of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Note This field applies only to non-U.S-issued cards.  For enroll, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions when the card is not enrolled. For more information, see \"Interpreting the Reply,\" page 22.  If you are not using the CyberSource payment services, you must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `06`: The card can be enrolled. Liability shift. - `07`: The card cannot be enrolled. No liability shift.  For validate, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions. The field is absent when authentication fails. You must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `05`: Successful authentication - `06`: Authentication attempted - `07`: Failed authentication (No response from the merchant because of a problem.) 

        :param eci: The eci of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._eci = eci

    @property
    def eci_raw(self):
        """
        Gets the eci_raw of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        ECI value that can be returned for Visa, Mastercard, American Express, JCB, Diners Club, and Discover. The field is absent when authentication fails. If your payment processor is Streamline, you must pass the value of this field instead of the value of `eci` or `ucafCollectionIndicator`.  This field can contain one of these values: - `01`: Authentication attempted (Mastercard) - `02`: Successful authentication (Mastercard) - `05`: Successful authentication (Visa, American Express, JCB, Diners Club, and Discover) - `06`: Authentication attempted (Visa, American Express, JCB, Diners Club, and Discover) 

        :return: The eci_raw of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._eci_raw

    @eci_raw.setter
    def eci_raw(self, eci_raw):
        """
        Sets the eci_raw of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        ECI value that can be returned for Visa, Mastercard, American Express, JCB, Diners Club, and Discover. The field is absent when authentication fails. If your payment processor is Streamline, you must pass the value of this field instead of the value of `eci` or `ucafCollectionIndicator`.  This field can contain one of these values: - `01`: Authentication attempted (Mastercard) - `02`: Successful authentication (Mastercard) - `05`: Successful authentication (Visa, American Express, JCB, Diners Club, and Discover) - `06`: Authentication attempted (Visa, American Express, JCB, Diners Club, and Discover) 

        :param eci_raw: The eci_raw of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._eci_raw = eci_raw

    @property
    def pareq(self):
        """
        Gets the pareq of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Payer authentication request (PAReq) message that you need to forward to the ACS. The value can be very large. The value is in base64. 

        :return: The pareq of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._pareq

    @pareq.setter
    def pareq(self, pareq):
        """
        Sets the pareq of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Payer authentication request (PAReq) message that you need to forward to the ACS. The value can be very large. The value is in base64. 

        :param pareq: The pareq of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._pareq = pareq

    @property
    def pares_status(self):
        """
        Gets the pares_status of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Raw result of the authentication check. If you are configured for Asia, Middle East, and Africa Gateway Processing, you need to send the value of this field in your authorization request. This field can contain one of these values: - `A`: Proof of authentication attempt was generated. - `B`: Bypassed authentication. - `N`: Customer failed or canceled authentication. Transaction denied. - `R`: Authentication rejected (used for 3D Secure 2.0 transactions only) - `U`: Authentication not completed regardless of the reason. - `Y`: Customer was successfully authenticated. 

        :return: The pares_status of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._pares_status

    @pares_status.setter
    def pares_status(self, pares_status):
        """
        Sets the pares_status of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Raw result of the authentication check. If you are configured for Asia, Middle East, and Africa Gateway Processing, you need to send the value of this field in your authorization request. This field can contain one of these values: - `A`: Proof of authentication attempt was generated. - `B`: Bypassed authentication. - `N`: Customer failed or canceled authentication. Transaction denied. - `R`: Authentication rejected (used for 3D Secure 2.0 transactions only) - `U`: Authentication not completed regardless of the reason. - `Y`: Customer was successfully authenticated. 

        :param pares_status: The pares_status of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._pares_status = pares_status

    @property
    def proof_xml(self):
        """
        Gets the proof_xml of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Date and time of the enrollment check combined with the VEReq and VERes elements. If you ever need to show proof of enrollment checking, you may need to parse the string for the information required by the payment card company. The value can be very large. For details about possible values, see the `pa_enroll_proofxml` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/wwhelp/wwhimpl/js/html/wwhelp.htm) - For cards issued in the U.S. or Canada, Visa may require this data for specific merchant category codes. - For cards not issued in the U.S. or Canada, your bank may require this data as proof of enrollment checking for any payer authentication transaction that you re-present because of a chargeback. 

        :return: The proof_xml of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._proof_xml

    @proof_xml.setter
    def proof_xml(self, proof_xml):
        """
        Sets the proof_xml of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Date and time of the enrollment check combined with the VEReq and VERes elements. If you ever need to show proof of enrollment checking, you may need to parse the string for the information required by the payment card company. The value can be very large. For details about possible values, see the `pa_enroll_proofxml` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/wwhelp/wwhimpl/js/html/wwhelp.htm) - For cards issued in the U.S. or Canada, Visa may require this data for specific merchant category codes. - For cards not issued in the U.S. or Canada, your bank may require this data as proof of enrollment checking for any payer authentication transaction that you re-present because of a chargeback. 

        :param proof_xml: The proof_xml of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._proof_xml = proof_xml

    @property
    def proxy_pan(self):
        """
        Gets the proxy_pan of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Encrypted version of the card number used in the payer authentication request message. 

        :return: The proxy_pan of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._proxy_pan

    @proxy_pan.setter
    def proxy_pan(self, proxy_pan):
        """
        Sets the proxy_pan of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Encrypted version of the card number used in the payer authentication request message. 

        :param proxy_pan: The proxy_pan of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._proxy_pan = proxy_pan

    @property
    def specification_version(self):
        """
        Gets the specification_version of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        This field contains the 3D Secure version that was used to process the transaction. For example, 1.0.2 or 2.0.0. 

        :return: The specification_version of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._specification_version

    @specification_version.setter
    def specification_version(self, specification_version):
        """
        Sets the specification_version of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        This field contains the 3D Secure version that was used to process the transaction. For example, 1.0.2 or 2.0.0. 

        :param specification_version: The specification_version of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._specification_version = specification_version

    @property
    def ucaf_authentication_data(self):
        """
        Gets the ucaf_authentication_data of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        AAV is a unique identifier generated by the cardissuing bank for Mastercard SecureCode transactions after the customer is authenticated. The value is in base64. Include the data in the card authorization request. 

        :return: The ucaf_authentication_data of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._ucaf_authentication_data

    @ucaf_authentication_data.setter
    def ucaf_authentication_data(self, ucaf_authentication_data):
        """
        Sets the ucaf_authentication_data of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        AAV is a unique identifier generated by the cardissuing bank for Mastercard SecureCode transactions after the customer is authenticated. The value is in base64. Include the data in the card authorization request. 

        :param ucaf_authentication_data: The ucaf_authentication_data of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._ucaf_authentication_data = ucaf_authentication_data

    @property
    def ucaf_collection_indicator(self):
        """
        Gets the ucaf_collection_indicator of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        For enroll, Returned only for Mastercard transactions. Indicates that authentication is not required because the customer is not enrolled. Add the value of this field to the authorization field ucaf_collection_indicator. This field can contain these values: 0, 1.  For validate, Numeric electronic commerce indicator (ECI) returned only for Mastercard SecureCode transactions. The field is absent when authentication fails. You must send this value to your payment processor in the request for card authorization. This field contain one of these values: - `0`: Authentication data not collected, and customer authentication was not completed. - `1`: Authentication data not collected because customer authentication was not completed. - `2`: Authentication data collected because customer completed authentication. 

        :return: The ucaf_collection_indicator of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: float
        """
        return self._ucaf_collection_indicator

    @ucaf_collection_indicator.setter
    def ucaf_collection_indicator(self, ucaf_collection_indicator):
        """
        Sets the ucaf_collection_indicator of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        For enroll, Returned only for Mastercard transactions. Indicates that authentication is not required because the customer is not enrolled. Add the value of this field to the authorization field ucaf_collection_indicator. This field can contain these values: 0, 1.  For validate, Numeric electronic commerce indicator (ECI) returned only for Mastercard SecureCode transactions. The field is absent when authentication fails. You must send this value to your payment processor in the request for card authorization. This field contain one of these values: - `0`: Authentication data not collected, and customer authentication was not completed. - `1`: Authentication data not collected because customer authentication was not completed. - `2`: Authentication data collected because customer completed authentication. 

        :param ucaf_collection_indicator: The ucaf_collection_indicator of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: float
        """

        self._ucaf_collection_indicator = ucaf_collection_indicator

    @property
    def veres_enrolled(self):
        """
        Gets the veres_enrolled of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Result of the enrollment check. This field can contain one of these values: - `Y`: Card enrolled or can be enrolled; you must authenticate. Liability shift. - `N`: Card not enrolled; proceed with authorization. Liability shift. - `U`: Unable to authenticate regardless of the reason. No liability shift.  **Note** This field only applies to the Asia, Middle East, and Africa Gateway. If you are configured for this processor, you must send the value of this field in your authorization request.  The following value can be returned if you are using rules-based Payer Authentication: - `B`: Indicates that authentication was bypassed.  For details, see `pa_enroll_veres_enrolled` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/wwhelp/wwhimpl/js/html/wwhelp.htm) 

        :return: The veres_enrolled of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._veres_enrolled

    @veres_enrolled.setter
    def veres_enrolled(self, veres_enrolled):
        """
        Sets the veres_enrolled of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Result of the enrollment check. This field can contain one of these values: - `Y`: Card enrolled or can be enrolled; you must authenticate. Liability shift. - `N`: Card not enrolled; proceed with authorization. Liability shift. - `U`: Unable to authenticate regardless of the reason. No liability shift.  **Note** This field only applies to the Asia, Middle East, and Africa Gateway. If you are configured for this processor, you must send the value of this field in your authorization request.  The following value can be returned if you are using rules-based Payer Authentication: - `B`: Indicates that authentication was bypassed.  For details, see `pa_enroll_veres_enrolled` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/wwhelp/wwhimpl/js/html/wwhelp.htm) 

        :param veres_enrolled: The veres_enrolled of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._veres_enrolled = veres_enrolled

    @property
    def xid(self):
        """
        Gets the xid of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Transaction identifier generated by CyberSource for successful enrollment or validation checks. Use this value, which is in base64, to match an outgoing PAReq with an incoming PARes. CyberSource forwards the XID with the card authorization service to these payment processors in these cases: - Barclays - Streamline (when the **ecommerceIndicator**`=spa`) 

        :return: The xid of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._xid

    @xid.setter
    def xid(self, xid):
        """
        Sets the xid of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        Transaction identifier generated by CyberSource for successful enrollment or validation checks. Use this value, which is in base64, to match an outgoing PAReq with an incoming PARes. CyberSource forwards the XID with the card authorization service to these payment processors in these cases: - Barclays - Streamline (when the **ecommerceIndicator**`=spa`) 

        :param xid: The xid of this RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation.
        :type: str
        """

        self._xid = xid

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, RiskV1AuthenticationsPost201ResponseConsumerAuthenticationInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
