# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Riskv1authenticationresultsConsumerAuthenticationInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'authentication_transaction_id': 'str',
        'signed_pares': 'str'
    }

    attribute_map = {
        'authentication_transaction_id': 'authenticationTransactionId',
        'signed_pares': 'signedPares'
    }

    def __init__(self, authentication_transaction_id=None, signed_pares=None):
        """
        Riskv1authenticationresultsConsumerAuthenticationInformation - a model defined in Swagger
        """

        self._authentication_transaction_id = None
        self._signed_pares = None

        if authentication_transaction_id is not None:
          self.authentication_transaction_id = authentication_transaction_id
        self.signed_pares = signed_pares

    @property
    def authentication_transaction_id(self):
        """
        Gets the authentication_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages. **Note**: Required for Standard integration for enroll service. Required for Hybrid integration for validate service. 

        :return: The authentication_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_transaction_id

    @authentication_transaction_id.setter
    def authentication_transaction_id(self, authentication_transaction_id):
        """
        Sets the authentication_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages. **Note**: Required for Standard integration for enroll service. Required for Hybrid integration for validate service. 

        :param authentication_transaction_id: The authentication_transaction_id of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if authentication_transaction_id is not None and len(authentication_transaction_id) > 20:
            raise ValueError("Invalid value for `authentication_transaction_id`, length must be less than or equal to `20`")

        self._authentication_transaction_id = authentication_transaction_id

    @property
    def signed_pares(self):
        """
        Gets the signed_pares of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Payer authentication result (PARes) message returned by the card-issuing bank. If you need to show proof of enrollment checking, you may need to decrypt and parse the string for the information required by the payment card company. For more information, see \"Storing Payer Authentication Data,\" page 160. Important The value is in base64. You must remove all carriage returns and line feeds before adding the PARes to the request. 

        :return: The signed_pares of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._signed_pares

    @signed_pares.setter
    def signed_pares(self, signed_pares):
        """
        Sets the signed_pares of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        Payer authentication result (PARes) message returned by the card-issuing bank. If you need to show proof of enrollment checking, you may need to decrypt and parse the string for the information required by the payment card company. For more information, see \"Storing Payer Authentication Data,\" page 160. Important The value is in base64. You must remove all carriage returns and line feeds before adding the PARes to the request. 

        :param signed_pares: The signed_pares of this Riskv1authenticationresultsConsumerAuthenticationInformation.
        :type: str
        """
        if signed_pares is None:
            raise ValueError("Invalid value for `signed_pares`, must not be `None`")

        self._signed_pares = signed_pares

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Riskv1authenticationresultsConsumerAuthenticationInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
