# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Riskv1authenticationsConsumerAuthenticationInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'alternate_authentication_data': 'str',
        'alternate_authentication_date': 'str',
        'alternate_authentication_method': 'str',
        'authentication_transaction_id': 'str',
        'challenge_code': 'str',
        'customer_card_alias': 'str',
        'default_card': 'bool',
        'installment_total_count': 'int',
        'marketing_opt_in': 'bool',
        'marketing_source': 'str',
        'mcc': 'str',
        'message_category': 'str',
        'npa_code': 'str',
        'override_payment_method': 'str',
        'product_code': 'str',
        'requestor_id': 'str',
        'requestor_name': 'str',
        'reference_id': 'str',
        'transaction_mode': 'str'
    }

    attribute_map = {
        'alternate_authentication_data': 'alternateAuthenticationData',
        'alternate_authentication_date': 'alternateAuthenticationDate',
        'alternate_authentication_method': 'alternateAuthenticationMethod',
        'authentication_transaction_id': 'authenticationTransactionId',
        'challenge_code': 'challengeCode',
        'customer_card_alias': 'customerCardAlias',
        'default_card': 'defaultCard',
        'installment_total_count': 'installmentTotalCount',
        'marketing_opt_in': 'marketingOptIn',
        'marketing_source': 'marketingSource',
        'mcc': 'mcc',
        'message_category': 'messageCategory',
        'npa_code': 'npaCode',
        'override_payment_method': 'overridePaymentMethod',
        'product_code': 'productCode',
        'requestor_id': 'requestorId',
        'requestor_name': 'requestorName',
        'reference_id': 'referenceId',
        'transaction_mode': 'transactionMode'
    }

    def __init__(self, alternate_authentication_data=None, alternate_authentication_date=None, alternate_authentication_method=None, authentication_transaction_id=None, challenge_code=None, customer_card_alias=None, default_card=None, installment_total_count=None, marketing_opt_in=None, marketing_source=None, mcc=None, message_category=None, npa_code=None, override_payment_method=None, product_code=None, requestor_id=None, requestor_name=None, reference_id=None, transaction_mode=None):
        """
        Riskv1authenticationsConsumerAuthenticationInformation - a model defined in Swagger
        """

        self._alternate_authentication_data = None
        self._alternate_authentication_date = None
        self._alternate_authentication_method = None
        self._authentication_transaction_id = None
        self._challenge_code = None
        self._customer_card_alias = None
        self._default_card = None
        self._installment_total_count = None
        self._marketing_opt_in = None
        self._marketing_source = None
        self._mcc = None
        self._message_category = None
        self._npa_code = None
        self._override_payment_method = None
        self._product_code = None
        self._requestor_id = None
        self._requestor_name = None
        self._reference_id = None
        self._transaction_mode = None

        if alternate_authentication_data is not None:
          self.alternate_authentication_data = alternate_authentication_data
        if alternate_authentication_date is not None:
          self.alternate_authentication_date = alternate_authentication_date
        if alternate_authentication_method is not None:
          self.alternate_authentication_method = alternate_authentication_method
        if authentication_transaction_id is not None:
          self.authentication_transaction_id = authentication_transaction_id
        if challenge_code is not None:
          self.challenge_code = challenge_code
        if customer_card_alias is not None:
          self.customer_card_alias = customer_card_alias
        if default_card is not None:
          self.default_card = default_card
        if installment_total_count is not None:
          self.installment_total_count = installment_total_count
        if marketing_opt_in is not None:
          self.marketing_opt_in = marketing_opt_in
        if marketing_source is not None:
          self.marketing_source = marketing_source
        self.mcc = mcc
        if message_category is not None:
          self.message_category = message_category
        if npa_code is not None:
          self.npa_code = npa_code
        if override_payment_method is not None:
          self.override_payment_method = override_payment_method
        if product_code is not None:
          self.product_code = product_code
        if requestor_id is not None:
          self.requestor_id = requestor_id
        if requestor_name is not None:
          self.requestor_name = requestor_name
        self.reference_id = reference_id
        self.transaction_mode = transaction_mode

    @property
    def alternate_authentication_data(self):
        """
        Gets the alternate_authentication_data of this Riskv1authenticationsConsumerAuthenticationInformation.
        Data that documents and supports a specific authentication process. 

        :return: The alternate_authentication_data of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._alternate_authentication_data

    @alternate_authentication_data.setter
    def alternate_authentication_data(self, alternate_authentication_data):
        """
        Sets the alternate_authentication_data of this Riskv1authenticationsConsumerAuthenticationInformation.
        Data that documents and supports a specific authentication process. 

        :param alternate_authentication_data: The alternate_authentication_data of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """
        if alternate_authentication_data is not None and len(alternate_authentication_data) > 2048:
            raise ValueError("Invalid value for `alternate_authentication_data`, length must be less than or equal to `2048`")

        self._alternate_authentication_data = alternate_authentication_data

    @property
    def alternate_authentication_date(self):
        """
        Gets the alternate_authentication_date of this Riskv1authenticationsConsumerAuthenticationInformation.
        Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM 

        :return: The alternate_authentication_date of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._alternate_authentication_date

    @alternate_authentication_date.setter
    def alternate_authentication_date(self, alternate_authentication_date):
        """
        Sets the alternate_authentication_date of this Riskv1authenticationsConsumerAuthenticationInformation.
        Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM 

        :param alternate_authentication_date: The alternate_authentication_date of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """
        if alternate_authentication_date is not None and len(alternate_authentication_date) > 14:
            raise ValueError("Invalid value for `alternate_authentication_date`, length must be less than or equal to `14`")

        self._alternate_authentication_date = alternate_authentication_date

    @property
    def alternate_authentication_method(self):
        """
        Gets the alternate_authentication_method of this Riskv1authenticationsConsumerAuthenticationInformation.
        Mechanism used by the cardholder to authenticate to the 3D Secure requestor. Possible values: - `01`: No authentication occurred - `02`: Login using merchant system credentials - `03`: Login using Federated ID - `04`: Login using FIDO Authenticator 

        :return: The alternate_authentication_method of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._alternate_authentication_method

    @alternate_authentication_method.setter
    def alternate_authentication_method(self, alternate_authentication_method):
        """
        Sets the alternate_authentication_method of this Riskv1authenticationsConsumerAuthenticationInformation.
        Mechanism used by the cardholder to authenticate to the 3D Secure requestor. Possible values: - `01`: No authentication occurred - `02`: Login using merchant system credentials - `03`: Login using Federated ID - `04`: Login using FIDO Authenticator 

        :param alternate_authentication_method: The alternate_authentication_method of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """

        self._alternate_authentication_method = alternate_authentication_method

    @property
    def authentication_transaction_id(self):
        """
        Gets the authentication_transaction_id of this Riskv1authenticationsConsumerAuthenticationInformation.
        Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages. **Note**: Required for Standard integration for enroll service. Required for Hybrid integration for validate service. 

        :return: The authentication_transaction_id of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._authentication_transaction_id

    @authentication_transaction_id.setter
    def authentication_transaction_id(self, authentication_transaction_id):
        """
        Sets the authentication_transaction_id of this Riskv1authenticationsConsumerAuthenticationInformation.
        Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages. **Note**: Required for Standard integration for enroll service. Required for Hybrid integration for validate service. 

        :param authentication_transaction_id: The authentication_transaction_id of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """
        if authentication_transaction_id is not None and len(authentication_transaction_id) > 20:
            raise ValueError("Invalid value for `authentication_transaction_id`, length must be less than or equal to `20`")

        self._authentication_transaction_id = authentication_transaction_id

    @property
    def challenge_code(self):
        """
        Gets the challenge_code of this Riskv1authenticationsConsumerAuthenticationInformation.
        Possible values: - `01`: No preference - `02`: No challenge request - `03`: Challenge requested (3D Secure requestor preference) - `04`: Challenge requested (mandate) - `05-79`: Reserved for EMVCo future use (values invalid until defined by EMVCo) - `80-99`: Reserved for DS use  For details, see `pa_challenge_code` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/wwhelp/wwhimpl/js/html/wwhelp.htm) 

        :return: The challenge_code of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._challenge_code

    @challenge_code.setter
    def challenge_code(self, challenge_code):
        """
        Sets the challenge_code of this Riskv1authenticationsConsumerAuthenticationInformation.
        Possible values: - `01`: No preference - `02`: No challenge request - `03`: Challenge requested (3D Secure requestor preference) - `04`: Challenge requested (mandate) - `05-79`: Reserved for EMVCo future use (values invalid until defined by EMVCo) - `80-99`: Reserved for DS use  For details, see `pa_challenge_code` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/wwhelp/wwhimpl/js/html/wwhelp.htm) 

        :param challenge_code: The challenge_code of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """

        self._challenge_code = challenge_code

    @property
    def customer_card_alias(self):
        """
        Gets the customer_card_alias of this Riskv1authenticationsConsumerAuthenticationInformation.
        An alias that uniquely identifies the customer's account and credit card on file. Note This field is required if Tokenization is enabled in the merchant profile settings. 

        :return: The customer_card_alias of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._customer_card_alias

    @customer_card_alias.setter
    def customer_card_alias(self, customer_card_alias):
        """
        Sets the customer_card_alias of this Riskv1authenticationsConsumerAuthenticationInformation.
        An alias that uniquely identifies the customer's account and credit card on file. Note This field is required if Tokenization is enabled in the merchant profile settings. 

        :param customer_card_alias: The customer_card_alias of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """
        if customer_card_alias is not None and len(customer_card_alias) > 128:
            raise ValueError("Invalid value for `customer_card_alias`, length must be less than or equal to `128`")

        self._customer_card_alias = customer_card_alias

    @property
    def default_card(self):
        """
        Gets the default_card of this Riskv1authenticationsConsumerAuthenticationInformation.
        Indicates that the card being used is the one designated as the primary payment card for purchase. Recommended for Discover ProtectBuy. 

        :return: The default_card of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: bool
        """
        return self._default_card

    @default_card.setter
    def default_card(self, default_card):
        """
        Sets the default_card of this Riskv1authenticationsConsumerAuthenticationInformation.
        Indicates that the card being used is the one designated as the primary payment card for purchase. Recommended for Discover ProtectBuy. 

        :param default_card: The default_card of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: bool
        """

        self._default_card = default_card

    @property
    def installment_total_count(self):
        """
        Gets the installment_total_count of this Riskv1authenticationsConsumerAuthenticationInformation.
        An integer value greater than 1 indicating the max number of permitted authorizations for installment payments. **Note** This is required if the merchant and cardholder have agreed to installment payments. 

        :return: The installment_total_count of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: int
        """
        return self._installment_total_count

    @installment_total_count.setter
    def installment_total_count(self, installment_total_count):
        """
        Sets the installment_total_count of this Riskv1authenticationsConsumerAuthenticationInformation.
        An integer value greater than 1 indicating the max number of permitted authorizations for installment payments. **Note** This is required if the merchant and cardholder have agreed to installment payments. 

        :param installment_total_count: The installment_total_count of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: int
        """

        self._installment_total_count = installment_total_count

    @property
    def marketing_opt_in(self):
        """
        Gets the marketing_opt_in of this Riskv1authenticationsConsumerAuthenticationInformation.
        Indicates whether the customer has opted in for marketing offers. Recommended for Discover ProtectBuy. 

        :return: The marketing_opt_in of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: bool
        """
        return self._marketing_opt_in

    @marketing_opt_in.setter
    def marketing_opt_in(self, marketing_opt_in):
        """
        Sets the marketing_opt_in of this Riskv1authenticationsConsumerAuthenticationInformation.
        Indicates whether the customer has opted in for marketing offers. Recommended for Discover ProtectBuy. 

        :param marketing_opt_in: The marketing_opt_in of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: bool
        """

        self._marketing_opt_in = marketing_opt_in

    @property
    def marketing_source(self):
        """
        Gets the marketing_source of this Riskv1authenticationsConsumerAuthenticationInformation.
        Indicates origin of the marketing offer. Recommended for Discover ProtectBuy. 

        :return: The marketing_source of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._marketing_source

    @marketing_source.setter
    def marketing_source(self, marketing_source):
        """
        Sets the marketing_source of this Riskv1authenticationsConsumerAuthenticationInformation.
        Indicates origin of the marketing offer. Recommended for Discover ProtectBuy. 

        :param marketing_source: The marketing_source of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """
        if marketing_source is not None and len(marketing_source) > 40:
            raise ValueError("Invalid value for `marketing_source`, length must be less than or equal to `40`")

        self._marketing_source = marketing_source

    @property
    def mcc(self):
        """
        Gets the mcc of this Riskv1authenticationsConsumerAuthenticationInformation.
        Merchant category code. **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :return: The mcc of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._mcc

    @mcc.setter
    def mcc(self, mcc):
        """
        Sets the mcc of this Riskv1authenticationsConsumerAuthenticationInformation.
        Merchant category code. **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :param mcc: The mcc of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """
        if mcc is None:
            raise ValueError("Invalid value for `mcc`, must not be `None`")
        if mcc is not None and len(mcc) > 4:
            raise ValueError("Invalid value for `mcc`, length must be less than or equal to `4`")

        self._mcc = mcc

    @property
    def message_category(self):
        """
        Gets the message_category of this Riskv1authenticationsConsumerAuthenticationInformation.
        Category of the message for a specific use case. Possible values:  - `01`: PA- payment authentication - `02`: NPA- non-payment authentication - `03-79`: Reserved for EMVCo future use (values invalid until defined by EMVCo) - `80-99`: Reserved for DS use 

        :return: The message_category of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._message_category

    @message_category.setter
    def message_category(self, message_category):
        """
        Sets the message_category of this Riskv1authenticationsConsumerAuthenticationInformation.
        Category of the message for a specific use case. Possible values:  - `01`: PA- payment authentication - `02`: NPA- non-payment authentication - `03-79`: Reserved for EMVCo future use (values invalid until defined by EMVCo) - `80-99`: Reserved for DS use 

        :param message_category: The message_category of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """

        self._message_category = message_category

    @property
    def npa_code(self):
        """
        Gets the npa_code of this Riskv1authenticationsConsumerAuthenticationInformation.
        Non-Payer Authentication Indicator. Possible values: - `01`: Add card - `02`: Maintain card information - `03`: Cardholder verification for EMV token - `04-80` Reserved for EMVCo - `80-90` Reserved DS 

        :return: The npa_code of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._npa_code

    @npa_code.setter
    def npa_code(self, npa_code):
        """
        Sets the npa_code of this Riskv1authenticationsConsumerAuthenticationInformation.
        Non-Payer Authentication Indicator. Possible values: - `01`: Add card - `02`: Maintain card information - `03`: Cardholder verification for EMV token - `04-80` Reserved for EMVCo - `80-90` Reserved DS 

        :param npa_code: The npa_code of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """
        if npa_code is not None and len(npa_code) > 2:
            raise ValueError("Invalid value for `npa_code`, length must be less than or equal to `2`")

        self._npa_code = npa_code

    @property
    def override_payment_method(self):
        """
        Gets the override_payment_method of this Riskv1authenticationsConsumerAuthenticationInformation.
        Specifies the Brazilian payment account type used for the transaction. This field overrides other payment types that might be specified in the request. Use one of the following values for this field: - `NA`: Not applicable. Do not override other payment types that are specified in the request. - `CR`: Credit card. - `DB`: Debit card. - `VSAVR`: Visa Vale Refeicao - `VSAVA`: Visa Vale Alimentacao **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :return: The override_payment_method of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._override_payment_method

    @override_payment_method.setter
    def override_payment_method(self, override_payment_method):
        """
        Sets the override_payment_method of this Riskv1authenticationsConsumerAuthenticationInformation.
        Specifies the Brazilian payment account type used for the transaction. This field overrides other payment types that might be specified in the request. Use one of the following values for this field: - `NA`: Not applicable. Do not override other payment types that are specified in the request. - `CR`: Credit card. - `DB`: Debit card. - `VSAVR`: Visa Vale Refeicao - `VSAVA`: Visa Vale Alimentacao **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :param override_payment_method: The override_payment_method of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """

        self._override_payment_method = override_payment_method

    @property
    def product_code(self):
        """
        Gets the product_code of this Riskv1authenticationsConsumerAuthenticationInformation.
        Specifies the product code, which designates the type of transaction. Specify one of the following values for this field: - AIR: Airline purchase Important Required for American Express SafeKey (U.S.). - `ACC`: Accommodation Rental - `ACF`: Account funding - `CHA`: Check acceptance - `DIG`: Digital Goods - `DSP`: Cash Dispensing - `GAS`: Fuel - `GEN`: General Retail - `LUX`: Luxury Retail - `PAL`: Prepaid activation and load - `PHY`: Goods or services purchase - `QCT`: Quasi-cash transaction - `REN`: Car Rental - `RES`: Restaurant - `SVC`: Services - `TBD`: Other - `TRA`: Travel **Important** Required for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :return: The product_code of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._product_code

    @product_code.setter
    def product_code(self, product_code):
        """
        Sets the product_code of this Riskv1authenticationsConsumerAuthenticationInformation.
        Specifies the product code, which designates the type of transaction. Specify one of the following values for this field: - AIR: Airline purchase Important Required for American Express SafeKey (U.S.). - `ACC`: Accommodation Rental - `ACF`: Account funding - `CHA`: Check acceptance - `DIG`: Digital Goods - `DSP`: Cash Dispensing - `GAS`: Fuel - `GEN`: General Retail - `LUX`: Luxury Retail - `PAL`: Prepaid activation and load - `PHY`: Goods or services purchase - `QCT`: Quasi-cash transaction - `REN`: Car Rental - `RES`: Restaurant - `SVC`: Services - `TBD`: Other - `TRA`: Travel **Important** Required for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions. 

        :param product_code: The product_code of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """
        if product_code is not None and len(product_code) > 3:
            raise ValueError("Invalid value for `product_code`, length must be less than or equal to `3`")

        self._product_code = product_code

    @property
    def requestor_id(self):
        """
        Gets the requestor_id of this Riskv1authenticationsConsumerAuthenticationInformation.
        Cardinal's directory server assigned 3DS Requestor ID value

        :return: The requestor_id of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._requestor_id

    @requestor_id.setter
    def requestor_id(self, requestor_id):
        """
        Sets the requestor_id of this Riskv1authenticationsConsumerAuthenticationInformation.
        Cardinal's directory server assigned 3DS Requestor ID value

        :param requestor_id: The requestor_id of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """
        if requestor_id is not None and len(requestor_id) > 35:
            raise ValueError("Invalid value for `requestor_id`, length must be less than or equal to `35`")

        self._requestor_id = requestor_id

    @property
    def requestor_name(self):
        """
        Gets the requestor_name of this Riskv1authenticationsConsumerAuthenticationInformation.
        Cardinal's directory server assigned 3DS Requestor Name value

        :return: The requestor_name of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._requestor_name

    @requestor_name.setter
    def requestor_name(self, requestor_name):
        """
        Sets the requestor_name of this Riskv1authenticationsConsumerAuthenticationInformation.
        Cardinal's directory server assigned 3DS Requestor Name value

        :param requestor_name: The requestor_name of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """
        if requestor_name is not None and len(requestor_name) > 40:
            raise ValueError("Invalid value for `requestor_name`, length must be less than or equal to `40`")

        self._requestor_name = requestor_name

    @property
    def reference_id(self):
        """
        Gets the reference_id of this Riskv1authenticationsConsumerAuthenticationInformation.
        Reference ID that corresponds to the device fingerprinting data that was collected previously. Note Required for Hybrid integration. 

        :return: The reference_id of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._reference_id

    @reference_id.setter
    def reference_id(self, reference_id):
        """
        Sets the reference_id of this Riskv1authenticationsConsumerAuthenticationInformation.
        Reference ID that corresponds to the device fingerprinting data that was collected previously. Note Required for Hybrid integration. 

        :param reference_id: The reference_id of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """
        if reference_id is None:
            raise ValueError("Invalid value for `reference_id`, must not be `None`")
        if reference_id is not None and len(reference_id) > 50:
            raise ValueError("Invalid value for `reference_id`, length must be less than or equal to `50`")

        self._reference_id = reference_id

    @property
    def transaction_mode(self):
        """
        Gets the transaction_mode of this Riskv1authenticationsConsumerAuthenticationInformation.
        Transaction mode identifier. Identifies the channel from which the transaction originates. Possible values: - `MOTO` - MOTO (Mail Order Telephone Order) - `RETAIL` - Retail - `ECOMMERCE` - eCommerce - `MOBILE` - Mobile Device - `TABLET` - Tablet 

        :return: The transaction_mode of this Riskv1authenticationsConsumerAuthenticationInformation.
        :rtype: str
        """
        return self._transaction_mode

    @transaction_mode.setter
    def transaction_mode(self, transaction_mode):
        """
        Sets the transaction_mode of this Riskv1authenticationsConsumerAuthenticationInformation.
        Transaction mode identifier. Identifies the channel from which the transaction originates. Possible values: - `MOTO` - MOTO (Mail Order Telephone Order) - `RETAIL` - Retail - `ECOMMERCE` - eCommerce - `MOBILE` - Mobile Device - `TABLET` - Tablet 

        :param transaction_mode: The transaction_mode of this Riskv1authenticationsConsumerAuthenticationInformation.
        :type: str
        """
        if transaction_mode is None:
            raise ValueError("Invalid value for `transaction_mode`, must not be `None`")

        self._transaction_mode = transaction_mode

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Riskv1authenticationsConsumerAuthenticationInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
