# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Riskv1authenticationsDeviceInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ip_address': 'str',
        'raw_data': 'list[Riskv1authenticationsDeviceInformationRawData]',
        'http_accept_browser_value': 'str',
        'http_accept_content': 'str',
        'user_agent_browser_value': 'str'
    }

    attribute_map = {
        'ip_address': 'ipAddress',
        'raw_data': 'rawData',
        'http_accept_browser_value': 'httpAcceptBrowserValue',
        'http_accept_content': 'httpAcceptContent',
        'user_agent_browser_value': 'userAgentBrowserValue'
    }

    def __init__(self, ip_address=None, raw_data=None, http_accept_browser_value=None, http_accept_content=None, user_agent_browser_value=None):
        """
        Riskv1authenticationsDeviceInformation - a model defined in Swagger
        """

        self._ip_address = None
        self._raw_data = None
        self._http_accept_browser_value = None
        self._http_accept_content = None
        self._user_agent_browser_value = None

        if ip_address is not None:
          self.ip_address = ip_address
        if raw_data is not None:
          self.raw_data = raw_data
        if http_accept_browser_value is not None:
          self.http_accept_browser_value = http_accept_browser_value
        if http_accept_content is not None:
          self.http_accept_content = http_accept_content
        if user_agent_browser_value is not None:
          self.user_agent_browser_value = user_agent_browser_value

    @property
    def ip_address(self):
        """
        Gets the ip_address of this Riskv1authenticationsDeviceInformation.
        IP address of the customer. 

        :return: The ip_address of this Riskv1authenticationsDeviceInformation.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this Riskv1authenticationsDeviceInformation.
        IP address of the customer. 

        :param ip_address: The ip_address of this Riskv1authenticationsDeviceInformation.
        :type: str
        """
        if ip_address is not None and len(ip_address) > 15:
            raise ValueError("Invalid value for `ip_address`, length must be less than or equal to `15`")

        self._ip_address = ip_address

    @property
    def raw_data(self):
        """
        Gets the raw_data of this Riskv1authenticationsDeviceInformation.

        :return: The raw_data of this Riskv1authenticationsDeviceInformation.
        :rtype: list[Riskv1authenticationsDeviceInformationRawData]
        """
        return self._raw_data

    @raw_data.setter
    def raw_data(self, raw_data):
        """
        Sets the raw_data of this Riskv1authenticationsDeviceInformation.

        :param raw_data: The raw_data of this Riskv1authenticationsDeviceInformation.
        :type: list[Riskv1authenticationsDeviceInformationRawData]
        """

        self._raw_data = raw_data

    @property
    def http_accept_browser_value(self):
        """
        Gets the http_accept_browser_value of this Riskv1authenticationsDeviceInformation.
        Value of the Accept header sent by the customer’s web browser. **Note** If the customer’s browser provides a value, you must include it in your request. 

        :return: The http_accept_browser_value of this Riskv1authenticationsDeviceInformation.
        :rtype: str
        """
        return self._http_accept_browser_value

    @http_accept_browser_value.setter
    def http_accept_browser_value(self, http_accept_browser_value):
        """
        Sets the http_accept_browser_value of this Riskv1authenticationsDeviceInformation.
        Value of the Accept header sent by the customer’s web browser. **Note** If the customer’s browser provides a value, you must include it in your request. 

        :param http_accept_browser_value: The http_accept_browser_value of this Riskv1authenticationsDeviceInformation.
        :type: str
        """
        if http_accept_browser_value is not None and len(http_accept_browser_value) > 255:
            raise ValueError("Invalid value for `http_accept_browser_value`, length must be less than or equal to `255`")

        self._http_accept_browser_value = http_accept_browser_value

    @property
    def http_accept_content(self):
        """
        Gets the http_accept_content of this Riskv1authenticationsDeviceInformation.
        The exact content of the HTTP accept header. 

        :return: The http_accept_content of this Riskv1authenticationsDeviceInformation.
        :rtype: str
        """
        return self._http_accept_content

    @http_accept_content.setter
    def http_accept_content(self, http_accept_content):
        """
        Sets the http_accept_content of this Riskv1authenticationsDeviceInformation.
        The exact content of the HTTP accept header. 

        :param http_accept_content: The http_accept_content of this Riskv1authenticationsDeviceInformation.
        :type: str
        """
        if http_accept_content is not None and len(http_accept_content) > 256:
            raise ValueError("Invalid value for `http_accept_content`, length must be less than or equal to `256`")

        self._http_accept_content = http_accept_content

    @property
    def user_agent_browser_value(self):
        """
        Gets the user_agent_browser_value of this Riskv1authenticationsDeviceInformation.
        Value of the User-Agent header sent by the customer’s web browser. Note If the customer’s browser provides a value, you must include it in your request. 

        :return: The user_agent_browser_value of this Riskv1authenticationsDeviceInformation.
        :rtype: str
        """
        return self._user_agent_browser_value

    @user_agent_browser_value.setter
    def user_agent_browser_value(self, user_agent_browser_value):
        """
        Sets the user_agent_browser_value of this Riskv1authenticationsDeviceInformation.
        Value of the User-Agent header sent by the customer’s web browser. Note If the customer’s browser provides a value, you must include it in your request. 

        :param user_agent_browser_value: The user_agent_browser_value of this Riskv1authenticationsDeviceInformation.
        :type: str
        """
        if user_agent_browser_value is not None and len(user_agent_browser_value) > 255:
            raise ValueError("Invalid value for `user_agent_browser_value`, length must be less than or equal to `255`")

        self._user_agent_browser_value = user_agent_browser_value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Riskv1authenticationsDeviceInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
