# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class PtsV2PaymentsPost201ResponseProcessorInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'auth_indicator': 'str',
        'approval_code': 'str',
        'transaction_id': 'str',
        'network_transaction_id': 'str',
        'provider_transaction_id': 'str',
        'response_code': 'str',
        'response_code_source': 'str',
        'response_details': 'str',
        'response_category_code': 'str',
        'forwarded_acquirer_code': 'str',
        'avs': 'PtsV2PaymentsPost201ResponseProcessorInformationAvs',
        'card_verification': 'PtsV2PaymentsPost201ResponseProcessorInformationCardVerification',
        'merchant_advice': 'PtsV2PaymentsPost201ResponseProcessorInformationMerchantAdvice',
        'electronic_verification_results': 'PtsV2PaymentsPost201ResponseProcessorInformationElectronicVerificationResults',
        'ach_verification': 'PtsV2PaymentsPost201ResponseProcessorInformationAchVerification',
        'customer': 'PtsV2PaymentsPost201ResponseProcessorInformationCustomer',
        'consumer_authentication_response': 'PtsV2PaymentsPost201ResponseProcessorInformationConsumerAuthenticationResponse',
        'system_trace_audit_number': 'str',
        'payment_account_reference_number': 'str',
        'transaction_integrity_code': 'str',
        'amex_verbal_auth_reference_number': 'str',
        'sales_slip_number': 'float',
        'master_card_service_code': 'str',
        'master_card_service_reply_code': 'str',
        'master_card_authentication_type': 'str',
        'name': 'str',
        'routing': 'PtsV2PaymentsPost201ResponseProcessorInformationRouting',
        'merchant_number': 'str'
    }

    attribute_map = {
        'auth_indicator': 'authIndicator',
        'approval_code': 'approvalCode',
        'transaction_id': 'transactionId',
        'network_transaction_id': 'networkTransactionId',
        'provider_transaction_id': 'providerTransactionId',
        'response_code': 'responseCode',
        'response_code_source': 'responseCodeSource',
        'response_details': 'responseDetails',
        'response_category_code': 'responseCategoryCode',
        'forwarded_acquirer_code': 'forwardedAcquirerCode',
        'avs': 'avs',
        'card_verification': 'cardVerification',
        'merchant_advice': 'merchantAdvice',
        'electronic_verification_results': 'electronicVerificationResults',
        'ach_verification': 'achVerification',
        'customer': 'customer',
        'consumer_authentication_response': 'consumerAuthenticationResponse',
        'system_trace_audit_number': 'systemTraceAuditNumber',
        'payment_account_reference_number': 'paymentAccountReferenceNumber',
        'transaction_integrity_code': 'transactionIntegrityCode',
        'amex_verbal_auth_reference_number': 'amexVerbalAuthReferenceNumber',
        'sales_slip_number': 'salesSlipNumber',
        'master_card_service_code': 'masterCardServiceCode',
        'master_card_service_reply_code': 'masterCardServiceReplyCode',
        'master_card_authentication_type': 'masterCardAuthenticationType',
        'name': 'name',
        'routing': 'routing',
        'merchant_number': 'merchantNumber'
    }

    def __init__(self, auth_indicator=None, approval_code=None, transaction_id=None, network_transaction_id=None, provider_transaction_id=None, response_code=None, response_code_source=None, response_details=None, response_category_code=None, forwarded_acquirer_code=None, avs=None, card_verification=None, merchant_advice=None, electronic_verification_results=None, ach_verification=None, customer=None, consumer_authentication_response=None, system_trace_audit_number=None, payment_account_reference_number=None, transaction_integrity_code=None, amex_verbal_auth_reference_number=None, sales_slip_number=None, master_card_service_code=None, master_card_service_reply_code=None, master_card_authentication_type=None, name=None, routing=None, merchant_number=None):
        """
        PtsV2PaymentsPost201ResponseProcessorInformation - a model defined in Swagger
        """

        self._auth_indicator = None
        self._approval_code = None
        self._transaction_id = None
        self._network_transaction_id = None
        self._provider_transaction_id = None
        self._response_code = None
        self._response_code_source = None
        self._response_details = None
        self._response_category_code = None
        self._forwarded_acquirer_code = None
        self._avs = None
        self._card_verification = None
        self._merchant_advice = None
        self._electronic_verification_results = None
        self._ach_verification = None
        self._customer = None
        self._consumer_authentication_response = None
        self._system_trace_audit_number = None
        self._payment_account_reference_number = None
        self._transaction_integrity_code = None
        self._amex_verbal_auth_reference_number = None
        self._sales_slip_number = None
        self._master_card_service_code = None
        self._master_card_service_reply_code = None
        self._master_card_authentication_type = None
        self._name = None
        self._routing = None
        self._merchant_number = None

        if auth_indicator is not None:
          self.auth_indicator = auth_indicator
        if approval_code is not None:
          self.approval_code = approval_code
        if transaction_id is not None:
          self.transaction_id = transaction_id
        if network_transaction_id is not None:
          self.network_transaction_id = network_transaction_id
        if provider_transaction_id is not None:
          self.provider_transaction_id = provider_transaction_id
        if response_code is not None:
          self.response_code = response_code
        if response_code_source is not None:
          self.response_code_source = response_code_source
        if response_details is not None:
          self.response_details = response_details
        if response_category_code is not None:
          self.response_category_code = response_category_code
        if forwarded_acquirer_code is not None:
          self.forwarded_acquirer_code = forwarded_acquirer_code
        if avs is not None:
          self.avs = avs
        if card_verification is not None:
          self.card_verification = card_verification
        if merchant_advice is not None:
          self.merchant_advice = merchant_advice
        if electronic_verification_results is not None:
          self.electronic_verification_results = electronic_verification_results
        if ach_verification is not None:
          self.ach_verification = ach_verification
        if customer is not None:
          self.customer = customer
        if consumer_authentication_response is not None:
          self.consumer_authentication_response = consumer_authentication_response
        if system_trace_audit_number is not None:
          self.system_trace_audit_number = system_trace_audit_number
        if payment_account_reference_number is not None:
          self.payment_account_reference_number = payment_account_reference_number
        if transaction_integrity_code is not None:
          self.transaction_integrity_code = transaction_integrity_code
        if amex_verbal_auth_reference_number is not None:
          self.amex_verbal_auth_reference_number = amex_verbal_auth_reference_number
        if sales_slip_number is not None:
          self.sales_slip_number = sales_slip_number
        if master_card_service_code is not None:
          self.master_card_service_code = master_card_service_code
        if master_card_service_reply_code is not None:
          self.master_card_service_reply_code = master_card_service_reply_code
        if master_card_authentication_type is not None:
          self.master_card_authentication_type = master_card_authentication_type
        if name is not None:
          self.name = name
        if routing is not None:
          self.routing = routing
        if merchant_number is not None:
          self.merchant_number = merchant_number

    @property
    def auth_indicator(self):
        """
        Gets the auth_indicator of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Flag that specifies the purpose of the authorization.  Possible values:  - **0**: Preauthorization  - **1**: Final authorization  For processor-specific information, see the auth_indicator field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :return: The auth_indicator of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._auth_indicator

    @auth_indicator.setter
    def auth_indicator(self, auth_indicator):
        """
        Sets the auth_indicator of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Flag that specifies the purpose of the authorization.  Possible values:  - **0**: Preauthorization  - **1**: Final authorization  For processor-specific information, see the auth_indicator field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :param auth_indicator: The auth_indicator of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if auth_indicator is not None and len(auth_indicator) > 1:
            raise ValueError("Invalid value for `auth_indicator`, length must be less than or equal to `1`")

        self._auth_indicator = auth_indicator

    @property
    def approval_code(self):
        """
        Gets the approval_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Authorization code. Returned only when the processor returns this value. 

        :return: The approval_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._approval_code

    @approval_code.setter
    def approval_code(self, approval_code):
        """
        Sets the approval_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Authorization code. Returned only when the processor returns this value. 

        :param approval_code: The approval_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """

        self._approval_code = approval_code

    @property
    def transaction_id(self):
        """
        Gets the transaction_id of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Network transaction identifier (TID). You can use this value to identify a specific transaction when you are discussing the transaction with your processor. Not all processors provide this value.  #### Cielo For Cielo, this value is the non-sequential unit (NSU) and is supported for all transactions. The value is generated by Cielo or the issuing bank.  #### Comercio Latino For Comercio Latino, this value is the proof of sale or non-sequential unit (NSU) number generated by the acquirers Cielo and Rede, or the issuing bank.  #### Visa Platform Connect and GPN For details about this value for Visa Platform Connect and GPN, see \"Network Transaction Identifiers\" in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/wwhelp/wwhimpl/js/html/wwhelp.htm) 

        :return: The transaction_id of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """
        Sets the transaction_id of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Network transaction identifier (TID). You can use this value to identify a specific transaction when you are discussing the transaction with your processor. Not all processors provide this value.  #### Cielo For Cielo, this value is the non-sequential unit (NSU) and is supported for all transactions. The value is generated by Cielo or the issuing bank.  #### Comercio Latino For Comercio Latino, this value is the proof of sale or non-sequential unit (NSU) number generated by the acquirers Cielo and Rede, or the issuing bank.  #### Visa Platform Connect and GPN For details about this value for Visa Platform Connect and GPN, see \"Network Transaction Identifiers\" in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/wwhelp/wwhimpl/js/html/wwhelp.htm) 

        :param transaction_id: The transaction_id of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if transaction_id is not None and len(transaction_id) > 50:
            raise ValueError("Invalid value for `transaction_id`, length must be less than or equal to `50`")

        self._transaction_id = transaction_id

    @property
    def network_transaction_id(self):
        """
        Gets the network_transaction_id of this PtsV2PaymentsPost201ResponseProcessorInformation.
        The description for this field is not available.

        :return: The network_transaction_id of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._network_transaction_id

    @network_transaction_id.setter
    def network_transaction_id(self, network_transaction_id):
        """
        Sets the network_transaction_id of this PtsV2PaymentsPost201ResponseProcessorInformation.
        The description for this field is not available.

        :param network_transaction_id: The network_transaction_id of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """

        self._network_transaction_id = network_transaction_id

    @property
    def provider_transaction_id(self):
        """
        Gets the provider_transaction_id of this PtsV2PaymentsPost201ResponseProcessorInformation.
        The description for this field is not available.

        :return: The provider_transaction_id of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._provider_transaction_id

    @provider_transaction_id.setter
    def provider_transaction_id(self, provider_transaction_id):
        """
        Sets the provider_transaction_id of this PtsV2PaymentsPost201ResponseProcessorInformation.
        The description for this field is not available.

        :param provider_transaction_id: The provider_transaction_id of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """

        self._provider_transaction_id = provider_transaction_id

    @property
    def response_code(self):
        """
        Gets the response_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        For most processors, this is the error message sent directly from the bank. Returned only when the processor returns this value.  **Important** Do not use this field to evaluate the result of the authorization.  #### AIBMS If this value is `08`, you can accept the transaction if the customer provides you with identification.  #### Atos This value is the response code sent from Atos and it might also include the response code from the bank. Format: `aa,bb` with the two values separated by a comma and where: - `aa` is the two-digit error message from Atos. - `bb` is the optional two-digit error message from the bank.  #### Comercio Latino This value is the status code and the error or response code received from the processor separated by a colon. Format: [status code]:E[error code] or [status code]:R[response code] Example `2:R06`  #### JCN Gateway Processor-defined detail error code. The associated response category code is in the `responseCategoryCode` field. 

        :return: The response_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._response_code

    @response_code.setter
    def response_code(self, response_code):
        """
        Sets the response_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        For most processors, this is the error message sent directly from the bank. Returned only when the processor returns this value.  **Important** Do not use this field to evaluate the result of the authorization.  #### AIBMS If this value is `08`, you can accept the transaction if the customer provides you with identification.  #### Atos This value is the response code sent from Atos and it might also include the response code from the bank. Format: `aa,bb` with the two values separated by a comma and where: - `aa` is the two-digit error message from Atos. - `bb` is the optional two-digit error message from the bank.  #### Comercio Latino This value is the status code and the error or response code received from the processor separated by a colon. Format: [status code]:E[error code] or [status code]:R[response code] Example `2:R06`  #### JCN Gateway Processor-defined detail error code. The associated response category code is in the `responseCategoryCode` field. 

        :param response_code: The response_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if response_code is not None and len(response_code) > 10:
            raise ValueError("Invalid value for `response_code`, length must be less than or equal to `10`")

        self._response_code = response_code

    @property
    def response_code_source(self):
        """
        Gets the response_code_source of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Used by Visa only and contains the response source/reason code that identifies the source of the response decision. 

        :return: The response_code_source of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._response_code_source

    @response_code_source.setter
    def response_code_source(self, response_code_source):
        """
        Sets the response_code_source of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Used by Visa only and contains the response source/reason code that identifies the source of the response decision. 

        :param response_code_source: The response_code_source of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if response_code_source is not None and len(response_code_source) > 1:
            raise ValueError("Invalid value for `response_code_source`, length must be less than or equal to `1`")

        self._response_code_source = response_code_source

    @property
    def response_details(self):
        """
        Gets the response_details of this PtsV2PaymentsPost201ResponseProcessorInformation.
        This field might contain information about a decline. This field is supported only for **CyberSource through VisaNet**. 

        :return: The response_details of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._response_details

    @response_details.setter
    def response_details(self, response_details):
        """
        Sets the response_details of this PtsV2PaymentsPost201ResponseProcessorInformation.
        This field might contain information about a decline. This field is supported only for **CyberSource through VisaNet**. 

        :param response_details: The response_details of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if response_details is not None and len(response_details) > 255:
            raise ValueError("Invalid value for `response_details`, length must be less than or equal to `255`")

        self._response_details = response_details

    @property
    def response_category_code(self):
        """
        Gets the response_category_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Processor-defined response category code. The associated detail error code is in the `responseCode` field of the service you requested.  This field is supported only for:   - Japanese issuers  - Domestic transactions in Japan  - Comercio Latino—processor transaction ID required for troubleshooting  **Maximum length for processors**:   - Comercio Latino: 32  - All other processors: 3 

        :return: The response_category_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._response_category_code

    @response_category_code.setter
    def response_category_code(self, response_category_code):
        """
        Sets the response_category_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Processor-defined response category code. The associated detail error code is in the `responseCode` field of the service you requested.  This field is supported only for:   - Japanese issuers  - Domestic transactions in Japan  - Comercio Latino—processor transaction ID required for troubleshooting  **Maximum length for processors**:   - Comercio Latino: 32  - All other processors: 3 

        :param response_category_code: The response_category_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if response_category_code is not None and len(response_category_code) > 32:
            raise ValueError("Invalid value for `response_category_code`, length must be less than or equal to `32`")

        self._response_category_code = response_category_code

    @property
    def forwarded_acquirer_code(self):
        """
        Gets the forwarded_acquirer_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Name of the Japanese acquirer that processed the transaction. Returned only for JCN Gateway. Please contact the CyberSource Japan Support Group for more information. 

        :return: The forwarded_acquirer_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._forwarded_acquirer_code

    @forwarded_acquirer_code.setter
    def forwarded_acquirer_code(self, forwarded_acquirer_code):
        """
        Sets the forwarded_acquirer_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Name of the Japanese acquirer that processed the transaction. Returned only for JCN Gateway. Please contact the CyberSource Japan Support Group for more information. 

        :param forwarded_acquirer_code: The forwarded_acquirer_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if forwarded_acquirer_code is not None and len(forwarded_acquirer_code) > 32:
            raise ValueError("Invalid value for `forwarded_acquirer_code`, length must be less than or equal to `32`")

        self._forwarded_acquirer_code = forwarded_acquirer_code

    @property
    def avs(self):
        """
        Gets the avs of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :return: The avs of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: PtsV2PaymentsPost201ResponseProcessorInformationAvs
        """
        return self._avs

    @avs.setter
    def avs(self, avs):
        """
        Sets the avs of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :param avs: The avs of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: PtsV2PaymentsPost201ResponseProcessorInformationAvs
        """

        self._avs = avs

    @property
    def card_verification(self):
        """
        Gets the card_verification of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :return: The card_verification of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: PtsV2PaymentsPost201ResponseProcessorInformationCardVerification
        """
        return self._card_verification

    @card_verification.setter
    def card_verification(self, card_verification):
        """
        Sets the card_verification of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :param card_verification: The card_verification of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: PtsV2PaymentsPost201ResponseProcessorInformationCardVerification
        """

        self._card_verification = card_verification

    @property
    def merchant_advice(self):
        """
        Gets the merchant_advice of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :return: The merchant_advice of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: PtsV2PaymentsPost201ResponseProcessorInformationMerchantAdvice
        """
        return self._merchant_advice

    @merchant_advice.setter
    def merchant_advice(self, merchant_advice):
        """
        Sets the merchant_advice of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :param merchant_advice: The merchant_advice of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: PtsV2PaymentsPost201ResponseProcessorInformationMerchantAdvice
        """

        self._merchant_advice = merchant_advice

    @property
    def electronic_verification_results(self):
        """
        Gets the electronic_verification_results of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :return: The electronic_verification_results of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: PtsV2PaymentsPost201ResponseProcessorInformationElectronicVerificationResults
        """
        return self._electronic_verification_results

    @electronic_verification_results.setter
    def electronic_verification_results(self, electronic_verification_results):
        """
        Sets the electronic_verification_results of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :param electronic_verification_results: The electronic_verification_results of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: PtsV2PaymentsPost201ResponseProcessorInformationElectronicVerificationResults
        """

        self._electronic_verification_results = electronic_verification_results

    @property
    def ach_verification(self):
        """
        Gets the ach_verification of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :return: The ach_verification of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: PtsV2PaymentsPost201ResponseProcessorInformationAchVerification
        """
        return self._ach_verification

    @ach_verification.setter
    def ach_verification(self, ach_verification):
        """
        Sets the ach_verification of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :param ach_verification: The ach_verification of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: PtsV2PaymentsPost201ResponseProcessorInformationAchVerification
        """

        self._ach_verification = ach_verification

    @property
    def customer(self):
        """
        Gets the customer of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :return: The customer of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: PtsV2PaymentsPost201ResponseProcessorInformationCustomer
        """
        return self._customer

    @customer.setter
    def customer(self, customer):
        """
        Sets the customer of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :param customer: The customer of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: PtsV2PaymentsPost201ResponseProcessorInformationCustomer
        """

        self._customer = customer

    @property
    def consumer_authentication_response(self):
        """
        Gets the consumer_authentication_response of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :return: The consumer_authentication_response of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: PtsV2PaymentsPost201ResponseProcessorInformationConsumerAuthenticationResponse
        """
        return self._consumer_authentication_response

    @consumer_authentication_response.setter
    def consumer_authentication_response(self, consumer_authentication_response):
        """
        Sets the consumer_authentication_response of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :param consumer_authentication_response: The consumer_authentication_response of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: PtsV2PaymentsPost201ResponseProcessorInformationConsumerAuthenticationResponse
        """

        self._consumer_authentication_response = consumer_authentication_response

    @property
    def system_trace_audit_number(self):
        """
        Gets the system_trace_audit_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        This field is returned only for **American Express Direct** and **Visa Platform Connect**.  #### American Express Direct  System trace audit number (STAN). This value identifies the transaction and is useful when investigating a chargeback dispute.  #### Visa Platform Connect  System trace number that must be printed on the customer’s receipt.  For details, see `receipt_number` field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/wwhelp/wwhimpl/js/html/wwhelp.htm) 

        :return: The system_trace_audit_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._system_trace_audit_number

    @system_trace_audit_number.setter
    def system_trace_audit_number(self, system_trace_audit_number):
        """
        Sets the system_trace_audit_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        This field is returned only for **American Express Direct** and **Visa Platform Connect**.  #### American Express Direct  System trace audit number (STAN). This value identifies the transaction and is useful when investigating a chargeback dispute.  #### Visa Platform Connect  System trace number that must be printed on the customer’s receipt.  For details, see `receipt_number` field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/wwhelp/wwhimpl/js/html/wwhelp.htm) 

        :param system_trace_audit_number: The system_trace_audit_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if system_trace_audit_number is not None and len(system_trace_audit_number) > 6:
            raise ValueError("Invalid value for `system_trace_audit_number`, length must be less than or equal to `6`")

        self._system_trace_audit_number = system_trace_audit_number

    @property
    def payment_account_reference_number(self):
        """
        Gets the payment_account_reference_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Visa-generated reference number that identifies a card-present transaction for which you provided one of the following:   - Visa primary account number (PAN)  - Visa-generated token for a PAN  This reference number serves as a link to the cardholder account and to all transactions for that account. 

        :return: The payment_account_reference_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._payment_account_reference_number

    @payment_account_reference_number.setter
    def payment_account_reference_number(self, payment_account_reference_number):
        """
        Sets the payment_account_reference_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Visa-generated reference number that identifies a card-present transaction for which you provided one of the following:   - Visa primary account number (PAN)  - Visa-generated token for a PAN  This reference number serves as a link to the cardholder account and to all transactions for that account. 

        :param payment_account_reference_number: The payment_account_reference_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if payment_account_reference_number is not None and len(payment_account_reference_number) > 32:
            raise ValueError("Invalid value for `payment_account_reference_number`, length must be less than or equal to `32`")

        self._payment_account_reference_number = payment_account_reference_number

    @property
    def transaction_integrity_code(self):
        """
        Gets the transaction_integrity_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Transaction integrity classification provided by Mastercard. This value specifies Mastercard’s evaluation of the transaction’s safety and security. This field is returned only for **Visa Platform Connect**.  For card-present transactions, possible values:   - `A1`: EMV or token in a secure, trusted environment  - `B1`: EMV or chip equivalent  - `C1`: Magnetic stripe  - `E1`: Key entered  - `U0`: Unclassified  For card-not-present transactions, possible values:   - `A2`: Digital transactions  - `B2`: Authenticated checkout  - `C2`: Transaction validation  - `D2`: Enhanced data  - `E2`: Generic messaging  - `U0`: Unclassified  For information about these values, contact Mastercard or your acquirer.  #### Visa Platform Connect  The value for this field corresponds to the following data in the TC 33 capture file,<sup>1</sup>: - Record: CP01 TCR6 - Position: 136-137 - Field: Mastercard Transaction Integrity Classification  <sup>1</sup> The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. Visa Platform Connect creates the TC 33 Capture file at the end of the day and sends it to the merchant’s acquirer, who uses this information to facilitate end-of-day clearing processing with payment networks. 

        :return: The transaction_integrity_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._transaction_integrity_code

    @transaction_integrity_code.setter
    def transaction_integrity_code(self, transaction_integrity_code):
        """
        Sets the transaction_integrity_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Transaction integrity classification provided by Mastercard. This value specifies Mastercard’s evaluation of the transaction’s safety and security. This field is returned only for **Visa Platform Connect**.  For card-present transactions, possible values:   - `A1`: EMV or token in a secure, trusted environment  - `B1`: EMV or chip equivalent  - `C1`: Magnetic stripe  - `E1`: Key entered  - `U0`: Unclassified  For card-not-present transactions, possible values:   - `A2`: Digital transactions  - `B2`: Authenticated checkout  - `C2`: Transaction validation  - `D2`: Enhanced data  - `E2`: Generic messaging  - `U0`: Unclassified  For information about these values, contact Mastercard or your acquirer.  #### Visa Platform Connect  The value for this field corresponds to the following data in the TC 33 capture file,<sup>1</sup>: - Record: CP01 TCR6 - Position: 136-137 - Field: Mastercard Transaction Integrity Classification  <sup>1</sup> The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. Visa Platform Connect creates the TC 33 Capture file at the end of the day and sends it to the merchant’s acquirer, who uses this information to facilitate end-of-day clearing processing with payment networks. 

        :param transaction_integrity_code: The transaction_integrity_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if transaction_integrity_code is not None and len(transaction_integrity_code) > 2:
            raise ValueError("Invalid value for `transaction_integrity_code`, length must be less than or equal to `2`")

        self._transaction_integrity_code = transaction_integrity_code

    @property
    def amex_verbal_auth_reference_number(self):
        """
        Gets the amex_verbal_auth_reference_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Referral response number for a verbal authorization with FDMS Nashville when using an American Express card. Give this number to American Express when you call them for the verbal authorization. 

        :return: The amex_verbal_auth_reference_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._amex_verbal_auth_reference_number

    @amex_verbal_auth_reference_number.setter
    def amex_verbal_auth_reference_number(self, amex_verbal_auth_reference_number):
        """
        Sets the amex_verbal_auth_reference_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Referral response number for a verbal authorization with FDMS Nashville when using an American Express card. Give this number to American Express when you call them for the verbal authorization. 

        :param amex_verbal_auth_reference_number: The amex_verbal_auth_reference_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if amex_verbal_auth_reference_number is not None and len(amex_verbal_auth_reference_number) > 6:
            raise ValueError("Invalid value for `amex_verbal_auth_reference_number`, length must be less than or equal to `6`")

        self._amex_verbal_auth_reference_number = amex_verbal_auth_reference_number

    @property
    def sales_slip_number(self):
        """
        Gets the sales_slip_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Transaction identifier that CyberSource generates. You have the option of printing the sales slip number on the receipt.  This field is supported only for **JCN Gateway**. 

        :return: The sales_slip_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: float
        """
        return self._sales_slip_number

    @sales_slip_number.setter
    def sales_slip_number(self, sales_slip_number):
        """
        Sets the sales_slip_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Transaction identifier that CyberSource generates. You have the option of printing the sales slip number on the receipt.  This field is supported only for **JCN Gateway**. 

        :param sales_slip_number: The sales_slip_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: float
        """
        if sales_slip_number is not None and sales_slip_number > 99999:
            raise ValueError("Invalid value for `sales_slip_number`, must be a value less than or equal to `99999`")

        self._sales_slip_number = sales_slip_number

    @property
    def master_card_service_code(self):
        """
        Gets the master_card_service_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Mastercard service that was used for the transaction. Mastercard provides this value to CyberSource.  Possible value:  - 53: Mastercard card-on-file token service  #### Visa Platform Connect The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 133-134 - Field: Mastercard Merchant on-behalf service. **Note** This field is returned only for Visa Platform Connect. 

        :return: The master_card_service_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._master_card_service_code

    @master_card_service_code.setter
    def master_card_service_code(self, master_card_service_code):
        """
        Sets the master_card_service_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Mastercard service that was used for the transaction. Mastercard provides this value to CyberSource.  Possible value:  - 53: Mastercard card-on-file token service  #### Visa Platform Connect The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 133-134 - Field: Mastercard Merchant on-behalf service. **Note** This field is returned only for Visa Platform Connect. 

        :param master_card_service_code: The master_card_service_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if master_card_service_code is not None and len(master_card_service_code) > 2:
            raise ValueError("Invalid value for `master_card_service_code`, length must be less than or equal to `2`")

        self._master_card_service_code = master_card_service_code

    @property
    def master_card_service_reply_code(self):
        """
        Gets the master_card_service_reply_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Result of the Mastercard card-on-file token service. Mastercard provides this value to CyberSource.  Possible values:   - `C`: Service completed successfully.  - `F`: One of the following:    - Incorrect Mastercard POS entry mode. The Mastercard POS entry mode should be 81 for an authorization or      authorization reversal.    - Incorrect Mastercard POS entry mode. The Mastercard POS entry mode should be 01 for a tokenized request.    - Token requestor ID is missing or formatted incorrectly.  - `I`: One of the following:    - Invalid token requestor ID.    - Suspended or deactivated token.    - Invalid token (not in mapping table).  - `T`: Invalid combination of token requestor ID and token.  - `U`: Expired token.  - `W`: Primary account number (PAN) listed in electronic warning bulletin.  **Note** This field is returned only for **Visa Platform Connect**. 

        :return: The master_card_service_reply_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._master_card_service_reply_code

    @master_card_service_reply_code.setter
    def master_card_service_reply_code(self, master_card_service_reply_code):
        """
        Sets the master_card_service_reply_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Result of the Mastercard card-on-file token service. Mastercard provides this value to CyberSource.  Possible values:   - `C`: Service completed successfully.  - `F`: One of the following:    - Incorrect Mastercard POS entry mode. The Mastercard POS entry mode should be 81 for an authorization or      authorization reversal.    - Incorrect Mastercard POS entry mode. The Mastercard POS entry mode should be 01 for a tokenized request.    - Token requestor ID is missing or formatted incorrectly.  - `I`: One of the following:    - Invalid token requestor ID.    - Suspended or deactivated token.    - Invalid token (not in mapping table).  - `T`: Invalid combination of token requestor ID and token.  - `U`: Expired token.  - `W`: Primary account number (PAN) listed in electronic warning bulletin.  **Note** This field is returned only for **Visa Platform Connect**. 

        :param master_card_service_reply_code: The master_card_service_reply_code of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if master_card_service_reply_code is not None and len(master_card_service_reply_code) > 1:
            raise ValueError("Invalid value for `master_card_service_reply_code`, length must be less than or equal to `1`")

        self._master_card_service_reply_code = master_card_service_reply_code

    @property
    def master_card_authentication_type(self):
        """
        Gets the master_card_authentication_type of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Type of authentication for which the transaction qualifies as determined by the Mastercard authentication service, which confirms the identity of the cardholder. Mastercard provides this value to CyberSource.  Possible values:   - `1`: Transaction qualifies for Mastercard authentication type 1.  - `2`: Transaction qualifies for Mastercard authentication type 2.  #### Visa Platform Connect The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 132 - Field: Mastercard Member Defined service. **Note** This field is returned only for Visa Platform Connect. 

        :return: The master_card_authentication_type of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._master_card_authentication_type

    @master_card_authentication_type.setter
    def master_card_authentication_type(self, master_card_authentication_type):
        """
        Sets the master_card_authentication_type of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Type of authentication for which the transaction qualifies as determined by the Mastercard authentication service, which confirms the identity of the cardholder. Mastercard provides this value to CyberSource.  Possible values:   - `1`: Transaction qualifies for Mastercard authentication type 1.  - `2`: Transaction qualifies for Mastercard authentication type 2.  #### Visa Platform Connect The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 132 - Field: Mastercard Member Defined service. **Note** This field is returned only for Visa Platform Connect. 

        :param master_card_authentication_type: The master_card_authentication_type of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if master_card_authentication_type is not None and len(master_card_authentication_type) > 1:
            raise ValueError("Invalid value for `master_card_authentication_type`, length must be less than or equal to `1`")

        self._master_card_authentication_type = master_card_authentication_type

    @property
    def name(self):
        """
        Gets the name of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Name of the Processor. 

        :return: The name of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Name of the Processor. 

        :param name: The name of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if name is not None and len(name) > 30:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `30`")

        self._name = name

    @property
    def routing(self):
        """
        Gets the routing of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :return: The routing of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: PtsV2PaymentsPost201ResponseProcessorInformationRouting
        """
        return self._routing

    @routing.setter
    def routing(self, routing):
        """
        Sets the routing of this PtsV2PaymentsPost201ResponseProcessorInformation.

        :param routing: The routing of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: PtsV2PaymentsPost201ResponseProcessorInformationRouting
        """

        self._routing = routing

    @property
    def merchant_number(self):
        """
        Gets the merchant_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Identifier that was assigned to you by your acquirer.  This value must be printed on the receipt.  This field is supported only on **American Express Direct**, **FDC Nashville Global**, and **SIX**. 

        :return: The merchant_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :rtype: str
        """
        return self._merchant_number

    @merchant_number.setter
    def merchant_number(self, merchant_number):
        """
        Sets the merchant_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        Identifier that was assigned to you by your acquirer.  This value must be printed on the receipt.  This field is supported only on **American Express Direct**, **FDC Nashville Global**, and **SIX**. 

        :param merchant_number: The merchant_number of this PtsV2PaymentsPost201ResponseProcessorInformation.
        :type: str
        """
        if merchant_number is not None and len(merchant_number) > 15:
            raise ValueError("Invalid value for `merchant_number`, length must be less than or equal to `15`")

        self._merchant_number = merchant_number

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PtsV2PaymentsPost201ResponseProcessorInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
