# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    IPG Cashier Pay API

    API for enabling the user to make payment from merchant's platform with redirecting to DANA's platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from dana.ipg.v1.models.money import Money
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class AmountDetail(BaseModel, BaseSdkModel):
    """
    AmountDetail
    """ # noqa: E501
    order_amount: Money = Field(description="Order amount. Contains two sub-fields:<br> 1. Value: Transaction amount, including the cents<br> 2. Currency: Currency code based on ISO<br> ")
    pay_amount: Optional[Money] = Field(default=None, description="Pay amount. Contains two sub-fields:<br> 1. Value: Transaction amount, including the cents<br> 2. Currency: Currency code based on ISO<br> ")
    void_amount: Optional[Money] = Field(default=None, description="Void amount. Contains two sub-fields:<br> 1. Value: Transaction amount, including the cents<br> 2. Currency: Currency code based on ISO<br> ")
    confirm_amount: Optional[Money] = Field(default=None, description="Confirm amount. Contains two sub-fields:<br> 1. Value: Transaction amount, including the cents<br> 2. Currency: Currency code based on ISO<br> ")
    refund_amount: Optional[Money] = Field(default=None, description="Refund amount. Contains two sub-fields:<br> 1. Value: Transaction amount, including the cents<br> 2. Currency: Currency code based on ISO<br> ")
    chargeback_amount: Optional[Money] = Field(default=None, description="Chargeback amount. Contains two sub-fields:<br> 1. Value: Transaction amount, including the cents<br> 2. Currency: Currency code based on ISO<br> ")
    charge_amount: Optional[Money] = Field(default=None, description="Charge amount. Contains two sub-fields:<br> 1. Value: Transaction amount, including the cents<br> 2. Currency: Currency code based on ISO<br> ")
    __properties: ClassVar[List[str]] = ["orderAmount", "payAmount", "voidAmount", "confirmAmount", "refundAmount", "chargebackAmount", "chargeAmount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AmountDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of order_amount
        if self.order_amount:
            _dict['orderAmount'] = self.order_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pay_amount
        if self.pay_amount:
            _dict['payAmount'] = self.pay_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of void_amount
        if self.void_amount:
            _dict['voidAmount'] = self.void_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of confirm_amount
        if self.confirm_amount:
            _dict['confirmAmount'] = self.confirm_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of refund_amount
        if self.refund_amount:
            _dict['refundAmount'] = self.refund_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of chargeback_amount
        if self.chargeback_amount:
            _dict['chargebackAmount'] = self.chargeback_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of charge_amount
        if self.charge_amount:
            _dict['chargeAmount'] = self.charge_amount.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AmountDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderAmount": Money.from_dict(obj["orderAmount"]) if obj.get("orderAmount") is not None else None,
            "payAmount": Money.from_dict(obj["payAmount"]) if obj.get("payAmount") is not None else None,
            "voidAmount": Money.from_dict(obj["voidAmount"]) if obj.get("voidAmount") is not None else None,
            "confirmAmount": Money.from_dict(obj["confirmAmount"]) if obj.get("confirmAmount") is not None else None,
            "refundAmount": Money.from_dict(obj["refundAmount"]) if obj.get("refundAmount") is not None else None,
            "chargebackAmount": Money.from_dict(obj["chargebackAmount"]) if obj.get("chargebackAmount") is not None else None,
            "chargeAmount": Money.from_dict(obj["chargeAmount"]) if obj.get("chargeAmount") is not None else None
        })
        return _obj


