# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    IPG Cashier Pay API

    API for enabling the user to make payment from merchant's platform with redirecting to DANA's platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from dana.ipg.v1.models.international_order_info_exchange_rate import InternationalOrderInfoExchangeRate
from dana.ipg.v1.models.money import Money
from dana.ipg.v1.models.payment_promo_info import PaymentPromoInfo
from dana.ipg.v1.models.refund_promo_info import RefundPromoInfo
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class InternationalOrderInfo(BaseModel, BaseSdkModel):
    """
    Additional information for international orders (non-IDR currency transactions)
    """ # noqa: E501
    origin_order_amount: Optional[Money] = Field(default=None, description="Origin order amount in the original currency. Contains value (amount including cents) and currency (code based on ISO)")
    exchange_rate: Optional[InternationalOrderInfoExchangeRate] = Field(default=None)
    total_amount: Optional[Money] = Field(default=None, description="Total amount after conversion. Contains value (amount including cents) and currency (code based on ISO)")
    payment_promo_info: Optional[PaymentPromoInfo] = Field(default=None, description="Define the detail of payment promo information, contains promotion that handled and set by merchant")
    refund_promo_info: Optional[RefundPromoInfo] = Field(default=None, description="Define the detail of refund promo information")
    __properties: ClassVar[List[str]] = ["originOrderAmount", "exchangeRate", "totalAmount", "paymentPromoInfo", "refundPromoInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InternationalOrderInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of origin_order_amount
        if self.origin_order_amount:
            _dict['originOrderAmount'] = self.origin_order_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of exchange_rate
        if self.exchange_rate:
            _dict['exchangeRate'] = self.exchange_rate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total_amount
        if self.total_amount:
            _dict['totalAmount'] = self.total_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payment_promo_info
        if self.payment_promo_info:
            _dict['paymentPromoInfo'] = self.payment_promo_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of refund_promo_info
        if self.refund_promo_info:
            _dict['refundPromoInfo'] = self.refund_promo_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InternationalOrderInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "originOrderAmount": Money.from_dict(obj["originOrderAmount"]) if obj.get("originOrderAmount") is not None else None,
            "exchangeRate": InternationalOrderInfoExchangeRate.from_dict(obj["exchangeRate"]) if obj.get("exchangeRate") is not None else None,
            "totalAmount": Money.from_dict(obj["totalAmount"]) if obj.get("totalAmount") is not None else None,
            "paymentPromoInfo": PaymentPromoInfo.from_dict(obj["paymentPromoInfo"]) if obj.get("paymentPromoInfo") is not None else None,
            "refundPromoInfo": RefundPromoInfo.from_dict(obj["refundPromoInfo"]) if obj.get("refundPromoInfo") is not None else None
        })
        return _obj


