# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    IPG Cashier Pay API

    API for enabling the user to make payment from merchant's platform with redirecting to DANA's platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from dana.ipg.v1.models.amount_detail import AmountDetail
from dana.ipg.v1.models.buyer import Buyer
from dana.ipg.v1.models.goods import Goods
from dana.ipg.v1.models.payment_view import PaymentView
from dana.ipg.v1.models.seller import Seller
from dana.ipg.v1.models.shipping_info import ShippingInfo
from dana.ipg.v1.models.status_detail import StatusDetail
from dana.ipg.v1.models.time_detail import TimeDetail
from dana.ipg.v1.models.virtual_account_info import VirtualAccountInfo
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class QueryPaymentResponseAdditionalInfo(BaseModel, BaseSdkModel):
    """
    QueryPaymentResponseAdditionalInfo
    """ # noqa: E501
    merchant_id: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Merchant identifier")
    buyer: Optional[Buyer] = None
    seller: Optional[Seller] = None
    amount_detail: Optional[AmountDetail] = Field(default=None)
    time_detail: Optional[TimeDetail] = Field(default=None)
    goods: Optional[List[Goods]] = Field(default=None, description="Additional information of goods")
    shipping_info: Optional[List[ShippingInfo]] = Field(default=None, description="Additional information of shipping")
    order_memo: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of memo")
    payment_views: Optional[List[PaymentView]] = Field(default=None, description="Additional information of payment views")
    extend_info: Optional[Annotated[str, Field(strict=True, max_length=4096)]] = Field(default=None, description="Additional information of extend")
    status_detail: Optional[StatusDetail] = Field(default=None)
    close_reason: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, description="Additional information of close reason")
    virtual_account_info: Optional[VirtualAccountInfo] = Field(default=None)
    __properties: ClassVar[List[str]] = ["merchantId", "buyer", "seller", "amountDetail", "timeDetail", "goods", "shippingInfo", "orderMemo", "paymentViews", "extendInfo", "statusDetail", "closeReason", "virtualAccountInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QueryPaymentResponseAdditionalInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of buyer
        if self.buyer:
            _dict['buyer'] = self.buyer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of seller
        if self.seller:
            _dict['seller'] = self.seller.to_dict()
        # override the default output from pydantic by calling `to_dict()` of amount_detail
        if self.amount_detail:
            _dict['amountDetail'] = self.amount_detail.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time_detail
        if self.time_detail:
            _dict['timeDetail'] = self.time_detail.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in goods (list)
        _items = []
        if self.goods:
            for _item_goods in self.goods:
                if _item_goods:
                    _items.append(_item_goods.to_dict())
            _dict['goods'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shipping_info (list)
        _items = []
        if self.shipping_info:
            for _item_shipping_info in self.shipping_info:
                if _item_shipping_info:
                    _items.append(_item_shipping_info.to_dict())
            _dict['shippingInfo'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payment_views (list)
        _items = []
        if self.payment_views:
            for _item_payment_views in self.payment_views:
                if _item_payment_views:
                    _items.append(_item_payment_views.to_dict())
            _dict['paymentViews'] = _items
        # override the default output from pydantic by calling `to_dict()` of status_detail
        if self.status_detail:
            _dict['statusDetail'] = self.status_detail.to_dict()
        # override the default output from pydantic by calling `to_dict()` of virtual_account_info
        if self.virtual_account_info:
            _dict['virtualAccountInfo'] = self.virtual_account_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QueryPaymentResponseAdditionalInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "merchantId": obj.get("merchantId"),
            "buyer": Buyer.from_dict(obj["buyer"]) if obj.get("buyer") is not None else None,
            "seller": Seller.from_dict(obj["seller"]) if obj.get("seller") is not None else None,
            "amountDetail": AmountDetail.from_dict(obj["amountDetail"]) if obj.get("amountDetail") is not None else None,
            "timeDetail": TimeDetail.from_dict(obj["timeDetail"]) if obj.get("timeDetail") is not None else None,
            "goods": [Goods.from_dict(_item) for _item in obj["goods"]] if obj.get("goods") is not None else None,
            "shippingInfo": [ShippingInfo.from_dict(_item) for _item in obj["shippingInfo"]] if obj.get("shippingInfo") is not None else None,
            "orderMemo": obj.get("orderMemo"),
            "paymentViews": [PaymentView.from_dict(_item) for _item in obj["paymentViews"]] if obj.get("paymentViews") is not None else None,
            "extendInfo": obj.get("extendInfo"),
            "statusDetail": StatusDetail.from_dict(obj["statusDetail"]) if obj.get("statusDetail") is not None else None,
            "closeReason": obj.get("closeReason"),
            "virtualAccountInfo": VirtualAccountInfo.from_dict(obj["virtualAccountInfo"]) if obj.get("virtualAccountInfo") is not None else None
        })
        return _obj


