# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Disbursement API

    API for doing disbursement operations in DANA, including DANA account inquiry, transfer to DANA, and transfer to bank disbursement

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field, StrictBool, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class TransferToBankRequestAdditionalInfo(BaseModel, BaseSdkModel):
    """
    Additional information
    """ # noqa: E501
    fund_type: Annotated[str, Field(strict=True, max_length=64)] = Field(description="Additional information of withdraw fund type, i.e.<br> MERCHANT_WITHDRAW_FOR_CORPORATE ")
    external_division_id: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of external division identifier. (fundType: MERCHANT_WITHDRAW_FOR_CORPORATE)<br> Notes: The required of this parameter is Optional, but if \"additionalInfo.chargeTarget\" has value DIVISION then the required of this parameter will be changed to Mandatory ")
    charge_target: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of charge target. The values are:<br> • null<br> • DIVISION<br> • MERCHANT<br> Notes: If the value is DIVISION, externalDivisionId will be Mandatory ")
    need_notify: Optional[StrictBool] = Field(default=None, description="Additional information of flag result notification on transaction completed (result sync/async)")
    beneficiary_account_name: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of beneficiary account name for validation purpose")
    access_token: Optional[Annotated[str, Field(strict=True, max_length=512)]] = Field(default=None, description="Contains customer token, which has been obtained from binding process, refer to Account Binding & Unbinding documentation<br> If request is coming from user interaction, this field is mandatory. If not, just filled customerNumber ")
    __properties: ClassVar[List[str]] = ["fundType", "externalDivisionId", "chargeTarget", "needNotify", "beneficiaryAccountName", "accessToken"]

    @field_validator('charge_target')
    def charge_target_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DIVISION', 'MERCHANT']):
            raise ValueError("must be one of enum values ('DIVISION', 'MERCHANT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransferToBankRequestAdditionalInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransferToBankRequestAdditionalInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fundType": obj.get("fundType"),
            "externalDivisionId": obj.get("externalDivisionId"),
            "chargeTarget": obj.get("chargeTarget"),
            "needNotify": obj.get("needNotify"),
            "beneficiaryAccountName": obj.get("beneficiaryAccountName"),
            "accessToken": obj.get("accessToken")
        })
        return _obj


