# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Merchant Management API

    API for merchant management operations in DANA

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class CreateDivisionRequestExtInfo(BaseModel, BaseSdkModel):
    """
    Extended information
    """ # noqa: E501
    pic_email: Optional[StrictStr] = Field(default=None, description="PIC email address")
    pic_phonenumber: Optional[StrictStr] = Field(default=None, description="PIC phone number")
    submitter_email: Optional[StrictStr] = Field(default=None, description="Submitter email address")
    goods_sold_type: Optional[StrictStr] = Field(default=None, description="Type of goods sold")
    usecase: Optional[StrictStr] = Field(default=None, description="Use case type")
    user_profiling: Optional[StrictStr] = Field(default=None, description="User profiling type")
    avg_ticket: Optional[StrictStr] = Field(default=None, description="Average ticket size")
    omzet: Optional[StrictStr] = Field(default=None, description="Revenue range")
    ext_urls: Optional[StrictStr] = Field(default=None, description="External URLs")
    brand_name: Optional[StrictStr] = Field(default=None, description="Brand name")
    __properties: ClassVar[List[str]] = ["PIC_EMAIL", "PIC_PHONENUMBER", "SUBMITTER_EMAIL", "GOODS_SOLD_TYPE", "USECASE", "USER_PROFILING", "AVG_TICKET", "OMZET", "EXT_URLS", "BRAND_NAME"]

    @field_validator('goods_sold_type')
    def goods_sold_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DIGITAL', 'PHYSICAL']):
            raise ValueError("must be one of enum values ('DIGITAL', 'PHYSICAL')")
        return value

    @field_validator('user_profiling')
    def user_profiling_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['B2B', 'B2C']):
            raise ValueError("must be one of enum values ('B2B', 'B2C')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateDivisionRequestExtInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateDivisionRequestExtInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            # If it's a string (JSON), try to parse it
            if isinstance(obj, str):
                try:
                    obj = json.loads(obj)
                except json.JSONDecodeError:
                    return cls.model_validate(obj)
            else:
                return cls.model_validate(obj)

        
        # Handle OPEN_API nested response format: {"response": {"head": {...}, "body": {...}}}
        # Check if this is a response model and has nested structure
        if "CreateDivisionRequestExtInfo".endswith("Response") and "response" in obj and "body" in obj["response"]:
            # For OPEN_API nested format, pass the nested response structure directly
            _obj = cls.model_validate({
                "PIC_EMAIL": obj.get("PIC_EMAIL"),
                           "picEmail": obj.get("picEmail"),
            "picPhonenumber": obj.get("picPhonenumber"),
            "submitterEmail": obj.get("submitterEmail"),
            "goodsSoldType": obj.get("goodsSoldType"),
            "usecase": obj.get("usecase"),
            "userProfiling": obj.get("userProfiling"),
            "avgTicket": obj.get("avgTicket"),
            "omzet": obj.get("omzet"),
            "extUrls": obj.get("extUrls"),
            "brandName": obj.get("brandName"),
"PIC_PHONENUMBER": obj.get("PIC_PHONENUMBER"),
                "SUBMITTER_EMAIL": obj.get("SUBMITTER_EMAIL"),
                "GOODS_SOLD_TYPE": obj.get("GOODS_SOLD_TYPE"),
                "USECASE": obj.get("USECASE"),
                "USER_PROFILING": obj.get("USER_PROFILING"),
                "AVG_TICKET": obj.get("AVG_TICKET"),
                "OMZET": obj.get("OMZET"),
                "EXT_URLS": obj.get("EXT_URLS"),
                "BRAND_NAME": obj.get("BRAND_NAME")
            })
        else:
            # For flat format, pass the object as-is
            _obj = cls.model_validate({
                "PIC_EMAIL": obj.get("PIC_EMAIL"),
                           "picEmail": obj.get("picEmail"),
            "picPhonenumber": obj.get("picPhonenumber"),
            "submitterEmail": obj.get("submitterEmail"),
            "goodsSoldType": obj.get("goodsSoldType"),
            "usecase": obj.get("usecase"),
            "userProfiling": obj.get("userProfiling"),
            "avgTicket": obj.get("avgTicket"),
            "omzet": obj.get("omzet"),
            "extUrls": obj.get("extUrls"),
            "brandName": obj.get("brandName"),
"PIC_PHONENUMBER": obj.get("PIC_PHONENUMBER"),
                "SUBMITTER_EMAIL": obj.get("SUBMITTER_EMAIL"),
                "GOODS_SOLD_TYPE": obj.get("GOODS_SOLD_TYPE"),
                "USECASE": obj.get("USECASE"),
                "USER_PROFILING": obj.get("USER_PROFILING"),
                "AVG_TICKET": obj.get("AVG_TICKET"),
                "OMZET": obj.get("OMZET"),
                "EXT_URLS": obj.get("EXT_URLS"),
                "BRAND_NAME": obj.get("BRAND_NAME")
            })
        
        return _obj


