# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Merchant Management API

    API for merchant management operations in DANA

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from dana.merchant_management.v1.models.address_info import AddressInfo
from dana.merchant_management.v1.models.business_docs import BusinessDocs
from dana.merchant_management.v1.models.mobile_no_info import MobileNoInfo
from dana.merchant_management.v1.models.pic_info import PicInfo
from dana.merchant_management.v1.models.user_name import UserName
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class UpdateShopRequest(BaseModel, BaseSdkModel):
    """
    UpdateShopRequest
    """ # noqa: E501
    shop_id: StrictStr = Field(description="Shop identifier. Length depends on shopIdType - INNER_ID (21 max), EXTERNAL_ID (64 max)")
    merchant_id: Annotated[str, Field(strict=True, max_length=21)] = Field(description="Merchant identifier")
    shop_id_type: StrictStr = Field(description="Shop identifier type")
    main_name: Optional[Annotated[str, Field(strict=True, max_length=256)]] = Field(default=None, description="Shop name")
    shop_address: AddressInfo = Field()
    shop_desc: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = Field(default=None, description="Shop description")
    new_external_shop_id: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="New external shop identifier")
    mcc_codes: Optional[List[StrictStr]] = Field(default=None, description="Merchant category code")
    logo_url_map: Optional[Dict[str, StrictStr]] = Field(default=None, description="Logo URL map with base64 encoded images. Keys can be LOGO, PC_LOGO, MOBILE_LOGO")
    ext_info: Optional[Dict[str, Any]] = Field(default=None, description="Extend information")
    size_type: Optional[StrictStr] = Field(default=None, description="Size type")
    ln: Optional[Annotated[str, Field(strict=True, max_length=10)]] = Field(default=None, description="Longitude of shop's location")
    lat: Optional[Annotated[str, Field(strict=True, max_length=10)]] = Field(default=None, description="Latitude of shop's location")
    loyalty: Optional[StrictStr] = Field(default=None, description="Flag for loyalty category")
    owner_address: Optional[AddressInfo] = Field(default=None)
    owner_name: Optional[UserName] = Field(default=None)
    owner_phone_number: Optional[MobileNoInfo] = Field(default=None)
    owner_id_type: Optional[StrictStr] = Field(default=None, description="Owner identifier type")
    owner_id_no: Optional[StrictStr] = Field(default=None, description="Owner identifier number. Length depends on ownerIdType - KTP (16), SIM (12-14), Passport (8), NIB (>=13), SIUP (free text)")
    device_number: Optional[StrictStr] = Field(default=None, description="Device number")
    pos_number: Optional[StrictStr] = Field(default=None, description="POS number")
    api_version: Optional[Annotated[str, Field(strict=True, max_length=8)]] = Field(default=None, description="API version flag. Use > 2 for new attributes")
    business_entity: Optional[StrictStr] = Field(default=None, description="Business entity type")
    shop_owning: Optional[StrictStr] = Field(default=None, description="Shop owning information")
    shop_biz_type: Optional[StrictStr] = Field(default=None, description="Shop business type")
    business_docs: Optional[List[BusinessDocs]] = Field(default=None, description="Business documents. \"individu\" entity can only use KTP and SIM. Other entities can use SIUP and NIB")
    business_end_date: Optional[Annotated[str, Field(strict=True, max_length=10)]] = Field(default=None, description="Business end date, in format YYYY-MM-dd")
    tax_no: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Tax number (NPWP). Must be 15 digits")
    tax_address: Optional[AddressInfo] = Field(default=None)
    brand_name: Optional[Annotated[str, Field(strict=True, max_length=256)]] = Field(default=None, description="Brand name on legal name or tax name")
    director_pics: Optional[List[PicInfo]] = Field(default=None, description="Director as a PIC of shop")
    non_director_pics: Optional[List[PicInfo]] = Field(default=None, description="Non director which become an PIC of shop")
    __properties: ClassVar[List[str]] = ["shopId", "merchantId", "shopIdType", "mainName", "shopAddress", "shopDesc", "newExternalShopId", "mccCodes", "logoUrlMap", "extInfo", "sizeType", "ln", "lat", "loyalty", "ownerAddress", "ownerName", "ownerPhoneNumber", "ownerIdType", "ownerIdNo", "deviceNumber", "posNumber", "apiVersion", "businessEntity", "shopOwning", "shopBizType", "businessDocs", "businessEndDate", "taxNo", "taxAddress", "brandName", "directorPics", "nonDirectorPics"]

    @field_validator('shop_id_type')
    def shop_id_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['INNER_ID', 'EXTERNAL_ID']):
            raise ValueError("must be one of enum values ('INNER_ID', 'EXTERNAL_ID')")
        return value

    @field_validator('size_type')
    def size_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['UMI', 'UKE', 'UME', 'UBE']):
            raise ValueError("must be one of enum values ('UMI', 'UKE', 'UME', 'UBE')")
        return value

    @field_validator('loyalty')
    def loyalty_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['true', 'false']):
            raise ValueError("must be one of enum values ('true', 'false')")
        return value

    @field_validator('owner_id_type')
    def owner_id_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['KTP', 'SIM', 'PASSPORT', 'SIUP', 'NIB']):
            raise ValueError("must be one of enum values ('KTP', 'SIM', 'PASSPORT', 'SIUP', 'NIB')")
        return value

    @field_validator('business_entity')
    def business_entity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pt', 'cv', 'individu', 'usaha_dagang', 'yayasan', 'koperasi']):
            raise ValueError("must be one of enum values ('pt', 'cv', 'individu', 'usaha_dagang', 'yayasan', 'koperasi')")
        return value

    @field_validator('shop_owning')
    def shop_owning_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DIRECT_OWNED', 'FRANCHISED']):
            raise ValueError("must be one of enum values ('DIRECT_OWNED', 'FRANCHISED')")
        return value

    @field_validator('shop_biz_type')
    def shop_biz_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ONLINE', 'OFFLINE']):
            raise ValueError("must be one of enum values ('ONLINE', 'OFFLINE')")
        return value

    @field_validator('tax_no')
    def tax_no_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]{15}$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]{15}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateShopRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of shop_address
        if self.shop_address:
            _dict['shopAddress'] = self.shop_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner_address
        if self.owner_address:
            _dict['ownerAddress'] = self.owner_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner_name
        if self.owner_name:
            _dict['ownerName'] = self.owner_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner_phone_number
        if self.owner_phone_number:
            _dict['ownerPhoneNumber'] = self.owner_phone_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in business_docs (list)
        _items = []
        if self.business_docs:
            for _item_business_docs in self.business_docs:
                if _item_business_docs:
                    _items.append(_item_business_docs.to_dict())
            _dict['businessDocs'] = _items
        # override the default output from pydantic by calling `to_dict()` of tax_address
        if self.tax_address:
            _dict['taxAddress'] = self.tax_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in director_pics (list)
        _items = []
        if self.director_pics:
            for _item_director_pics in self.director_pics:
                if _item_director_pics:
                    _items.append(_item_director_pics.to_dict())
            _dict['directorPics'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in non_director_pics (list)
        _items = []
        if self.non_director_pics:
            for _item_non_director_pics in self.non_director_pics:
                if _item_non_director_pics:
                    _items.append(_item_non_director_pics.to_dict())
            _dict['nonDirectorPics'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateShopRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            # If it's a string (JSON), try to parse it
            if isinstance(obj, str):
                try:
                    obj = json.loads(obj)
                except json.JSONDecodeError:
                    return cls.model_validate(obj)
            else:
                return cls.model_validate(obj)

        
        # Handle OPEN_API nested response format: {"response": {"head": {...}, "body": {...}}}
        # Check if this is a response model and has nested structure
        if "UpdateShopRequest".endswith("Response") and "response" in obj and "body" in obj["response"]:
            # For OPEN_API nested format, pass the nested response structure directly
            _obj = cls.model_validate({
                "shopId": obj.get("shopId"),
                "merchantId": obj.get("merchantId"),
                "shopIdType": obj.get("shopIdType"),
                "mainName": obj.get("mainName"),
                "shopAddress": AddressInfo.from_dict(obj["shopAddress"]) if obj.get("shopAddress") is not None else None,
                "shopDesc": obj.get("shopDesc"),
                "newExternalShopId": obj.get("newExternalShopId"),
                "mccCodes": obj.get("mccCodes"),
                "logoUrlMap": obj.get("logoUrlMap"),
                "extInfo": obj.get("extInfo"),
                "sizeType": obj.get("sizeType"),
                "ln": obj.get("ln"),
                "lat": obj.get("lat"),
                "loyalty": obj.get("loyalty"),
                "ownerAddress": AddressInfo.from_dict(obj["ownerAddress"]) if obj.get("ownerAddress") is not None else None,
                "ownerName": UserName.from_dict(obj["ownerName"]) if obj.get("ownerName") is not None else None,
                "ownerPhoneNumber": MobileNoInfo.from_dict(obj["ownerPhoneNumber"]) if obj.get("ownerPhoneNumber") is not None else None,
                "ownerIdType": obj.get("ownerIdType"),
                "ownerIdNo": obj.get("ownerIdNo"),
                "deviceNumber": obj.get("deviceNumber"),
                "posNumber": obj.get("posNumber"),
                "apiVersion": obj.get("apiVersion"),
                "businessEntity": obj.get("businessEntity"),
                "shopOwning": obj.get("shopOwning"),
                "shopBizType": obj.get("shopBizType"),
                "businessDocs": [BusinessDocs.from_dict(_item) for _item in obj["businessDocs"]] if obj.get("businessDocs") is not None else None,
                "businessEndDate": obj.get("businessEndDate"),
                "taxNo": obj.get("taxNo"),
                "taxAddress": AddressInfo.from_dict(obj["taxAddress"]) if obj.get("taxAddress") is not None else None,
                "brandName": obj.get("brandName"),
                "directorPics": [PicInfo.from_dict(_item) for _item in obj["directorPics"]] if obj.get("directorPics") is not None else None,
                "nonDirectorPics": [PicInfo.from_dict(_item) for _item in obj["nonDirectorPics"]] if obj.get("nonDirectorPics") is not None else None
            })
        else:
            # For flat format, pass the object as-is
            _obj = cls.model_validate({
                "shopId": obj.get("shopId"),
                "merchantId": obj.get("merchantId"),
                "shopIdType": obj.get("shopIdType"),
                "mainName": obj.get("mainName"),
                "shopAddress": AddressInfo.from_dict(obj["shopAddress"]) if obj.get("shopAddress") is not None else None,
                "shopDesc": obj.get("shopDesc"),
                "newExternalShopId": obj.get("newExternalShopId"),
                "mccCodes": obj.get("mccCodes"),
                "logoUrlMap": obj.get("logoUrlMap"),
                "extInfo": obj.get("extInfo"),
                "sizeType": obj.get("sizeType"),
                "ln": obj.get("ln"),
                "lat": obj.get("lat"),
                "loyalty": obj.get("loyalty"),
                "ownerAddress": AddressInfo.from_dict(obj["ownerAddress"]) if obj.get("ownerAddress") is not None else None,
                "ownerName": UserName.from_dict(obj["ownerName"]) if obj.get("ownerName") is not None else None,
                "ownerPhoneNumber": MobileNoInfo.from_dict(obj["ownerPhoneNumber"]) if obj.get("ownerPhoneNumber") is not None else None,
                "ownerIdType": obj.get("ownerIdType"),
                "ownerIdNo": obj.get("ownerIdNo"),
                "deviceNumber": obj.get("deviceNumber"),
                "posNumber": obj.get("posNumber"),
                "apiVersion": obj.get("apiVersion"),
                "businessEntity": obj.get("businessEntity"),
                "shopOwning": obj.get("shopOwning"),
                "shopBizType": obj.get("shopBizType"),
                "businessDocs": [BusinessDocs.from_dict(_item) for _item in obj["businessDocs"]] if obj.get("businessDocs") is not None else None,
                "businessEndDate": obj.get("businessEndDate"),
                "taxNo": obj.get("taxNo"),
                "taxAddress": AddressInfo.from_dict(obj["taxAddress"]) if obj.get("taxAddress") is not None else None,
                "brandName": obj.get("brandName"),
                "directorPics": [PicInfo.from_dict(_item) for _item in obj["directorPics"]] if obj.get("directorPics") is not None else None,
                "nonDirectorPics": [PicInfo.from_dict(_item) for _item in obj["nonDirectorPics"]] if obj.get("nonDirectorPics") is not None else None
            })
        
        return _obj


