# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Widget API

    API for enabling the user to make payment from merchant's platform with redirecting to DANA's platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from dana.widget.v1.models.money import Money
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class AccountInfo(BaseModel, BaseSdkModel):
    """
    AccountInfo
    """ # noqa: E501
    balance_type: Optional[Annotated[str, Field(strict=True, max_length=70)]] = Field(default=None, description="Account information of balance type to specify which balance type expected to be returned. Will return all available balance type if this parameter empty")
    amount: Optional[Money] = Field(default=None, description="Account information of amount which include the net active amount. Contains two sub-fields:<br> 1. Value: Amount, including the cents<br> 2. Currency: Currency code based on ISO ")
    float_amount: Optional[Money] = Field(default=None, description="Account information of float amount which include the inactive amount due to cut off period. Contains two sub-fields:<br> 1. Value: Amount, including the cents<br> 2. Currency: Currency code based on ISO ")
    hold_amount: Optional[Money] = Field(default=None, description="Account information of hold amount which include the unusable amount due to certain type of transaction. Contains two sub-fields:<br> 1. Value: Amount, including the cents<br> 2. Currency: Currency code based on ISO ")
    available_balance: Optional[Money] = Field(default=None, description="Account information of available balance which include the active amount that can be used for transaction. Contains two sub-fields:<br> 1. Value: Amount, including the cents<br> 2. Currency: Currency code based on ISO ")
    ledger_balance: Optional[Money] = Field(default=None, description="Account information of ledger balance which include the starting balance for this day. Contains two sub-fields:<br> 1. Value: Amount, including the cents<br> 2. Currency: Currency code based on ISO ")
    current_multilateral_limit: Optional[Money] = Field(default=None, description="Account information of current multilateral limit. Contains two sub-fields:<br> 1. Value: Amount, including the cents<br> 2. Currency: Currency code based on ISO ")
    registration_status_code: Optional[Annotated[str, Field(strict=True, max_length=4)]] = Field(default=None, description="Account information of customer registration status")
    status: Optional[Annotated[str, Field(strict=True, max_length=4)]] = Field(default=None, description="Account information of status. The values include:<br> 1 = Active Account<br> 2 = Closed Account<br> 4 = New Account<br> 6 = Restricted Account<br> 7 = Frozen Account ")
    __properties: ClassVar[List[str]] = ["balanceType", "amount", "floatAmount", "holdAmount", "availableBalance", "ledgerBalance", "currentMultilateralLimit", "registrationStatusCode", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccountInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of amount
        if self.amount:
            _dict['amount'] = self.amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of float_amount
        if self.float_amount:
            _dict['floatAmount'] = self.float_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of hold_amount
        if self.hold_amount:
            _dict['holdAmount'] = self.hold_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of available_balance
        if self.available_balance:
            _dict['availableBalance'] = self.available_balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ledger_balance
        if self.ledger_balance:
            _dict['ledgerBalance'] = self.ledger_balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of current_multilateral_limit
        if self.current_multilateral_limit:
            _dict['currentMultilateralLimit'] = self.current_multilateral_limit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccountInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "balanceType": obj.get("balanceType"),
            "amount": Money.from_dict(obj["amount"]) if obj.get("amount") is not None else None,
            "floatAmount": Money.from_dict(obj["floatAmount"]) if obj.get("floatAmount") is not None else None,
            "holdAmount": Money.from_dict(obj["holdAmount"]) if obj.get("holdAmount") is not None else None,
            "availableBalance": Money.from_dict(obj["availableBalance"]) if obj.get("availableBalance") is not None else None,
            "ledgerBalance": Money.from_dict(obj["ledgerBalance"]) if obj.get("ledgerBalance") is not None else None,
            "currentMultilateralLimit": Money.from_dict(obj["currentMultilateralLimit"]) if obj.get("currentMultilateralLimit") is not None else None,
            "registrationStatusCode": obj.get("registrationStatusCode"),
            "status": obj.get("status")
        })
        return _obj


