# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Widget API

    API for enabling the user to make payment from merchant's platform with redirecting to DANA's platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class EnvInfo(BaseModel, BaseSdkModel):
    """
    EnvInfo
    """ # noqa: E501
    session_id: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, description="Session identifier")
    token_id: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, description="Token identifier")
    website_language: Optional[Annotated[str, Field(strict=True, max_length=16)]] = Field(default=None, description="Website language")
    client_ip: Optional[Annotated[str, Field(strict=True, max_length=32)]] = Field(default=None, description="Client IP address")
    os_type: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, description="Operating system type")
    app_version: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, description="App version")
    sdk_version: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, description="SDK version")
    source_platform: Annotated[str, Field(strict=True, max_length=32)] = Field(description="The source platform is always independent payment gateway (IPG)")
    order_os_type: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, description="Order operating system type")
    merchant_app_version: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, description="Merchant App version")
    terminal_type: Annotated[str, Field(strict=True, max_length=32)] = Field(description="Terminal type. The enums:<br> * APP - Mobile Application<br> * WEB - Browser Web<br> * WAP - Mobile Wap<br> * SYSTEM - System Call<br> ")
    order_terminal_type: Optional[Annotated[str, Field(strict=True, max_length=32)]] = Field(default=None, description="Order terminal type. The enums:<br> * APP - Mobile Application<br> * WEB - Browser Web<br> * WAP - Mobile Wap<br> * SYSTEM - System Call<br> ")
    extend_info: Optional[Annotated[str, Field(strict=True, max_length=4096)]] = Field(default=None, description="Extend information")
    client_key: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Unique identifier for partner was generated by DANA")
    __properties: ClassVar[List[str]] = ["sessionId", "tokenId", "websiteLanguage", "clientIp", "osType", "appVersion", "sdkVersion", "sourcePlatform", "orderOsType", "merchantAppVersion", "terminalType", "orderTerminalType", "extendInfo", "clientKey"]

    @field_validator('source_platform')
    def source_platform_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['IPG']):
            raise ValueError("must be one of enum values ('IPG')")
        return value

    @field_validator('terminal_type')
    def terminal_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['APP', 'WEB', 'WAP', 'SYSTEM']):
            raise ValueError("must be one of enum values ('APP', 'WEB', 'WAP', 'SYSTEM')")
        return value

    @field_validator('order_terminal_type')
    def order_terminal_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['APP', 'WEB', 'WAP', 'SYSTEM']):
            raise ValueError("must be one of enum values ('APP', 'WEB', 'WAP', 'SYSTEM')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EnvInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EnvInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sessionId": obj.get("sessionId"),
            "tokenId": obj.get("tokenId"),
            "websiteLanguage": obj.get("websiteLanguage"),
            "clientIp": obj.get("clientIp"),
            "osType": obj.get("osType"),
            "appVersion": obj.get("appVersion"),
            "sdkVersion": obj.get("sdkVersion"),
            "sourcePlatform": obj.get("sourcePlatform"),
            "orderOsType": obj.get("orderOsType"),
            "merchantAppVersion": obj.get("merchantAppVersion"),
            "terminalType": obj.get("terminalType"),
            "orderTerminalType": obj.get("orderTerminalType"),
            "extendInfo": obj.get("extendInfo"),
            "clientKey": obj.get("clientKey")
        })
        return _obj


