# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Widget API

    API for enabling the user to make payment from merchant's platform with redirecting to DANA's platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class RefundOrderRequestAdditionalInfo(BaseModel, BaseSdkModel):
    """
    Additional information
    """ # noqa: E501
    payout_account_no: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of payout account number. This param need to be filled if want to refund to specific payout account not that specified by DANA")
    refund_applied_time: Optional[Annotated[str, Field(strict=True, max_length=25)]] = Field(default=None, description="Additional information of refund applied time, in format YYYY-MM-DDTHH:mm:ss+07:00. Time must be in GMT+7 (Jakarta time)")
    actor_type: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of actor type, refer to ActorTypeEnum")
    return_charge_to_payer: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of return charge to payer")
    destination: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of destination")
    env_info: Dict[str, Any] = Field(description="Additional information of environment")
    audit_info: Optional[Dict[str, Any]] = Field(default=None, description="Additional information of audit")
    actor_context: Optional[Dict[str, Any]] = Field(default=None, description="Additional information of actor context")
    refund_option_bill: Optional[List[Dict[str, Any]]] = Field(default=None, description="Additional information of refund option bill")
    extend_info: Optional[Annotated[str, Field(strict=True, max_length=4096)]] = Field(default=None, description="Additional information of extend")
    async_refund: Optional[Annotated[str, Field(strict=True, max_length=5)]] = Field(default=None, description="Additional information of async refund to determine the process of refund whether sync or async. The values is true/false")
    __properties: ClassVar[List[str]] = ["payoutAccountNo", "refundAppliedTime", "actorType", "returnChargeToPayer", "destination", "envInfo", "auditInfo", "actorContext", "refundOptionBill", "extendInfo", "asyncRefund"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RefundOrderRequestAdditionalInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RefundOrderRequestAdditionalInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "payoutAccountNo": obj.get("payoutAccountNo"),
            "refundAppliedTime": obj.get("refundAppliedTime"),
            "actorType": obj.get("actorType"),
            "returnChargeToPayer": obj.get("returnChargeToPayer"),
            "destination": obj.get("destination"),
            "envInfo": obj.get("envInfo"),
            "auditInfo": obj.get("auditInfo"),
            "actorContext": obj.get("actorContext"),
            "refundOptionBill": obj.get("refundOptionBill"),
            "extendInfo": obj.get("extendInfo"),
            "asyncRefund": obj.get("asyncRefund")
        })
        return _obj


