# dash_api_python_client
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1
- Package version: 0.1.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import dash_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import dash_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import dash_api
from dash_api.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: oauth2
dash_api.configuration.access_token = 'YOUR_ACCESS_TOKEN'
# create an instance of the API class
api_instance = dash_api.ActivitiesApi()
id = 56 # int | 

try:
    api_response = api_instance.api_activities_by_id_get(id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ActivitiesApi->api_activities_by_id_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActivitiesApi* | [**api_activities_by_id_get**](docs/ActivitiesApi.md#api_activities_by_id_get) | **GET** /api/activities/{id} | 
*ActivitiesApi* | [**api_activities_get**](docs/ActivitiesApi.md#api_activities_get) | **GET** /api/activities | 
*ActivitiesApi* | [**api_activities_post**](docs/ActivitiesApi.md#api_activities_post) | **POST** /api/activities | 
*ActivitiesApi* | [**api_activities_structure_by_id_get**](docs/ActivitiesApi.md#api_activities_structure_by_id_get) | **GET** /api/activities/structure/{id} | 
*ActivitiesApi* | [**api_activities_top_most_get**](docs/ActivitiesApi.md#api_activities_top_most_get) | **GET** /api/activities/top-most | 
*ActivitiesApi* | [**api_activities_types_by_id_get**](docs/ActivitiesApi.md#api_activities_types_by_id_get) | **GET** /api/activities/types/{id} | 
*ActivitiesApi* | [**api_activities_types_get**](docs/ActivitiesApi.md#api_activities_types_get) | **GET** /api/activities/types | 
*ActivitiesApi* | [**api_activities_types_post**](docs/ActivitiesApi.md#api_activities_types_post) | **POST** /api/activities/types | 
*ChargeApi* | [**api_charge_by_id_get**](docs/ChargeApi.md#api_charge_by_id_get) | **GET** /api/charge/{id} | 
*ChargeApi* | [**api_charge_get**](docs/ChargeApi.md#api_charge_get) | **GET** /api/charge | 
*ChargeApi* | [**api_charge_identifier_get**](docs/ChargeApi.md#api_charge_identifier_get) | **GET** /api/charge/identifier | 
*ChargeApi* | [**api_charge_post**](docs/ChargeApi.md#api_charge_post) | **POST** /api/charge | 
*EnvironmentApi* | [**api_environment_get**](docs/EnvironmentApi.md#api_environment_get) | **GET** /api/Environment | 
*EventApi* | [**api_events_by_id_activities_get**](docs/EventApi.md#api_events_by_id_activities_get) | **GET** /api/events/{Id}/activities | 
*EventApi* | [**api_events_by_id_activities_post**](docs/EventApi.md#api_events_by_id_activities_post) | **POST** /api/events/{Id}/activities | 
*EventApi* | [**api_events_by_id_get**](docs/EventApi.md#api_events_by_id_get) | **GET** /api/events/{Id} | 
*EventApi* | [**api_events_by_id_organisations_get**](docs/EventApi.md#api_events_by_id_organisations_get) | **GET** /api/events/{Id}/organisations | 
*EventApi* | [**api_events_by_id_organisations_post**](docs/EventApi.md#api_events_by_id_organisations_post) | **POST** /api/events/{Id}/organisations | 
*EventApi* | [**api_events_get**](docs/EventApi.md#api_events_get) | **GET** /api/events | 
*EventApi* | [**api_events_post**](docs/EventApi.md#api_events_post) | **POST** /api/events | 
*EventStatusApi* | [**api_events_statuses_get**](docs/EventStatusApi.md#api_events_statuses_get) | **GET** /api/events/statuses | 
*EventTypeApi* | [**api_events_types_get**](docs/EventTypeApi.md#api_events_types_get) | **GET** /api/events/types | 
*OrganisationApi* | [**api_organisation_by_id_get**](docs/OrganisationApi.md#api_organisation_by_id_get) | **GET** /api/organisation/{id} | 
*OrganisationApi* | [**api_organisation_by_org_id_groups_by_org_group_id_delete**](docs/OrganisationApi.md#api_organisation_by_org_id_groups_by_org_group_id_delete) | **DELETE** /api/organisation/{orgId}/groups/{orgGroupId} | 
*OrganisationApi* | [**api_organisation_by_org_id_groups_by_org_group_id_get**](docs/OrganisationApi.md#api_organisation_by_org_id_groups_by_org_group_id_get) | **GET** /api/organisation/{orgId}/groups/{orgGroupId} | 
*OrganisationApi* | [**api_organisation_get**](docs/OrganisationApi.md#api_organisation_get) | **GET** /api/organisation | 
*OrganisationApi* | [**api_organisation_groups_by_id_delete**](docs/OrganisationApi.md#api_organisation_groups_by_id_delete) | **DELETE** /api/organisation/groups/{id} | 
*OrganisationApi* | [**api_organisation_groups_by_id_get**](docs/OrganisationApi.md#api_organisation_groups_by_id_get) | **GET** /api/organisation/groups/{id} | 
*OrganisationApi* | [**api_organisation_groups_by_org_group_id_organisations_get**](docs/OrganisationApi.md#api_organisation_groups_by_org_group_id_organisations_get) | **GET** /api/organisation/groups/{orgGroupId}/organisations | 
*OrganisationApi* | [**api_organisation_groups_by_org_group_id_organisations_post**](docs/OrganisationApi.md#api_organisation_groups_by_org_group_id_organisations_post) | **POST** /api/organisation/groups/{orgGroupId}/organisations | 
*OrganisationApi* | [**api_organisation_groups_get**](docs/OrganisationApi.md#api_organisation_groups_get) | **GET** /api/organisation/groups | 
*OrganisationApi* | [**api_organisation_groups_post**](docs/OrganisationApi.md#api_organisation_groups_post) | **POST** /api/organisation/groups | 
*OrganisationApi* | [**api_organisation_post**](docs/OrganisationApi.md#api_organisation_post) | **POST** /api/organisation | 
*OrganisationApi* | [**api_organisation_structure_by_org_id_get**](docs/OrganisationApi.md#api_organisation_structure_by_org_id_get) | **GET** /api/organisation/structure/{orgId} | 
*OrganisationApi* | [**api_organisation_top_most_get**](docs/OrganisationApi.md#api_organisation_top_most_get) | **GET** /api/organisation/top-most | 
*OrganisationTypeApi* | [**api_organisation_type_get**](docs/OrganisationTypeApi.md#api_organisation_type_get) | **GET** /api/organisation/type | 
*ResourceApi* | [**api_resources_permissions_get**](docs/ResourceApi.md#api_resources_permissions_get) | **GET** /api/resources/permissions | 
*ResourceApi* | [**api_resources_types_get**](docs/ResourceApi.md#api_resources_types_get) | **GET** /api/resources/types | 
*RestrictionsApi* | [**api_restrictions_by_id_delete**](docs/RestrictionsApi.md#api_restrictions_by_id_delete) | **DELETE** /api/Restrictions/{id} | 
*RestrictionsApi* | [**api_restrictions_by_id_get**](docs/RestrictionsApi.md#api_restrictions_by_id_get) | **GET** /api/Restrictions/{id} | 
*RestrictionsApi* | [**api_restrictions_post**](docs/RestrictionsApi.md#api_restrictions_post) | **POST** /api/Restrictions | 
*RolesApi* | [**api_roles_by_id_delete**](docs/RolesApi.md#api_roles_by_id_delete) | **DELETE** /api/roles/{id} | 
*RolesApi* | [**api_roles_by_id_get**](docs/RolesApi.md#api_roles_by_id_get) | **GET** /api/roles/{id} | 
*RolesApi* | [**api_roles_by_id_put**](docs/RolesApi.md#api_roles_by_id_put) | **PUT** /api/roles/{id} | 
*RolesApi* | [**api_roles_by_id_resource_types_by_resource_type_id_permissions_get**](docs/RolesApi.md#api_roles_by_id_resource_types_by_resource_type_id_permissions_get) | **GET** /api/roles/{id}/resourceTypes/{resourceTypeId}/permissions | 
*RolesApi* | [**api_roles_by_id_resource_types_by_resource_type_id_permissions_post**](docs/RolesApi.md#api_roles_by_id_resource_types_by_resource_type_id_permissions_post) | **POST** /api/roles/{id}/resourceTypes/{resourceTypeId}/permissions | 
*RolesApi* | [**api_roles_by_id_resource_types_get**](docs/RolesApi.md#api_roles_by_id_resource_types_get) | **GET** /api/roles/{id}/resourceTypes | 
*RolesApi* | [**api_roles_by_id_resource_types_post**](docs/RolesApi.md#api_roles_by_id_resource_types_post) | **POST** /api/roles/{id}/resourceTypes | 
*RolesApi* | [**api_roles_by_id_resources_by_resource_id_permissions_get**](docs/RolesApi.md#api_roles_by_id_resources_by_resource_id_permissions_get) | **GET** /api/roles/{id}/resources/{resourceId}/permissions | 
*RolesApi* | [**api_roles_by_id_resources_by_resource_id_permissions_post**](docs/RolesApi.md#api_roles_by_id_resources_by_resource_id_permissions_post) | **POST** /api/roles/{id}/resources/{resourceId}/permissions | 
*RolesApi* | [**api_roles_by_id_resources_get**](docs/RolesApi.md#api_roles_by_id_resources_get) | **GET** /api/roles/{id}/resources | 
*RolesApi* | [**api_roles_by_id_resources_post**](docs/RolesApi.md#api_roles_by_id_resources_post) | **POST** /api/roles/{id}/resources | 
*RolesApi* | [**api_roles_by_id_users_by_provider_id_get**](docs/RolesApi.md#api_roles_by_id_users_by_provider_id_get) | **GET** /api/roles/{id}/users/{providerId} | 
*RolesApi* | [**api_roles_by_id_users_get**](docs/RolesApi.md#api_roles_by_id_users_get) | **GET** /api/roles/{id}/users | 
*RolesApi* | [**api_roles_by_id_users_post**](docs/RolesApi.md#api_roles_by_id_users_post) | **POST** /api/roles/{id}/users | 
*RolesApi* | [**api_roles_by_role_id_users_by_provider_id_restrictions_by_restriction_id_delete**](docs/RolesApi.md#api_roles_by_role_id_users_by_provider_id_restrictions_by_restriction_id_delete) | **DELETE** /api/roles/{roleId}/users/{providerId}/restrictions/{restrictionId} | 
*RolesApi* | [**api_roles_by_role_id_users_by_provider_id_restrictions_get**](docs/RolesApi.md#api_roles_by_role_id_users_by_provider_id_restrictions_get) | **GET** /api/roles/{roleId}/users/{providerId}/restrictions | 
*RolesApi* | [**api_roles_by_role_id_users_by_provider_id_restrictions_post**](docs/RolesApi.md#api_roles_by_role_id_users_by_provider_id_restrictions_post) | **POST** /api/roles/{roleId}/users/{providerId}/restrictions | 
*RolesApi* | [**api_roles_get**](docs/RolesApi.md#api_roles_get) | **GET** /api/roles | 
*RolesApi* | [**api_roles_post**](docs/RolesApi.md#api_roles_post) | **POST** /api/roles | 
*TeamsApi* | [**api_teams_by_id_delete**](docs/TeamsApi.md#api_teams_by_id_delete) | **DELETE** /api/Teams/{id} | 
*TeamsApi* | [**api_teams_by_id_get**](docs/TeamsApi.md#api_teams_by_id_get) | **GET** /api/Teams/{id} | 
*TeamsApi* | [**api_teams_by_id_put**](docs/TeamsApi.md#api_teams_by_id_put) | **PUT** /api/Teams/{id} | 
*TeamsApi* | [**api_teams_by_team_id_charges_by_charge_id_get**](docs/TeamsApi.md#api_teams_by_team_id_charges_by_charge_id_get) | **GET** /api/Teams/{teamId}/charges/{chargeId} | 
*TeamsApi* | [**api_teams_by_team_id_charges_get**](docs/TeamsApi.md#api_teams_by_team_id_charges_get) | **GET** /api/Teams/{teamId}/charges | 
*TeamsApi* | [**api_teams_by_team_id_charges_post**](docs/TeamsApi.md#api_teams_by_team_id_charges_post) | **POST** /api/Teams/{teamId}/charges | 
*TeamsApi* | [**api_teams_by_team_id_events_by_event_id_get**](docs/TeamsApi.md#api_teams_by_team_id_events_by_event_id_get) | **GET** /api/Teams/{teamId}/events/{eventId} | 
*TeamsApi* | [**api_teams_by_team_id_events_get**](docs/TeamsApi.md#api_teams_by_team_id_events_get) | **GET** /api/Teams/{teamId}/events | 
*TeamsApi* | [**api_teams_by_team_id_events_post**](docs/TeamsApi.md#api_teams_by_team_id_events_post) | **POST** /api/Teams/{teamId}/events | 
*TeamsApi* | [**api_teams_get**](docs/TeamsApi.md#api_teams_get) | **GET** /api/Teams | 
*TeamsApi* | [**api_teams_post**](docs/TeamsApi.md#api_teams_post) | **POST** /api/Teams | 
*UserApi* | [**api_user_by_provider_id_charges_by_charge_id_get**](docs/UserApi.md#api_user_by_provider_id_charges_by_charge_id_get) | **GET** /api/user/{providerId}/charges/{chargeId} | 
*UserApi* | [**api_user_by_provider_id_charges_by_relationship_type_post**](docs/UserApi.md#api_user_by_provider_id_charges_by_relationship_type_post) | **POST** /api/user/{providerId}/charges/{relationshipType} | 
*UserApi* | [**api_user_by_provider_id_charges_get**](docs/UserApi.md#api_user_by_provider_id_charges_get) | **GET** /api/user/{providerId}/charges | 
*UserApi* | [**api_user_by_provider_id_get**](docs/UserApi.md#api_user_by_provider_id_get) | **GET** /api/user/{providerId} | 
*UserApi* | [**api_user_by_provider_id_head**](docs/UserApi.md#api_user_by_provider_id_head) | **HEAD** /api/user/{providerId} | 
*UserApi* | [**api_user_by_provider_id_organisations_by_assignment_post**](docs/UserApi.md#api_user_by_provider_id_organisations_by_assignment_post) | **POST** /api/user/{providerId}/organisations/{assignment} | 
*UserApi* | [**api_user_by_provider_id_organisations_by_organisation_id_delete**](docs/UserApi.md#api_user_by_provider_id_organisations_by_organisation_id_delete) | **DELETE** /api/user/{providerId}/organisations/{organisationId} | 
*UserApi* | [**api_user_by_provider_id_organisations_by_organisation_id_get**](docs/UserApi.md#api_user_by_provider_id_organisations_by_organisation_id_get) | **GET** /api/user/{providerId}/organisations/{organisationId} | 
*UserApi* | [**api_user_by_provider_id_organisations_get**](docs/UserApi.md#api_user_by_provider_id_organisations_get) | **GET** /api/user/{providerId}/organisations | 
*UserApi* | [**api_user_get**](docs/UserApi.md#api_user_get) | **GET** /api/user | 
*UserApi* | [**api_user_post**](docs/UserApi.md#api_user_post) | **POST** /api/user | 


## Documentation For Models

 - [Activity](docs/Activity.md)
 - [ActivityType](docs/ActivityType.md)
 - [Address](docs/Address.md)
 - [Charge](docs/Charge.md)
 - [Event](docs/Event.md)
 - [EventStatus](docs/EventStatus.md)
 - [EventType](docs/EventType.md)
 - [Organisation](docs/Organisation.md)
 - [OrganisationContact](docs/OrganisationContact.md)
 - [OrganisationGroup](docs/OrganisationGroup.md)
 - [OrganisationType](docs/OrganisationType.md)
 - [Permission](docs/Permission.md)
 - [PrimaryAffiliateOrganisation](docs/PrimaryAffiliateOrganisation.md)
 - [Resource](docs/Resource.md)
 - [ResourceType](docs/ResourceType.md)
 - [Restriction](docs/Restriction.md)
 - [Role](docs/Role.md)
 - [Team](docs/Team.md)
 - [User](docs/User.md)
 - [UserAddress](docs/UserAddress.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://test.auth.dashapp.com.au/connect/authorize
- **Scopes**: 
 - **dash_api**: Access to dash api


## Author



