# dash_auth_python_client
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1
- Package version: 0.1.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import dash_auth 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import dash_auth
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import dash_auth
from dash_auth.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: oauth2
dash_auth.configuration.access_token = 'YOUR_ACCESS_TOKEN'
# create an instance of the API class
api_instance = dash_auth.AccountApi()
id = 'id_example' # str | 

try:
    api_response = api_instance.api_account_by_id_get(id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->api_account_by_id_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**api_account_by_id_get**](docs/AccountApi.md#api_account_by_id_get) | **GET** /api/Account/{id} | 
*AccountApi* | [**api_account_get**](docs/AccountApi.md#api_account_get) | **GET** /api/Account | 
*AccountApi* | [**api_account_post**](docs/AccountApi.md#api_account_post) | **POST** /api/Account | 
*LoginApi* | [**api_login_auth_external_get**](docs/LoginApi.md#api_login_auth_external_get) | **GET** /api/Login/auth-external | 
*LoginApi* | [**api_login_post**](docs/LoginApi.md#api_login_post) | **POST** /api/Login | 
*LoginApi* | [**api_login_providers_get**](docs/LoginApi.md#api_login_providers_get) | **GET** /api/Login/providers | 
*LoginApi* | [**api_login_request_external_get**](docs/LoginApi.md#api_login_request_external_get) | **GET** /api/Login/request-external | 
*LogoutApi* | [**api_logout_by_logout_id_get**](docs/LogoutApi.md#api_logout_by_logout_id_get) | **GET** /api/Logout/{logoutId} | 
*PasswordApi* | [**api_account_password_post**](docs/PasswordApi.md#api_account_password_post) | **POST** /api/account/Password | 
*PasswordApi* | [**api_account_password_put**](docs/PasswordApi.md#api_account_password_put) | **PUT** /api/account/Password | 


## Documentation For Models

 - [AuthenticationScheme](docs/AuthenticationScheme.md)
 - [ChangePasswordRequest](docs/ChangePasswordRequest.md)
 - [Logout](docs/Logout.md)
 - [Register](docs/Register.md)
 - [User](docs/User.md)
 - [UserAddress](docs/UserAddress.md)
 - [UserLogin](docs/UserLogin.md)
 - [UserQuery](docs/UserQuery.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **dash_auth_api**: Access to dash auth api


## Author



