DataAPI
====================


提供基于Python的数据库访问，主要目的：

1. 将用户从繁琐的拼写sql语句的工作中解放出来，更专注于数据具体的内容；

2. 增加抽象层，避免用户对数据库的直接访问。方便未来DBA对于数据库的更新、维护以及解耦。

	
为DataAPI添砖加瓦
-----------------------

数据API是一个需求驱动型的项目，单个的api往往即对应一个典型的数据库查询情景，例如这条查询语句：

```sql
select instrumentID, tradingDate, closePrice, openPrice from EQY_EOD 
	where instrumentID='600000' and tradingDate > '2015-01-01' and tradingDate < '2015-10-01'
```

等价于如下的api函数调用：

```python
api.GetEquityBarEOD('600000', '2015-01-01', '2015-10-01', ['closePrice', 'openPrice'])
```

所以，最简单的为DataAPI做出贡献的办法是：

> ### 把你最最最常用SQL语句发给我们！（不要忘记附上简单的查询含义，这样方便我们进行api命名）


依赖
-------------------

推荐使用Anaconda发行版，降低使用``pip``安装``numpy``以及``pandas``可能遇到的问题：

 - enum34 (仅python2)
 - numpy
 - pandas
 - pymssql
 - sqlalchemy
 
可选依赖（用于缓存机制）:

 - tables

安装
-----------------

安装必要依赖

	pip install -r requirements.txt
	
安装``DataAPI``

	python setup.py install
 
使用
-----------------

```python
	>> from DataAPI import *
	>> # 以下代码获取股票1分钟线
	>> api.GetEquityBarMin1('600000', '2015-01-01', '2015-01-31')
	
                    	productID instrumentID tradingDate       tradingTime
	timeStamp                                                                  
	2015-01-05 09:30:00    600000       600000  2015-01-05  09:30:00.0000000   
	2015-01-05 09:31:00    600000       600000  2015-01-05  09:31:00.0000000   
	2015-01-05 09:32:00    600000       600000  2015-01-05  09:32:00.0000000   
	2015-01-05 09:33:00    600000       600000  2015-01-05  09:33:00.0000000   
	2015-01-05 09:34:00    600000       600000  2015-01-05  09:34:00.0000000   
	2015-01-05 09:35:00    600000       600000  2015-01-05  09:35:00.0000000   
	2015-01-05 09:36:00    600000       600000  2015-01-05  09:36:00.0000000   
```

文档
-----------------------

具体的文档，请见目录：``doc``






	