LITERALS = {
    "keywords": {
        "ALTER": ["DATABASE", "SCHEMA", "TABLE"],
        "CREATE": ["DATABASE", "EXTERNAL", "TABLE", "VIEW"],
        "EXTERNAL": ["TABLE"],
        "DESCRIBE": ["TABLE", "VIEW"],
        "DROP": ["DATABASE", "TABLE", "VIEW"],
        "MSCK": ["REPAIR TABLE"],
        "SHOW": [
            "COLUMNS IN",
            "CREATE TABLE",
            "CREATE VIEW",
            "DATABASES",
            "SCHEMAS",
            "PARTITIONS",
            "TABLES",
            "TBLPROPERTIES",
            "VIEWS",
        ],
        "REPLACE": ["VIEW"],
        "WITH": [],
        "SELECT": [],
        "ALL": [],
        "DISTINCT": [],
        "FROM": [],
        "WHERE": [],
        "INNER": ["JOIN"],
        "OUTER": ["JOIN"],
        "CROSS": ["JOIN"],
        "LEFT": ["JOIN", "OUTER JOIN"],
        "RIGHT": ["JOIN", "OUTER JOIN"],
        "FULL": ["JOIN", "OUTER JOIN"],
        "JOIN": [],
        "ON": [],
        "USING": [],
        "GROUP BY": [],
        "HAVING": [],
        "UNION": [],
        "ORDER BY": [],
        "ASC": [],
        "DESC": [],
        "NULLS FIRST": [],
        "NULLS LAST": [],
        "LIMIT": [],
        "AND": [],
        "OR": [],
        "NOT": [],
        "CAST": [],
        "CASE": [],
        "WHEN": [],
        "THEN": [],
        "ELSE": [],
        "END": [],
        "JSON": [],
        "IF NOT EXISTS": [],
    },
    "functions": [
        "aes_decrypt",
        "aes_encrypt",
        "ascii",
        "base64",
        "bin",
        "binary",
        "bit_length",
        "btrim",
        "char",
        "char_length",
        "character_length",
        "charindex",
        "chr",
        "concat",
        "concat_ws",
        "contains",
        "crc32",
        "decode",
        "encode",
        "endswith",
        "find_in_set",
        "format_number",
        "format_number",
        "format_string ",
        "hex",
        "str ilike ",
        "initcap",
        "instr",
        "lcase",
        "left",
        "length",
        "levenshtein",
        "str like ",
        "locate",
        "lower",
        "lpad ",
        "ltrim",
        "md5",
        "octet_length",
        "overlay",
        "parse_url",
        "position",
        "position",
        "printf",
        "regexp",
        "regexp_extract ",
        "regexp_extract_all",
        "regexp_replace",
        "repeat",
        "replace",
        "reverse",
        "right",
        "rlike",
        "rpad ",
        "rtrim",
        "sentences ",
        "sha",
        "sha1",
        "sha2",
        "soundex",
        "space",
        "split",
        "startswith",
        "string",
        "substr",
        "substr",
        "substring",
        "substring",
        "substring_index",
        "translate",
        "trim",
        "ucase",
        "unbase64",
        "unhex",
        "upper",
        "abs",
        "acos",
        "acosh",
        "asin",
        "asinh",
        "atan",
        "atan2",
        "atanh",
        "bigint",
        "bit_count",
        "bit_get",
        "bit_reverse",
        "bround",
        "cbrt",
        "ceil",
        "ceiling",
        "conv",
        "cos",
        "cosh",
        "cot",
        "csc",
        "decimal",
        "degrees",
        "divisor div dividend",
        "double",
        "e",
        "exp",
        "expm1",
        "factorial",
        "float",
        "floor",
        "getbit",
        "hypot",
        "int",
        "isnan",
        "ln",
        "log",
        "log1p",
        "log2",
        "log10",
        "mod",
        "nanvl",
        "negative",
        "pi",
        "pmod",
        "positive",
        "pow",
        "power",
        "radians",
        "rand",
        "randn",
        "random",
        "rint",
        "round",
        "sec",
        "sin",
        "shiftleft",
        "shiftright ",
        "shiftrightunsigned",
        "sign",
        "signum",
        "sinh",
        "smallint",
        "sqrt",
        "tan",
        "tanh",
        "tinyint",
        "try_add",
        "try_divide",
        "try_multiply",
        "try_subtract",
        "any",
        "approx_count_distinct",
        "approx_percentile",
        "approx_top_k",
        "array_agg",
        "avg",
        "bit_and",
        "bit_or",
        "bit_xor",
        "bool_and",
        "bool_or",
        "collect_list",
        "collect_set",
        "corr",
        "count",
        "count",
        "count_if",
        "count_min_sketch",
        "covar_pop",
        "covar_samp",
        "every",
        "first",
        "first_value",
        "kurtosis",
        "last",
        "last_value",
        "max",
        "max_by",
        "mean",
        "min",
        "min_by",
        "percentile",
        "percentile_approx",
        "percentile_cont(pct) WITHIN GROUP ",
        "skewness",
        "some",
        "std",
        "stddev",
        "stddev_pop",
        "stddev_samp",
        "sum",
        "var_pop",
        "var_samp",
        "variance",
        "dense_rank",
        "ntile",
        "percent_rank",
        "rank",
        "row_number",
        "cume_dist",
        "lag",
        "lead",
        "nth_value",
        "arrayExpr[indexExpr]",
        "aggregate ",
        "array",
        "array_contains",
        "array_distinct",
        "array_except",
        "array_intersect",
        "array_join",
        "array_max",
        "array_min",
        "array_position",
        "array_remove",
        "array_repeat",
        "array_sort",
        "array_union",
        "arrays_overlap",
        "arrays_zip",
        "cardinality",
        "concat",
        "element_at",
        "exists",
        "explode",
        "explode_outer",
        "filter",
        "flatten",
        "forall",
        "inline",
        "inline_outer",
        "posexplode",
        "posexplode_outer",
        "reduce",
        "reverse",
        "sequence",
        "shuffle",
        "size",
        "slice",
        "sort_array",
        "transform",
        "zip_with",
        "mapExpr[keyExpr]",
        "cardinality",
        "element_at",
        "explode",
        "explode_outer",
        "map",
        "map_concat",
        "map_contains_key",
        "map_entries",
        "map_filter",
        "map_from_arrays",
        "map_from_entries",
        "map_keys",
        "map_values",
        "map_zip_with",
        "size",
        "transform_keys",
        "transform_values",
        "abs",
        "add_months",
        "current_date",
        "current_timestamp",
        "current_timezone",
        "date",
        "date_add",
        "date_format",
        "date_from_unix_date",
        "date_part",
        "date_sub",
        "date_trunc",
        "dateadd",
        "datediff",
        "datediff",
        "day",
        "dayofmonth",
        "dayofweek",
        "dayofyear",
        "divisor div dividend",
        "extract",
        "from_unixtime",
        "from_utc_timestamp",
        "hour",
        "last_day",
        "make_date",
        "make_dt_interval",
        "make_interval",
        "make_timestamp",
        "make_ym_interval",
        "minute",
        "month",
        "months_between",
        "next_day",
        "now",
        "quarter",
        "second",
        "sign",
        "signum",
        "timestamp",
        "timestamp_micros",
        "timestamp_millis",
        "timestamp_seconds",
        "timestampadd",
        "timestampdiff",
        "to_date",
        "to_timestamp",
        "to_unix_timestamp",
        "to_utc_timestamp",
        "trunc",
        "try_add",
        "try_divide",
        "try_multiply",
        "try_subtract",
        "unix_date",
        "unix_micros",
        "unix_millis",
        "unix_seconds",
        "unix_timestamp",
        "weekday",
        "weekofyear",
        "year",
        "window",
        "array",
        "bigint",
        "binary",
        "boolean",
        "cast",
        "date",
        "decimal",
        "double",
        "float",
        "int",
        "make_date",
        "make_dt_interval",
        "make_interval",
        "make_timestamp",
        "make_ym_interval",
        "map",
        "named_struct",
        "smallint",
        "string",
        "struct",
        "tinyint",
        "timestamp",
        "try_cast",
        "from_csv",
        "schema_of_csv",
        "to_csv",
        "from_json",
        "get_json_object",
        "json_array_length",
        "json_object_keys ",
        "json_tuple",
        "schema_of_json",
        "to_json",
        "xpath",
        "xpath_boolean",
        "xpath_double",
        "xpath_float",
        "xpath_int",
        "xpath_long",
        "xpath_number",
        "xpath_short",
        "xpath_string",
        "assert_true",
        "CASE",
        "coalesce",
        "cube ",
        "current_catalog",
        "current_database",
        "current_schema",
        "current_user",
        "decode",
        "elt",
        "greatest",
        "grouping",
        "grouping_id",
        "hash",
        "java_method",
        "if",
        "iff",
        "ifnull",
        "input_file_block_length",
        "input_file_block_start",
        "input_file_name",
        "is_member",
        "isnull",
        "isnotnull",
        "least",
        "monotonically_increasing_id",
        "nullif",
        "nvl",
        "nvl2",
        "raise_error",
        "range",
        "range",
        "reflect",
        "spark_partition_id",
        "stack",
        "uuid",
        "window",
        "xxhash64",
        "version",
    ],
    "datatypes": [
        "BIGINT",
        "BINARY",
        "BOOLEAN",
        "DATE",
        "DECIMAL",
        "DOUBLE",
        "FLOAT",
        "INT",
        "INTERVAL",
        "VOID",
        "SMALLINT",
        "STRING",
        "TIMESTAMP",
        "TINYINT",
        "ARRAY",
        "MAP",
        "STRUCT",
    ],
}


def get_literals(literal_type, type_=tuple):
    # Where `literal_type` is one of 'keywords', 'functions', 'datatypes',
    # returns a tuple of literal values of that type.
    return type_(LITERALS[literal_type])
