# Data Processing & Visualization Tool

A Python tool that automatically cleans CSV datasets, removes null values, and creates beautiful visualizations.

## Quick Start

### Installation

```bash
pip install -e .
```

### Usage

```bash
datacleaner
```

Then follow the prompts!

## What it does

1. **Loads CSV files** - Import your data
2. **Detects null values** - Shows what needs cleaning
3. **Cleans data** - Removes nulls, normalizes column names
4. **Creates visualizations** - Histograms, scatter plots, bar charts
5. **Saves everything organized** - By filename for easy access

## Folder Structure

```
DataCleaner/
├── process_data.py          # Main script
├── setup.py                 # Installation config
├── requirements.txt         # Dependencies
├── README.md                # This file
├── outputs/
│   └── visualizations.py    # Visualization class
├── data/                    # Put CSV files here
└── outputs/
    ├── Data/                # Cleaned CSV files
    └── Graphs/              # Visualizations (organized by filename)
```

## Requirements

- Python 3.7+
- pandas
- matplotlib

## For Developers

### Local Development

```bash
pip install -e .
python process_data.py
```

### Manual Installation (if pip doesn't work)

```bash
pip install pandas matplotlib
python process_data.py
```

## Features

✓ Automatic null value detection  
✓ Interactive cleaning prompts  
✓ Smart column name normalization  
✓ Multiple visualization types  
✓ Organized output folders  
✓ Loop-based processing (process multiple files)  

## License

Free to use and modify!
