# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v1.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v1.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v1.model.api_error_response import APIErrorResponse
from datadog_api_client.v1.model.cancel_downtimes_by_scope_request import CancelDowntimesByScopeRequest
from datadog_api_client.v1.model.canceled_downtimes_ids import CanceledDowntimesIds
from datadog_api_client.v1.model.downtime import Downtime


class DowntimesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._cancel_downtime_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/downtime/{downtime_id}",
                "operation_id": "cancel_downtime",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "downtime_id",
                ],
                "required": [
                    "downtime_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "downtime_id": (int,),
                },
                "attribute_map": {
                    "downtime_id": "downtime_id",
                },
                "location_map": {
                    "downtime_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._cancel_downtimes_by_scope_endpoint = _Endpoint(
            settings={
                "response_type": (CanceledDowntimesIds,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/downtime/cancel/by_scope",
                "operation_id": "cancel_downtimes_by_scope",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (CancelDowntimesByScopeRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._create_downtime_endpoint = _Endpoint(
            settings={
                "response_type": (Downtime,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/downtime",
                "operation_id": "create_downtime",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (Downtime,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._get_downtime_endpoint = _Endpoint(
            settings={
                "response_type": (Downtime,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/downtime/{downtime_id}",
                "operation_id": "get_downtime",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "downtime_id",
                ],
                "required": [
                    "downtime_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "downtime_id": (int,),
                },
                "attribute_map": {
                    "downtime_id": "downtime_id",
                },
                "location_map": {
                    "downtime_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_downtimes_endpoint = _Endpoint(
            settings={
                "response_type": ([Downtime],),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/downtime",
                "operation_id": "list_downtimes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "current_only",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "current_only": (bool,),
                },
                "attribute_map": {
                    "current_only": "current_only",
                },
                "location_map": {
                    "current_only": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_monitor_downtimes_endpoint = _Endpoint(
            settings={
                "response_type": ([Downtime],),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/monitor/{monitor_id}/downtimes",
                "operation_id": "list_monitor_downtimes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "monitor_id",
                ],
                "required": [
                    "monitor_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "monitor_id": (int,),
                },
                "attribute_map": {
                    "monitor_id": "monitor_id",
                },
                "location_map": {
                    "monitor_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._update_downtime_endpoint = _Endpoint(
            settings={
                "response_type": (Downtime,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/downtime/{downtime_id}",
                "operation_id": "update_downtime",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "downtime_id",
                    "body",
                ],
                "required": [
                    "downtime_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "downtime_id": (int,),
                    "body": (Downtime,),
                },
                "attribute_map": {
                    "downtime_id": "downtime_id",
                },
                "location_map": {
                    "downtime_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def cancel_downtime(self, downtime_id, **kwargs):
        """Cancel a downtime  # noqa: E501

        Cancel a downtime.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_downtime(downtime_id, async_req=True)
        >>> result = thread.get()

        Args:
            downtime_id (int): ID of the downtime to cancel.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._cancel_downtime_endpoint.default_arguments(kwargs)
        kwargs["downtime_id"] = downtime_id
        return self._cancel_downtime_endpoint.call_with_http_info(**kwargs)

    def cancel_downtimes_by_scope(self, body, **kwargs):
        """Cancel downtimes by scope  # noqa: E501

        Delete all downtimes that match the scope of `X`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_downtimes_by_scope(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (CancelDowntimesByScopeRequest): Scope to cancel downtimes for.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CanceledDowntimesIds
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._cancel_downtimes_by_scope_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._cancel_downtimes_by_scope_endpoint.call_with_http_info(**kwargs)

    def create_downtime(self, body, **kwargs):
        """Schedule a downtime  # noqa: E501

        Schedule a downtime.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_downtime(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (Downtime): Schedule a downtime request body.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Downtime
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_downtime_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_downtime_endpoint.call_with_http_info(**kwargs)

    def get_downtime(self, downtime_id, **kwargs):
        """Get a downtime  # noqa: E501

        Get downtime detail by `downtime_id`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_downtime(downtime_id, async_req=True)
        >>> result = thread.get()

        Args:
            downtime_id (int): ID of the downtime to fetch.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Downtime
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_downtime_endpoint.default_arguments(kwargs)
        kwargs["downtime_id"] = downtime_id
        return self._get_downtime_endpoint.call_with_http_info(**kwargs)

    def list_downtimes(self, **kwargs):
        """Get all downtimes  # noqa: E501

        Get all scheduled downtimes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_downtimes(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            current_only (bool): Only return downtimes that are active when the request is made.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Downtime]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_downtimes_endpoint.default_arguments(kwargs)
        return self._list_downtimes_endpoint.call_with_http_info(**kwargs)

    def list_monitor_downtimes(self, monitor_id, **kwargs):
        """Get all downtimes for a monitor  # noqa: E501

        Get all downtimes for the specified monitor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_monitor_downtimes(monitor_id, async_req=True)
        >>> result = thread.get()

        Args:
            monitor_id (int): The id of the monitor

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Downtime]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_monitor_downtimes_endpoint.default_arguments(kwargs)
        kwargs["monitor_id"] = monitor_id
        return self._list_monitor_downtimes_endpoint.call_with_http_info(**kwargs)

    def update_downtime(self, downtime_id, body, **kwargs):
        """Update a downtime  # noqa: E501

        Update a single downtime by `downtime_id`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_downtime(downtime_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            downtime_id (int): ID of the downtime to update.
            body (Downtime): Update a downtime request body.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Downtime
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_downtime_endpoint.default_arguments(kwargs)
        kwargs["downtime_id"] = downtime_id
        kwargs["body"] = body
        return self._update_downtime_endpoint.call_with_http_info(**kwargs)
