# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v1.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v1.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v1.model.api_error_response import APIErrorResponse
from datadog_api_client.v1.model.event_create_request import EventCreateRequest
from datadog_api_client.v1.model.event_create_response import EventCreateResponse
from datadog_api_client.v1.model.event_list_response import EventListResponse
from datadog_api_client.v1.model.event_priority import EventPriority
from datadog_api_client.v1.model.event_response import EventResponse


class EventsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._create_event_endpoint = _Endpoint(
            settings={
                "response_type": (EventCreateResponse,),
                "auth": ["apiKeyAuth"],
                "endpoint_path": "/api/v1/events",
                "operation_id": "create_event",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (EventCreateRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._get_event_endpoint = _Endpoint(
            settings={
                "response_type": (EventResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/events/{event_id}",
                "operation_id": "get_event",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "event_id",
                ],
                "required": [
                    "event_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "event_id": (int,),
                },
                "attribute_map": {
                    "event_id": "event_id",
                },
                "location_map": {
                    "event_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_events_endpoint = _Endpoint(
            settings={
                "response_type": (EventListResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/events",
                "operation_id": "list_events",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start",
                    "end",
                    "priority",
                    "sources",
                    "tags",
                    "unaggregated",
                    "exclude_aggregate",
                    "page",
                ],
                "required": [
                    "start",
                    "end",
                ],
                "nullable": [],
                "enum": [],
                "validation": [
                    "page",
                ],
            },
            root_map={
                "validations": {
                    ("page",): {
                        "inclusive_maximum": 2147483647,
                    },
                },
                "allowed_values": {},
                "openapi_types": {
                    "start": (int,),
                    "end": (int,),
                    "priority": (EventPriority,),
                    "sources": (str,),
                    "tags": (str,),
                    "unaggregated": (bool,),
                    "exclude_aggregate": (bool,),
                    "page": (int,),
                },
                "attribute_map": {
                    "start": "start",
                    "end": "end",
                    "priority": "priority",
                    "sources": "sources",
                    "tags": "tags",
                    "unaggregated": "unaggregated",
                    "exclude_aggregate": "exclude_aggregate",
                    "page": "page",
                },
                "location_map": {
                    "start": "query",
                    "end": "query",
                    "priority": "query",
                    "sources": "query",
                    "tags": "query",
                    "unaggregated": "query",
                    "exclude_aggregate": "query",
                    "page": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

    def create_event(self, body, **kwargs):
        """Post an event  # noqa: E501

        This endpoint allows you to post events to the stream. Tag them, set priority and event aggregate them with other events.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_event(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (EventCreateRequest): Event request object

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            EventCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_event_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_event_endpoint.call_with_http_info(**kwargs)

    def get_event(self, event_id, **kwargs):
        """Get an event  # noqa: E501

        This endpoint allows you to query for event details.  **Note**: If the event you’re querying contains markdown formatting of any kind, you may see characters such as `%`,`\\`,`n` in your output.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event(event_id, async_req=True)
        >>> result = thread.get()

        Args:
            event_id (int): The ID of the event.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            EventResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_event_endpoint.default_arguments(kwargs)
        kwargs["event_id"] = event_id
        return self._get_event_endpoint.call_with_http_info(**kwargs)

    def list_events(self, start, end, **kwargs):
        """Query the event stream  # noqa: E501

        The event stream can be queried and filtered by time, priority, sources and tags.  **Notes**: - If the event you’re querying contains markdown formatting of any kind, you may see characters such as `%`,`\\`,`n` in your output.  - This endpoint returns a maximum of `1000` most recent results. To return additional results, identify the last timestamp of the last result and set that as the `end` query time to paginate the results. You can also use the page parameter to specify which set of `1000` results to return.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_events(start, end, async_req=True)
        >>> result = thread.get()

        Args:
            start (int): POSIX timestamp.
            end (int): POSIX timestamp.

        Keyword Args:
            priority (EventPriority): Priority of your events, either `low` or `normal`.. [optional]
            sources (str): A comma separated string of sources.. [optional]
            tags (str): A comma separated list indicating what tags, if any, should be used to filter the list of monitors by scope.. [optional]
            unaggregated (bool): Set unaggregated to `true` to return all events within the specified [`start`,`end`] timeframe. Otherwise if an event is aggregated to a parent event with a timestamp outside of the timeframe, it won't be available in the output. Aggregated events with `is_aggregate=true` in the response will still be returned unless exclude_aggregate is set to `true.`. [optional]
            exclude_aggregate (bool): Set `exclude_aggregate` to `true` to only return unaggregated events where `is_aggregate=false` in the response. If the `exclude_aggregate` parameter is set to `true`, then the unaggregated parameter is ignored and will be `true` by default.. [optional]
            page (int): By default 1000 results are returned per request. Set page to the number of the page to return with `0` being the first page. The page parameter can only be used when either unaggregated or exclude_aggregate is set to `true.`. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            EventListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_events_endpoint.default_arguments(kwargs)
        kwargs["start"] = start
        kwargs["end"] = end
        return self._list_events_endpoint.call_with_http_info(**kwargs)
