# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v1.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v1.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v1.model.api_error_response import APIErrorResponse
from datadog_api_client.v1.model.host_list_response import HostListResponse
from datadog_api_client.v1.model.host_mute_response import HostMuteResponse
from datadog_api_client.v1.model.host_mute_settings import HostMuteSettings
from datadog_api_client.v1.model.host_totals import HostTotals


class HostsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._get_host_totals_endpoint = _Endpoint(
            settings={
                "response_type": (HostTotals,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/hosts/totals",
                "operation_id": "get_host_totals",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "_from",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "_from": (int,),
                },
                "attribute_map": {
                    "_from": "from",
                },
                "location_map": {
                    "_from": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_hosts_endpoint = _Endpoint(
            settings={
                "response_type": (HostListResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/hosts",
                "operation_id": "list_hosts",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "filter",
                    "sort_field",
                    "sort_dir",
                    "start",
                    "count",
                    "_from",
                    "include_muted_hosts_data",
                    "include_hosts_metadata",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "filter": (str,),
                    "sort_field": (str,),
                    "sort_dir": (str,),
                    "start": (int,),
                    "count": (int,),
                    "_from": (int,),
                    "include_muted_hosts_data": (bool,),
                    "include_hosts_metadata": (bool,),
                },
                "attribute_map": {
                    "filter": "filter",
                    "sort_field": "sort_field",
                    "sort_dir": "sort_dir",
                    "start": "start",
                    "count": "count",
                    "_from": "from",
                    "include_muted_hosts_data": "include_muted_hosts_data",
                    "include_hosts_metadata": "include_hosts_metadata",
                },
                "location_map": {
                    "filter": "query",
                    "sort_field": "query",
                    "sort_dir": "query",
                    "start": "query",
                    "count": "query",
                    "_from": "query",
                    "include_muted_hosts_data": "query",
                    "include_hosts_metadata": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._mute_host_endpoint = _Endpoint(
            settings={
                "response_type": (HostMuteResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/host/{host_name}/mute",
                "operation_id": "mute_host",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "host_name",
                    "body",
                ],
                "required": [
                    "host_name",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "host_name": (str,),
                    "body": (HostMuteSettings,),
                },
                "attribute_map": {
                    "host_name": "host_name",
                },
                "location_map": {
                    "host_name": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._unmute_host_endpoint = _Endpoint(
            settings={
                "response_type": (HostMuteResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/host/{host_name}/unmute",
                "operation_id": "unmute_host",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "host_name",
                ],
                "required": [
                    "host_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "host_name": (str,),
                },
                "attribute_map": {
                    "host_name": "host_name",
                },
                "location_map": {
                    "host_name": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

    def get_host_totals(self, **kwargs):
        """Get the total number of active hosts  # noqa: E501

        This endpoint returns the total number of active and up hosts in your Datadog account. Active means the host has reported in the past hour, and up means it has reported in the past two hours.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_totals(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _from (int): Number of seconds from which you want to get total number of active hosts.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            HostTotals
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_host_totals_endpoint.default_arguments(kwargs)
        return self._get_host_totals_endpoint.call_with_http_info(**kwargs)

    def list_hosts(self, **kwargs):
        """Get all hosts for your organization  # noqa: E501

        This endpoint allows searching for hosts by name, alias, or tag. Hosts live within the past 3 hours are included by default. Retention is 7 days. Results are paginated with a max of 1000 results at a time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_hosts(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): String to filter search results.. [optional]
            sort_field (str): Sort hosts by this field.. [optional]
            sort_dir (str): Direction of sort. Options include `asc` and `desc`.. [optional]
            start (int): Host result to start search from.. [optional]
            count (int): Number of hosts to return. Max 1000.. [optional]
            _from (int): Number of seconds since UNIX epoch from which you want to search your hosts.. [optional]
            include_muted_hosts_data (bool): Include information on the muted status of hosts and when the mute expires.. [optional]
            include_hosts_metadata (bool): Include additional metadata about the hosts (agent_version, machine, platform, processor, etc.).. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            HostListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_hosts_endpoint.default_arguments(kwargs)
        return self._list_hosts_endpoint.call_with_http_info(**kwargs)

    def mute_host(self, host_name, body, **kwargs):
        """Mute a host  # noqa: E501

        Mute a host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mute_host(host_name, body, async_req=True)
        >>> result = thread.get()

        Args:
            host_name (str): Name of the host to mute.
            body (HostMuteSettings): Mute a host request body.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            HostMuteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._mute_host_endpoint.default_arguments(kwargs)
        kwargs["host_name"] = host_name
        kwargs["body"] = body
        return self._mute_host_endpoint.call_with_http_info(**kwargs)

    def unmute_host(self, host_name, **kwargs):
        """Unmute a host  # noqa: E501

        Unmutes a host. This endpoint takes no JSON arguments.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unmute_host(host_name, async_req=True)
        >>> result = thread.get()

        Args:
            host_name (str): Name of the host to unmute.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            HostMuteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._unmute_host_endpoint.default_arguments(kwargs)
        kwargs["host_name"] = host_name
        return self._unmute_host_endpoint.call_with_http_info(**kwargs)
