# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v1.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v1.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v1.model.api_error_response import APIErrorResponse
from datadog_api_client.v1.model.logs_api_error_response import LogsAPIErrorResponse
from datadog_api_client.v1.model.logs_pipeline import LogsPipeline
from datadog_api_client.v1.model.logs_pipeline_list import LogsPipelineList
from datadog_api_client.v1.model.logs_pipelines_order import LogsPipelinesOrder


class LogsPipelinesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._create_logs_pipeline_endpoint = _Endpoint(
            settings={
                "response_type": (LogsPipeline,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/logs/config/pipelines",
                "operation_id": "create_logs_pipeline",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (LogsPipeline,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._delete_logs_pipeline_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/logs/config/pipelines/{pipeline_id}",
                "operation_id": "delete_logs_pipeline",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "pipeline_id",
                ],
                "required": [
                    "pipeline_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "pipeline_id": (str,),
                },
                "attribute_map": {
                    "pipeline_id": "pipeline_id",
                },
                "location_map": {
                    "pipeline_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_logs_pipeline_endpoint = _Endpoint(
            settings={
                "response_type": (LogsPipeline,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/logs/config/pipelines/{pipeline_id}",
                "operation_id": "get_logs_pipeline",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "pipeline_id",
                ],
                "required": [
                    "pipeline_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "pipeline_id": (str,),
                },
                "attribute_map": {
                    "pipeline_id": "pipeline_id",
                },
                "location_map": {
                    "pipeline_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_logs_pipeline_order_endpoint = _Endpoint(
            settings={
                "response_type": (LogsPipelinesOrder,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/logs/config/pipeline-order",
                "operation_id": "get_logs_pipeline_order",
                "http_method": "GET",
                "servers": None,
            },
            params_map={"all": [], "required": [], "nullable": [], "enum": [], "validation": []},
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_logs_pipelines_endpoint = _Endpoint(
            settings={
                "response_type": (LogsPipelineList,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/logs/config/pipelines",
                "operation_id": "list_logs_pipelines",
                "http_method": "GET",
                "servers": None,
            },
            params_map={"all": [], "required": [], "nullable": [], "enum": [], "validation": []},
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._update_logs_pipeline_endpoint = _Endpoint(
            settings={
                "response_type": (LogsPipeline,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/logs/config/pipelines/{pipeline_id}",
                "operation_id": "update_logs_pipeline",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "pipeline_id",
                    "body",
                ],
                "required": [
                    "pipeline_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "pipeline_id": (str,),
                    "body": (LogsPipeline,),
                },
                "attribute_map": {
                    "pipeline_id": "pipeline_id",
                },
                "location_map": {
                    "pipeline_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._update_logs_pipeline_order_endpoint = _Endpoint(
            settings={
                "response_type": (LogsPipelinesOrder,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/logs/config/pipeline-order",
                "operation_id": "update_logs_pipeline_order",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (LogsPipelinesOrder,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def create_logs_pipeline(self, body, **kwargs):
        """Create a pipeline  # noqa: E501

        Create a pipeline in your organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_logs_pipeline(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (LogsPipeline): Definition of the new pipeline.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogsPipeline
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_logs_pipeline_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_logs_pipeline_endpoint.call_with_http_info(**kwargs)

    def delete_logs_pipeline(self, pipeline_id, **kwargs):
        """Delete a pipeline  # noqa: E501

        Delete a given pipeline from your organization. This endpoint takes no JSON arguments.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_logs_pipeline(pipeline_id, async_req=True)
        >>> result = thread.get()

        Args:
            pipeline_id (str): ID of the pipeline to delete.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_logs_pipeline_endpoint.default_arguments(kwargs)
        kwargs["pipeline_id"] = pipeline_id
        return self._delete_logs_pipeline_endpoint.call_with_http_info(**kwargs)

    def get_logs_pipeline(self, pipeline_id, **kwargs):
        """Get a pipeline  # noqa: E501

        Get a specific pipeline from your organization. This endpoint takes no JSON arguments.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_logs_pipeline(pipeline_id, async_req=True)
        >>> result = thread.get()

        Args:
            pipeline_id (str): ID of the pipeline to get.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogsPipeline
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_logs_pipeline_endpoint.default_arguments(kwargs)
        kwargs["pipeline_id"] = pipeline_id
        return self._get_logs_pipeline_endpoint.call_with_http_info(**kwargs)

    def get_logs_pipeline_order(self, **kwargs):
        """Get pipeline order  # noqa: E501

        Get the current order of your pipelines. This endpoint takes no JSON arguments.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_logs_pipeline_order(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogsPipelinesOrder
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_logs_pipeline_order_endpoint.default_arguments(kwargs)
        return self._get_logs_pipeline_order_endpoint.call_with_http_info(**kwargs)

    def list_logs_pipelines(self, **kwargs):
        """Get all pipelines  # noqa: E501

        Get all pipelines from your organization. This endpoint takes no JSON arguments.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_logs_pipelines(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogsPipelineList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_logs_pipelines_endpoint.default_arguments(kwargs)
        return self._list_logs_pipelines_endpoint.call_with_http_info(**kwargs)

    def update_logs_pipeline(self, pipeline_id, body, **kwargs):
        """Update a pipeline  # noqa: E501

        Update a given pipeline configuration to change it’s processors or their order.  **Note**: Using this method updates your pipeline configuration by **replacing** your current configuration with the new one sent to your Datadog organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_logs_pipeline(pipeline_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            pipeline_id (str): ID of the pipeline to delete.
            body (LogsPipeline): New definition of the pipeline.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogsPipeline
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_logs_pipeline_endpoint.default_arguments(kwargs)
        kwargs["pipeline_id"] = pipeline_id
        kwargs["body"] = body
        return self._update_logs_pipeline_endpoint.call_with_http_info(**kwargs)

    def update_logs_pipeline_order(self, body, **kwargs):
        """Update pipeline order  # noqa: E501

        Update the order of your pipelines. Since logs are processed sequentially, reordering a pipeline may change the structure and content of the data processed by other pipelines and their processors.  **Note**: Using the `PUT` method updates your pipeline order by replacing your current order with the new one sent to your Datadog organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_logs_pipeline_order(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (LogsPipelinesOrder): Object containing the new ordered list of pipeline IDs.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogsPipelinesOrder
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_logs_pipeline_order_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._update_logs_pipeline_order_endpoint.call_with_http_info(**kwargs)
